/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.BlockStoreShuffleReader$;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockFetcherIterator;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!\u0002\n\u0014\u0001UY\u0002\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!a\u0006A!A!\u0002\u0013i\u0006\"\u00021\u0001\t\u0003\t\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007m\u0002\u0001\u000b\u0011\u00029\t\u000b]\u0004A\u0011\t=\b\u0015\u0005E1#!A\t\u0002U\t\u0019BB\u0005\u0013'\u0005\u0005\t\u0012A\u000b\u0002\u0016!1\u0001-\u0004C\u0001\u0003/A\u0011\"!\u0007\u000e#\u0003%\t!a\u0007\t\u0013\u0005]R\"%A\u0005\u0002\u0005e\u0002\"CA\"\u001bE\u0005I\u0011AA#\u0005]\u0011En\\2l'R|'/Z*ik\u001a4G.\u001a*fC\u0012,'O\u0003\u0002\u0015+\u000591\u000f[;gM2,'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0016\u0007qICg\u0005\u0003\u0001;\r2\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0003%K\u001d\u001aT\"A\n\n\u0005\u0019\u001a\"!D*ik\u001a4G.\u001a*fC\u0012,'\u000f\u0005\u0002)S1\u0001A!\u0002\u0016\u0001\u0005\u0004a#!A&\u0004\u0001E\u0011Q\u0006\r\t\u0003=9J!aL\u0010\u0003\u000f9{G\u000f[5oOB\u0011a$M\u0005\u0003e}\u00111!\u00118z!\tAC\u0007B\u00036\u0001\t\u0007AFA\u0001D!\t9$(D\u00019\u0015\tIT#\u0001\u0005j]R,'O\\1m\u0013\tY\u0004HA\u0004M_\u001e<\u0017N\\4\u0002\r!\fg\u000e\u001a7fa\tq$\tE\u0003%\u007f\u001d\n5'\u0003\u0002A'\t\t\")Y:f'\",hM\u001a7f\u0011\u0006tG\r\\3\u0011\u0005!\u0012E!C\"\u0002\u0003\u0003\u0005\tQ!\u0001-\u0005\ryF%M\u0001\u000fgR\f'\u000f\u001e)beRLG/[8o!\tqb)\u0003\u0002H?\t\u0019\u0011J\u001c;\u0002\u0019\u0015tG\rU1si&$\u0018n\u001c8\u0002\u000f\r|g\u000e^3yiB\u00111\nT\u0007\u0002+%\u0011Q*\u0006\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\ttKJL\u0017\r\\5{KJl\u0015M\\1hKJ\u0004\"\u0001U*\u000e\u0003ES!AU\u000b\u0002\u0015M,'/[1mSj,'/\u0003\u0002U#\n\t2+\u001a:jC2L'0\u001a:NC:\fw-\u001a:\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0011\u0005]SV\"\u0001-\u000b\u0005e+\u0012aB:u_J\fw-Z\u0005\u00037b\u0013AB\u00117pG.l\u0015M\\1hKJ\f\u0001#\\1q\u001fV$\b/\u001e;Ue\u0006\u001c7.\u001a:\u0011\u0005-s\u0016BA0\u0016\u0005Ai\u0015\r](viB,H\u000f\u0016:bG.,'/\u0001\u0004=S:LGO\u0010\u000b\tE\u000eD\u0017N[6m[B!A\u0005A\u00144\u0011\u0015a\u0004\u00021\u0001ea\t)w\rE\u0003%\u007f\u001d27\u0007\u0005\u0002)O\u0012I1iYA\u0001\u0002\u0003\u0015\t\u0001\f\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0011\"\u0001\r!\u0012\u0005\u0006\u0013\"\u0001\rA\u0013\u0005\b\u001d\"\u0001\n\u00111\u0001P\u0011\u001d)\u0006\u0002%AA\u0002YCq\u0001\u0018\u0005\u0011\u0002\u0003\u0007Q,A\u0002eKB,\u0012\u0001\u001d\u0019\u0003cV\u0004Ra\u0013:(iNJ!a]\u000b\u0003#MCWO\u001a4mK\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\u0005\u0002)k\u0012I1)AA\u0001\u0002\u0003\u0015\t\u0001L\u0001\u0005I\u0016\u0004\b%\u0001\u0003sK\u0006$G#A=\u0011\u000bi\f)!a\u0003\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007fW\u00051AH]8pizJ\u0011\u0001I\u0005\u0004\u0003\u0007y\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\u0019a\b\t\u0006=\u00055qeM\u0005\u0004\u0003\u001fy\"\u0001\u0003)s_\u0012,8\r\u001e\u001a\u0002/\tcwnY6Ti>\u0014Xm\u00155vM\u001adWMU3bI\u0016\u0014\bC\u0001\u0013\u000e'\tiQ\u0004\u0006\u0002\u0002\u0014\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*b!!\b\u00024\u0005URCAA\u0010U\ry\u0015\u0011E\u0016\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0005v]\u000eDWmY6fI*\u0019\u0011QF\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0005\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)!f\u0004b\u0001Y\u0011)Qg\u0004b\u0001Y\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*b!a\u000f\u0002@\u0005\u0005SCAA\u001fU\r1\u0016\u0011\u0005\u0003\u0006UA\u0011\r\u0001\f\u0003\u0006kA\u0011\r\u0001L\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\r\u0005\u001d\u00131JA'+\t\tIEK\u0002^\u0003C!QAK\tC\u00021\"Q!N\tC\u00021\u0002")
public class BlockStoreShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final BaseShuffleHandle<K, ?, C> handle;
    private final int startPartition;
    private final int endPartition;
    private final TaskContext context;
    private final SerializerManager serializerManager;
    private final BlockManager blockManager;
    private final MapOutputTracker mapOutputTracker;
    private final ShuffleDependency<K, ?, C> dep;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> MapOutputTracker $lessinit$greater$default$7() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7();
    }

    public static <K, C> BlockManager $lessinit$greater$default$6() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6();
    }

    public static <K, C> SerializerManager $lessinit$greater$default$5() {
        return BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    @Override
    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        Object object;
        Some some;
        Ordering keyOrd;
        InterruptibleIterator interruptibleIterator;
        ShuffleBlockFetcherIterator wrappedStreams = new ShuffleBlockFetcherIterator(this.context, this.blockManager.shuffleClient(), this.blockManager, this.mapOutputTracker.getMapSizesByExecutorId(this.handle.shuffleId(), this.startPartition, this.endPartition), (Function2<BlockId, InputStream, InputStream>)(Function2 & Serializable & scala.Serializable)(blockId, s) -> $this.serializerManager.wrapStream((BlockId)blockId, (InputStream)s), SparkEnv$.MODULE$.get().conf().getSizeAsMb("spark.reducer.maxSizeInFlight", "48m") * 1024L * 1024L, SparkEnv$.MODULE$.get().conf().getInt("spark.reducer.maxReqsInFlight", Integer.MAX_VALUE), BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.REDUCER_MAX_BLOCKS_IN_FLIGHT_PER_ADDRESS())), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM())), SparkEnv$.MODULE$.get().conf().getBoolean("spark.shuffle.detectCorrupt", true));
        SerializerInstance serializerInstance = this.dep().serializer().newInstance();
        Iterator recordIter = wrappedStreams.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream wrappedStream = (InputStream)tuple2._2();
            Iterator<Tuple2<Object, Object>> iterator = serializerInstance.deserializeStream(wrappedStream).asKeyValueIterator();
            return iterator;
        });
        TempShuffleReadMetrics readMetrics = this.context.taskMetrics().createTempShuffleReadMetrics();
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            readMetrics.incRecordsRead(1L);
            return record;
        }), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, metricIter);
        if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey(combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey(keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator aggregatedIter = interruptibleIterator;
        Option<Ordering<K>> option = this.dep().keyOrdering();
        if (option instanceof Some && (keyOrd = (Ordering)(some = (Some)option).value()) != null) {
            Ordering ordering = keyOrd;
            TaskContext x$12 = this.context;
            Some x$2 = new Some((Object)ordering);
            Serializer x$3 = this.dep().serializer();
            None$ x$4 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
            Option<Partitioner> x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
            ExternalSorter sorter = new ExternalSorter(x$12, x$4, x$5, x$2, x$3);
            sorter.insertAll(aggregatedIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            object = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (None$.MODULE$.equals(option)) {
            object = aggregatedIter;
        } else {
            throw new MatchError(option);
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = object;
        InterruptibleIterator<Object> interruptibleIterator3 = interruptibleIterator2 instanceof InterruptibleIterator ? resultIter : new InterruptibleIterator<Product2<K, C>>(this.context, resultIter);
        return interruptibleIterator3;
    }

    public BlockStoreShuffleReader(BaseShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, TaskContext context, SerializerManager serializerManager, BlockManager blockManager, MapOutputTracker mapOutputTracker) {
        this.handle = handle;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.context = context;
        this.serializerManager = serializerManager;
        this.blockManager = blockManager;
        this.mapOutputTracker = mapOutputTracker;
        Logging.$init$(this);
        this.dep = handle.dependency();
    }
}

