/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.TaskKilled;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.TaskState$;
import org.apache.spark.UnknownReason$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.TaskResult;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\b\u0011\u0001IA\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011E\u0001!\u0011!Q\u0001\n-BQa\f\u0001\u0005\u0002ABq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004:\u0001\u0001\u0006IA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0005<\u0011\u00191\u0005\u0001)A\u0005y!9q\t\u0001b\u0001\n#A\u0005B\u0002+\u0001A\u0003%\u0011\nC\u0004V\u0001\t\u0007I\u0011\u0003%\t\rY\u0003\u0001\u0015!\u0003J\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\u0011\u0001\u0003V1tWJ+7/\u001e7u\u000f\u0016$H/\u001a:\u000b\u0005E\u0011\u0012!C:dQ\u0016$W\u000f\\3s\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\n\u0002\u0011%tG/\u001a:oC2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\u0006A1\u000f]1sW\u0016sgo\u0001\u0001\u0011\u0005!JS\"\u0001\n\n\u0005)\u0012\"\u0001C*qCJ\\WI\u001c<\u0011\u00051jS\"\u0001\t\n\u00059\u0002\"!\u0005+bg.\u001c6\r[3ek2,'/S7qY\u00061A(\u001b8jiz\"2!\r\u001a4!\ta\u0003\u0001C\u0003&\u0007\u0001\u0007q\u0005C\u0003\u0012\u0007\u0001\u00071&A\u0004U\u0011J+\u0015\tR*\u0016\u0003Y\u0002\"AG\u001c\n\u0005aZ\"aA%oi\u0006AA\u000b\u0013*F\u0003\u0012\u001b\u0006%A\u000bhKR$\u0016m]6SKN,H\u000e^#yK\u000e,Ho\u001c:\u0016\u0003q\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012 \u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\facZ3u)\u0006\u001c8NU3tk2$X\t_3dkR|'\u000fI\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A%\u0011\u0007)ku*D\u0001L\u0015\ta%)\u0001\u0003mC:<\u0017B\u0001(L\u0005-!\u0006N]3bI2{7-\u00197\u0011\u0005A\u0013V\"A)\u000b\u0005\u001d\u0013\u0012BA*R\u0005I\u0019VM]5bY&TXM]%ogR\fgnY3\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0015i\u0006\u001c8NU3tk2$8+\u001a:jC2L'0\u001a:\u0002+Q\f7o\u001b*fgVdGoU3sS\u0006d\u0017N_3sA\u0005)RM\\9vKV,7+^2dKN\u001ch-\u001e7UCN\\G\u0003B-]C\u001a\u0004\"A\u0007.\n\u0005m[\"\u0001B+oSRDQ!\u0018\u0007A\u0002y\u000ba\u0002^1tWN+G/T1oC\u001e,'\u000f\u0005\u0002-?&\u0011\u0001\r\u0005\u0002\u000f)\u0006\u001c8nU3u\u001b\u0006t\u0017mZ3s\u0011\u0015\u0011G\u00021\u0001d\u0003\r!\u0018\u000e\u001a\t\u00035\u0011L!!Z\u000e\u0003\t1{gn\u001a\u0005\u0006O2\u0001\r\u0001[\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0016$G)\u0019;b!\tIG.D\u0001k\u0015\tY')A\u0002oS>L!!\u001c6\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\tf]F,X-^3GC&dW\r\u001a+bg.$b!\u00179re\u0006%\u0001\"B/\u000e\u0001\u0004q\u0006\"\u00022\u000e\u0001\u0004\u0019\u0007\"B:\u000e\u0001\u0004!\u0018!\u0003;bg.\u001cF/\u0019;f!\r)\u00181\u0001\b\u0003m~t!a\u001e@\u000f\u0005alhBA=}\u001b\u0005Q(BA>'\u0003\u0019a$o\\8u}%\tq#\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0004\u0003\u0003\u0011\u0012!\u0003+bg.\u001cF/\u0019;f\u0013\u0011\t)!a\u0002\u0003\u0013Q\u000b7o[*uCR,'bAA\u0001%!)q-\u0004a\u0001Q\u0006!1\u000f^8q)\u0005I\u0006")
public class TaskResultGetter
implements Logging {
    public final SparkEnv org$apache$spark$scheduler$TaskResultGetter$$sparkEnv;
    public final TaskSchedulerImpl org$apache$spark$scheduler$TaskResultGetter$$scheduler;
    private final int THREADS;
    private final ExecutorService getTaskResultExecutor;
    private final ThreadLocal<SerializerInstance> serializer;
    private final ThreadLocal<SerializerInstance> taskResultSerializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int THREADS() {
        return this.THREADS;
    }

    public ExecutorService getTaskResultExecutor() {
        return this.getTaskResultExecutor;
    }

    public ThreadLocal<SerializerInstance> serializer() {
        return this.serializer;
    }

    public ThreadLocal<SerializerInstance> taskResultSerializer() {
        return this.taskResultSerializer;
    }

    public void enqueueSuccessfulTask(TaskSetManager taskSetManager, long tid, ByteBuffer serializedData) {
        this.getTaskResultExecutor().execute(new Runnable(this, serializedData, taskSetManager, tid){
            private final /* synthetic */ TaskResultGetter $outer;
            private final ByteBuffer serializedData$1;
            private final TaskSetManager taskSetManager$1;
            private final long tid$1;

            public void run() {
                Object object = new Object();
                try {
                    Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            Tuple2 tuple2;
                            TaskResult taskResult = (TaskResult)$this.$outer.serializer().get().deserialize($this.serializedData$1, ClassTag$.MODULE$.apply(TaskResult.class));
                            if (taskResult instanceof DirectTaskResult) {
                                DirectTaskResult directTaskResult = (DirectTaskResult)taskResult;
                                if (!$this.taskSetManager$1.canFetchMoreResults($this.serializedData$1.limit())) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.KILLED(), new TaskKilled("Tasks result size has exceeded maxResultSize", TaskKilled$.MODULE$.apply$default$2(), TaskKilled$.MODULE$.apply$default$3()));
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                directTaskResult.value($this.$outer.taskResultSerializer().get());
                                tuple2 = new Tuple2((Object)directTaskResult, (Object)BoxesRunTime.boxToInteger((int)$this.serializedData$1.limit()));
                            } else if (taskResult instanceof IndirectTaskResult) {
                                IndirectTaskResult indirectTaskResult = (IndirectTaskResult)taskResult;
                                BlockId blockId = indirectTaskResult.blockId();
                                int size = indirectTaskResult.size();
                                if (!$this.taskSetManager$1.canFetchMoreResults(size)) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.KILLED(), new TaskKilled("Tasks result size has exceeded maxResultSize", TaskKilled$.MODULE$.apply$default$2(), TaskKilled$.MODULE$.apply$default$3()));
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                $this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Fetching indirect task result for TID %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.tid$1)})));
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleTaskGettingResult($this.taskSetManager$1, $this.tid$1);
                                Option<ChunkedByteBuffer> serializedTaskResult = $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().getRemoteBytes(blockId);
                                if (!serializedTaskResult.isDefined()) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.FINISHED(), TaskResultLost$.MODULE$);
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                DirectTaskResult deserializedResult = (DirectTaskResult)$this.$outer.serializer().get().deserialize(((ChunkedByteBuffer)serializedTaskResult.get()).toByteBuffer(), ClassTag$.MODULE$.apply(DirectTaskResult.class));
                                deserializedResult.value($this.$outer.taskResultSerializer().get());
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                tuple2 = new Tuple2((Object)deserializedResult, (Object)BoxesRunTime.boxToInteger((int)size));
                            } else {
                                throw new MatchError((Object)taskResult);
                            }
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            DirectTaskResult result = (DirectTaskResult)tuple22._1();
                            int size = tuple22._2$mcI$sp();
                            Tuple2 tuple23 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)size));
                            Tuple2 tuple24 = tuple23;
                            DirectTaskResult result2 = (DirectTaskResult)tuple24._1();
                            int size2 = tuple24._2$mcI$sp();
                            result2.accumUpdates_$eq((Seq)result2.accumUpdates().map((Function1 & Serializable & scala.Serializable)a -> {
                                AccumulatorV2 accumulatorV2;
                                Option<String> option = a.name();
                                Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                                if (!(option != null ? !option.equals((Object)some) : some != null)) {
                                    void var3_3;
                                    LongAccumulator acc = (LongAccumulator)a;
                                    Predef$.MODULE$.assert(acc.sum() == 0L, (Function0 & Serializable & scala.Serializable)() -> "task result size should not have been set on the executors");
                                    acc.setValue(size2);
                                    accumulatorV2 = var3_3;
                                } else {
                                    accumulatorV2 = a;
                                }
                                return accumulatorV2;
                            }, Seq$.MODULE$.canBuildFrom()));
                            $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleSuccessfulTask($this.taskSetManager$1, $this.tid$1, result2);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ClassNotFoundException) {
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                $this.taskSetManager$1.abort(new StringBuilder(32).append("ClassNotFound with classloader: ").append(loader).toString(), $this.taskSetManager$1.abort$default$2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable ex = (Throwable)option.get();
                                $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting task result", ex);
                                $this.taskSetManager$1.abort(new StringOps(Predef$.MODULE$.augmentString("Exception while getting task result: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})), $this.taskSetManager$1.abort$default$2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable;
                        }
                    });
                }
                catch (NonLocalReturnControl ex) {
                    if (ex.key() == object) {
                        ex.value$mcV$sp();
                    }
                    throw ex;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serializedData$1 = serializedData$1;
                this.taskSetManager$1 = taskSetManager$1;
                this.tid$1 = tid$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.TaskResultGetter$$anon$3 java.lang.Object ), $anonfun$run$4(), $anonfun$run$2(org.apache.spark.scheduler.TaskResultGetter$$anon$3 ), $anonfun$run$3(int org.apache.spark.util.AccumulatorV2 ), $anonfun$run$5()}, serializedLambda);
            }
        });
    }

    public void enqueueFailedTask(TaskSetManager taskSetManager, long tid, Enumeration.Value taskState, ByteBuffer serializedData) {
        ObjectRef reason = ObjectRef.create((Object)UnknownReason$.MODULE$);
        try {
            this.getTaskResultExecutor().execute(new Runnable(this, serializedData, reason, taskSetManager, tid, taskState){
                private final /* synthetic */ TaskResultGetter $outer;
                private final ByteBuffer serializedData$2;
                private final ObjectRef reason$1;
                private final TaskSetManager taskSetManager$2;
                private final long tid$2;
                private final Enumeration.Value taskState$1;

                public void run() {
                    Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
                        try {
                            try {
                                if ($this.serializedData$2 != null && $this.serializedData$2.limit() > 0) {
                                    $this.reason$1.elem = (TaskFailedReason)$this.$outer.serializer().get().deserialize($this.serializedData$2, loader, ClassTag$.MODULE$.apply(TaskFailedReason.class));
                                }
                            }
                            catch (ClassNotFoundException cnd) {
                                $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Could not deserialize TaskEndReason: ClassNotFound with classloader ").append(loader).toString());
                            }
                            catch (Exception exception) {}
                        }
                        finally {
                            $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$2, $this.tid$2, $this.taskState$1, (TaskFailedReason)$this.reason$1.elem);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.serializedData$2 = serializedData$2;
                    this.reason$1 = reason$1;
                    this.taskSetManager$2 = taskSetManager$2;
                    this.tid$2 = tid$2;
                    this.taskState$1 = taskState$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$6(org.apache.spark.scheduler.TaskResultGetter$$anon$4 ), $anonfun$run$7(java.lang.ClassLoader )}, serializedLambda);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException && this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.isStopped()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void stop() {
        this.getTaskResultExecutor().shutdownNow();
    }

    public TaskResultGetter(SparkEnv sparkEnv, TaskSchedulerImpl scheduler) {
        this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv = sparkEnv;
        this.org$apache$spark$scheduler$TaskResultGetter$$scheduler = scheduler;
        Logging.$init$(this);
        this.THREADS = sparkEnv.conf().getInt("spark.resultGetter.threads", 4);
        this.getTaskResultExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.THREADS(), "task-result-getter");
        this.serializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.closureSerializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.taskResultSerializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.serializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

