/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.HaltReplayException;
import org.apache.spark.scheduler.ReplayListenerBus$;
import org.apache.spark.scheduler.SparkListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.ListenerBus;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0007\u000f\u0001A1\u0002\"B\u0014\u0001\t\u0003I\u0003\"B\u0016\u0001\t\u0003a\u0003bB3\u0001#\u0003%\tA\u001a\u0005\bc\u0002\t\n\u0011\"\u0001s\u0011\u0015Y\u0003\u0001\"\u0001u\u0011\u001d\t9\u0001\u0001C)\u0003\u00139a\u0001\u0017\b\t\u0002AIfAB\u0007\u000f\u0011\u0003\u0001\"\fC\u0003(\u0011\u0011\u00051,\u0002\u0003]\u0011\u0001i\u0006b\u00021\t\u0005\u0004%\t!\u0019\u0005\u0007I\"\u0001\u000b\u0011\u00022\u0003#I+\u0007\u000f\\1z\u0019&\u001cH/\u001a8fe\n+8O\u0003\u0002\u0010!\u0005I1o\u00195fIVdWM\u001d\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sON!\u0001aF\u000f\"!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u001d%\u0011\u0001E\u0004\u0002\u0011'B\f'o\u001b'jgR,g.\u001a:CkN\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\t\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001+!\tq\u0002!\u0001\u0004sKBd\u0017-\u001f\u000b\u0006[ARt\t\u0014\t\u000319J!aL\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\t\u0001\rAM\u0001\bY><G)\u0019;b!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0002j_*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000bm\u0012\u0001\u0019\u0001\u001f\u0002\u0015M|WO]2f\u001d\u0006lW\r\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007fei\u0011\u0001\u0011\u0006\u0003\u0003\"\na\u0001\u0010:p_Rt\u0014BA\"\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rK\u0002b\u0002%\u0003!\u0003\u0005\r!S\u0001\u000f[\u0006L(-\u001a+sk:\u001c\u0017\r^3e!\tA\"*\u0003\u0002L3\t9!i\\8mK\u0006t\u0007bB'\u0003!\u0003\u0005\rAT\u0001\rKZ,g\u000e^:GS2$XM\u001d\t\u0003\u001f*q!\u0001U\u0004\u000f\u0005E;fB\u0001*W\u001d\t\u0019VK\u0004\u0002@)&\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fA\t\u0011CU3qY\u0006LH*[:uK:,'OQ;t!\tq\u0002b\u0005\u0002\t/Q\t\u0011L\u0001\nSKBd\u0017-_#wK:$8OR5mi\u0016\u0014\b\u0003\u0002\r_y%K!aX\r\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E*F\u0019\u0016\u001bEkX!M\u0019~3\u0015\n\u0014+F%V\t!\r\u0005\u0002d\u00155\t\u0001\"\u0001\nT\u000b2+5\tV0B\u00192{f)\u0013'U\u000bJ\u0003\u0013\u0001\u0005:fa2\f\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u00059'FA%iW\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003%)hn\u00195fG.,GM\u0003\u0002o3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005A\\'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"/\u001a9mCf$C-\u001a4bk2$H\u0005N\u000b\u0002g*\u0012a\n\u001b\u000b\t[U\f\t!a\u0001\u0002\u0006!)a/\u0002a\u0001o\u0006)A.\u001b8fgB\u0019\u00010 \u001f\u000f\u0005e\\hBA {\u0013\u0005Q\u0012B\u0001?\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\u0011%#XM]1u_JT!\u0001`\r\t\u000bm*\u0001\u0019\u0001\u001f\t\u000b!+\u0001\u0019A%\t\u000b5+\u0001\u0019\u0001(\u0002)%\u001c\u0018j\u001a8pe\u0006\u0014G.Z#yG\u0016\u0004H/[8o)\rI\u00151\u0002\u0005\b\u0003\u001b1\u0001\u0019AA\b\u0003\u0005)\u0007c\u0001=\u0002\u0012%\u0019\u00111C@\u0003\u0013QC'o\\<bE2,\u0007")
public class ReplayListenerBus
implements SparkListenerBus {
    private final CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Function1<String, Object> SELECT_ALL_FILTER() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public void doPostEvent(SparkListenerInterface listener, SparkListenerEvent event) {
        SparkListenerBus.doPostEvent$(this, listener, event);
    }

    @Override
    public List<SparkListenerInterface> listeners() {
        return ListenerBus.listeners$(this);
    }

    @Override
    public Option getTimer(Object listener) {
        return ListenerBus.getTimer$(this, listener);
    }

    @Override
    public final void addListener(Object listener) {
        ListenerBus.addListener$(this, listener);
    }

    @Override
    public final void removeListener(Object listener) {
        ListenerBus.removeListener$(this, listener);
    }

    @Override
    public void removeListenerOnError(Object listener) {
        ListenerBus.removeListenerOnError$(this, listener);
    }

    @Override
    public void postToAll(Object event) {
        ListenerBus.postToAll$(this, event);
    }

    @Override
    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.findListenersByClass$(this, evidence$1);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    @Override
    public final void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void replay(InputStream logData, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        Iterator lines = Source$.MODULE$.fromInputStream(logData, Codec$.MODULE$.fallbackSystemCodec()).getLines();
        this.replay((Iterator<String>)lines, sourceName, maybeTruncated, eventsFilter);
    }

    public void replay(Iterator<String> lines, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        ObjectRef currentLine = ObjectRef.create(null);
        IntRef lineNumber = IntRef.create((int)0);
        HashSet unrecognizedEvents = new HashSet();
        HashSet unrecognizedProperties = new HashSet();
        try {
            Iterator lineEntries = lines.zipWithIndex().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplayListenerBus.$anonfun$replay$1(eventsFilter, x0$1)));
            while (lineEntries.hasNext()) {
                try {
                    Tuple2 entry = (Tuple2)lineEntries.next();
                    currentLine.elem = (String)entry._1();
                    lineNumber.elem = entry._2$mcI$sp() + 1;
                    this.postToAll(JsonProtocol$.MODULE$.sparkEventFromJson(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput((String)currentLine.elem), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
                }
                catch (ClassNotFoundException e) {
                    Object object;
                    if (!unrecognizedEvents.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop unrecognized event: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedEvents.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (UnrecognizedPropertyException e) {
                    Object object;
                    if (!unrecognizedProperties.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Drop unrecognized property: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedProperties.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (JsonParseException jpe) {
                    if (!maybeTruncated || lineEntries.hasNext()) {
                        throw jpe;
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Got JsonParseException from log file ").append(sourceName).append(" at line ").append(lineNumber$1.elem).append(", the file might not have finished writing cleanly.").toString());
                }
            }
        }
        catch (Throwable throwable) {
            boolean bl = false;
            IOException iOException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof HaltReplayException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof EOFException && maybeTruncated) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof IOException) {
                bl = true;
                iOException = (IOException)throwable2;
                if (maybeTruncated) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Failed to read Spark event log: ").append(sourceName).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (bl) {
                throw iOException;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Exception parsing Spark event log: ").append(sourceName).toString(), exception);
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Malformed line #").append(lineNumber$1.elem).append(": ").append((String)currentLine$1.elem).append("\n").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public boolean replay$default$3() {
        return false;
    }

    public Function1<String, Object> replay$default$4() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public boolean isIgnorableException(Throwable e) {
        return e instanceof HaltReplayException;
    }

    public static final /* synthetic */ boolean $anonfun$replay$1(Function1 eventsFilter$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String line = (String)tuple2._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)eventsFilter$1.apply((Object)line));
        return bl;
    }

    public ReplayListenerBus() {
        Logging.$init$(this);
        ListenerBus.$init$(this);
        SparkListenerBus.$init$(this);
    }
}

