/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.scheduler.AsyncEventQueue;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.LiveListenerBusMetrics;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

@ScalaSignature(bytes="\u0006\u0001\t=c!B\u00193\u0001QR\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0003S\u0011%A\u0006\u00011A\u0001B\u0003&a\n\u0003\u0005Z\u0001\t\u0007I\u0011\u0001\u001b[\u0011\u0019q\u0006\u0001)A\u00057\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB7\u0001A\u0003%\u0011\rC\u0004o\u0001\t\u0007I\u0011\u00021\t\r=\u0004\u0001\u0015!\u0003b\u0011\u001d\u0001\bA1A\u0005\nEDa!\u001e\u0001!\u0002\u0013\u0011\bb\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u0011\u0019q\b\u0001)Q\u0005q\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\f!Q\u00111\u0004\u0001A\u0002\u0013\u0005!'!\b\t\u0015\u0005U\u0002\u00011A\u0005\u0002I\n9\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0015BA\u0010\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!A\u0011q\f\u0001\u0005\u0002Q\n\t\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007D\u0001\"!2\u0001\t\u0003!\u0014q\u0019\u0005\t\u0003\u007f\u0004A\u0011\u0001\u001b\u0003\u0002!A!1\u0002\u0001\u0005\u0002I\u0012ia\u0002\u0005\u0003\u0016IB\t\u0001\u000eB\f\r\u001d\t$\u0007#\u00015\u00053AaaR\u0013\u0005\u0002\tm\u0001\"\u0003B\u000fK\t\u0007I\u0011\u0001B\u0010\u0011!\u0011\t$\nQ\u0001\n\t\u0005\u0002B\u0003B\u001aK\t\u0007I\u0011\u0001\u001a\u00036!A!\u0011I\u0013!\u0002\u0013\u00119\u0004\u0003\u0006\u0003D\u0015\u0012\r\u0011\"\u00013\u0005kA\u0001B!\u0012&A\u0003%!q\u0007\u0005\u000b\u0005\u000f*#\u0019!C\u0001e\tU\u0002\u0002\u0003B%K\u0001\u0006IAa\u000e\t\u0015\t-SE1A\u0005\u0002I\u0012)\u0004\u0003\u0005\u0003N\u0015\u0002\u000b\u0011\u0002B\u001c\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c(BA\u001a5\u0003%\u00198\r[3ek2,'O\u0003\u00026m\u0005)1\u000f]1sW*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h'\t\u00011\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005\u0011+U\"\u0001\u001b\n\u0005\u0019#$!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011j\u0013\t\u0003\u0015\u0002i\u0011A\r\u0005\u0006\u0003\n\u0001\raQ\u0001\rgB\f'o[\"p]R,\u0007\u0010^\u000b\u0002\u001dB\u0011AiT\u0005\u0003!R\u0012Ab\u00159be.\u001cuN\u001c;fqR\f\u0001c\u001d9be.\u001cuN\u001c;fqR|F%Z9\u0015\u0005M3\u0006C\u0001\u001fU\u0013\t)VH\u0001\u0003V]&$\bbB,\u0005\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014!D:qCJ\\7i\u001c8uKb$\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003m\u0003\"A\u0013/\n\u0005u\u0013$A\u0006'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqa\u001d;beR,G-F\u0001b!\t\u00117.D\u0001d\u0015\t!W-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003M\u001e\f!bY8oGV\u0014(/\u001a8u\u0015\tA\u0017.\u0001\u0003vi&d'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u000e\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:uCJ$X\r\u001a\u0011\u0002\u000fM$x\u000e\u001d9fI\u0006A1\u000f^8qa\u0016$\u0007%\u0001\u000bee>\u0004\b/\u001a3Fm\u0016tGo]\"pk:$XM]\u000b\u0002eB\u0011!m]\u0005\u0003i\u000e\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003U!'o\u001c9qK\u0012,e/\u001a8ug\u000e{WO\u001c;fe\u0002\n1\u0003\\1tiJ+\u0007o\u001c:u)&lWm\u001d;b[B,\u0012\u0001\u001f\t\u0003yeL!A_\u001f\u0003\t1{gnZ\u0001\u0018Y\u0006\u001cHOU3q_J$H+[7fgR\fW\u000e]0%KF$\"aU?\t\u000f]{\u0011\u0011!a\u0001q\u0006!B.Y:u%\u0016\u0004xN\u001d;US6,7\u000f^1na\u0002B3\u0001EA\u0001!\ra\u00141A\u0005\u0004\u0003\u000bi$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rE,X-^3t+\t\tY\u0001\u0005\u0004\u0002\u000e\u0005=\u00111C\u0007\u0002K&\u0019\u0011\u0011C3\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\rQ\u0015QC\u0005\u0004\u0003/\u0011$aD!ts:\u001cWI^3oiF+X-^3\u0002\u000fE,X-^3tA\u0005a\u0011/^3vK\u0012,e/\u001a8ugV\u0011\u0011q\u0004\t\u0007\u0003C\tY#a\f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\tq!\\;uC\ndWMC\u0002\u0002*u\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti#a\t\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0002K\u0003cI1!a\r3\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\u0002!E,X-^3e\u000bZ,g\u000e^:`I\u0015\fHcA*\u0002:!Aq\u000bFA\u0001\u0002\u0004\ty\"A\u0007rk\u0016,X\rZ#wK:$8\u000f\t\u0015\u0004+\u0005\u0005\u0011\u0001E1eIR{7\u000b[1sK\u0012\fV/Z;f)\r\u0019\u00161\t\u0005\b\u0003\u000b2\u0002\u0019AA$\u0003!a\u0017n\u001d;f]\u0016\u0014\bc\u0001&\u0002J%\u0019\u00111\n\u001a\u0003-M\u0003\u0018M]6MSN$XM\\3s\u0013:$XM\u001d4bG\u0016\fA#\u00193e)>l\u0015M\\1hK6,g\u000e^)vKV,GcA*\u0002R!9\u0011QI\fA\u0002\u0005\u001d\u0013\u0001E1eIR{7\u000b^1ukN\fV/Z;f)\r\u0019\u0016q\u000b\u0005\b\u0003\u000bB\u0002\u0019AA$\u0003I\tG\r\u001a+p\u000bZ,g\u000e\u001e'pOF+X-^3\u0015\u0007M\u000bi\u0006C\u0004\u0002Fe\u0001\r!a\u0012\u0002\u0015\u0005$G\rV8Rk\u0016,X\rF\u0003T\u0003G\n)\u0007C\u0004\u0002Fi\u0001\r!a\u0012\t\u000f\u0005\u001d$\u00041\u0001\u0002j\u0005)\u0011/^3vKB!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=T(\u0004\u0002\u0002r)\u0019\u00111\u000f\"\u0002\rq\u0012xn\u001c;?\u0013\r\t9(P\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]T(\u0001\bsK6|g/\u001a'jgR,g.\u001a:\u0015\u0007M\u000b\u0019\tC\u0004\u0002Fm\u0001\r!a\u0012\u0002\tA|7\u000f\u001e\u000b\u0004'\u0006%\u0005bBAF9\u0001\u0007\u0011qF\u0001\u0006KZ,g\u000e^\u0001\ra>\u001cH\u000fV8Rk\u0016,Xm\u001d\u000b\u0004'\u0006E\u0005bBAF;\u0001\u0007\u0011qF\u0001\u0006gR\f'\u000f\u001e\u000b\u0006'\u0006]\u00151\u0014\u0005\u0007\u00033s\u0002\u0019\u0001(\u0002\u0005M\u001c\u0007bBAO=\u0001\u0007\u0011qT\u0001\u000e[\u0016$(/[2t'f\u001cH/Z7\u0011\t\u0005\u0005\u0016QU\u0007\u0003\u0003GS!!\u0017\u001b\n\t\u0005\u001d\u00161\u0015\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u0002\u001d]\f\u0017\u000e^+oi&dW)\u001c9usR\u00191+!,\t\r\u0005=v\u00041\u0001y\u00035!\u0018.\\3pkRl\u0015\u000e\u001c7jg\"*q$a-\u0002@B)A(!.\u0002:&\u0019\u0011qW\u001f\u0003\rQD'o\\<t!\u0011\ti!a/\n\u0007\u0005uVM\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011\u0011X\u0001\u0005gR|\u0007\u000fF\u0001T\u0003Q1\u0017N\u001c3MSN$XM\\3sg\nK8\t\\1tgV!\u0011\u0011ZAr)\t\tY\r\u0006\u0003\u0002N\u0006=\bCBAh\u00033\fyN\u0004\u0003\u0002R\u0006Ug\u0002BA8\u0003'L\u0011AP\u0005\u0004\u0003/l\u0014a\u00029bG.\fw-Z\u0005\u0005\u00037\fiNA\u0002TKFT1!a6>!\u0011\t\t/a9\r\u0001\u00119\u0011Q]\u0011C\u0002\u0005\u001d(!\u0001+\u0012\t\u0005%\u0018q\t\t\u0004y\u0005-\u0018bAAw{\t9aj\u001c;iS:<\u0007\"CAyC\u0005\u0005\t9AAz\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003k\fY0a8\u000e\u0005\u0005](bAA}{\u00059!/\u001a4mK\u000e$\u0018\u0002BA\u007f\u0003o\u0014\u0001b\u00117bgN$\u0016mZ\u0001\nY&\u001cH/\u001a8feN,\"Aa\u0001\u0011\r\t\u0015!qAA$\u001b\u00059\u0017b\u0001B\u0005O\n!A*[:u\u00031\t7\r^5wKF+X-^3t)\t\u0011y\u0001\u0005\u0004\u0002l\tE\u0011\u0011N\u0005\u0005\u0005'\tiHA\u0002TKR\fq\u0002T5wK2K7\u000f^3oKJ\u0014Uo\u001d\t\u0003\u0015\u0016\u001a\"!J\u001e\u0015\u0005\t]\u0011\u0001F<ji\"Lg\u000eT5ti\u0016tWM\u001d+ie\u0016\fG-\u0006\u0002\u0003\"A1!1\u0005B\u0014\u0005Wi!A!\n\u000b\u0005!l\u0014\u0002\u0002B\u0015\u0005K\u0011q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\t\u0004y\t5\u0012b\u0001B\u0018{\t9!i\\8mK\u0006t\u0017!F<ji\"Lg\u000eT5ti\u0016tWM\u001d+ie\u0016\fG\rI\u0001\r'\"\u000b%+\u0012#`#V+U+R\u000b\u0003\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{I\u0017\u0001\u00027b]\u001eLA!a\u001f\u0003<\u0005i1\u000bS!S\u000b\u0012{\u0016+V#V\u000b\u0002\n\u0001#\u0011)Q?N#\u0016\tV+T?F+V)V#\u0002#\u0005\u0003\u0006kX*U\u0003R+6kX)V\u000bV+\u0005%A\rF1\u0016\u001bU\u000bV(S?6\u000be*Q$F\u001b\u0016sEkX)V\u000bV+\u0015AG#Y\u000b\u000e+Fk\u0014*`\u001b\u0006s\u0015iR#N\u000b:#v,U+F+\u0016\u0003\u0013aD#W\u000b:#v\fT(H?F+V)V#\u0002!\u00153VI\u0014+`\u0019>;u,U+F+\u0016\u0003\u0003")
public class LiveListenerBus {
    private final SparkConf conf;
    private SparkContext sparkContext;
    private final LiveListenerBusMetrics metrics;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final AtomicLong droppedEventsCounter;
    private volatile long lastReportTimestamp;
    private final CopyOnWriteArrayList<AsyncEventQueue> queues;
    private volatile ListBuffer<SparkListenerEvent> queuedEvents;

    public static DynamicVariable<Object> withinListenerThread() {
        return LiveListenerBus$.MODULE$.withinListenerThread();
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public LiveListenerBusMetrics metrics() {
        return this.metrics;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private AtomicLong droppedEventsCounter() {
        return this.droppedEventsCounter;
    }

    private long lastReportTimestamp() {
        return this.lastReportTimestamp;
    }

    private void lastReportTimestamp_$eq(long x$1) {
        this.lastReportTimestamp = x$1;
    }

    private CopyOnWriteArrayList<AsyncEventQueue> queues() {
        return this.queues;
    }

    public ListBuffer<SparkListenerEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void queuedEvents_$eq(ListBuffer<SparkListenerEvent> x$1) {
        this.queuedEvents = x$1;
    }

    public void addToSharedQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.SHARED_QUEUE());
    }

    public void addToManagementQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EXECUTOR_MANAGEMENT_QUEUE());
    }

    public void addToStatusQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.APP_STATUS_QUEUE());
    }

    public void addToEventLogQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EVENT_LOG_QUEUE());
    }

    public void addToQueue(SparkListenerInterface listener, String queue) {
        LiveListenerBus liveListenerBus = this;
        synchronized (liveListenerBus) {
            Object object;
            if (this.stopped().get()) {
                throw new IllegalStateException("LiveListenerBus is stopped.");
            }
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$addToQueue$1(queue, x$1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                AsyncEventQueue queue2 = (AsyncEventQueue)some.value();
                queue2.addListener(listener);
                object = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                AsyncEventQueue newQueue = new AsyncEventQueue(queue, this.conf, this.metrics(), this);
                newQueue.addListener(listener);
                if (this.started().get()) {
                    newQueue.start(this.sparkContext());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.queues().add(newQueue));
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public synchronized void removeListener(SparkListenerInterface listener) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).filter((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$1(listener, queue)))).foreach((Function1 & Serializable & scala.Serializable)toRemove -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$2(this, toRemove)));
    }

    public void post(SparkListenerEvent event) {
        block7: {
            if (this.stopped().get()) {
                return;
            }
            this.metrics().numEventsPosted().inc();
            if (this.queuedEvents() == null) {
                this.postToQueues(event);
                return;
            }
            LiveListenerBus liveListenerBus = this;
            synchronized (liveListenerBus) {
                block6: {
                    if (!this.started().get()) {
                        this.queuedEvents().$plus$eq((Object)event);
                        break block6;
                    }
                    break block7;
                }
                return;
            }
        }
        this.postToQueues(event);
    }

    private void postToQueues(SparkListenerEvent event) {
        Iterator<AsyncEventQueue> it = this.queues().iterator();
        while (it.hasNext()) {
            it.next().post(event);
        }
    }

    public synchronized void start(SparkContext sc, MetricsSystem metricsSystem) {
        if (!this.started().compareAndSet(false, true)) {
            throw new IllegalStateException("LiveListenerBus already started.");
        }
        this.sparkContext_$eq(sc);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)q -> {
            LiveListenerBus.$anonfun$start$1(this, sc, q);
            return BoxedUnit.UNIT;
        });
        this.queuedEvents_$eq(null);
        metricsSystem.registerSource(this.metrics());
    }

    public void waitUntilEmpty(long timeoutMillis) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            LiveListenerBus.$anonfun$waitUntilEmpty$1(deadline, timeoutMillis, queue);
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        if (!this.started().get()) {
            throw new IllegalStateException("Attempted to stop bus that has not yet started!");
        }
        if (!this.stopped().compareAndSet(false, true)) {
            return;
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        this.queues().clear();
    }

    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)queue -> queue.findListenersByClass(evidence$1), Buffer$.MODULE$.canBuildFrom());
    }

    public List<SparkListenerInterface> listeners() {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.listeners()).asScala(), Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    public Set<String> activeQueues() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$addToQueue$1(String queue$1, AsyncEventQueue x$1) {
        String string = x$1.name();
        String string2 = queue$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$1(SparkListenerInterface listener$1, AsyncEventQueue queue) {
        queue.removeListener(listener$1);
        return queue.listeners().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$2(LiveListenerBus $this, AsyncEventQueue toRemove) {
        block0: {
            if (!$this.started().get() || $this.stopped().get()) break block0;
            toRemove.stop();
        }
        return $this.queues().remove(toRemove);
    }

    public static final /* synthetic */ void $anonfun$start$1(LiveListenerBus $this, SparkContext sc$1, AsyncEventQueue q) {
        q.start(sc$1);
        $this.queuedEvents().foreach((Function1 & Serializable & scala.Serializable)event -> {
            q.post(event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilEmpty$1(long deadline$1, long timeoutMillis$1, AsyncEventQueue queue) {
        if (!queue.waitUntilEmpty(deadline$1)) {
            throw new TimeoutException(new StringBuilder(39).append("The event queue is not empty after ").append(timeoutMillis$1).append(" ms.").toString());
        }
    }

    public LiveListenerBus(SparkConf conf) {
        this.conf = conf;
        this.metrics = new LiveListenerBusMetrics(conf);
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.droppedEventsCounter = new AtomicLong(0L);
        this.lastReportTimestamp = 0L;
        this.queues = new CopyOnWriteArrayList();
        this.queuedEvents = new ListBuffer();
    }
}

