/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.Pool;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulableBuilder;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0013'\u0001!r\u0003\u0002C \u0001\u0005\u000b\u0007I\u0011A!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\tC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0011\u0019Q\u0006\u0001)A\u0005%\"91\f\u0001b\u0001\n\u0003a\u0006B\u00026\u0001A\u0003%Q\fC\u0004l\u0001\t\u0007I\u0011A)\t\r1\u0004\u0001\u0015!\u0003S\u0011\u001di\u0007A1A\u0005\u0002ECaA\u001c\u0001!\u0002\u0013\u0011\u0006bB8\u0001\u0005\u0004%\t!\u0015\u0005\u0007a\u0002\u0001\u000b\u0011\u0002*\t\u000fE\u0004!\u0019!C\u0001#\"1!\u000f\u0001Q\u0001\nICqa\u001d\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004u\u0001\u0001\u0006IA\u0015\u0005\bk\u0002\u0011\r\u0011\"\u0001R\u0011\u00191\b\u0001)A\u0005%\"9q\u000f\u0001b\u0001\n\u0003\t\u0006B\u0002=\u0001A\u0003%!\u000bC\u0004z\u0001\t\u0007I\u0011A)\t\ri\u0004\u0001\u0015!\u0003S\u0011\u001dY\bA1A\u0005\u0002qDq!a\u0003\u0001A\u0003%Q\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0003\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u00111\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002 !9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\tI\t\u0001C!\u0003\u0017\u0013aCR1jeN\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\"vS2$WM\u001d\u0006\u0003O!\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001cB\u0001A\u00186sA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003\u0019J!\u0001\u000f\u0014\u0003%M\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\"vS2$WM\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003y!\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003}m\u0012q\u0001T8hO&tw-\u0001\u0005s_>$\bk\\8m\u0007\u0001)\u0012A\u0011\t\u0003m\rK!\u0001\u0012\u0014\u0003\tA{w\u000e\\\u0001\ne>|G\u000fU8pY\u0002\nAaY8oMB\u0011\u0001*S\u0007\u0002Q%\u0011!\n\u000b\u0002\n'B\f'o[\"p]\u001a\fa\u0001P5oSRtDcA'O\u001fB\u0011a\u0007\u0001\u0005\u0006\u007f\u0011\u0001\rA\u0011\u0005\u0006\r\u0012\u0001\raR\u0001#'\u000eCU\tR+M\u000bJ{\u0016\t\u0014'P\u0007\u0006#\u0016j\u0014(`\r&cUi\u0018)S\u001fB+%\u000bV-\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0004TiJLgnZ\u0001$'\u000eCU\tR+M\u000bJ{\u0016\t\u0014'P\u0007\u0006#\u0016j\u0014(`\r&cUi\u0018)S\u001fB+%\u000bV-!\u0003I\u00198\r[3ek2,'/\u00117m_\u000e4\u0015\u000e\\3\u0016\u0003u\u00032\u0001\r0a\u0013\ty\u0016G\u0001\u0004PaRLwN\u001c\t\u0003C\"t!A\u00194\u0011\u0005\r\fT\"\u00013\u000b\u0005\u0015\u0004\u0015A\u0002\u001fs_>$h(\u0003\u0002hc\u00051\u0001K]3eK\u001aL!!W5\u000b\u0005\u001d\f\u0014aE:dQ\u0016$W\u000f\\3s\u00032dwn\u0019$jY\u0016\u0004\u0013A\u0006#F\r\u0006+F\nV0T\u0007\"+E)\u0016'F%~3\u0015\nT#\u0002/\u0011+e)Q+M)~\u001b6\tS#E+2+%k\u0018$J\u0019\u0016\u0003\u0013!\u0007$B\u0013J{6k\u0011%F\tVcUIU0Q%>\u0003VI\u0015+J\u000bN\u000b!DR!J%~\u001b6\tS#E+2+%k\u0018)S\u001fB+%\u000bV%F'\u0002\n\u0011\u0003R#G\u0003VcEk\u0018)P\u001f2{f*Q'F\u0003I!UIR!V\u0019R{\u0006kT(M?:\u000bU*\u0012\u0011\u0002/5Ke*S'V\u001b~\u001b\u0006*\u0011*F'~\u0003&k\u0014)F%RK\u0016\u0001G'J\u001d&kU+T0T\u0011\u0006\u0013ViU0Q%>\u0003VI\u0015+ZA\u0005A2k\u0011%F\tVc\u0015JT$`\u001b>#Ui\u0018)S\u001fB+%\u000bV-\u00023M\u001b\u0005*\u0012#V\u0019&suiX'P\t\u0016{\u0006KU(Q\u000bJ#\u0016\fI\u0001\u0010/\u0016Ku\t\u0013+`!J{\u0005+\u0012*U3\u0006\u0001r+R%H\u0011R{\u0006KU(Q\u000bJ#\u0016\fI\u0001\u0013!>{Ej\u0018(B\u001b\u0016{\u0006KU(Q\u000bJ#\u0016,A\nQ\u001f>cuLT!N\u000b~\u0003&k\u0014)F%RK\u0006%\u0001\bQ\u001f>c5k\u0018)S\u001fB+%\u000bV-\u0002\u001fA{u\nT*`!J{\u0005+\u0012*U3\u0002\nq\u0003R#G\u0003VcEkX*D\u0011\u0016#U\u000bT%O\u000f~ku\nR#\u0016\u0003u\u00042A`A\u0002\u001d\t1t0C\u0002\u0002\u0002\u0019\nabU2iK\u0012,H.\u001b8h\u001b>$W-\u0003\u0003\u0002\u0006\u0005\u001d!!\u0002,bYV,\u0017bAA\u0005c\tYQI\\;nKJ\fG/[8o\u0003a!UIR!V\u0019R{6k\u0011%F\tVc\u0015JT$`\u001b>#U\tI\u0001\u0016\t\u00163\u0015)\u0016'U?6Ke*S'V\u001b~\u001b\u0006*\u0011*F+\t\t\t\u0002E\u00021\u0003'I1!!\u00062\u0005\rIe\u000e^\u0001\u0017\t\u00163\u0015)\u0016'U?6Ke*S'V\u001b~\u001b\u0006*\u0011*FA\u0005qA)\u0012$B+2#vlV#J\u000f\"#\u0016a\u0004#F\r\u0006+F\nV0X\u000b&;\u0005\n\u0016\u0011\u0002\u0015\t,\u0018\u000e\u001c3Q_>d7\u000f\u0006\u0002\u0002\"A\u0019\u0001'a\t\n\u0007\u0005\u0015\u0012G\u0001\u0003V]&$\u0018\u0001\u00052vS2$G)\u001a4bk2$\bk\\8m\u0003Y\u0011W/\u001b7e\r\u0006L'oU2iK\u0012,H.\u001a:Q_>dGCBA\u0011\u0003[\ti\u0004C\u0004\u00020\u0005\u0002\r!!\r\u0002\u0005%\u001c\b\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]b+\u0001\u0002j_&!\u00111HA\u001b\u0005-Ie\u000e];u'R\u0014X-Y7\t\r\u0005}\u0012\u00051\u0001a\u0003!1\u0017\u000e\\3OC6,\u0017AF4fiN\u001b\u0007.\u001a3vY&tw-T8eKZ\u000bG.^3\u0015\u0015\u0005\u0015\u0013qLA8\u0003g\n9\b\u0005\u0003\u0002H\u0005ecbAA%\u007f:!\u00111JA,\u001d\u0011\ti%!\u0016\u000f\t\u0005=\u00131\u000b\b\u0004G\u0006E\u0013\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0003\u0002\\\u0005u#AD*dQ\u0016$W\u000f\\5oO6{G-\u001a\u0006\u0004\u0003\u00031\u0003bBA1E\u0001\u0007\u00111M\u0001\ta>|GNT8eKB!\u0011QMA6\u001b\t\t9GC\u0002\u0002jE\n1\u0001_7m\u0013\u0011\ti'a\u001a\u0003\t9{G-\u001a\u0005\u0007\u0003c\u0012\u0003\u0019\u00011\u0002\u0011A|w\u000e\u001c(b[\u0016Dq!!\u001e#\u0001\u0004\t)%\u0001\u0007eK\u001a\fW\u000f\u001c;WC2,X\r\u0003\u0004\u0002@\t\u0002\r\u0001Y\u0001\fO\u0016$\u0018J\u001c;WC2,X\r\u0006\u0007\u0002\u0012\u0005u\u0014qPAA\u0003\u000b\u000b9\tC\u0004\u0002b\r\u0002\r!a\u0019\t\r\u0005E4\u00051\u0001a\u0011\u0019\t\u0019i\ta\u0001A\u0006a\u0001O]8qKJ$\u0018PT1nK\"9\u0011QO\u0012A\u0002\u0005E\u0001BBA G\u0001\u0007\u0001-A\tbI\u0012$\u0016m]6TKRl\u0015M\\1hKJ$b!!\t\u0002\u000e\u0006]\u0005bBAHI\u0001\u0007\u0011\u0011S\u0001\b[\u0006t\u0017mZ3s!\r1\u00141S\u0005\u0004\u0003+3#aC*dQ\u0016$W\u000f\\1cY\u0016Dq!!'%\u0001\u0004\tY*\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003C3\u0016\u0001B;uS2LA!!*\u0002 \nQ\u0001K]8qKJ$\u0018.Z:")
public class FairSchedulableBuilder
implements SchedulableBuilder,
Logging {
    private final Pool rootPool;
    private final String SCHEDULER_ALLOCATION_FILE_PROPERTY;
    private final Option<String> schedulerAllocFile;
    private final String DEFAULT_SCHEDULER_FILE;
    private final String FAIR_SCHEDULER_PROPERTIES;
    private final String DEFAULT_POOL_NAME;
    private final String MINIMUM_SHARES_PROPERTY;
    private final String SCHEDULING_MODE_PROPERTY;
    private final String WEIGHT_PROPERTY;
    private final String POOL_NAME_PROPERTY;
    private final String POOLS_PROPERTY;
    private final Enumeration.Value DEFAULT_SCHEDULING_MODE;
    private final int DEFAULT_MINIMUM_SHARE;
    private final int DEFAULT_WEIGHT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Pool rootPool() {
        return this.rootPool;
    }

    public String SCHEDULER_ALLOCATION_FILE_PROPERTY() {
        return this.SCHEDULER_ALLOCATION_FILE_PROPERTY;
    }

    public Option<String> schedulerAllocFile() {
        return this.schedulerAllocFile;
    }

    public String DEFAULT_SCHEDULER_FILE() {
        return this.DEFAULT_SCHEDULER_FILE;
    }

    public String FAIR_SCHEDULER_PROPERTIES() {
        return this.FAIR_SCHEDULER_PROPERTIES;
    }

    public String DEFAULT_POOL_NAME() {
        return this.DEFAULT_POOL_NAME;
    }

    public String MINIMUM_SHARES_PROPERTY() {
        return this.MINIMUM_SHARES_PROPERTY;
    }

    public String SCHEDULING_MODE_PROPERTY() {
        return this.SCHEDULING_MODE_PROPERTY;
    }

    public String WEIGHT_PROPERTY() {
        return this.WEIGHT_PROPERTY;
    }

    public String POOL_NAME_PROPERTY() {
        return this.POOL_NAME_PROPERTY;
    }

    public String POOLS_PROPERTY() {
        return this.POOLS_PROPERTY;
    }

    public Enumeration.Value DEFAULT_SCHEDULING_MODE() {
        return this.DEFAULT_SCHEDULING_MODE;
    }

    public int DEFAULT_MINIMUM_SHARE() {
        return this.DEFAULT_MINIMUM_SHARE;
    }

    public int DEFAULT_WEIGHT() {
        return this.DEFAULT_WEIGHT;
    }

    @Override
    public void buildPools() {
        None$ fileData = None$.MODULE$;
        try {
            try {
                fileData = (Option)this.schedulerAllocFile().map((Function1 & Serializable & scala.Serializable)f -> {
                    FileInputStream fis = new FileInputStream((String)f);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Creating Fair Scheduler pools from ").append((String)f).toString());
                    return new Some((Object)new Tuple2((Object)fis, f));
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    None$ none$;
                    InputStream is = Utils$.MODULE$.getSparkClassLoader().getResourceAsStream(this.DEFAULT_SCHEDULER_FILE());
                    if (is != null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Creating Fair Scheduler pools from default file: ").append(this.DEFAULT_SCHEDULER_FILE()).toString());
                        none$ = new Some((Object)new Tuple2((Object)is, (Object)this.DEFAULT_SCHEDULER_FILE()));
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(179).append("Fair Scheduler configuration file not found so jobs will be scheduled in ").append("FIFO order. To use fair scheduling, configure pools in ").append(this.DEFAULT_SCHEDULER_FILE()).append(" or ").append("set ").append(this.SCHEDULER_ALLOCATION_FILE_PROPERTY()).append(" to a file that contains the configuration.").toString());
                        none$ = None$.MODULE$;
                    }
                    return none$;
                });
                fileData.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FairSchedulableBuilder.$anonfun$buildPools$6(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    String defaultMessage = "Error while building the fair scheduler pools";
                    String message = (String)fileData.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String fileName = (String)tuple2._2();
                        String string = new StringBuilder(6).append(defaultMessage).append(" from ").append(fileName).toString();
                        return string;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultMessage);
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, t);
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            fileData.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                FairSchedulableBuilder.$anonfun$buildPools$10(x0$3);
                return BoxedUnit.UNIT;
            });
        }
        this.buildDefaultPool();
    }

    private void buildDefaultPool() {
        block0: {
            if (this.rootPool().getSchedulableByName(this.DEFAULT_POOL_NAME()) != null) break block0;
            Pool pool = new Pool(this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(pool);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created default pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MINIMUM_SHARE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WEIGHT())})));
        }
    }

    private void buildFairSchedulerPool(InputStream is, String fileName) {
        Elem xml = (Elem)XML$.MODULE$.load(is);
        xml.$bslash$bslash(this.POOLS_PROPERTY()).foreach((Function1 & Serializable & scala.Serializable)poolNode -> {
            FairSchedulableBuilder.$anonfun$buildFairSchedulerPool$1(this, fileName, poolNode);
            return BoxedUnit.UNIT;
        });
    }

    private Enumeration.Value getSchedulingModeValue(Node poolNode, String poolName, Enumeration.Value defaultValue, String fileName) {
        Enumeration.Value value;
        block3: {
            String xmlSchedulingMode = poolNode.$bslash(this.SCHEDULING_MODE_PROPERTY()).text().trim().toUpperCase(Locale.ROOT);
            String warningMessage = new StringBuilder(120).append("Unsupported schedulingMode: ").append(xmlSchedulingMode).append(" found in ").append("Fair Scheduler configuration file: ").append(fileName).append(", using ").append("the default schedulingMode: ").append(defaultValue).append(" for pool: ").append(poolName).toString();
            try {
                Enumeration.Value value2 = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                Enumeration.Value value3 = SchedulingMode$.MODULE$.NONE();
                if (value2 == null ? value3 != null : !value2.equals(value3)) {
                    value = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
            catch (NoSuchElementException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
        }
        return value;
    }

    private int getIntValue(Node poolNode, String poolName, String propertyName, int defaultValue, String fileName) {
        int n;
        String data = poolNode.$bslash(propertyName).text().trim();
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(data)).toInt();
        }
        catch (NumberFormatException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Error while loading fair scheduler configuration from ").append(fileName).append(": ").append(propertyName).append(" is blank or invalid: ").append(data).append(", using the default ").append(propertyName).append(": ").append(defaultValue).append(" for pool: ").append(poolName).toString());
            n = defaultValue;
        }
        return n;
    }

    @Override
    public void addTaskSetManager(Schedulable manager, Properties properties) {
        String poolName = properties != null ? properties.getProperty(this.FAIR_SCHEDULER_PROPERTIES(), this.DEFAULT_POOL_NAME()) : this.DEFAULT_POOL_NAME();
        Schedulable parentPool = this.rootPool().getSchedulableByName(poolName);
        if (parentPool == null) {
            parentPool = new Pool(poolName, this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(parentPool);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(251).append("A job was submitted with scheduler pool ").append(poolName).append(", which has not been ").append("configured. This can happen when the file that pools are read from isn't set, or ").append("when that file doesn't contain ").append(poolName).append(". Created ").append(poolName).append(" with default ").append("configuration (schedulingMode: ").append(this.DEFAULT_SCHEDULING_MODE()).append(", ").append("minShare: ").append(this.DEFAULT_MINIMUM_SHARE()).append(", weight: ").append(this.DEFAULT_WEIGHT()).append(")").toString());
        }
        parentPool.addSchedulable(manager);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Added task set ").append(manager.name()).append(" tasks to pool ").append(poolName).toString());
    }

    public static final /* synthetic */ void $anonfun$buildPools$6(FairSchedulableBuilder $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        String fileName = (String)tuple2._2();
        $this.buildFairSchedulerPool(is, fileName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildPools$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        is.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildFairSchedulerPool$1(FairSchedulableBuilder $this, String fileName$1, Node poolNode) {
        String poolName = poolNode.$bslash($this.POOL_NAME_PROPERTY()).text();
        Enumeration.Value schedulingMode = $this.getSchedulingModeValue(poolNode, poolName, $this.DEFAULT_SCHEDULING_MODE(), fileName$1);
        int minShare = $this.getIntValue(poolNode, poolName, $this.MINIMUM_SHARES_PROPERTY(), $this.DEFAULT_MINIMUM_SHARE(), fileName$1);
        int weight = $this.getIntValue(poolNode, poolName, $this.WEIGHT_PROPERTY(), $this.DEFAULT_WEIGHT(), fileName$1);
        $this.rootPool().addSchedulable(new Pool(poolName, schedulingMode, minShare, weight));
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{poolName, schedulingMode, BoxesRunTime.boxToInteger((int)minShare), BoxesRunTime.boxToInteger((int)weight)})));
    }

    public FairSchedulableBuilder(Pool rootPool, SparkConf conf) {
        this.rootPool = rootPool;
        Logging.$init$(this);
        this.SCHEDULER_ALLOCATION_FILE_PROPERTY = "spark.scheduler.allocation.file";
        this.schedulerAllocFile = conf.getOption(this.SCHEDULER_ALLOCATION_FILE_PROPERTY());
        this.DEFAULT_SCHEDULER_FILE = "fairscheduler.xml";
        this.FAIR_SCHEDULER_PROPERTIES = "spark.scheduler.pool";
        this.DEFAULT_POOL_NAME = "default";
        this.MINIMUM_SHARES_PROPERTY = "minShare";
        this.SCHEDULING_MODE_PROPERTY = "schedulingMode";
        this.WEIGHT_PROPERTY = "weight";
        this.POOL_NAME_PROPERTY = "@name";
        this.POOLS_PROPERTY = "pool";
        this.DEFAULT_SCHEDULING_MODE = SchedulingMode$.MODULE$.FIFO();
        this.DEFAULT_MINIMUM_SHARE = 0;
        this.DEFAULT_WEIGHT = 1;
    }
}

