/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3QAC\u0006\u0001\u001bMA\u0001B\n\u0001\u0003\u0002\u0003\u0006K\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)Q\u0005_!)Q\u0007\u0001C\u0001m!)Q\u0007\u0001C\tu!)Q\u0007\u0001C\u0001w!)1\t\u0001C!\t\")Q\t\u0001C!\r\")A\n\u0001C!\u001b\")a\u000b\u0001C!/\n\u00192i\\7qe\u0016\u001c8/\u001a3NCB\u001cF/\u0019;vg*\u0011A\"D\u0001\ng\u000eDW\rZ;mKJT!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\n\u0005\u0001QQb\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011aC\u0005\u0003;-\u0011\u0011\"T1q'R\fG/^:\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013AA5p\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\u001d\u0015CH/\u001a:oC2L'0\u00192mK\u0006\u0019An\\2\u0004\u0001A\u0011\u0011\u0006L\u0007\u0002U)\u00111&D\u0001\bgR|'/Y4f\u0013\ti#F\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u0002\u001f\r|W\u000e\u001d:fgN,GmU5{KN\u00042!\u0006\u00193\u0013\t\tdCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0016g%\u0011AG\u0006\u0002\u0005\u0005f$X-\u0001\u0004=S:LGO\u0010\u000b\u0004oaJ\u0004CA\u000e\u0001\u0011\u001513\u00011\u0001)\u0011\u0015q3\u00011\u00010)\u00059DcA\u001c={!)a%\u0002a\u0001Q!)a(\u0002a\u0001\u007f\u0005\tRO\\2p[B\u0014Xm]:fINK'0Z:\u0011\u0007U\u0001\u0004\t\u0005\u0002\u0016\u0003&\u0011!I\u0006\u0002\u0005\u0019>tw-\u0001\u0005m_\u000e\fG/[8o+\u0005A\u0013aD4fiNK'0\u001a$pe\ncwnY6\u0015\u0005\u0001;\u0005\"\u0002%\b\u0001\u0004I\u0015\u0001\u0003:fIV\u001cW-\u00133\u0011\u0005UQ\u0015BA&\u0017\u0005\rIe\u000e^\u0001\u000eoJLG/Z#yi\u0016\u0014h.\u00197\u0015\u00059\u000b\u0006CA\u000bP\u0013\t\u0001fC\u0001\u0003V]&$\b\"\u0002*\t\u0001\u0004\u0019\u0016aA8viB\u0011q\u0004V\u0005\u0003+\u0002\u0012Ab\u00142kK\u000e$x*\u001e;qkR\fAB]3bI\u0016CH/\u001a:oC2$\"A\u0014-\t\u000beK\u0001\u0019\u0001.\u0002\u0005%t\u0007CA\u0010\\\u0013\ta\u0006EA\u0006PE*,7\r^%oaV$\b")
public class CompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private byte[] compressedSizes;

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        return MapStatus$.MODULE$.decompressSize(this.compressedSizes[reduceId]);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            $this.loc.writeExternal(out);
            out.writeInt($this.compressedSizes.length);
            out.write($this.compressedSizes);
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            int len = in.readInt();
            $this.compressedSizes = new byte[len];
            in.readFully($this.compressedSizes);
        });
    }

    public CompressedMapStatus(BlockManagerId loc, byte[] compressedSizes) {
        this.loc = loc;
        this.compressedSizes = compressedSizes;
    }

    public CompressedMapStatus() {
        this((BlockManagerId)null, (byte[])null);
    }

    public CompressedMapStatus(BlockManagerId loc, long[] uncompressedSizes) {
        this(loc, (byte[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(uncompressedSizes)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(long size) {
                return MapStatus$.MODULE$.compressSize(size);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
    }
}

