/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011ea!B(Q\u0001AS\u0006\u0002C3\u0001\u0005\u000b\u0007I\u0011A4\t\u00111\u0004!\u0011!Q\u0001\n!D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"Q\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u00055\u0001A!A!\u0002\u0013\ty\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u0015\u0005%\u0002A1A\u0005\u0002A\u000bY\u0003\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0017\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\"\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA(\u0011%\t9\u0006\u0001b\u0001\n\u0013\tI\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA.\u0011\u001d\t)\u0007\u0001C\u0005\u0003OB\u0011\"a!\u0001\u0005\u0004%I!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC1\"a$\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0006\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\ty\n\u0001a\u0001\u0002\u0003\u0006K!a\"\t\u0013\u0005%\u0006A1A\u0005\u0002\u0005-\u0006\u0002CA]\u0001\u0001\u0006I!!,\t\u0015\u0005m\u0006A1A\u0005\u0002A\u000bi\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BA`\u0011-\t9\r\u0001a\u0001\u0002\u0004%I!!3\t\u0017\u0005U\u0007\u00011AA\u0002\u0013%\u0011q\u001b\u0005\f\u00037\u0004\u0001\u0019!A!B\u0013\tY\rC\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002b\"A\u0011q\u001e\u0001!\u0002\u0013\t\u0019\u000fC\u0005\u0002r\u0002\u0011\r\u0011\"\u0003\u0002t\"A!q\u0001\u0001!\u0002\u0013\t)\u0010\u0003\u0005\u0003\n\u0001!\t\u0001\u0015B\u0006\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'A!Ba\u0004\u0001\u0011\u000b\u0007I\u0011\tB\u000f\u0011\u001d\u0011\t\u0004\u0001C!\u0005gAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003\\\u0001!\tE!\u0018\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!A!1\u0010\u0001\u0005\u0002A\u0013i\b\u0003\u0005\u0003\b\u0002!\t\u0001\u0015BE\u0011!\u0011\u0019\n\u0001C\u0001!\nU\u0005\u0002\u0003Bh\u0001\u0011\u0005\u0001K!5\t\u0011\t\r\b\u0001\"\u0001Q\u0005KD\u0001B!@\u0001\t\u0003\u0001&q \u0005\b\u0005C\u0002A\u0011IB\u000b\u0011\u001d\u0019I\u0002\u0001C!\u00077Aqa!\b\u0001\t\u0003\u001aY\u0002C\u0004\u0004 \u0001!Iaa\u0007\t\u000f\tu\b\u0001\"\u0011\u0004\"!911\u0007\u0001\u0005B\rU\u0002bBB\u001f\u0001\u0011\u00053q\b\u0005\b\u0007\u001f\u0002A\u0011BB)\r\u0019\u00199\u0006\u0001\u0003\u0004Z!Q1q\r\u001c\u0003\u0002\u0003\u0006Ia!\u001b\t\u000f\u0005]a\u0007\"\u0001\u0004x!Y1q\u0010\u001cA\u0002\u0003\u0007I\u0011BBA\u0011-\u0019)J\u000ea\u0001\u0002\u0004%Iaa&\t\u0017\rme\u00071A\u0001B\u0003&11\u0011\u0005\b\u0007?3D\u0011ABQ\u0011\u001d\u00199K\u000eC!\u0007SCqaa,7\t\u0003\u001aY\u0002C\u0004\u00042Z\"\tea-\u0007\r\rm\u0006\u0001BB_\u0011)\u0019)\r\u0011B\u0001B\u0003%1q\u0019\u0005\u000b\u0007O\u0002%\u0011!Q\u0001\n\re\u0004BCA?\u0001\n\u0005\t\u0015!\u0003\u0003\f\"9\u0011q\u0003!\u0005\u0002\r5\u0007bBBl\u0001\u0012\u00053\u0011\u001c\u0005\b\u0007G\u0004E\u0011IBs\u0011\u001d\u0019I\u000f\u0011C!\u0007W<\u0001ba=Q\u0011\u0003\u00016Q\u001f\u0004\b\u001fBC\t\u0001UB|\u0011\u001d\t9\"\u0013C\u0001\u0007\u007fD!\u0002\"\u0001J\u0005\u0004%\t\u0001\u0015C\u0002\u0011!!y!\u0013Q\u0001\n\u0011\u0015\u0001B\u0003C\t\u0013\n\u0007I\u0011\u0001)\u0005\u0014!AAqC%!\u0002\u0013!)BA\u0006OKR$\u0018P\u00159d\u000b:4(BA)S\u0003\u0015qW\r\u001e;z\u0015\t\u0019F+A\u0002sa\u000eT!!\u0016,\u0002\u000bM\u0004\u0018M]6\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\n\u0004\u0001m{\u0006C\u0001/^\u001b\u0005\u0011\u0016B\u00010S\u0005\u0019\u0011\u0006oY#omB\u0011\u0001mY\u0007\u0002C*\u0011!\rV\u0001\tS:$XM\u001d8bY&\u0011A-\u0019\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001U\t\u0001\u000e\u0005\u0002jU6\tA+\u0003\u0002l)\nI1\u000b]1sW\u000e{gNZ\u0001\u0006G>tg\rI\u0001\u0017U\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dKB\u0011qN]\u0007\u0002a*\u0011\u0011\u000fV\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018BA:q\u0005YQ\u0015M^1TKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0017\u0001\u00025pgR\u0004\"A^@\u000f\u0005]l\bC\u0001=|\u001b\u0005I(B\u0001>g\u0003\u0019a$o\\8u})\tA0A\u0003tG\u0006d\u0017-\u0003\u0002\u007fw\u00061\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A`>\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u00042![A\u0005\u0013\r\tY\u0001\u0016\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006qa.^7Vg\u0006\u0014G.Z\"pe\u0016\u001c\b\u0003BA\t\u0003'i\u0011a_\u0005\u0004\u0003+Y(aA%oi\u00061A(\u001b8jiz\"B\"a\u0007\u0002 \u0005\u0005\u00121EA\u0013\u0003O\u00012!!\b\u0001\u001b\u0005\u0001\u0006\"B3\b\u0001\u0004A\u0007\"B7\b\u0001\u0004q\u0007\"\u0002;\b\u0001\u0004)\bbBA\u0003\u000f\u0001\u0007\u0011q\u0001\u0005\b\u0003\u001b9\u0001\u0019AA\b\u00035!(/\u00198ta>\u0014HoQ8oMV\u0011\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011)H/\u001b7\u000b\u0007\u0005]B+A\u0004oKR<xN]6\n\t\u0005m\u0012\u0011\u0007\u0002\u000e)J\fgn\u001d9peR\u001cuN\u001c4\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA\u0005QA-[:qCR\u001c\u0007.\u001a:\u0016\u0005\u0005\r\u0003\u0003BA\u000f\u0003\u000bJ1!a\u0012Q\u0005)!\u0015n\u001d9bi\u000eDWM]\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b%A\u0007tiJ,\u0017-\\'b]\u0006<WM]\u000b\u0003\u0003\u001f\u0002B!!\b\u0002R%\u0019\u00111\u000b)\u0003%9+G\u000f^=TiJ,\u0017-\\'b]\u0006<WM]\u0001\u000fgR\u0014X-Y7NC:\fw-\u001a:!\u0003A!(/\u00198ta>\u0014HoQ8oi\u0016DH/\u0006\u0002\u0002\\A!\u0011QLA0\u001b\t\t)$\u0003\u0003\u0002b\u0005U\"\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000fI\u0001\u0017GJ,\u0017\r^3DY&,g\u000e\u001e\"p_R\u001cHO]1qgR\u0011\u0011\u0011\u000e\t\u0007\u0003W\n\u0019(a\u001e\u000e\u0005\u00055$\u0002BA\u001a\u0003_R!!!\u001d\u0002\t)\fg/Y\u0005\u0005\u0003k\niG\u0001\u0003MSN$\b\u0003BA=\u0003\u007fj!!a\u001f\u000b\t\u0005u\u0014QG\u0001\u0007G2LWM\u001c;\n\t\u0005\u0005\u00151\u0010\u0002\u0019)J\fgn\u001d9peR\u001cE.[3oi\n{w\u000e^:ue\u0006\u0004\u0018!D2mS\u0016tGOR1di>\u0014\u00180\u0006\u0002\u0002\bB!\u0011\u0011PAE\u0013\u0011\tY)a\u001f\u0003-Q\u0013\u0018M\\:q_J$8\t\\5f]R4\u0015m\u0019;pef\fab\u00197jK:$h)Y2u_JL\b%A\ngS2,Gi\\<oY>\fGMR1di>\u0014\u00180A\fgS2,Gi\\<oY>\fGMR1di>\u0014\u0018p\u0018\u0013fcR!\u0011QSAN!\u0011\t\t\"a&\n\u0007\u0005e5P\u0001\u0003V]&$\b\"CAO)\u0005\u0005\t\u0019AAD\u0003\rAH%M\u0001\u0015M&dW\rR8x]2|\u0017\r\u001a$bGR|'/\u001f\u0011)\u0007U\t\u0019\u000b\u0005\u0003\u0002\u0012\u0005\u0015\u0016bAATw\nAao\u001c7bi&dW-\u0001\tuS6,w.\u001e;TG\",G-\u001e7feV\u0011\u0011Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*!\u00111WA7\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003o\u000b\tL\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0003a\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN]\u000b\u0003\u0003\u007f\u0003B!a,\u0002B&!\u00111YAY\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u00023\rd\u0017.\u001a8u\u0007>tg.Z2uS>tW\t_3dkR|'\u000fI\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005-\u0007\u0003BAg\u0003#l!!a4\u000b\t\u0005\u001d\u0017QG\u0005\u0005\u0003'\fyMA\bUe\u0006t7\u000f]8siN+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0005\u0003+\u000bI\u000eC\u0005\u0002\u001en\t\t\u00111\u0001\u0002L\u000691/\u001a:wKJ\u0004\u0003f\u0001\u000f\u0002$\u000691\u000f^8qa\u0016$WCAAr!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003c\u000ba!\u0019;p[&\u001c\u0017\u0002BAw\u0003O\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:u_B\u0004X\r\u001a\u0011\u0002\u0011=,HOY8yKN,\"!!>\u0011\u0011\u0005=\u0016q_A~\u0005\u0003IA!!?\u00022\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007q\u000bi0C\u0002\u0002\u0000J\u0013!B\u00159d\u0003\u0012$'/Z:t!\u0011\tiBa\u0001\n\u0007\t\u0015\u0001K\u0001\u0004PkR\u0014w\u000e_\u0001\n_V$(m\u001c=fg\u0002\nAB]3n_Z,w*\u001e;c_b$B!!&\u0003\u000e!9!qB\u0011A\u0002\u0005m\u0018aB1eIJ,7o]\u0001\fgR\f'\u000f^*feZ,'\u000f\u0006\u0004\u0002\u0016\nU!\u0011\u0004\u0005\u0007\u0005/\u0011\u0003\u0019A;\u0002\u0017\tLg\u000eZ!eIJ,7o\u001d\u0005\b\u00057\u0011\u0003\u0019AA\b\u0003\u0011\u0001xN\u001d;\u0016\u0005\u0005m\bfA\u0012\u0003\"A!!1\u0005B\u0017\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012AC1o]>$\u0018\r^5p]*\u0011!1F\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005_\u0011)C\u0001\u0005Ok2d\u0017M\u00197f\u00035\u0019X\r^;q\u000b:$\u0007o\\5oiR1!Q\u0007B\u001e\u0005\u007f\u00012\u0001\u0018B\u001c\u0013\r\u0011ID\u0015\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011\u0019\u0011i\u0004\na\u0001k\u0006!a.Y7f\u0011\u001d\u0011\t\u0005\na\u0001\u0005\u0007\n\u0001\"\u001a8ea>Lg\u000e\u001e\t\u00049\n\u0015\u0013b\u0001B$%\nY!\u000b]2F]\u0012\u0004x.\u001b8u\u0003i\t7/\u001f8d'\u0016$X\u000f]#oIB|\u0017N\u001c;SK\u001a\u0014\u00150\u0016*J)\u0011\u0011iEa\u0016\u0011\r\t=#1\u000bB\u001b\u001b\t\u0011\tFC\u0002\u00024nLAA!\u0016\u0003R\t1a)\u001e;ve\u0016DaA!\u0017&\u0001\u0004)\u0018aA;sS\u0006!1\u000f^8q)\u0011\t)Ja\u0018\t\u000f\t\u0005d\u00051\u0001\u00036\u0005YQM\u001c3q_&tGOU3g\u00031\u0001xn\u001d;U_>+HOY8y)\u0019\t)Ja\u001a\u0003r!9!\u0011N\u0014A\u0002\t-\u0014\u0001\u0003:fG\u0016Lg/\u001a:\u0011\t\u0005u!QN\u0005\u0004\u0005_\u0002&a\u0005(fiRL(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007b\u0002B:O\u0001\u0007!QO\u0001\b[\u0016\u001c8/Y4f!\u0011\tiBa\u001e\n\u0007\te\u0004KA\u0007PkR\u0014w\u000e_'fgN\fw-Z\u0001\u0005g\u0016tG\r\u0006\u0003\u0002\u0016\n}\u0004b\u0002B:Q\u0001\u0007!\u0011\u0011\t\u0005\u0003;\u0011\u0019)C\u0002\u0003\u0006B\u0013aBU3rk\u0016\u001cH/T3tg\u0006<W-\u0001\u0007de\u0016\fG/Z\"mS\u0016tG\u000f\u0006\u0003\u0003\f\nE\u0005\u0003BA=\u0005\u001bKAAa$\u0002|\tyAK]1ogB|'\u000f^\"mS\u0016tG\u000fC\u0004\u0003\u0010%\u0002\r!a?\u0002\u0007\u0005\u001c8.\u0006\u0003\u0003\u0018\n\u0005FC\u0002BM\u0005\u0007\u0014)\r\u0006\u0003\u0003\u001c\nM\u0006C\u0002B(\u0005'\u0012i\n\u0005\u0003\u0003 \n\u0005F\u0002\u0001\u0003\b\u0005GS#\u0019\u0001BS\u0005\u0005!\u0016\u0003\u0002BT\u0005[\u0003B!!\u0005\u0003*&\u0019!1V>\u0003\u000f9{G\u000f[5oOB!\u0011\u0011\u0003BX\u0013\r\u0011\tl\u001f\u0002\u0004\u0003:L\b\"\u0003B[U\u0005\u0005\t9\u0001B\\\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005s\u0013yL!(\u000e\u0005\tm&b\u0001B_w\u00069!/\u001a4mK\u000e$\u0018\u0002\u0002Ba\u0005w\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\b\u0005gR\u0003\u0019\u0001BA\u0011\u001d\u00119M\u000ba\u0001\u0005\u0013\fq\u0001^5nK>,H\u000fE\u0002]\u0005\u0017L1A!4S\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f^\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$BAa5\u0003`B!!Q\u001bBn\u001b\t\u00119N\u0003\u0003\u0003Z\u0006=\u0014a\u00018j_&!!Q\u001cBl\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0005C\\\u0003\u0019\u0001BW\u0003\u001d\u0019wN\u001c;f]R\fqb]3sS\u0006d\u0017N_3TiJ,\u0017-\u001c\u000b\u0005\u0005O\u0014i\u000fE\u0002p\u0005SL1Aa;q\u0005M\u0019VM]5bY&T\u0018\r^5p]N#(/Z1n\u0011\u001d\u0011y\u000f\fa\u0001\u0005c\f1a\\;u!\u0011\u0011\u0019P!?\u000e\u0005\tU(\u0002\u0002B|\u0003_\n!![8\n\t\tm(Q\u001f\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0003\u0004\u0002\r\u001dACBB\u0002\u0007\u001f\u0019\t\u0002\u0006\u0003\u0004\u0006\r%\u0001\u0003\u0002BP\u0007\u000f!qAa).\u0005\u0004\u0011)\u000bC\u0005\u0004\f5\n\t\u0011q\u0001\u0004\u000e\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\te&qXB\u0003\u0011\u001d\ti(\fa\u0001\u0005\u0017Cqaa\u0005.\u0001\u0004\u0011\u0019.A\u0003csR,7\u000f\u0006\u0003\u00036\r]\u0001b\u0002B!]\u0001\u0007!1I\u0001\tg\",H\u000fZ8x]R\u0011\u0011QS\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:\fqa\u00197fC:,\b/\u0006\u0003\u0004$\r\u001dB\u0003BB\u0013\u0007S\u0001BAa(\u0004(\u00119!1\u0015\u001aC\u0002\t\u0015\u0006bBB\u0016e\u0001\u00071QF\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0019\t\tba\f\u0004&%\u00191\u0011G>\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014A\u00034jY\u0016\u001cVM\u001d<feV\u00111q\u0007\t\u00049\u000ee\u0012bAB\u001e%\n\u0001\"\u000b]2F]Z4\u0015\u000e\\3TKJ4XM]\u0001\f_B,gn\u00115b]:,G\u000e\u0006\u0003\u0004B\r5\u0003\u0003BB\"\u0007\u0013j!a!\u0012\u000b\t\r\u001d#q[\u0001\tG\"\fgN\\3mg&!11JB#\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011\u0019\u0011I\u0006\u000ea\u0001k\u0006qAm\\<oY>\fGm\u00117jK:$HC\u0002BF\u0007'\u001a)\u0006C\u0003uk\u0001\u0007Q\u000fC\u0004\u0003\u001cU\u0002\r!a\u0004\u0003'\u0019KG.\u001a#po:dw.\u00193DQ\u0006tg.\u001a7\u0014\u000bY\u001aYf!\u0011\u0011\t\ru31M\u0007\u0003\u0007?RAa!\u0019\u0002p\u0005!A.\u00198h\u0013\u0011\u0019)ga\u0018\u0003\r=\u0013'.Z2u\u0003\u0019\u0019x.\u001e:dKB!11NB9\u001d\u0011\u0019\u0019e!\u001c\n\t\r=4QI\u0001\u0005!&\u0004X-\u0003\u0003\u0004t\rU$!D*pkJ\u001cWm\u00115b]:,GN\u0003\u0003\u0004p\r\u0015C\u0003BB=\u0007{\u00022aa\u001f7\u001b\u0005\u0001\u0001bBB4q\u0001\u00071\u0011N\u0001\u0006KJ\u0014xN]\u000b\u0003\u0007\u0007\u0003Ba!\"\u0004\u0010:!1qQBF\u001d\rA8\u0011R\u0005\u0002y&\u00191QR>\u0002\u000fA\f7m[1hK&!1\u0011SBJ\u0005%!\u0006N]8xC\ndWMC\u0002\u0004\u000en\f\u0011\"\u001a:s_J|F%Z9\u0015\t\u0005U5\u0011\u0014\u0005\n\u0003;S\u0014\u0011!a\u0001\u0007\u0007\u000ba!\u001a:s_J\u0004\u0003fA\u001e\u0002$\u0006A1/\u001a;FeJ|'\u000f\u0006\u0003\u0002\u0016\u000e\r\u0006bBBSy\u0001\u000711Q\u0001\u0002K\u0006!!/Z1e)\u0011\tyaa+\t\u000f\r5V\b1\u0001\u0003T\u0006\u0019Am\u001d;\u0002\u000b\rdwn]3\u0002\r%\u001cx\n]3o)\t\u0019)\f\u0005\u0003\u0002\u0012\r]\u0016bAB]w\n9!i\\8mK\u0006t'\u0001\u0006$jY\u0016$un\u001e8m_\u0006$7)\u00197mE\u0006\u001c7nE\u0003A\u00077\u001ay\f\u0005\u0003\u0002z\r\u0005\u0017\u0002BBb\u0003w\u0012ab\u0015;sK\u0006l7)\u00197mE\u0006\u001c7.\u0001\u0003tS:\\\u0007\u0003BB\"\u0007\u0013LAaa3\u0004F\t\u0019rK]5uC\ndWMQ=uK\u000eC\u0017M\u001c8fYRA1qZBi\u0007'\u001c)\u000eE\u0002\u0004|\u0001Cqa!2E\u0001\u0004\u00199\rC\u0004\u0004h\u0011\u0003\ra!\u001f\t\u000f\u0005uD\t1\u0001\u0003\f\u00061qN\u001c#bi\u0006$b!!&\u0004\\\u000e}\u0007BBBo\u000b\u0002\u0007Q/\u0001\u0005tiJ,\u0017-\\%e\u0011\u001d\u0019\t/\u0012a\u0001\u0005'\f1AY;g\u0003)ygnQ8na2,G/\u001a\u000b\u0005\u0003+\u001b9\u000f\u0003\u0004\u0004^\u001a\u0003\r!^\u0001\n_:4\u0015-\u001b7ve\u0016$b!!&\u0004n\u000e=\bBBBo\u000f\u0002\u0007Q\u000fC\u0004\u0004r\u001e\u0003\raa!\u0002\u000b\r\fWo]3\u0002\u00179+G\u000f^=Sa\u000e,eN\u001e\t\u0004\u0003;I5\u0003B%\u0004z~\u0003B!!\u0005\u0004|&\u00191Q`>\u0003\r\u0005s\u0017PU3g)\t\u0019)0\u0001\u0006dkJ\u0014XM\u001c;F]Z,\"\u0001\"\u0002\u0011\r\u0011\u001dA1BA\u000e\u001b\t!IAC\u0002\u00024mLA\u0001\"\u0004\u0005\n\tyA)\u001f8b[&\u001cg+\u0019:jC\ndW-A\u0006dkJ\u0014XM\u001c;F]Z\u0004\u0013!D2veJ,g\u000e^\"mS\u0016tG/\u0006\u0002\u0005\u0016A1Aq\u0001C\u0006\u0005\u0017\u000babY;se\u0016tGo\u00117jK:$\b\u0005")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final SparkConf conf;
    private final JavaSerializerInstance javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new AuthClientBootstrap(this.transportConf(), this.securityManager.getSaslUser(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        block0: {
            Outbox outbox = this.outboxes().remove(address);
            if (outbox == null) break block0;
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new AuthServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(bindAddress, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.host, this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        this.host = null;
        return this.address;
    }

    @Override
    public RpcAddress address() {
        return !this.bitmap$0 ? this.address$lzycompute() : this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1 & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByURI$1(endpointRef, uri, BoxesRunTime.unboxToBoolean((Object)find)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, remoteAddr, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcAddress remoteAddr$1;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(34).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append("in ").append(this.timeout$1.duration()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteAddr$1 = remoteAddr$1;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)timeoutCancelable.cancel(true)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0 & Serializable & scala.Serializable)() -> this.deserialize((Function0 & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        block5: {
            if (!this.stopped().compareAndSet(false, true)) {
                return;
            }
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            Object object2 = this.clientConnectionExecutor() != null ? this.clientConnectionExecutor().shutdownNow() : BoxedUnit.UNIT;
            if (this.fileDownloadFactory() == null) break block5;
            this.fileDownloadFactory().close();
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this.streamManager();
    }

    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0 & Serializable & scala.Serializable)() -> "Host name must be defined.");
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0 & Serializable & scala.Serializable)() -> "Port must be defined.");
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Path must be defined.");
        Pipe pipe = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe.source());
        JFunction0.mcV.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            pipe.sink().close();
            source.close();
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$3 = () -> NettyRpcEnv.$anonfun$openChannel$6((Function0)x$1);
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(x$1, (Function0<BoxedUnit>)x$2, (Function0<BoxedUnit>)x$3);
        return source;
    }

    private TransportClient downloadClient(String host, int port) {
        if (this.fileDownloadFactory() == null) {
            NettyRpcEnv nettyRpcEnv = this;
            synchronized (nettyRpcEnv) {
                if (this.fileDownloadFactory() == null) {
                    String module = "files";
                    String prefix = "spark.rpc.io.";
                    SparkConf clone = this.conf().clone();
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Object object;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (key.startsWith(prefix)) {
                                String opt = key.substring(prefix.length());
                                object = clone.setIfMissing(new StringBuilder(10).append("spark.").append(module).append(".io.").append(opt).toString(), value);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        BoxedUnit boxedUnit = object;
                        return boxedUnit;
                    });
                    int ioThreads = clone.getInt("spark.files.io.threads", 1);
                    TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone, module, ioThreads);
                    TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                    this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                }
            }
        }
        return this.fileDownloadFactory().createClient(host, port);
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByURI$1(NettyRpcEndpointRef endpointRef$1, String uri$1, boolean find) {
        return find ? Future$.MODULE$.successful((Object)endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(uri$1));
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        block2: {
            if (promise$1.tryFailure(e)) break block2;
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!promise$1.trySuccess(object)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$openChannel$6(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1$1);
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager, int numUsableCores) {
        this.conf = conf;
        this.javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", numUsableCores));
        this.dispatcher = new Dispatcher(this, numUsableCores);
        this.streamManager = new NettyStreamManager(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Error downloading stream ").append(streamId).append(".").toString(), cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        private final Pipe.SourceChannel source;
        private volatile Throwable error;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
        }

        @Override
        public int read(ByteBuffer dst) {
            int bytesRead;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.source.read(dst));
            if (this.error() != null) {
                throw this.error();
            }
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable readErr = failure.exception();
                    throw readErr;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
            return n;
        }

        @Override
        public void close() {
            this.source.close();
        }

        @Override
        public boolean isOpen() {
            return this.source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, Pipe.SourceChannel source) {
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

