/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.NettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.OnStart$;
import org.apache.spark.rpc.netty.OnStop$;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\f\u0019\u0001a\u0011\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011Y\u0002!\u0011!Q\u0001\nIB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005s!)a\b\u0001C\u0001\u007f!91\t\u0001b\u0001\n#!\u0005B\u0002)\u0001A\u0003%Q\tC\u0004`\u0001\u0001\u0007I\u0011\u00021\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\"11\u000e\u0001Q!\n\u0005Dq!\u001c\u0001A\u0002\u0013%\u0001\rC\u0004o\u0001\u0001\u0007I\u0011B8\t\rE\u0004\u0001\u0015)\u0003b\u0011\u001d\u0019\b\u00011A\u0005\nQDq\u0001\u001f\u0001A\u0002\u0013%\u0011\u0010\u0003\u0004|\u0001\u0001\u0006K!\u001e\u0005\u0006{\u0002!\tA \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aa!!\u0006\u0001\t\u0003\u0001\u0007bBA\f\u0001\u0011E\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011BA\u0010\u0005\u0015IeNY8y\u0015\tI\"$A\u0003oKR$\u0018P\u0003\u0002\u001c9\u0005\u0019!\u000f]2\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c2\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&L\u0007\u0002W)\u0011A\u0006H\u0001\tS:$XM\u001d8bY&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0004\u0001U\t!\u0007\u0005\u00024i5\t\u0001$\u0003\u000261\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006aQM\u001c3q_&tGOU3gA\u0005AQM\u001c3q_&tG/F\u0001:!\tQ4(D\u0001\u001b\u0013\ta$DA\u0006Sa\u000e,e\u000e\u001a9pS:$\u0018!C3oIB|\u0017N\u001c;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005M\u0002\u0001\"B\u0018\u0006\u0001\u0004\u0011\u0004\"B\u001c\u0006\u0001\u0004I\u0014\u0001C7fgN\fw-Z:\u0016\u0003\u0015\u00032AR&N\u001b\u00059%B\u0001%J\u0003\u0011)H/\u001b7\u000b\u0003)\u000bAA[1wC&\u0011Aj\u0012\u0002\u000b\u0019&t7.\u001a3MSN$\bCA\u001aO\u0013\ty\u0005D\u0001\u0007J]\n|\u00070T3tg\u0006<W-A\u0005nKN\u001c\u0018mZ3tA!\"qA\u0015/^!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0016-\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0001Z\u0003\u0015Q\u0017M^1y\u0013\tYFKA\u0005Hk\u0006\u0014H-\u001a3Cs\u0006)a/\u00197vK\u0006\na,\u0001\u0003uQ&\u001c\u0018aB:u_B\u0004X\rZ\u000b\u0002CB\u0011AEY\u0005\u0003G\u0016\u0012qAQ8pY\u0016\fg.A\u0006ti>\u0004\b/\u001a3`I\u0015\fHC\u00014j!\t!s-\u0003\u0002iK\t!QK\\5u\u0011\u001dQ\u0017\"!AA\u0002\u0005\f1\u0001\u001f\u00132\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\u0006\u0002\u0006S9v\u000b\u0001#\u001a8bE2,7i\u001c8dkJ\u0014XM\u001c;\u0002)\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$x\fJ3r)\t1\u0007\u000fC\u0004k\u0019\u0005\u0005\t\u0019A1\u0002#\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$\b\u0005\u000b\u0003\u000e%rk\u0016\u0001\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193t+\u0005)\bC\u0001\u0013w\u0013\t9XEA\u0002J]R\fAC\\;n\u0003\u000e$\u0018N^3UQJ,\u0017\rZ:`I\u0015\fHC\u00014{\u0011\u001dQw\"!AA\u0002U\f\u0011C\\;n\u0003\u000e$\u0018N^3UQJ,\u0017\rZ:!Q\u0011\u0001\"\u000bX/\u0002\u000fA\u0014xnY3tgR\u0011am \u0005\b\u0003\u0003\t\u0002\u0019AA\u0002\u0003)!\u0017n\u001d9bi\u000eDWM\u001d\t\u0004g\u0005\u0015\u0011bAA\u00041\tQA)[:qCR\u001c\u0007.\u001a:\u0002\tA|7\u000f\u001e\u000b\u0004M\u00065\u0001BBA\b%\u0001\u0007Q*A\u0004nKN\u001c\u0018mZ3\u0002\tM$x\u000e\u001d\u000b\u0002M\u00069\u0011n]#naRL\u0018AB8o\tJ|\u0007\u000fF\u0002g\u00037Aa!a\u0004\u0016\u0001\u0004i\u0015AC:bM\u0016d\u0017pQ1mYR!\u0011\u0011EA\u0017)\r1\u00171\u0005\u0005\t\u0003K1B\u00111\u0001\u0002(\u00051\u0011m\u0019;j_:\u0004B\u0001JA\u0015M&\u0019\u00111F\u0013\u0003\u0011q\u0012\u0017P\\1nKzBQa\u000e\fA\u0002e\u0002")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    BoxedUnit boxedUnit;
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        boxedUnit = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit boxedUnit = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                } else if (OnStart$.MODULE$.equals(inboxMessage)) {
                    BoxedUnit boxedUnit;
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)inboxMessage);
                }
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    BoxedUnit boxedUnit2;
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable3;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            throw throwable;
        }
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

