/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.netty.Inbox;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.LocalNettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcMessage;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.Promise;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0016-\u000112\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!\u0011!Q\u0001\n)CQ!\u0014\u0001\u0005\u000293AA\u0015\u0001\u0005'\"AA\u000b\u0002BC\u0002\u0013\u0005Q\u000b\u0003\u0005b\t\t\u0005\t\u0015!\u0003W\u0011!\u0011GA!b\u0001\n\u0003\u0019\u0007\u0002\u00035\u0005\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011%$!Q1A\u0005\u0002)D\u0001B\u001c\u0003\u0003\u0002\u0003\u0006Ia\u001b\u0005\u0006\u001b\u0012!\ta\u001c\u0005\bk\u0012\u0011\r\u0011\"\u0001w\u0011\u0019QH\u0001)A\u0005o\"91\u0010\u0001b\u0001\n\u0013a\bbBA\b\u0001\u0001\u0006I! \u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"!\b\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"!\u000b\u0001A\u0003%\u00111\u0005\u0005\n\u0003W\u0001\u0001\u0019!C\u0005\u0003[A\u0011\"!\u000e\u0001\u0001\u0004%I!a\u000e\t\u0011\u0005\r\u0003\u0001)Q\u0005\u0003_Aq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a,\u0001\t\u0003\t\t\fC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005U\bbBA|\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003s\u0004A\u0011AA~\u0011%\ty\u0010\u0001b\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011\u0002B\u0002\r\u0019\u0011Y\u0001\u0001\u0003\u0003\u000e!1QJ\nC\u0001\u0005CAqA!\n'\t\u0003\n)\u0010C\u0005\u0003(\u0001\u0011\r\u0011\"\u0003\u0003*!9!1\u0006\u0001!\u0002\u0013\u0001(A\u0003#jgB\fGo\u00195fe*\u0011QFL\u0001\u0006]\u0016$H/\u001f\u0006\u0003_A\n1A\u001d9d\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7c\u0001\u00018{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0019\u0002\u0011%tG/\u001a:oC2L!AQ \u0003\u000f1{wmZ5oO\u0006Aa.\u001a;us\u0016sgo\u0001\u0001\u0011\u0005\u0019;U\"\u0001\u0017\n\u0005!c#a\u0003(fiRL(\u000b]2F]Z\faB\\;n+N\f'\r\\3D_J,7\u000f\u0005\u00029\u0017&\u0011A*\u000f\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002P!F\u0003\"A\u0012\u0001\t\u000b\r\u001b\u0001\u0019A#\t\u000b%\u001b\u0001\u0019\u0001&\u0003\u0019\u0015sG\r]8j]R$\u0015\r^1\u0014\u0005\u00119\u0014\u0001\u00028b[\u0016,\u0012A\u0016\t\u0003/zs!\u0001\u0017/\u0011\u0005eKT\"\u0001.\u000b\u0005m#\u0015A\u0002\u001fs_>$h(\u0003\u0002^s\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti\u0016(A\u0003oC6,\u0007%\u0001\u0005f]\u0012\u0004x.\u001b8u+\u0005!\u0007CA3g\u001b\u0005q\u0013BA4/\u0005-\u0011\u0006oY#oIB|\u0017N\u001c;\u0002\u0013\u0015tG\r]8j]R\u0004\u0013a\u0001:fMV\t1\u000e\u0005\u0002GY&\u0011Q\u000e\f\u0002\u0014\u001d\u0016$H/\u001f*qG\u0016sG\r]8j]R\u0014VMZ\u0001\u0005e\u00164\u0007\u0005\u0006\u0003qeN$\bCA9\u0005\u001b\u0005\u0001\u0001\"\u0002+\f\u0001\u00041\u0006\"\u00022\f\u0001\u0004!\u0007\"B5\f\u0001\u0004Y\u0017!B5oE>DX#A<\u0011\u0005\u0019C\u0018BA=-\u0005\u0015IeNY8y\u0003\u0019IgNY8yA\u0005IQM\u001c3q_&tGo]\u000b\u0002{B)a0a\u0003Wa6\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AC2p]\u000e,(O]3oi*!\u0011QAA\u0004\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006L1!!\u0004\u0000\u00055\u0019uN\\2veJ,g\u000e^'ba\u0006QQM\u001c3q_&tGo\u001d\u0011\u0002\u0019\u0015tG\r]8j]R\u0014VMZ:\u0016\u0005\u0005U\u0001C\u0002@\u0002\f\u0011\f9\u0002E\u0002f\u00033I1!a\u0007/\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fQ\"\u001a8ea>Lg\u000e\u001e*fMN\u0004\u0013!\u0003:fG\u0016Lg/\u001a:t+\t\t\u0019\u0003\u0005\u0003\u007f\u0003K\u0001\u0018bAA\u0014\u007f\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\u0006Q!/Z2fSZ,'o\u001d\u0011\u0002\u000fM$x\u000e\u001d9fIV\u0011\u0011q\u0006\t\u0004q\u0005E\u0012bAA\u001as\t9!i\\8mK\u0006t\u0017aC:u_B\u0004X\rZ0%KF$B!!\u000f\u0002@A\u0019\u0001(a\u000f\n\u0007\u0005u\u0012H\u0001\u0003V]&$\b\"CA!+\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\tgR|\u0007\u000f]3eA!:a#a\u0012\u0002Z\u0005m\u0003\u0003BA%\u0003+j!!a\u0013\u000b\t\u0005\u0005\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0006b]:|G/\u0019;j_:T!!a\u0015\u0002\u000b)\fg/\u0019=\n\t\u0005]\u00131\n\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!!\u0018\u0002\tQD\u0017n]\u0001\u0014e\u0016<\u0017n\u001d;feJ\u00038-\u00128ea>Lg\u000e\u001e\u000b\u0006W\u0006\r\u0014Q\r\u0005\u0006)^\u0001\rA\u0016\u0005\u0006E^\u0001\r\u0001Z\u0001\u0012O\u0016$(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA\f\u0003WBQA\u0019\rA\u0002\u0011\fAC]3n_Z,'\u000b]2F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA\u001d\u0003cBQAY\rA\u0002\u0011\fQ#\u001e8sK\u001eL7\u000f^3s%B\u001cWI\u001c3q_&tG\u000f\u0006\u0003\u0002:\u0005]\u0004\"\u0002+\u001b\u0001\u00041\u0016\u0001B:u_B$B!!\u000f\u0002~!9\u0011qP\u000eA\u0002\u0005]\u0011A\u0004:qG\u0016sG\r]8j]R\u0014VMZ\u0001\na>\u001cH\u000fV8BY2$B!!\u000f\u0002\u0006\"9\u0011q\u0011\u000fA\u0002\u0005%\u0015aB7fgN\fw-\u001a\t\u0004\r\u0006-\u0015bAAGY\ta\u0011J\u001c2pq6+7o]1hK\u0006\t\u0002o\\:u%\u0016lw\u000e^3NKN\u001c\u0018mZ3\u0015\r\u0005e\u00121SAN\u0011\u001d\t9)\ba\u0001\u0003+\u00032ARAL\u0013\r\tI\n\f\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0011\u001d\ti*\ba\u0001\u0003?\u000b\u0001bY1mY\n\f7m\u001b\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003\u0019\u0019G.[3oi*\u0019\u0011\u0011\u0016\u0019\u0002\u000f9,Go^8sW&!\u0011QVAR\u0005M\u0011\u0006o\u0019*fgB|gn]3DC2d'-Y2l\u0003A\u0001xn\u001d;M_\u000e\fG.T3tg\u0006<W\r\u0006\u0004\u0002:\u0005M\u0016Q\u0017\u0005\b\u0003\u000fs\u0002\u0019AAK\u0011\u001d\t9L\ba\u0001\u0003s\u000b\u0011\u0001\u001d\t\u0007\u0003w\u000by,a1\u000e\u0005\u0005u&bAA\u0001s%!\u0011\u0011YA_\u0005\u001d\u0001&o\\7jg\u0016\u00042\u0001OAc\u0013\r\t9-\u000f\u0002\u0004\u0003:L\u0018!\u00059pgR|e.Z,bs6+7o]1hKR!\u0011\u0011HAg\u0011\u001d\t9i\ba\u0001\u0003+\u000b1\u0002]8ti6+7o]1hKRA\u0011\u0011HAj\u0003/\fI\u000e\u0003\u0004\u0002V\u0002\u0002\rAV\u0001\rK:$\u0007o\\5oi:\u000bW.\u001a\u0005\b\u0003\u000f\u0003\u0003\u0019AAE\u0011\u001d\tY\u000e\ta\u0001\u0003;\f\u0011cY1mY\n\f7m[%g'R|\u0007\u000f]3e!\u001dA\u0014q\\Ar\u0003sI1!!9:\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002f\u0006=h\u0002BAt\u0003Wt1!WAu\u0013\u0005Q\u0014bAAws\u00059\u0001/Y2lC\u001e,\u0017\u0002BAy\u0003g\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u00055\u0018\b\u0006\u0002\u0002:\u0005\u0001\u0012m^1jiR+'/\\5oCRLwN\\\u0001\u0007m\u0016\u0014\u0018NZ=\u0015\t\u0005=\u0012Q \u0005\u0006)\u000e\u0002\rAV\u0001\u000bi\"\u0014X-\u00193q_>dWC\u0001B\u0002!\rq(QA\u0005\u0004\u0005\u000fy(A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f1\u0002\u001e5sK\u0006$\u0007o\\8mA\tYQ*Z:tC\u001e,Gj\\8q'\u00151#q\u0002B\u000e!\u0011\u0011\tBa\u0006\u000e\u0005\tM!\u0002\u0002B\u000b\u0003\u000f\tA\u0001\\1oO&!!\u0011\u0004B\n\u0005\u0019y%M[3diB!!\u0011\u0003B\u000f\u0013\u0011\u0011yBa\u0005\u0003\u0011I+hN\\1cY\u0016$\"Aa\t\u0011\u0005E4\u0013a\u0001:v]\u0006Q\u0001k\\5t_:\u0004\u0016\u000e\u001c7\u0016\u0003A\f1\u0002U8jg>t\u0007+\u001b7mA\u0001")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentMap<String, EndpointData> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor org$apache$spark$rpc$netty$Dispatcher$$threadpool;
    private final EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                throw new IllegalStateException("RpcEnv has been stopped");
            }
            if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) {
                throw new IllegalArgumentException(new StringBuilder(39).append("There is already an RpcEndpoint called ").append(name).toString());
            }
            EndpointData data = (EndpointData)this.endpoints().get(name);
            this.endpointRefs().put(data.endpoint(), data.ref());
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
        return endpointRef;
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    private void unregisterRpcEndpoint(String name) {
        block0: {
            EndpointData data = (EndpointData)this.endpoints().remove(name);
            if (data == null) break block0;
            data.inbox().stop();
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                Dispatcher.$anonfun$postToAll$1(this, message, e);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            callback.onFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            p.tryFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    private void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Some some2;
            EndpointData data = (EndpointData)this.endpoints().get(endpointName);
            if (this.stopped()) {
                some2 = new Some((Object)new RpcEnvStoppedException());
            } else if (data == null) {
                some2 = new Some((Object)new SparkException(new StringBuilder(16).append("Could not find ").append(endpointName).append(".").toString()));
            } else {
                data.inbox().post(message);
                this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
                some2 = None$.MODULE$;
            }
            some = some2;
        }
        Some error = some;
        error.foreach(callbackIfStopped);
    }

    public void stop() {
        block4: {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                block3: {
                    if (this.stopped()) break block3;
                    this.stopped_$eq(true);
                    break block4;
                }
                return;
            }
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)name -> {
            this.unregisterRpcEndpoint(name);
            return BoxedUnit.UNIT;
        });
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
        this.org$apache$spark$rpc$netty$Dispatcher$$threadpool().shutdown();
    }

    public void awaitTermination() {
        this.org$apache$spark$rpc$netty$Dispatcher$$threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    public ThreadPoolExecutor org$apache$spark$rpc$netty$Dispatcher$$threadpool() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$threadpool;
    }

    public EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    }

    public static final /* synthetic */ void $anonfun$postToAll$1(Dispatcher $this, InboxMessage message$1, Exception e) {
        Exception exception = e;
        if (exception instanceof RpcEnvStoppedException) {
            RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)exception;
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(rpcEnvStoppedException.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (exception != null) {
            Exception exception2 = exception;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(exception2.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)exception);
        }
    }

    public Dispatcher(NettyRpcEnv nettyEnv, int numUsableCores) {
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.endpoints = new ConcurrentHashMap<String, EndpointData>();
        this.endpointRefs = new ConcurrentHashMap<RpcEndpoint, RpcEndpointRef>();
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        int numThreads = nettyEnv.conf().getInt("spark.rpc.netty.dispatcher.numThreads", package$.MODULE$.max(2, availableCores));
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "dispatcher-event-loop");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> pool.execute(new MessageLoop()));
        this.org$apache$spark$rpc$netty$Dispatcher$$threadpool = pool;
        this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    public class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }

    public class MessageLoop
    implements Runnable {
        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        try {
                            EndpointData data;
                            EndpointData endpointData = data = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill();
                            if (!(endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null)) {
                                this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
                                return;
                            }
                            data.inbox().process(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer());
                            continue block8;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            throw throwable;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Throwable t) {
                    try {
                        this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$threadpool().execute(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().new MessageLoop());
                    }
                    finally {
                        throw t;
                    }
                }
            }
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }
}

