/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.memory.MemoryStore;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eeA\u0002\u0014(\u0003\u0003Is\u0006\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011)\u0003!\u0011!Q\u0001\n\u001dCQa\u0013\u0001\u0005\u00021Cqa\u0015\u0001C\u0002\u0013EA\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\bO\u0002\u0011\r\u0011\"\u0005U\u0011\u0019A\u0007\u0001)A\u0005+\"9!\u000e\u0001b\u0001\n#Y\u0007BB8\u0001A\u0003%A\u000eC\u0004r\u0001\t\u0007I\u0011C6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d!\bA1Q\u0005\u0012UDaA\u001e\u0001!\u0002\u00139\u0005bB<\u0001\u0005\u0004&\t\"\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B$\t\u000be\u0004a\u0011A;\t\u000bi\u0004a\u0011A;\t\u000bm\u0004AQ\u0001?\t\u000f\u0005M\u0001A\"\u0001\u0002\u0016!9\u0011q\u0007\u0001\u0007\u0002\u0005e\u0002\u0002CA!\u0001\u0019\u0005q%a\u0011\t\u0011\u00055\u0003\u0001\"\u0001(\u0003\u001fB\u0001\"a\u0016\u0001\t\u00039\u0013\u0011\f\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t)\u0007\u0001C\u0003\u0003OBq!!\u001b\u0001\t\u000b\tY\u0007\u0003\u0004\u0002r\u0001!)!\u001e\u0005\u0007\u0003g\u0002AQA;\t\u0011\u0005U\u0004\u0001\"\u0001(\u0003oB\u0011\"a\u001f\u0001\u0005\u0004%)!! \t\u0011\u0005}\u0004\u0001)A\u0007\u0003cA\u0001\"!!\u0001\u0005\u0004%\t!\u001e\u0005\b\u0003\u0007\u0003\u0001\u0015!\u0003H\u0011)\t)\t\u0001b\u0001\n\u000b9\u0013q\u0011\u0005\t\u0003/\u0003\u0001\u0015!\u0004\u0002\n\niQ*Z7pefl\u0015M\\1hKJT!\u0001K\u0015\u0002\r5,Wn\u001c:z\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7c\u0001\u00011mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"a\u000e\u001e\u000e\u0003aR!!O\u0015\u0002\u0011%tG/\u001a:oC2L!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"a\u0010!\u000e\u0003%J!!Q\u0015\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001\u00038v[\u000e{'/Z:\u0011\u0005E\"\u0015BA#3\u0005\rIe\u000e^\u0001\u0014_:DU-\u00199Ti>\u0014\u0018mZ3NK6|'/\u001f\t\u0003c!K!!\u0013\u001a\u0003\t1{gnZ\u0001\u0016_:DU-\u00199Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%B\u0011a\nA\u0007\u0002O!)A(\u0002a\u0001}!)!)\u0002a\u0001\u0007\")a)\u0002a\u0001\u000f\")!*\u0002a\u0001\u000f\u00069rN\u001c%fCB\u001cFo\u001c:bO\u0016lU-\\8ssB{w\u000e\\\u000b\u0002+B\u0011aJV\u0005\u0003/\u001e\u0012\u0011c\u0015;pe\u0006<W-T3n_JL\bk\\8m\u0003ayg\u000eS3baN#xN]1hK6+Wn\u001c:z!>|G\u000e\t\u0015\u0005\u000fi#W\r\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0003\u0017AC1o]>$\u0018\r^5p]*\t\u0011-A\u0003kCZ\f\u00070\u0003\u0002d9\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002M\u0006!A\u000f[5t\u0003aygM\u001a%fCB\u001cFo\u001c:bO\u0016lU-\\8ssB{w\u000e\\\u0001\u001a_\u001a4\u0007*Z1q'R|'/Y4f\u001b\u0016lwN]=Q_>d\u0007\u0005\u000b\u0003\n5\u0012,\u0017!G8o\u0011\u0016\f\u0007/\u0012=fGV$\u0018n\u001c8NK6|'/\u001f)p_2,\u0012\u0001\u001c\t\u0003\u001d6L!A\\\u0014\u0003'\u0015CXmY;uS>tW*Z7pef\u0004vn\u001c7\u00025=t\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB{w\u000e\u001c\u0011)\t-QF-Z\u0001\u001b_\u001a4\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB{w\u000e\\\u0001\u001c_\u001a4\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB{w\u000e\u001c\u0011)\t5QF-Z\u0001\u0011[\u0006DxJ\u001a4IK\u0006\u0004X*Z7pef,\u0012aR\u0001\u0012[\u0006DxJ\u001a4IK\u0006\u0004X*Z7pef\u0004\u0013\u0001F8gM\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180A\u000bpM\u001aDU-\u00199Ti>\u0014\u0018mZ3NK6|'/\u001f\u0011\u0002-5\f\u0007p\u00148IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\fq#\\1y\u001f\u001a4\u0007*Z1q'R|'/Y4f\u001b\u0016lwN]=\u0002\u001dM,G/T3n_JL8\u000b^8sKR\u0019Q0!\u0001\u0011\u0005Er\u0018BA@3\u0005\u0011)f.\u001b;\t\u000f\u0005\rA\u00031\u0001\u0002\u0006\u0005)1\u000f^8sKB!\u0011qAA\b\u001b\t\tIAC\u0002)\u0003\u0017Q1!!\u0004*\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0005\u0002\n\tYQ*Z7pef\u001cFo\u001c:f\u0003Q\t7-];je\u0016\u001cFo\u001c:bO\u0016lU-\\8ssRA\u0011qCA\u000f\u0003S\ti\u0003E\u00022\u00033I1!a\u00073\u0005\u001d\u0011un\u001c7fC:Dq!a\b\u0016\u0001\u0004\t\t#A\u0004cY>\u001c7.\u00133\u0011\t\u0005\r\u0012QE\u0007\u0003\u0003\u0017IA!a\n\u0002\f\t9!\t\\8dW&#\u0007BBA\u0016+\u0001\u0007q)\u0001\u0005ok6\u0014\u0015\u0010^3t\u0011\u001d\ty#\u0006a\u0001\u0003c\t!\"\\3n_JLXj\u001c3f!\rq\u00151G\u0005\u0004\u0003k9#AC'f[>\u0014\u00180T8eK\u0006\u0019\u0012mY9vSJ,WK\u001c:pY2lU-\\8ssRA\u0011qCA\u001e\u0003{\ty\u0004C\u0004\u0002 Y\u0001\r!!\t\t\r\u0005-b\u00031\u0001H\u0011\u001d\tyC\u0006a\u0001\u0003c\ta#Y2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\b\u000f\u0006\u0015\u0013qIA&\u0011\u0019\tYc\u0006a\u0001\u000f\"1\u0011\u0011J\fA\u0002\u001d\u000bQ\u0002^1tW\u0006#H/Z7qi&#\u0007bBA\u0018/\u0001\u0007\u0011\u0011G\u0001\u0017e\u0016dW-Y:f\u000bb,7-\u001e;j_:lU-\\8ssR9Q0!\u0015\u0002T\u0005U\u0003BBA\u00161\u0001\u0007q\t\u0003\u0004\u0002Ja\u0001\ra\u0012\u0005\b\u0003_A\u0002\u0019AA\u0019\u0003\u0001\u0012X\r\\3bg\u0016\fE\u000e\\#yK\u000e,H/[8o\u001b\u0016lwN]=G_J$\u0016m]6\u0015\u0007\u001d\u000bY\u0006\u0003\u0004\u0002Je\u0001\raR\u0001\u0015e\u0016dW-Y:f'R|'/Y4f\u001b\u0016lwN]=\u0015\u000bu\f\t'a\u0019\t\r\u0005-\"\u00041\u0001H\u0011\u001d\tyC\u0007a\u0001\u0003c\tqC]3mK\u0006\u001cX-\u00117m'R|'/Y4f\u001b\u0016lwN]=\u0015\u0003u\f1C]3mK\u0006\u001cX-\u00168s_2dW*Z7pef$R!`A7\u0003_Ba!a\u000b\u001d\u0001\u00049\u0005bBA\u00189\u0001\u0007\u0011\u0011G\u0001\u0014Kb,7-\u001e;j_:lU-\\8ssV\u001bX\rZ\u0001\u0012gR|'/Y4f\u001b\u0016lwN]=Vg\u0016$\u0017AH4fi\u0016CXmY;uS>tW*Z7pef,6/Y4f\r>\u0014H+Y:l)\r9\u0015\u0011\u0010\u0005\u0007\u0003\u0013z\u0002\u0019A$\u0002%Q,hnZ:uK:lU-\\8ss6{G-Z\u000b\u0003\u0003c\t1\u0003^;oON$XM\\'f[>\u0014\u00180T8eK\u0002\nQ\u0002]1hKNK'0\u001a\"zi\u0016\u001c\u0018A\u00049bO\u0016\u001c\u0016N_3CsR,7\u000fI\u0001\u0018iVtwm\u001d;f]6+Wn\u001c:z\u00032dwnY1u_J,\"!!#\u0011\t\u0005-\u00151S\u0007\u0003\u0003\u001bS1\u0001KAH\u0015\r\t\t*K\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005U\u0015Q\u0012\u0002\u0010\u001b\u0016lwN]=BY2|7-\u0019;pe\u0006AB/\u001e8hgR,g.T3n_JL\u0018\t\u001c7pG\u0006$xN\u001d\u0011")
public abstract class MemoryManager
implements Logging {
    @GuardedBy(value="this")
    private final StorageMemoryPool onHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final StorageMemoryPool offHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool onHeapExecutionMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool offHeapExecutionMemoryPool;
    private final long maxOffHeapMemory;
    private final long offHeapStorageMemory;
    private final MemoryMode tungstenMemoryMode;
    private final long pageSizeBytes;
    private final MemoryAllocator tungstenMemoryAllocator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StorageMemoryPool onHeapStorageMemoryPool() {
        return this.onHeapStorageMemoryPool;
    }

    public StorageMemoryPool offHeapStorageMemoryPool() {
        return this.offHeapStorageMemoryPool;
    }

    public ExecutionMemoryPool onHeapExecutionMemoryPool() {
        return this.onHeapExecutionMemoryPool;
    }

    public ExecutionMemoryPool offHeapExecutionMemoryPool() {
        return this.offHeapExecutionMemoryPool;
    }

    public long maxOffHeapMemory() {
        return this.maxOffHeapMemory;
    }

    public long offHeapStorageMemory() {
        return this.offHeapStorageMemory;
    }

    public abstract long maxOnHeapStorageMemory();

    public abstract long maxOffHeapStorageMemory();

    public final synchronized void setMemoryStore(MemoryStore store) {
        this.onHeapStorageMemoryPool().setMemoryStore(store);
        this.offHeapStorageMemoryPool().setMemoryStore(store);
    }

    public abstract boolean acquireStorageMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract boolean acquireUnrollMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract long acquireExecutionMemory(long var1, long var3, MemoryMode var5);

    public synchronized void releaseExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public synchronized long releaseAllExecutionMemoryForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId);
    }

    public synchronized void releaseStorageMemory(long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public final synchronized void releaseAllStorageMemory() {
        this.onHeapStorageMemoryPool().releaseAllMemory();
        this.offHeapStorageMemoryPool().releaseAllMemory();
    }

    public final synchronized void releaseUnrollMemory(long numBytes, MemoryMode memoryMode) {
        this.releaseStorageMemory(numBytes, memoryMode);
    }

    public final synchronized long executionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed() + this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long storageMemoryUsed() {
        return this.onHeapStorageMemoryPool().memoryUsed() + this.offHeapStorageMemoryPool().memoryUsed();
    }

    public synchronized long getExecutionMemoryUsageForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId);
    }

    public final MemoryMode tungstenMemoryMode() {
        return this.tungstenMemoryMode;
    }

    public long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final MemoryAllocator tungstenMemoryAllocator() {
        return this.tungstenMemoryAllocator;
    }

    public MemoryManager(SparkConf conf, int numCores, long onHeapStorageMemory, long onHeapExecutionMemory) {
        MemoryAllocator memoryAllocator;
        long l;
        MemoryMode memoryMode;
        Logging.$init$(this);
        this.onHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapStorageMemoryPool().incrementPoolSize(onHeapStorageMemory);
        this.onHeapExecutionMemoryPool().incrementPoolSize(onHeapExecutionMemory);
        this.maxOffHeapMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()));
        this.offHeapStorageMemory = (long)((double)this.maxOffHeapMemory() * conf.getDouble("spark.memory.storageFraction", 0.5));
        this.offHeapExecutionMemoryPool().incrementPoolSize(this.maxOffHeapMemory() - this.offHeapStorageMemory());
        this.offHeapStorageMemoryPool().incrementPoolSize(this.offHeapStorageMemory());
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE())) > 0L, (Function0 & Serializable & scala.Serializable)() -> "spark.memory.offHeap.size must be > 0 when spark.memory.offHeap.enabled == true");
            Predef$.MODULE$.require(Platform.unaligned(), (Function0 & Serializable & scala.Serializable)() -> "No support for unaligned Unsafe. Set spark.memory.offHeap.enabled to false.");
            memoryMode = MemoryMode.OFF_HEAP;
        } else {
            memoryMode = MemoryMode.ON_HEAP;
        }
        this.tungstenMemoryMode = memoryMode;
        long minPageSize = 0x100000L;
        long maxPageSize = 64L * minPageSize;
        int cores = numCores > 0 ? numCores : Runtime.getRuntime().availableProcessors();
        int safetyFactor = 16;
        MemoryMode memoryMode2 = this.tungstenMemoryMode();
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            l = this.onHeapExecutionMemoryPool().poolSize();
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            l = this.offHeapExecutionMemoryPool().poolSize();
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        long maxTungstenMemory = l;
        long size = ByteArrayMethods.nextPowerOf2((long)(maxTungstenMemory / (long)cores / (long)safetyFactor));
        long l2 = package$.MODULE$.min(maxPageSize, package$.MODULE$.max(minPageSize, size));
        this.pageSizeBytes = conf.getSizeAsBytes("spark.buffer.pageSize", l2);
        MemoryMode memoryMode3 = this.tungstenMemoryMode();
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode3)) {
            memoryAllocator = MemoryAllocator.HEAP;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode3)) {
            memoryAllocator = MemoryAllocator.UNSAFE;
        } else {
            throw new MatchError((Object)memoryMode3);
        }
        this.tungstenMemoryAllocator = memoryAllocator;
    }
}

