/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.io.CompressionCodec;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0003\u0006\u0001'!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\r1\u0002\u0001\u0015!\u0003*\u0011\u001di\u0003A1A\u0005\n!BaA\f\u0001!\u0002\u0013I\u0003\"B\u0018\u0001\t\u0003\u0002\u0004\"\u0002\u001e\u0001\t\u0003Z$\u0001\u0006.Ti\u0012\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7M\u0003\u0002\f\u0019\u0005\u0011\u0011n\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u000f\u000e\u0003)I!!\b\u0006\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017\u0001B2p]\u001a\u0004\"\u0001I\u0011\u000e\u00031I!A\t\u0007\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002&MA\u00111\u0004\u0001\u0005\u0006=\t\u0001\raH\u0001\u000bEV4g-\u001a:TSj,W#A\u0015\u0011\u0005UQ\u0013BA\u0016\u0017\u0005\rIe\u000e^\u0001\fEV4g-\u001a:TSj,\u0007%A\u0003mKZ,G.\u0001\u0004mKZ,G\u000eI\u0001\u0017G>l\u0007O]3tg\u0016$w*\u001e;qkR\u001cFO]3b[R\u0011\u0011\u0007\u000f\t\u0003eYj\u0011a\r\u0006\u0003\u0017QR\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028g\taq*\u001e;qkR\u001cFO]3b[\")\u0011h\u0002a\u0001c\u0005\t1/A\u000bd_6\u0004(/Z:tK\u0012Le\u000e];u'R\u0014X-Y7\u0015\u0005qz\u0004C\u0001\u001a>\u0013\tq4GA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B\u001d\t\u0001\u0004a\u0004F\u0001\u0001B!\t\u0011U)D\u0001D\u0015\t!E\"\u0001\u0006b]:|G/\u0019;j_:L!AR\"\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public class ZStdCompressionCodec
implements CompressionCodec {
    private final int bufferSize;
    private final int level;

    private int bufferSize() {
        return this.bufferSize;
    }

    private int level() {
        return this.level;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        return new BufferedOutputStream((OutputStream)new ZstdOutputStream(s, this.level()), this.bufferSize());
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStream(s), this.bufferSize());
    }

    public ZStdCompressionCodec(SparkConf conf) {
        this.bufferSize = (int)conf.getSizeAsBytes("spark.io.compression.zstd.bufferSize", "32k");
        this.level = conf.getInt("spark.io.compression.zstd.level", 1);
    }
}

