/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.security.HadoopDelegationTokenProvider;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0003\u0006\u0001\u001dQAQ!\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005B)BqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004@\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u0001\u0002!I!\u0011\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u00061\u0002!\t%\u0017\u0005\u0006S\u0002!IA\u001b\u0002\u001c\u0011&4X\rR3mK\u001e\fG/[8o)>\\WM\u001c)s_ZLG-\u001a:\u000b\u0005-a\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00055q\u0011A\u00023fa2|\u0017P\u0003\u0002\u0010!\u0005)1\u000f]1sW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h'\u0011\u0001QcG\u0010\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\u000b\u0013\tq\"BA\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s!\t\u00013%D\u0001\"\u0015\t\u0011c\"\u0001\u0005j]R,'O\\1m\u0013\t!\u0013EA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u000b\t\u00039\u0001\t1b]3sm&\u001cWMT1nKV\t1\u0006\u0005\u0002-g9\u0011Q&\r\t\u0003]]i\u0011a\f\u0006\u0003a\u0019\na\u0001\u0010:p_Rt\u0014B\u0001\u001a\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I:\u0012!F2mCN\u001chj\u001c;G_VtG-\u0012:s_J\u001cFO]\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005QR\u0014AF2mCN\u001chj\u001c;G_VtG-\u0012:s_J\u001cFO\u001d\u0011\u0002\u0011!Lg/Z\"p]\u001a$\"A\u0011&\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001B2p]\u001aT!a\u0012\t\u0002\r!\fGm\\8q\u0013\tIEIA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0017\u0016\u0001\rAQ\u0001\u000bQ\u0006$wn\u001c9D_:4\u0017\u0001\u00073fY\u0016<\u0017\r^5p]R{7.\u001a8t%\u0016\fX/\u001b:fIR\u0019a*U,\u0011\u0005Yy\u0015B\u0001)\u0018\u0005\u001d\u0011un\u001c7fC:DQA\u0015\u0004A\u0002M\u000b\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005Q+V\"\u0001\b\n\u0005Ys!!C*qCJ\\7i\u001c8g\u0011\u0015Ye\u00011\u0001C\u0003Yy'\r^1j]\u0012+G.Z4bi&|g\u000eV8lK:\u001cH\u0003\u0002.aC\n\u00042AF.^\u0013\tavC\u0001\u0004PaRLwN\u001c\t\u0003-yK!aX\f\u0003\t1{gn\u001a\u0005\u0006\u0017\u001e\u0001\rA\u0011\u0005\u0006%\u001e\u0001\ra\u0015\u0005\u0006G\u001e\u0001\r\u0001Z\u0001\u0006GJ,Gm\u001d\t\u0003K\u001el\u0011A\u001a\u0006\u0003\u0017\u0019K!\u0001\u001b4\u0003\u0017\r\u0013X\rZ3oi&\fGn]\u0001\rI>\f5OU3bYV\u001bXM]\u000b\u0003W:$\"\u0001\\<\u0011\u00055tG\u0002\u0001\u0003\u0006_\"\u0011\r\u0001\u001d\u0002\u0002)F\u0011\u0011\u000f\u001e\t\u0003-IL!a]\f\u0003\u000f9{G\u000f[5oOB\u0011a#^\u0005\u0003m^\u00111!\u00118z\u0011\u0019A\b\u0002\"a\u0001s\u0006\u0011aM\u001c\t\u0004-id\u0017BA>\u0018\u0005!a$-\u001f8b[\u0016t\u0004")
public class HiveDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private final String classNotFoundErrorStr;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String serviceName() {
        return "hive";
    }

    private String classNotFoundErrorStr() {
        return this.classNotFoundErrorStr;
    }

    private Configuration hiveConf(Configuration hadoopConf) {
        HiveConf hiveConf;
        try {
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        }
        catch (Throwable throwable) {
            Configuration configuration;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fail to create Hive Configuration", e);
                configuration = hadoopConf;
            } else if (throwable2 instanceof NoClassDefFoundError) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                configuration = hadoopConf;
            } else {
                throw throwable;
            }
            hiveConf = configuration;
        }
        return hiveConf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        String deployMode = sparkConf.get("spark.submit.deployMode", "client");
        if (!UserGroupInformation.isSecurityEnabled()) return false;
        if (!new StringOps(Predef$.MODULE$.augmentString(this.hiveConf(hadoopConf).getTrimmed("hive.metastore.uris", ""))).nonEmpty()) return false;
        if (SparkHadoopUtil$.MODULE$.get().isProxyUser(UserGroupInformation.getCurrentUser())) return true;
        String string = deployMode;
        String string2 = "cluster";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (sparkConf.contains(package$.MODULE$.KEYTAB())) return false;
        return true;
    }

    @Override
    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        None$ none$;
        try {
            try {
                Configuration conf = this.hiveConf(hadoopConf);
                String principalKey = "hive.metastore.kerberos.principal";
                String principal = conf.getTrimmed(principalKey, "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Hive principal ").append(principalKey).append(" undefined").toString());
                String metastoreUri = conf.getTrimmed("hive.metastore.uris", "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(metastoreUri)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Hive metastore uri undefined");
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Getting Hive delegation token for ").append(currentUser.getUserName()).append(" against ").append(principal).append(" at ").append(metastoreUri).toString());
                this.doAsRealUser((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Hive hive = Hive.get((Configuration)conf, HiveConf.class);
                    String tokenStr = hive.getDelegationToken(currentUser.getUserName(), principal);
                    Token hive2Token = new Token();
                    hive2Token.decodeFromUrlString(tokenStr);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Get Token from hive metastore: ").append(hive2Token.toString()).toString());
                    creds.addToken(new Text("hive.server2.delegation.token"), hive2Token);
                });
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                None$ none$2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to get token from service ").append(this.serviceName()).toString(), e);
                    none$2 = None$.MODULE$;
                } else if (throwable2 instanceof NoClassDefFoundError) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                    none$2 = None$.MODULE$;
                } else {
                    throw throwable;
                }
                none$ = none$2;
            }
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Hive.closeCurrent());
        }
        return none$;
    }

    private <T> T doAsRealUser(Function0<T> fn) {
        Object object;
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = (UserGroupInformation)Option$.MODULE$.apply((Object)currentUser.getRealUser()).getOrElse((Function0 & Serializable & scala.Serializable)() -> currentUser);
        try {
            object = realUser.doAs(new PrivilegedExceptionAction<T>(null, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Throwable)Option$.MODULE$.apply((Object)e.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> e);
        }
        return (T)object;
    }

    public HiveDelegationTokenProvider() {
        Logging.$init$(this);
        this.classNotFoundErrorStr = new StringBuilder(93).append("You are attempting to use the ").append(this.getClass().getCanonicalName()).append(", but your Spark distribution is not built with Hive libraries.").toString();
    }
}

