/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.ObjectInputStream;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.DriverInfo;
import org.apache.spark.deploy.master.ExecutorDesc;
import org.apache.spark.deploy.master.WorkerState$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]g!\u0002\u00180\u0001MJ\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011A#\t\u0011E\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0015\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t'\u0002\u0011\t\u0011)A\u0005\r\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!b\u0001\n\u0003)\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011q\u0003!Q1A\u0005\u0002UC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t=\u0002\u0011)\u0019!C\u0001?\"Aa\r\u0001B\u0001B\u0003%\u0001\r\u0003\u0005h\u0001\t\u0015\r\u0011\"\u0001F\u0011!A\u0007A!A!\u0002\u00131\u0005\"B5\u0001\t\u0003Q\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0001v\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%\t!!\u0002\t\u0015\u0005E\u0001\u00011A\u0001B\u0003&a\u000fC\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0001\u0003SA1\"!\f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002 !Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011AA\u001a\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%\t!a\u0012\t\u0017\u0005-\u0003\u00011A\u0001B\u0003&\u0011Q\u0007\u0005\u000b\u0003\u001f\u0002\u0001\u0019!a\u0001\n\u0003)\u0006bCA)\u0001\u0001\u0007\t\u0019!C\u0001\u0003'B!\"a\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u0011)\tY\u0006\u0001a\u0001\u0002\u0004%\t!\u0016\u0005\f\u0003;\u0002\u0001\u0019!a\u0001\n\u0003\ty\u0006\u0003\u0006\u0002d\u0001\u0001\r\u0011!Q!\nYC1\"a\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002j!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011AA:\u0011-\t9\b\u0001a\u0001\u0002\u0003\u0006K!a\u001b\t\r\u0005m\u0004\u0001\"\u0001V\u0011\u0019\ti\b\u0001C\u0001+\"9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\u0007\u00037\u0003A\u0011A#\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0003\ty\rC\u0004\u0002T\u0002!\t!!6\u0003\u0015]{'o[3s\u0013:4wN\u0003\u00021c\u00051Q.Y:uKJT!AM\u001a\u0002\r\u0011,\u0007\u000f\\8z\u0015\t!T'A\u0003ta\u0006\u00148N\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<7c\u0001\u0001;\u0001B\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\u0004\"aO!\n\u0005\tc$\u0001D*fe&\fG.\u001b>bE2,\u0017AA5e\u0007\u0001)\u0012A\u0012\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%cT\"\u0001&\u000b\u0005-#\u0015A\u0002\u001fs_>$h(\u0003\u0002Ny\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tiE(A\u0002jI\u0002\nA\u0001[8ti\u0006)\u0001n\\:uA\u0005!\u0001o\u001c:u+\u00051\u0006CA\u001eX\u0013\tAFHA\u0002J]R\fQ\u0001]8si\u0002\nQaY8sKN\faaY8sKN\u0004\u0013AB7f[>\u0014\u00180A\u0004nK6|'/\u001f\u0011\u0002\u0011\u0015tG\r]8j]R,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GN\n1A\u001d9d\u0013\t)'M\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u0013\u0015tG\r]8j]R\u0004\u0013\u0001D<fEVK\u0017\t\u001a3sKN\u001c\u0018!D<fEVK\u0017\t\u001a3sKN\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\tW6tw\u000e]9sgB\u0011A\u000eA\u0007\u0002_!)1i\u0004a\u0001\r\")!k\u0004a\u0001\r\")Ak\u0004a\u0001-\")!l\u0004a\u0001-\")Al\u0004a\u0001-\")al\u0004a\u0001A\")qm\u0004a\u0001\r\u0006IQ\r_3dkR|'o]\u000b\u0002mB!q\u000f $\u007f\u001b\u0005A(BA={\u0003\u001diW\u000f^1cY\u0016T!a\u001f\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~q\n9\u0001*Y:i\u001b\u0006\u0004\bC\u00017\u0000\u0013\r\t\ta\f\u0002\r\u000bb,7-\u001e;pe\u0012+7oY\u0001\u000eKb,7-\u001e;peN|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004w\u0005%\u0011bAA\u0006y\t!QK\\5u\u0011!\ty!EA\u0001\u0002\u00041\u0018a\u0001=%c\u0005QQ\r_3dkR|'o\u001d\u0011)\u0007I\t)\u0002E\u0002<\u0003/I1!!\u0007=\u0005%!(/\u00198tS\u0016tG/A\u0004ee&4XM]:\u0016\u0005\u0005}\u0001#B<}\r\u0006\u0005\u0002c\u00017\u0002$%\u0019\u0011QE\u0018\u0003\u0015\u0011\u0013\u0018N^3s\u0013:4w.A\u0006ee&4XM]:`I\u0015\fH\u0003BA\u0004\u0003WA\u0011\"a\u0004\u0015\u0003\u0003\u0005\r!a\b\u0002\u0011\u0011\u0014\u0018N^3sg\u0002B3!FA\u000b\u0003\u0015\u0019H/\u0019;f+\t\t)\u0004\u0005\u0003\u00028\u0005ubb\u00017\u0002:%\u0019\u00111H\u0018\u0002\u0017]{'o[3s'R\fG/Z\u0005\u0005\u0003\u007f\t\tEA\u0003WC2,X-C\u0002\u0002Dq\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006I1\u000f^1uK~#S-\u001d\u000b\u0005\u0003\u000f\tI\u0005C\u0005\u0002\u0010]\t\t\u00111\u0001\u00026\u000511\u000f^1uK\u0002B3\u0001GA\u000b\u0003%\u0019wN]3t+N,G-A\u0007d_J,7/V:fI~#S-\u001d\u000b\u0005\u0003\u000f\t)\u0006\u0003\u0005\u0002\u0010i\t\t\u00111\u0001W\u0003)\u0019wN]3t+N,G\r\t\u0015\u00047\u0005U\u0011AC7f[>\u0014\u00180V:fI\u0006qQ.Z7pef,6/\u001a3`I\u0015\fH\u0003BA\u0004\u0003CB\u0001\"a\u0004\u001e\u0003\u0003\u0005\rAV\u0001\f[\u0016lwN]=Vg\u0016$\u0007\u0005K\u0002\u001f\u0003+\tQ\u0002\\1ti\"+\u0017M\u001d;cK\u0006$XCAA6!\rY\u0014QN\u0005\u0004\u0003_b$\u0001\u0002'p]\u001e\f\u0011\u0003\\1ti\"+\u0017M\u001d;cK\u0006$x\fJ3r)\u0011\t9!!\u001e\t\u0013\u0005=\u0001%!AA\u0002\u0005-\u0014A\u00047bgRDU-\u0019:uE\u0016\fG\u000f\t\u0015\u0004C\u0005U\u0011!C2pe\u0016\u001chI]3f\u0003)iW-\\8ss\u001a\u0013X-Z\u0001\u000be\u0016\fGm\u00142kK\u000e$H\u0003BA\u0004\u0003\u0007Cq!!\"%\u0001\u0004\t9)\u0001\u0002j]B!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015AA5p\u0015\t\t\t*\u0001\u0003kCZ\f\u0017\u0002BAK\u0003\u0017\u0013\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1n\u0003\u0011Ig.\u001b;\u0015\u0005\u0005\u001d\u0011\u0001\u00035pgR\u0004vN\u001d;\u0002\u0017\u0005$G-\u0012=fGV$xN\u001d\u000b\u0005\u0003\u000f\t\t\u000b\u0003\u0004\u0002$\u001e\u0002\rA`\u0001\u0005Kb,7-\u0001\bsK6|g/Z#yK\u000e,Ho\u001c:\u0015\t\u0005\u001d\u0011\u0011\u0016\u0005\u0007\u0003GC\u0003\u0019\u0001@\u0002\u0017!\f7/\u0012=fGV$xN\u001d\u000b\u0005\u0003_\u000b)\fE\u0002<\u0003cK1!a-=\u0005\u001d\u0011un\u001c7fC:Dq!a.*\u0001\u0004\tI,A\u0002baB\u00042\u0001\\A^\u0013\r\til\f\u0002\u0010\u0003B\u0004H.[2bi&|g.\u00138g_\u0006I\u0011\r\u001a3Ee&4XM\u001d\u000b\u0005\u0003\u000f\t\u0019\rC\u0004\u0002F*\u0002\r!!\t\u0002\r\u0011\u0014\u0018N^3s\u00031\u0011X-\\8wK\u0012\u0013\u0018N^3s)\u0011\t9!a3\t\u000f\u0005\u00157\u00061\u0001\u0002\"\u0005A1/\u001a;Ti\u0006$X\r\u0006\u0003\u0002\b\u0005E\u0007bBA\u0019Y\u0001\u0007\u0011QG\u0001\bSN\fE.\u001b<f)\t\ty\u000b")
public class WorkerInfo
implements Serializable {
    private final String id;
    private final String host;
    private final int port;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef endpoint;
    private final String webUiAddress;
    private transient HashMap<String, ExecutorDesc> executors;
    private transient HashMap<String, DriverInfo> drivers;
    private transient Enumeration.Value state;
    private transient int coresUsed;
    private transient int memoryUsed;
    private transient long lastHeartbeat;

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public String webUiAddress() {
        return this.webUiAddress;
    }

    public HashMap<String, ExecutorDesc> executors() {
        return this.executors;
    }

    public void executors_$eq(HashMap<String, ExecutorDesc> x$1) {
        this.executors = x$1;
    }

    public HashMap<String, DriverInfo> drivers() {
        return this.drivers;
    }

    public void drivers_$eq(HashMap<String, DriverInfo> x$1) {
        this.drivers = x$1;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public int coresUsed() {
        return this.coresUsed;
    }

    public void coresUsed_$eq(int x$1) {
        this.coresUsed = x$1;
    }

    public int memoryUsed() {
        return this.memoryUsed;
    }

    public void memoryUsed_$eq(int x$1) {
        this.memoryUsed = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public int coresFree() {
        return this.cores() - this.coresUsed();
    }

    public int memoryFree() {
        return this.memory() - this.memoryUsed();
    }

    private void readObject(ObjectInputStream in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            in.defaultReadObject();
            this.init();
        });
    }

    private void init() {
        this.executors_$eq((HashMap<String, ExecutorDesc>)new HashMap());
        this.drivers_$eq((HashMap<String, DriverInfo>)new HashMap());
        this.state_$eq(WorkerState$.MODULE$.ALIVE());
        this.coresUsed_$eq(0);
        this.memoryUsed_$eq(0);
        this.lastHeartbeat_$eq(System.currentTimeMillis());
    }

    public String hostPort() {
        Predef$.MODULE$.assert(this.port() > 0);
        return new StringBuilder(1).append(this.host()).append(":").append(this.port()).toString();
    }

    public void addExecutor(ExecutorDesc exec) {
        this.executors().update((Object)exec.fullId(), (Object)exec);
        this.coresUsed_$eq(this.coresUsed() + exec.cores());
        this.memoryUsed_$eq(this.memoryUsed() + exec.memory());
    }

    public void removeExecutor(ExecutorDesc exec) {
        block0: {
            if (!this.executors().contains((Object)exec.fullId())) break block0;
            this.executors().$minus$eq((Object)exec.fullId());
            this.coresUsed_$eq(this.coresUsed() - exec.cores());
            this.memoryUsed_$eq(this.memoryUsed() - exec.memory());
        }
    }

    public boolean hasExecutor(ApplicationInfo app) {
        return this.executors().values().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$hasExecutor$1(app, x$1)));
    }

    public void addDriver(DriverInfo driver) {
        this.drivers().update((Object)driver.id(), (Object)driver);
        this.memoryUsed_$eq(this.memoryUsed() + driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() + driver.desc().cores());
    }

    public void removeDriver(DriverInfo driver) {
        this.drivers().$minus$eq((Object)driver.id());
        this.memoryUsed_$eq(this.memoryUsed() - driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() - driver.desc().cores());
    }

    public void setState(Enumeration.Value state) {
        this.state_$eq(state);
    }

    public boolean isAlive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = WorkerState$.MODULE$.ALIVE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasExecutor$1(ApplicationInfo app$1, ExecutorDesc x$1) {
        ApplicationInfo applicationInfo = x$1.application();
        ApplicationInfo applicationInfo2 = app$1;
        return !(applicationInfo != null ? !applicationInfo.equals(applicationInfo2) : applicationInfo2 != null);
    }

    public WorkerInfo(String id, String host, int port, int cores, int memory, RpcEndpointRef endpoint, String webUiAddress) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.cores = cores;
        this.memory = memory;
        this.endpoint = endpoint;
        this.webUiAddress = webUiAddress;
        Utils$.MODULE$.checkHost(host);
        Predef$.MODULE$.assert(port > 0);
        this.init();
    }
}

