/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.internal.Logging;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.WeakHashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!\u0002\u001b6\u0001ez\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011e\u0003!\u0011!Q\u0001\niCQ!\u0018\u0001\u0005\u0002yCqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0011\u0019Y\u0007\u0001)A\u0005\u001d\"9A\u000e\u0001b\u0001\n\u0003Q\u0007BB7\u0001A\u0003%a\nC\u0004o\u0001\t\u0007I\u0011B8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\b\u00011A\u0005\u0002aD\u0011\"a\u0001\u0001\u0001\u0004%\t!!\u0002\t\u000f\u0005E\u0001\u0001)Q\u0005s\"I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011Q\u0005\u0001A\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003_\u0001\u0001\u0019!C\u0001\u0003cA\u0001\"!\u000e\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003o\u0001!\u0019!C\u0001\u0003sA\u0001\"!\u0015\u0001A\u0003%\u00111\b\u0005\n\u0003'\u0002!\u0019!C\u0001\u0003+B\u0001\"!\u0018\u0001A\u0003%\u0011q\u000b\u0005\n\u0003?\u0002\u0001\u0019!C\u0001\u0003CB\u0011\"!\u001b\u0001\u0001\u0004%\t!a\u001b\t\u0011\u0005=\u0004\u0001)Q\u0005\u0003GB\u0011\"!\u001d\u0001\u0001\u0004%\t!a\u001d\t\u0013\u0005]\u0004\u00011A\u0005\u0002\u0005e\u0004\u0002CA?\u0001\u0001\u0006K!!\u001e\t\u0011\u0005}\u0004A1A\u0005\u0002)Dq!!!\u0001A\u0003%a\nC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005\n\u0005\u0015\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003\u001f\u0003A\u0011BAI\r\u0019\t9\u000b\u0001\u0003\u0002*\"1Q,\nC\u0001\u0003cCq!a.&\t\u0003\ni\tC\u0004\u0002:\u0002!I!!$\t\u000f\u0005m\u0006\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0018\u0001\u0005\u0002\u00055\u0005bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011AAe\u000f\u001d\ti-\u000eE\u0005\u0003\u001f4a\u0001N\u001b\t\n\u0005E\u0007BB//\t\u0003\t\u0019\u000eC\u0005\u0002V:\u0012\r\u0011\"\u0001\u0002(!A\u0011q\u001b\u0018!\u0002\u0013\tI\u0003C\u0005\u0002Z:\u0012\r\u0011\"\u0001\u0002(!A\u00111\u001c\u0018!\u0002\u0013\tICA\nQsRDwN\\,pe.,'OR1di>\u0014\u0018P\u0003\u00027o\u00051\u0001/\u001f;i_:T!\u0001O\u001d\u0002\u0007\u0005\u0004\u0018N\u0003\u0002;w\u0005)1\u000f]1sW*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h'\r\u0001\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%K\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005-C%a\u0002'pO\u001eLgnZ\u0001\u000baf$\bn\u001c8Fq\u0016\u001c7\u0001\u0001\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005E\u0013U\"\u0001*\u000b\u0005Mk\u0015A\u0002\u001fs_>$h(\u0003\u0002V\u0005\u00061\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)&)A\u0004f]Z4\u0016M]:\u0011\t=[fJT\u0005\u00039b\u00131!T1q\u0003\u0019a\u0014N\\5u}Q\u0019q,\u00192\u0011\u0005\u0001\u0004Q\"A\u001b\t\u000b1\u001b\u0001\u0019\u0001(\t\u000be\u001b\u0001\u0019\u0001.\u0002\u0013U\u001cX\rR1f[>tW#A3\u0011\u0005\u00053\u0017BA4C\u0005\u001d\u0011un\u001c7fC:\f!\"^:f\t\u0006,Wn\u001c8!\u00031!\u0017-Z7p]6{G-\u001e7f+\u0005q\u0015!\u00043bK6|g.T8ek2,\u0007%\u0001\u0007x_J\\WM]'pIVdW-A\u0007x_J\\WM]'pIVdW\rI\u0001\u000bCV$\b\u000eS3ma\u0016\u0014X#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005ML\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\u0005U\u0014(\u0001E*pG.,G/Q;uQ\"+G\u000e]3s\u0003-\tW\u000f\u001e5IK2\u0004XM\u001d\u0011\u0002\r\u0011\fW-\\8o+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0011a\u0017M\\4\u000b\u0003y\fAA[1wC&\u0019\u0011\u0011A>\u0003\u000fA\u0013xnY3tg\u0006QA-Y3n_:|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004\u0003\u0006%\u0011bAA\u0006\u0005\n!QK\\5u\u0011!\ty!DA\u0001\u0002\u0004I\u0018a\u0001=%c\u00059A-Y3n_:\u0004\u0013A\u00033bK6|g\u000eS8tiV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD?\u0002\u00079,G/\u0003\u0003\u0002\"\u0005m!aC%oKR\fE\r\u001a:fgN\f1\u0002Z1f[>t\u0007j\\:uA\u0005QA-Y3n_:\u0004vN\u001d;\u0016\u0005\u0005%\u0002cA!\u0002,%\u0019\u0011Q\u0006\"\u0003\u0007%sG/\u0001\beC\u0016lwN\u001c)peR|F%Z9\u0015\t\u0005\u001d\u00111\u0007\u0005\n\u0003\u001f\u0011\u0012\u0011!a\u0001\u0003S\t1\u0002Z1f[>t\u0007k\u001c:uA\u0005iA-Y3n_:<vN]6feN,\"!a\u000f\u0011\u0011\u0005u\u0012qIA&\u0003Si!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\b[V$\u0018M\u00197f\u0015\r\t)EQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u007f\u00111bV3bW\"\u000b7\u000f['baB!\u0011\u0011DA'\u0013\u0011\ty%a\u0007\u0003\rM{7m[3u\u00039!\u0017-Z7p]^{'o[3sg\u0002\n1\"\u001b3mK^{'o[3sgV\u0011\u0011q\u000b\t\u0007\u0003{\tI&a\u0013\n\t\u0005m\u0013q\b\u0002\u0006#V,W/Z\u0001\rS\u0012dWmV8sW\u0016\u00148\u000fI\u0001\rY\u0006\u001cH/Q2uSZLG/_\u000b\u0003\u0003G\u00022!QA3\u0013\r\t9G\u0011\u0002\u0005\u0019>tw-\u0001\tmCN$\u0018i\u0019;jm&$\u0018p\u0018\u0013fcR!\u0011qAA7\u0011%\ty!GA\u0001\u0002\u0004\t\u0019'A\u0007mCN$\u0018i\u0019;jm&$\u0018\u0010I\u0001\u000eg&l\u0007\u000f\\3X_J\\WM]:\u0016\u0005\u0005U\u0004cBA\u001f\u0003\u000f\nY%_\u0001\u0012g&l\u0007\u000f\\3X_J\\WM]:`I\u0015\fH\u0003BA\u0004\u0003wB\u0011\"a\u0004\u001d\u0003\u0003\u0005\r!!\u001e\u0002\u001dMLW\u000e\u001d7f/>\u00148.\u001a:tA\u0005Q\u0001/\u001f;i_:\u0004\u0016\r\u001e5\u0002\u0017ALH\u000f[8o!\u0006$\b\u000eI\u0001\u0007GJ,\u0017\r^3\u0015\u0005\u0005-\u0013aE2sK\u0006$X\r\u00165s_V<\u0007\u000eR1f[>t\u0017AE2sK\u0006$XmU5na2,wk\u001c:lKJ\f1b\u001d;beR$\u0015-Z7p]R\u0011\u0011qA\u0001\u0018e\u0016$\u0017N]3diN#(/Z1ngR{7\u000b\u001e3feJ$b!a\u0002\u0002\u0014\u0006\r\u0006bBAKI\u0001\u0007\u0011qS\u0001\u0007gR$w.\u001e;\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(~\u0003\tIw.\u0003\u0003\u0002\"\u0006m%aC%oaV$8\u000b\u001e:fC6Dq!!*%\u0001\u0004\t9*\u0001\u0004ti\u0012,'O\u001d\u0002\u000e\u001b>t\u0017\u000e^8s)\"\u0014X-\u00193\u0014\u0007\u0015\nY\u000bE\u0002{\u0003[K1!a,|\u0005\u0019!\u0006N]3bIR\u0011\u00111\u0017\t\u0004\u0003k+S\"\u0001\u0001\u0002\u0007I,h.\u0001\ndY\u0016\fg.\u001e9JI2,wk\u001c:lKJ\u001c\u0018AC:u_B$\u0015-Z7p]\u0006!1\u000f^8q\u0003)\u0019Ho\u001c9X_J\\WM\u001d\u000b\u0005\u0003\u000f\t\u0019\rC\u0004\u0002F.\u0002\r!a\u0013\u0002\r]|'o[3s\u00035\u0011X\r\\3bg\u0016<vN]6feR!\u0011qAAf\u0011\u001d\t)\r\fa\u0001\u0003\u0017\n1\u0003U=uQ>twk\u001c:lKJ4\u0015m\u0019;pef\u0004\"\u0001\u0019\u0018\u0014\u00059\u0002ECAAh\u0003]\u0001&kT\"F'N{v+Q%U?RKU*R(V)~k5+\u0001\rQ%>\u001bUiU*`/\u0006KEk\u0018+J\u001b\u0016{U\u000bV0N'\u0002\na#\u0013#M\u000b~;vJU&F%~#\u0016*T#P+R{VjU\u0001\u0018\u0013\u0012cUiX,P%.+%k\u0018+J\u001b\u0016{U\u000bV0N'\u0002\u0002")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemon;
    private final String daemonModule;
    private final String workerModule;
    private final SocketAuthHelper authHelper;
    private Process daemon;
    private final InetAddress daemonHost;
    private int daemonPort;
    private final WeakHashMap<Socket, Object> daemonWorkers;
    private final Queue<Socket> idleWorkers;
    private long lastActivity;
    private WeakHashMap<Socket, Process> simpleWorkers;
    private final String pythonPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int IDLE_WORKER_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_MS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean useDaemon() {
        return this.useDaemon;
    }

    public String daemonModule() {
        return this.daemonModule;
    }

    public String workerModule() {
        return this.workerModule;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    public Process daemon() {
        return this.daemon;
    }

    public void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    public int daemonPort() {
        return this.daemonPort;
    }

    public void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    public WeakHashMap<Socket, Object> daemonWorkers() {
        return this.daemonWorkers;
    }

    public Queue<Socket> idleWorkers() {
        return this.idleWorkers;
    }

    public long lastActivity() {
        return this.lastActivity;
    }

    public void lastActivity_$eq(long x$1) {
        this.lastActivity = x$1;
    }

    public WeakHashMap<Socket, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    public void simpleWorkers_$eq(WeakHashMap<Socket, Process> x$1) {
        this.simpleWorkers = x$1;
    }

    public String pythonPath() {
        return this.pythonPath;
    }

    public Socket create() {
        Socket socket;
        if (this.useDaemon()) {
            block7: {
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    Socket socket2;
                    block6: {
                        if (this.idleWorkers().size() > 0) {
                            socket2 = (Socket)this.idleWorkers().dequeue();
                            break block6;
                        }
                        break block7;
                    }
                    return socket2;
                }
            }
            socket = this.createThroughDaemon();
        } else {
            socket = this.createSimpleWorker();
        }
        return socket;
    }

    private Socket createThroughDaemon() {
        Socket socket;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            socket = this.liftedTree1$1();
        }
        return socket;
    }

    private Socket createSimpleWorker() {
        Socket socket;
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket(0, 1, InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte())));
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule()}));
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            workerEnv.put("PYTHON_WORKER_FACTORY_PORT", ((Object)BoxesRunTime.boxToInteger((int)serverSocket.getLocalPort())).toString());
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            Process worker = pb.start();
            this.redirectStreamsToStderr(worker.getInputStream(), worker.getErrorStream());
            serverSocket.setSoTimeout(10000);
            try {
                Socket socket2 = serverSocket.accept();
                this.authHelper().authClient(socket2);
                this.simpleWorkers().put((Object)socket2, (Object)worker);
                socket = socket2;
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", e);
            }
        }
        return socket;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule()});
            ProcessBuilder pb = new ProcessBuilder(command);
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                this.daemonPort_$eq(in.readInt());
            }
            catch (EOFException eOFException) {
                throw new SparkException(new StringBuilder(27).append("No port number in ").append(this.daemonModule()).append("'s stdout").toString());
            }
            if (this.daemonPort() < 1 || this.daemonPort() > 65535) {
                String arg$macro$1 = this.daemonModule();
                Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)this.daemonPort());
                int arg$macro$3 = this.daemonPort();
                String arg$macro$4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString(" ");
                String arg$macro$5 = this.pythonPath();
                String exceptionMessage = new StringOps("\n            |Bad data in %s's standard output. Invalid port number:\n            |  %s (0x%08x)\n            |Python command to execute the daemon was:\n            |  %s\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  %s\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToInteger((int)arg$macro$3), arg$macro$4, arg$macro$5}));
                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(exceptionMessage)).stripMargin());
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable & scala.Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = new StringBuilder(124).append("\n              |Error from python worker:\n              |  ").append(formattedStderr).append("\n              |PYTHONPATH was:\n              |  ").append(this.pythonPath()).append("\n              |").append(e).toString();
                SparkException wrappedException = new SparkException(new StringOps(Predef$.MODULE$.augmentString(errorMessage)).stripMargin());
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread(stdout, System.err, new StringBuilder(18).append("stdout reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, new StringBuilder(18).append("stderr reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in redirecting streams", e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            Socket worker = (Socket)this.idleWorkers().dequeue();
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    private void stopDaemon() {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            Map map;
            if (this.useDaemon()) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                if (this.daemon() != null) {
                    this.daemon().destroy();
                }
                this.daemon_$eq(null);
                this.daemonPort_$eq(0);
                map = BoxedUnit.UNIT;
            } else {
                map = this.simpleWorkers().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public void stop() {
        this.stopDaemon();
    }

    public void stopWorker(Socket worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
                        DataOutputStream output = new DataOutputStream(this.daemon().getOutputStream());
                        output.writeInt(pid);
                        output.flush();
                        this.daemon().getOutputStream().flush();
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.close();
    }

    public void releaseWorker(Socket worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.lastActivity_$eq(System.currentTimeMillis());
                this.idleWorkers().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Socket[]{worker}));
            }
        } else {
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Socket createSocket$1() {
        void var1_1;
        Socket socket = new Socket(this.daemonHost(), this.daemonPort());
        int pid = new DataInputStream(socket.getInputStream()).readInt();
        if (pid < 0) {
            throw new IllegalStateException(new StringBuilder(48).append("Python daemon failed to launch worker with code ").append(pid).toString());
        }
        this.authHelper().authToServer(socket);
        this.daemonWorkers().put((Object)socket, (Object)BoxesRunTime.boxToInteger((int)pid));
        return var1_1;
    }

    private final Socket liftedTree1$1() {
        Socket socket;
        try {
            socket = this.createSocket$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to open socket to Python daemon:", exc);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            socket = this.createSocket$1();
        }
        return socket;
    }

    public PythonWorkerFactory(String pythonExec, scala.collection.immutable.Map<String, String> envVars) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.envVars = envVars;
        Logging.$init$(this);
        boolean useDaemonEnabled = SparkEnv$.MODULE$.get().conf().getBoolean("spark.python.use.daemon", true);
        this.useDaemon = !System.getProperty("os.name").startsWith("Windows") && useDaemonEnabled;
        this.daemonModule = (String)SparkEnv$.MODULE$.get().conf().getOption("spark.python.daemon.module").map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Python daemon module in PySpark is set to [").append((String)value).append("] in 'spark.python.daemon.module', ").append("using this to start the daemon up. Note that this configuration only has an effect when ").append("'spark.python.use.daemon' is enabled and the platform is not Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.daemon");
        this.workerModule = (String)SparkEnv$.MODULE$.get().conf().getOption("spark.python.worker.module").map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("Python worker module in PySpark is set to [").append((String)value).append("] in 'spark.python.worker.module', ").append("using this to start the worker up. Note that this configuration only has an effect when ").append("'spark.python.use.daemon' is disabled or the platform is Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.worker");
        this.authHelper = new SocketAuthHelper(SparkEnv$.MODULE$.get().conf());
        this.daemon = null;
        this.daemonHost = InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte()));
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue();
        this.lastActivity = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "")}));
    }

    public class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                MonitorThread monitorThread = this;
                synchronized (monitorThread) {
                    if (this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().lastActivity() + (long)PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_MS() < System.currentTimeMillis()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().lastActivity_$eq(System.currentTimeMillis());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super(new StringBuilder(24).append("Idle Worker Monitor for ").append(PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString());
            this.setDaemon(true);
        }
    }
}

