/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001Q4Qa\u0003\u0007\u0001\u0019IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u00069\u0001!\t!\b\u0005\bA\u0001\u0011\r\u0011\"\u0001\"\u0011\u0019I\u0004\u0001)A\u0005E!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u0003A\u0001\u0011\u0005\u0013\tC\u0003h\u0001\u0011%\u0001\u000eC\u0003k\u0001\u0011\u00051\u000eC\u0003q\u0001\u0011\u0005\u0011O\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe^{'o[3s\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7C\u0001\u0001\u0014!\t!R#D\u0001\r\u0013\t1BB\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006!1m\u001c8g\u0007\u0001\u0001\"\u0001\u0006\u000e\n\u0005ma!!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011ad\b\t\u0003)\u0001AQa\u0006\u0002A\u0002e\t1\"\\1q'R\fG/^:fgV\t!\u0005\u0005\u0003$U1\u0002T\"\u0001\u0013\u000b\u0005\u00152\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003O!\n!bY8mY\u0016\u001cG/[8o\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016%\u0005\ri\u0015\r\u001d\t\u0003[9j\u0011\u0001K\u0005\u0003_!\u00121!\u00138u!\ri\u0013gM\u0005\u0003e!\u0012Q!\u0011:sCf\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0007\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018B\u0001\u001d6\u0005%i\u0015\r]*uCR,8/\u0001\u0007nCB\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0005gKR\u001c\u0007.\u001b8h+\u0005a\u0004cA\u0012>Y%\u0011a\b\n\u0002\b\u0011\u0006\u001c\bnU3u\u0003%1W\r^2iS:<\u0007%A\fhKRl\u0015\r]*ju\u0016\u001c()_#yK\u000e,Ho\u001c:JIR!!)Y2f!\r\u00195J\u0014\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\r\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013B\u0001&)\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0011%#XM]1u_JT!A\u0013\u0015\u0011\t5z\u0015kV\u0005\u0003!\"\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001*V\u001b\u0005\u0019&B\u0001+\r\u0003\u001d\u0019Ho\u001c:bO\u0016L!AV*\u0003\u001d\tcwnY6NC:\fw-\u001a:JIB\u00191\t\u0017.\n\u0005ek%aA*fcB!QfT._!\t\u0011F,\u0003\u0002^'\n9!\t\\8dW&#\u0007CA\u0017`\u0013\t\u0001\u0007F\u0001\u0003M_:<\u0007\"\u00022\b\u0001\u0004a\u0013!C:ik\u001a4G.Z%e\u0011\u0015!w\u00011\u0001-\u00039\u0019H/\u0019:u!\u0006\u0014H/\u001b;j_:DQAZ\u0004A\u00021\nA\"\u001a8e!\u0006\u0014H/\u001b;j_:\f1bZ3u'R\fG/^:fgR\u0011\u0001'\u001b\u0005\u0006E\"\u0001\r\u0001L\u0001\u0012k:\u0014XmZ5ti\u0016\u00148\u000b[;gM2,GC\u00017p!\tiS.\u0003\u0002oQ\t!QK\\5u\u0011\u0015\u0011\u0017\u00021\u0001-\u0003-)\b\u000fZ1uK\u0016\u0003xn\u00195\u0015\u00051\u0014\b\"B:\u000b\u0001\u0004q\u0016\u0001\u00038fo\u0016\u0003xn\u00195")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private final Map<Object, MapStatus[]> mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
    private final HashSet<Object> fetching = new HashSet();

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    private HashSet<Object> fetching() {
        return this.fetching;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> getMapSizesByExecutorId(int shuffleId, int startPartition, int endPartition) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fetching outputs for shuffle ").append(shuffleId).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
        MapStatus[] statuses = this.getStatuses(shuffleId);
        try {
            iterator = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, statuses);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            throw e;
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MapStatus[] getStatuses(int shuffleId) {
        BoxedUnit boxedUnit;
        MapStatus[] mapStatusArray;
        MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
        if (statuses != null) {
            void var2_2;
            mapStatusArray = var2_2;
            return mapStatusArray;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
        long startTime = System.currentTimeMillis();
        MapStatus[] fetchedStatuses = null;
        HashSet<Object> hashSet = this.fetching();
        synchronized (hashSet) {
            while (this.fetching().contains((Object)BoxesRunTime.boxToInteger((int)shuffleId))) {
                this.liftedTree1$1();
            }
            fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            Object object = fetchedStatuses == null ? this.fetching().$plus$eq((Object)BoxesRunTime.boxToInteger((int)shuffleId)) : BoxedUnit.UNIT;
        }
        if (fetchedStatuses == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
            try {
                byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                fetchedStatuses = MapOutputTracker$.MODULE$.deserializeMapStatuses(fetchedBytes);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the output locations");
                boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
            }
            catch (Throwable throwable) {
                HashSet<Object> hashSet2 = this.fetching();
                synchronized (hashSet2) {
                    this.fetching().$minus$eq((Object)BoxesRunTime.boxToInteger((int)shuffleId));
                    this.fetching().notifyAll();
                    throw throwable;
                }
            }
            HashSet<Object> hashSet3 = this.fetching();
            synchronized (hashSet3) {
                this.fetching().$minus$eq((Object)BoxesRunTime.boxToInteger((int)shuffleId));
                this.fetching().notifyAll();
            }
        }
        boxedUnit = BoxedUnit.UNIT;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(System.currentTimeMillis() - startTime).append(" ms").toString());
        if (fetchedStatuses != null) {
            mapStatusArray = fetchedStatuses;
            return mapStatusArray;
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Missing all output locations for shuffle ").append(shuffleId).toString());
        throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(41).append("Missing all output locations for shuffle ").append(shuffleId).toString());
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
            }
        }
    }

    private final void liftedTree1$1() {
        try {
            this.fetching().wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        super(conf);
    }
}

