/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TAnalyticWindow;
import org.apache.doris.thrift.TExpr;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TAnalyticNode
implements TBase<TAnalyticNode, _Fields>,
Serializable,
Cloneable,
Comparable<TAnalyticNode> {
    private static final TStruct STRUCT_DESC = new TStruct("TAnalyticNode");
    private static final TField PARTITION_EXPRS_FIELD_DESC = new TField("partition_exprs", 15, 1);
    private static final TField ORDER_BY_EXPRS_FIELD_DESC = new TField("order_by_exprs", 15, 2);
    private static final TField ANALYTIC_FUNCTIONS_FIELD_DESC = new TField("analytic_functions", 15, 3);
    private static final TField WINDOW_FIELD_DESC = new TField("window", 12, 4);
    private static final TField INTERMEDIATE_TUPLE_ID_FIELD_DESC = new TField("intermediate_tuple_id", 8, 5);
    private static final TField OUTPUT_TUPLE_ID_FIELD_DESC = new TField("output_tuple_id", 8, 6);
    private static final TField BUFFERED_TUPLE_ID_FIELD_DESC = new TField("buffered_tuple_id", 8, 7);
    private static final TField PARTITION_BY_EQ_FIELD_DESC = new TField("partition_by_eq", 12, 8);
    private static final TField ORDER_BY_EQ_FIELD_DESC = new TField("order_by_eq", 12, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TAnalyticNodeStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TAnalyticNodeTupleSchemeFactory();
    @Nullable
    public List<TExpr> partition_exprs;
    @Nullable
    public List<TExpr> order_by_exprs;
    @Nullable
    public List<TExpr> analytic_functions;
    @Nullable
    public TAnalyticWindow window;
    public int intermediate_tuple_id;
    public int output_tuple_id;
    public int buffered_tuple_id;
    @Nullable
    public TExpr partition_by_eq;
    @Nullable
    public TExpr order_by_eq;
    private static final int __INTERMEDIATE_TUPLE_ID_ISSET_ID = 0;
    private static final int __OUTPUT_TUPLE_ID_ISSET_ID = 1;
    private static final int __BUFFERED_TUPLE_ID_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.WINDOW, _Fields.BUFFERED_TUPLE_ID, _Fields.PARTITION_BY_EQ, _Fields.ORDER_BY_EQ};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAnalyticNode() {
    }

    public TAnalyticNode(List<TExpr> partition_exprs, List<TExpr> order_by_exprs, List<TExpr> analytic_functions, int intermediate_tuple_id, int output_tuple_id) {
        this();
        this.partition_exprs = partition_exprs;
        this.order_by_exprs = order_by_exprs;
        this.analytic_functions = analytic_functions;
        this.intermediate_tuple_id = intermediate_tuple_id;
        this.setIntermediateTupleIdIsSet(true);
        this.output_tuple_id = output_tuple_id;
        this.setOutputTupleIdIsSet(true);
    }

    public TAnalyticNode(TAnalyticNode other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetPartitionExprs()) {
            ArrayList<TExpr> __this__partition_exprs = new ArrayList<TExpr>(other.partition_exprs.size());
            for (TExpr other_element : other.partition_exprs) {
                __this__partition_exprs.add(new TExpr(other_element));
            }
            this.partition_exprs = __this__partition_exprs;
        }
        if (other.isSetOrderByExprs()) {
            ArrayList<TExpr> __this__order_by_exprs = new ArrayList<TExpr>(other.order_by_exprs.size());
            for (TExpr other_element : other.order_by_exprs) {
                __this__order_by_exprs.add(new TExpr(other_element));
            }
            this.order_by_exprs = __this__order_by_exprs;
        }
        if (other.isSetAnalyticFunctions()) {
            ArrayList<TExpr> __this__analytic_functions = new ArrayList<TExpr>(other.analytic_functions.size());
            for (TExpr other_element : other.analytic_functions) {
                __this__analytic_functions.add(new TExpr(other_element));
            }
            this.analytic_functions = __this__analytic_functions;
        }
        if (other.isSetWindow()) {
            this.window = new TAnalyticWindow(other.window);
        }
        this.intermediate_tuple_id = other.intermediate_tuple_id;
        this.output_tuple_id = other.output_tuple_id;
        this.buffered_tuple_id = other.buffered_tuple_id;
        if (other.isSetPartitionByEq()) {
            this.partition_by_eq = new TExpr(other.partition_by_eq);
        }
        if (other.isSetOrderByEq()) {
            this.order_by_eq = new TExpr(other.order_by_eq);
        }
    }

    @Override
    public TAnalyticNode deepCopy() {
        return new TAnalyticNode(this);
    }

    @Override
    public void clear() {
        this.partition_exprs = null;
        this.order_by_exprs = null;
        this.analytic_functions = null;
        this.window = null;
        this.setIntermediateTupleIdIsSet(false);
        this.intermediate_tuple_id = 0;
        this.setOutputTupleIdIsSet(false);
        this.output_tuple_id = 0;
        this.setBufferedTupleIdIsSet(false);
        this.buffered_tuple_id = 0;
        this.partition_by_eq = null;
        this.order_by_eq = null;
    }

    public int getPartitionExprsSize() {
        return this.partition_exprs == null ? 0 : this.partition_exprs.size();
    }

    @Nullable
    public Iterator<TExpr> getPartitionExprsIterator() {
        return this.partition_exprs == null ? null : this.partition_exprs.iterator();
    }

    public void addToPartitionExprs(TExpr elem) {
        if (this.partition_exprs == null) {
            this.partition_exprs = new ArrayList<TExpr>();
        }
        this.partition_exprs.add(elem);
    }

    @Nullable
    public List<TExpr> getPartitionExprs() {
        return this.partition_exprs;
    }

    public TAnalyticNode setPartitionExprs(@Nullable List<TExpr> partition_exprs) {
        this.partition_exprs = partition_exprs;
        return this;
    }

    public void unsetPartitionExprs() {
        this.partition_exprs = null;
    }

    public boolean isSetPartitionExprs() {
        return this.partition_exprs != null;
    }

    public void setPartitionExprsIsSet(boolean value) {
        if (!value) {
            this.partition_exprs = null;
        }
    }

    public int getOrderByExprsSize() {
        return this.order_by_exprs == null ? 0 : this.order_by_exprs.size();
    }

    @Nullable
    public Iterator<TExpr> getOrderByExprsIterator() {
        return this.order_by_exprs == null ? null : this.order_by_exprs.iterator();
    }

    public void addToOrderByExprs(TExpr elem) {
        if (this.order_by_exprs == null) {
            this.order_by_exprs = new ArrayList<TExpr>();
        }
        this.order_by_exprs.add(elem);
    }

    @Nullable
    public List<TExpr> getOrderByExprs() {
        return this.order_by_exprs;
    }

    public TAnalyticNode setOrderByExprs(@Nullable List<TExpr> order_by_exprs) {
        this.order_by_exprs = order_by_exprs;
        return this;
    }

    public void unsetOrderByExprs() {
        this.order_by_exprs = null;
    }

    public boolean isSetOrderByExprs() {
        return this.order_by_exprs != null;
    }

    public void setOrderByExprsIsSet(boolean value) {
        if (!value) {
            this.order_by_exprs = null;
        }
    }

    public int getAnalyticFunctionsSize() {
        return this.analytic_functions == null ? 0 : this.analytic_functions.size();
    }

    @Nullable
    public Iterator<TExpr> getAnalyticFunctionsIterator() {
        return this.analytic_functions == null ? null : this.analytic_functions.iterator();
    }

    public void addToAnalyticFunctions(TExpr elem) {
        if (this.analytic_functions == null) {
            this.analytic_functions = new ArrayList<TExpr>();
        }
        this.analytic_functions.add(elem);
    }

    @Nullable
    public List<TExpr> getAnalyticFunctions() {
        return this.analytic_functions;
    }

    public TAnalyticNode setAnalyticFunctions(@Nullable List<TExpr> analytic_functions) {
        this.analytic_functions = analytic_functions;
        return this;
    }

    public void unsetAnalyticFunctions() {
        this.analytic_functions = null;
    }

    public boolean isSetAnalyticFunctions() {
        return this.analytic_functions != null;
    }

    public void setAnalyticFunctionsIsSet(boolean value) {
        if (!value) {
            this.analytic_functions = null;
        }
    }

    @Nullable
    public TAnalyticWindow getWindow() {
        return this.window;
    }

    public TAnalyticNode setWindow(@Nullable TAnalyticWindow window) {
        this.window = window;
        return this;
    }

    public void unsetWindow() {
        this.window = null;
    }

    public boolean isSetWindow() {
        return this.window != null;
    }

    public void setWindowIsSet(boolean value) {
        if (!value) {
            this.window = null;
        }
    }

    public int getIntermediateTupleId() {
        return this.intermediate_tuple_id;
    }

    public TAnalyticNode setIntermediateTupleId(int intermediate_tuple_id) {
        this.intermediate_tuple_id = intermediate_tuple_id;
        this.setIntermediateTupleIdIsSet(true);
        return this;
    }

    public void unsetIntermediateTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetIntermediateTupleId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setIntermediateTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getOutputTupleId() {
        return this.output_tuple_id;
    }

    public TAnalyticNode setOutputTupleId(int output_tuple_id) {
        this.output_tuple_id = output_tuple_id;
        this.setOutputTupleIdIsSet(true);
        return this;
    }

    public void unsetOutputTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetOutputTupleId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setOutputTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getBufferedTupleId() {
        return this.buffered_tuple_id;
    }

    public TAnalyticNode setBufferedTupleId(int buffered_tuple_id) {
        this.buffered_tuple_id = buffered_tuple_id;
        this.setBufferedTupleIdIsSet(true);
        return this;
    }

    public void unsetBufferedTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetBufferedTupleId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setBufferedTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    @Nullable
    public TExpr getPartitionByEq() {
        return this.partition_by_eq;
    }

    public TAnalyticNode setPartitionByEq(@Nullable TExpr partition_by_eq) {
        this.partition_by_eq = partition_by_eq;
        return this;
    }

    public void unsetPartitionByEq() {
        this.partition_by_eq = null;
    }

    public boolean isSetPartitionByEq() {
        return this.partition_by_eq != null;
    }

    public void setPartitionByEqIsSet(boolean value) {
        if (!value) {
            this.partition_by_eq = null;
        }
    }

    @Nullable
    public TExpr getOrderByEq() {
        return this.order_by_eq;
    }

    public TAnalyticNode setOrderByEq(@Nullable TExpr order_by_eq) {
        this.order_by_eq = order_by_eq;
        return this;
    }

    public void unsetOrderByEq() {
        this.order_by_eq = null;
    }

    public boolean isSetOrderByEq() {
        return this.order_by_eq != null;
    }

    public void setOrderByEqIsSet(boolean value) {
        if (!value) {
            this.order_by_eq = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PARTITION_EXPRS: {
                if (value == null) {
                    this.unsetPartitionExprs();
                    break;
                }
                this.setPartitionExprs((List)value);
                break;
            }
            case ORDER_BY_EXPRS: {
                if (value == null) {
                    this.unsetOrderByExprs();
                    break;
                }
                this.setOrderByExprs((List)value);
                break;
            }
            case ANALYTIC_FUNCTIONS: {
                if (value == null) {
                    this.unsetAnalyticFunctions();
                    break;
                }
                this.setAnalyticFunctions((List)value);
                break;
            }
            case WINDOW: {
                if (value == null) {
                    this.unsetWindow();
                    break;
                }
                this.setWindow((TAnalyticWindow)value);
                break;
            }
            case INTERMEDIATE_TUPLE_ID: {
                if (value == null) {
                    this.unsetIntermediateTupleId();
                    break;
                }
                this.setIntermediateTupleId((Integer)value);
                break;
            }
            case OUTPUT_TUPLE_ID: {
                if (value == null) {
                    this.unsetOutputTupleId();
                    break;
                }
                this.setOutputTupleId((Integer)value);
                break;
            }
            case BUFFERED_TUPLE_ID: {
                if (value == null) {
                    this.unsetBufferedTupleId();
                    break;
                }
                this.setBufferedTupleId((Integer)value);
                break;
            }
            case PARTITION_BY_EQ: {
                if (value == null) {
                    this.unsetPartitionByEq();
                    break;
                }
                this.setPartitionByEq((TExpr)value);
                break;
            }
            case ORDER_BY_EQ: {
                if (value == null) {
                    this.unsetOrderByEq();
                    break;
                }
                this.setOrderByEq((TExpr)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PARTITION_EXPRS: {
                return this.getPartitionExprs();
            }
            case ORDER_BY_EXPRS: {
                return this.getOrderByExprs();
            }
            case ANALYTIC_FUNCTIONS: {
                return this.getAnalyticFunctions();
            }
            case WINDOW: {
                return this.getWindow();
            }
            case INTERMEDIATE_TUPLE_ID: {
                return this.getIntermediateTupleId();
            }
            case OUTPUT_TUPLE_ID: {
                return this.getOutputTupleId();
            }
            case BUFFERED_TUPLE_ID: {
                return this.getBufferedTupleId();
            }
            case PARTITION_BY_EQ: {
                return this.getPartitionByEq();
            }
            case ORDER_BY_EQ: {
                return this.getOrderByEq();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PARTITION_EXPRS: {
                return this.isSetPartitionExprs();
            }
            case ORDER_BY_EXPRS: {
                return this.isSetOrderByExprs();
            }
            case ANALYTIC_FUNCTIONS: {
                return this.isSetAnalyticFunctions();
            }
            case WINDOW: {
                return this.isSetWindow();
            }
            case INTERMEDIATE_TUPLE_ID: {
                return this.isSetIntermediateTupleId();
            }
            case OUTPUT_TUPLE_ID: {
                return this.isSetOutputTupleId();
            }
            case BUFFERED_TUPLE_ID: {
                return this.isSetBufferedTupleId();
            }
            case PARTITION_BY_EQ: {
                return this.isSetPartitionByEq();
            }
            case ORDER_BY_EQ: {
                return this.isSetOrderByEq();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TAnalyticNode) {
            return this.equals((TAnalyticNode)that);
        }
        return false;
    }

    public boolean equals(TAnalyticNode that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_partition_exprs = this.isSetPartitionExprs();
        boolean that_present_partition_exprs = that.isSetPartitionExprs();
        if (this_present_partition_exprs || that_present_partition_exprs) {
            if (!this_present_partition_exprs || !that_present_partition_exprs) {
                return false;
            }
            if (!this.partition_exprs.equals(that.partition_exprs)) {
                return false;
            }
        }
        boolean this_present_order_by_exprs = this.isSetOrderByExprs();
        boolean that_present_order_by_exprs = that.isSetOrderByExprs();
        if (this_present_order_by_exprs || that_present_order_by_exprs) {
            if (!this_present_order_by_exprs || !that_present_order_by_exprs) {
                return false;
            }
            if (!this.order_by_exprs.equals(that.order_by_exprs)) {
                return false;
            }
        }
        boolean this_present_analytic_functions = this.isSetAnalyticFunctions();
        boolean that_present_analytic_functions = that.isSetAnalyticFunctions();
        if (this_present_analytic_functions || that_present_analytic_functions) {
            if (!this_present_analytic_functions || !that_present_analytic_functions) {
                return false;
            }
            if (!this.analytic_functions.equals(that.analytic_functions)) {
                return false;
            }
        }
        boolean this_present_window = this.isSetWindow();
        boolean that_present_window = that.isSetWindow();
        if (this_present_window || that_present_window) {
            if (!this_present_window || !that_present_window) {
                return false;
            }
            if (!this.window.equals(that.window)) {
                return false;
            }
        }
        boolean this_present_intermediate_tuple_id = true;
        boolean that_present_intermediate_tuple_id = true;
        if (this_present_intermediate_tuple_id || that_present_intermediate_tuple_id) {
            if (!this_present_intermediate_tuple_id || !that_present_intermediate_tuple_id) {
                return false;
            }
            if (this.intermediate_tuple_id != that.intermediate_tuple_id) {
                return false;
            }
        }
        boolean this_present_output_tuple_id = true;
        boolean that_present_output_tuple_id = true;
        if (this_present_output_tuple_id || that_present_output_tuple_id) {
            if (!this_present_output_tuple_id || !that_present_output_tuple_id) {
                return false;
            }
            if (this.output_tuple_id != that.output_tuple_id) {
                return false;
            }
        }
        boolean this_present_buffered_tuple_id = this.isSetBufferedTupleId();
        boolean that_present_buffered_tuple_id = that.isSetBufferedTupleId();
        if (this_present_buffered_tuple_id || that_present_buffered_tuple_id) {
            if (!this_present_buffered_tuple_id || !that_present_buffered_tuple_id) {
                return false;
            }
            if (this.buffered_tuple_id != that.buffered_tuple_id) {
                return false;
            }
        }
        boolean this_present_partition_by_eq = this.isSetPartitionByEq();
        boolean that_present_partition_by_eq = that.isSetPartitionByEq();
        if (this_present_partition_by_eq || that_present_partition_by_eq) {
            if (!this_present_partition_by_eq || !that_present_partition_by_eq) {
                return false;
            }
            if (!this.partition_by_eq.equals(that.partition_by_eq)) {
                return false;
            }
        }
        boolean this_present_order_by_eq = this.isSetOrderByEq();
        boolean that_present_order_by_eq = that.isSetOrderByEq();
        if (this_present_order_by_eq || that_present_order_by_eq) {
            if (!this_present_order_by_eq || !that_present_order_by_eq) {
                return false;
            }
            if (!this.order_by_eq.equals(that.order_by_eq)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPartitionExprs() ? 131071 : 524287);
        if (this.isSetPartitionExprs()) {
            hashCode = hashCode * 8191 + this.partition_exprs.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOrderByExprs() ? 131071 : 524287);
        if (this.isSetOrderByExprs()) {
            hashCode = hashCode * 8191 + this.order_by_exprs.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAnalyticFunctions() ? 131071 : 524287);
        if (this.isSetAnalyticFunctions()) {
            hashCode = hashCode * 8191 + this.analytic_functions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetWindow() ? 131071 : 524287);
        if (this.isSetWindow()) {
            hashCode = hashCode * 8191 + this.window.hashCode();
        }
        hashCode = hashCode * 8191 + this.intermediate_tuple_id;
        hashCode = hashCode * 8191 + this.output_tuple_id;
        hashCode = hashCode * 8191 + (this.isSetBufferedTupleId() ? 131071 : 524287);
        if (this.isSetBufferedTupleId()) {
            hashCode = hashCode * 8191 + this.buffered_tuple_id;
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionByEq() ? 131071 : 524287);
        if (this.isSetPartitionByEq()) {
            hashCode = hashCode * 8191 + this.partition_by_eq.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOrderByEq() ? 131071 : 524287);
        if (this.isSetOrderByEq()) {
            hashCode = hashCode * 8191 + this.order_by_eq.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TAnalyticNode other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetPartitionExprs()).compareTo(other.isSetPartitionExprs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionExprs() && (lastComparison = TBaseHelper.compareTo(this.partition_exprs, other.partition_exprs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrderByExprs()).compareTo(other.isSetOrderByExprs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrderByExprs() && (lastComparison = TBaseHelper.compareTo(this.order_by_exprs, other.order_by_exprs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAnalyticFunctions()).compareTo(other.isSetAnalyticFunctions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAnalyticFunctions() && (lastComparison = TBaseHelper.compareTo(this.analytic_functions, other.analytic_functions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWindow()).compareTo(other.isSetWindow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWindow() && (lastComparison = TBaseHelper.compareTo(this.window, other.window)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIntermediateTupleId()).compareTo(other.isSetIntermediateTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIntermediateTupleId() && (lastComparison = TBaseHelper.compareTo(this.intermediate_tuple_id, other.intermediate_tuple_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOutputTupleId()).compareTo(other.isSetOutputTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOutputTupleId() && (lastComparison = TBaseHelper.compareTo(this.output_tuple_id, other.output_tuple_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBufferedTupleId()).compareTo(other.isSetBufferedTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBufferedTupleId() && (lastComparison = TBaseHelper.compareTo(this.buffered_tuple_id, other.buffered_tuple_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartitionByEq()).compareTo(other.isSetPartitionByEq());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionByEq() && (lastComparison = TBaseHelper.compareTo(this.partition_by_eq, other.partition_by_eq)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrderByEq()).compareTo(other.isSetOrderByEq());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrderByEq() && (lastComparison = TBaseHelper.compareTo(this.order_by_eq, other.order_by_eq)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TAnalyticNode.scheme(iprot).read(iprot, (TAnalyticNode)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TAnalyticNode.scheme(oprot).write(oprot, (TAnalyticNode)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAnalyticNode(");
        boolean first = true;
        sb.append("partition_exprs:");
        if (this.partition_exprs == null) {
            sb.append("null");
        } else {
            sb.append(this.partition_exprs);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("order_by_exprs:");
        if (this.order_by_exprs == null) {
            sb.append("null");
        } else {
            sb.append(this.order_by_exprs);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("analytic_functions:");
        if (this.analytic_functions == null) {
            sb.append("null");
        } else {
            sb.append(this.analytic_functions);
        }
        first = false;
        if (this.isSetWindow()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("window:");
            if (this.window == null) {
                sb.append("null");
            } else {
                sb.append(this.window);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("intermediate_tuple_id:");
        sb.append(this.intermediate_tuple_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("output_tuple_id:");
        sb.append(this.output_tuple_id);
        first = false;
        if (this.isSetBufferedTupleId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("buffered_tuple_id:");
            sb.append(this.buffered_tuple_id);
            first = false;
        }
        if (this.isSetPartitionByEq()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partition_by_eq:");
            if (this.partition_by_eq == null) {
                sb.append("null");
            } else {
                sb.append(this.partition_by_eq);
            }
            first = false;
        }
        if (this.isSetOrderByEq()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("order_by_eq:");
            if (this.order_by_eq == null) {
                sb.append("null");
            } else {
                sb.append(this.order_by_eq);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.partition_exprs == null) {
            throw new TProtocolException("Required field 'partition_exprs' was not present! Struct: " + this.toString());
        }
        if (this.order_by_exprs == null) {
            throw new TProtocolException("Required field 'order_by_exprs' was not present! Struct: " + this.toString());
        }
        if (this.analytic_functions == null) {
            throw new TProtocolException("Required field 'analytic_functions' was not present! Struct: " + this.toString());
        }
        if (this.window != null) {
            this.window.validate();
        }
        if (this.partition_by_eq != null) {
            this.partition_by_eq.validate();
        }
        if (this.order_by_eq != null) {
            this.order_by_eq.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PARTITION_EXPRS, new FieldMetaData("partition_exprs", 1, new ListMetaData(15, new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.ORDER_BY_EXPRS, new FieldMetaData("order_by_exprs", 1, new ListMetaData(15, new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.ANALYTIC_FUNCTIONS, new FieldMetaData("analytic_functions", 1, new ListMetaData(15, new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.WINDOW, new FieldMetaData("window", 2, new StructMetaData(12, TAnalyticWindow.class)));
        tmpMap.put(_Fields.INTERMEDIATE_TUPLE_ID, new FieldMetaData("intermediate_tuple_id", 1, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.OUTPUT_TUPLE_ID, new FieldMetaData("output_tuple_id", 1, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.BUFFERED_TUPLE_ID, new FieldMetaData("buffered_tuple_id", 2, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.PARTITION_BY_EQ, new FieldMetaData("partition_by_eq", 2, new StructMetaData(12, TExpr.class)));
        tmpMap.put(_Fields.ORDER_BY_EQ, new FieldMetaData("order_by_eq", 2, new StructMetaData(12, TExpr.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAnalyticNode.class, metaDataMap);
    }

    private static class TAnalyticNodeTupleScheme
    extends TupleScheme<TAnalyticNode> {
        private TAnalyticNodeTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TAnalyticNode struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.partition_exprs.size());
            for (TExpr _iter468 : struct.partition_exprs) {
                _iter468.write(oprot);
            }
            oprot.writeI32(struct.order_by_exprs.size());
            for (TExpr _iter469 : struct.order_by_exprs) {
                _iter469.write(oprot);
            }
            oprot.writeI32(struct.analytic_functions.size());
            for (TExpr _iter470 : struct.analytic_functions) {
                _iter470.write(oprot);
            }
            oprot.writeI32(struct.intermediate_tuple_id);
            oprot.writeI32(struct.output_tuple_id);
            BitSet optionals = new BitSet();
            if (struct.isSetWindow()) {
                optionals.set(0);
            }
            if (struct.isSetBufferedTupleId()) {
                optionals.set(1);
            }
            if (struct.isSetPartitionByEq()) {
                optionals.set(2);
            }
            if (struct.isSetOrderByEq()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetWindow()) {
                struct.window.write(oprot);
            }
            if (struct.isSetBufferedTupleId()) {
                oprot.writeI32(struct.buffered_tuple_id);
            }
            if (struct.isSetPartitionByEq()) {
                struct.partition_by_eq.write(oprot);
            }
            if (struct.isSetOrderByEq()) {
                struct.order_by_eq.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, TAnalyticNode struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list471 = new TList(12, iprot.readI32());
            struct.partition_exprs = new ArrayList<TExpr>(_list471.size);
            for (int _i473 = 0; _i473 < _list471.size; ++_i473) {
                TExpr _elem472 = new TExpr();
                _elem472.read(iprot);
                struct.partition_exprs.add(_elem472);
            }
            struct.setPartitionExprsIsSet(true);
            TList _list474 = new TList(12, iprot.readI32());
            struct.order_by_exprs = new ArrayList<TExpr>(_list474.size);
            for (int _i476 = 0; _i476 < _list474.size; ++_i476) {
                TExpr _elem475 = new TExpr();
                _elem475.read(iprot);
                struct.order_by_exprs.add(_elem475);
            }
            struct.setOrderByExprsIsSet(true);
            TList _list477 = new TList(12, iprot.readI32());
            struct.analytic_functions = new ArrayList<TExpr>(_list477.size);
            for (int _i479 = 0; _i479 < _list477.size; ++_i479) {
                TExpr _elem478 = new TExpr();
                _elem478.read(iprot);
                struct.analytic_functions.add(_elem478);
            }
            struct.setAnalyticFunctionsIsSet(true);
            struct.intermediate_tuple_id = iprot.readI32();
            struct.setIntermediateTupleIdIsSet(true);
            struct.output_tuple_id = iprot.readI32();
            struct.setOutputTupleIdIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.window = new TAnalyticWindow();
                struct.window.read(iprot);
                struct.setWindowIsSet(true);
            }
            if (incoming.get(1)) {
                struct.buffered_tuple_id = iprot.readI32();
                struct.setBufferedTupleIdIsSet(true);
            }
            if (incoming.get(2)) {
                struct.partition_by_eq = new TExpr();
                struct.partition_by_eq.read(iprot);
                struct.setPartitionByEqIsSet(true);
            }
            if (incoming.get(3)) {
                struct.order_by_eq = new TExpr();
                struct.order_by_eq.read(iprot);
                struct.setOrderByEqIsSet(true);
            }
        }
    }

    private static class TAnalyticNodeTupleSchemeFactory
    implements SchemeFactory {
        private TAnalyticNodeTupleSchemeFactory() {
        }

        public TAnalyticNodeTupleScheme getScheme() {
            return new TAnalyticNodeTupleScheme();
        }
    }

    private static class TAnalyticNodeStandardScheme
    extends StandardScheme<TAnalyticNode> {
        private TAnalyticNodeStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TAnalyticNode struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list456 = iprot.readListBegin();
                            struct.partition_exprs = new ArrayList<TExpr>(_list456.size);
                            for (int _i458 = 0; _i458 < _list456.size; ++_i458) {
                                TExpr _elem457 = new TExpr();
                                _elem457.read(iprot);
                                struct.partition_exprs.add(_elem457);
                            }
                            iprot.readListEnd();
                            struct.setPartitionExprsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list459 = iprot.readListBegin();
                            struct.order_by_exprs = new ArrayList<TExpr>(_list459.size);
                            for (int _i461 = 0; _i461 < _list459.size; ++_i461) {
                                TExpr _elem460 = new TExpr();
                                _elem460.read(iprot);
                                struct.order_by_exprs.add(_elem460);
                            }
                            iprot.readListEnd();
                            struct.setOrderByExprsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list462 = iprot.readListBegin();
                            struct.analytic_functions = new ArrayList<TExpr>(_list462.size);
                            for (int _i464 = 0; _i464 < _list462.size; ++_i464) {
                                TExpr _elem463 = new TExpr();
                                _elem463.read(iprot);
                                struct.analytic_functions.add(_elem463);
                            }
                            iprot.readListEnd();
                            struct.setAnalyticFunctionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.window = new TAnalyticWindow();
                            struct.window.read(iprot);
                            struct.setWindowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.intermediate_tuple_id = iprot.readI32();
                            struct.setIntermediateTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.output_tuple_id = iprot.readI32();
                            struct.setOutputTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.buffered_tuple_id = iprot.readI32();
                            struct.setBufferedTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.partition_by_eq = new TExpr();
                            struct.partition_by_eq.read(iprot);
                            struct.setPartitionByEqIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.order_by_eq = new TExpr();
                            struct.order_by_eq.read(iprot);
                            struct.setOrderByEqIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetIntermediateTupleId()) {
                throw new TProtocolException("Required field 'intermediate_tuple_id' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetOutputTupleId()) {
                throw new TProtocolException("Required field 'output_tuple_id' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TAnalyticNode struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.partition_exprs != null) {
                oprot.writeFieldBegin(PARTITION_EXPRS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partition_exprs.size()));
                for (TExpr _iter465 : struct.partition_exprs) {
                    _iter465.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.order_by_exprs != null) {
                oprot.writeFieldBegin(ORDER_BY_EXPRS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.order_by_exprs.size()));
                for (TExpr _iter466 : struct.order_by_exprs) {
                    _iter466.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.analytic_functions != null) {
                oprot.writeFieldBegin(ANALYTIC_FUNCTIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.analytic_functions.size()));
                for (TExpr _iter467 : struct.analytic_functions) {
                    _iter467.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.window != null && struct.isSetWindow()) {
                oprot.writeFieldBegin(WINDOW_FIELD_DESC);
                struct.window.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(INTERMEDIATE_TUPLE_ID_FIELD_DESC);
            oprot.writeI32(struct.intermediate_tuple_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(OUTPUT_TUPLE_ID_FIELD_DESC);
            oprot.writeI32(struct.output_tuple_id);
            oprot.writeFieldEnd();
            if (struct.isSetBufferedTupleId()) {
                oprot.writeFieldBegin(BUFFERED_TUPLE_ID_FIELD_DESC);
                oprot.writeI32(struct.buffered_tuple_id);
                oprot.writeFieldEnd();
            }
            if (struct.partition_by_eq != null && struct.isSetPartitionByEq()) {
                oprot.writeFieldBegin(PARTITION_BY_EQ_FIELD_DESC);
                struct.partition_by_eq.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.order_by_eq != null && struct.isSetOrderByEq()) {
                oprot.writeFieldBegin(ORDER_BY_EQ_FIELD_DESC);
                struct.order_by_eq.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAnalyticNodeStandardSchemeFactory
    implements SchemeFactory {
        private TAnalyticNodeStandardSchemeFactory() {
        }

        public TAnalyticNodeStandardScheme getScheme() {
            return new TAnalyticNodeStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PARTITION_EXPRS(1, "partition_exprs"),
        ORDER_BY_EXPRS(2, "order_by_exprs"),
        ANALYTIC_FUNCTIONS(3, "analytic_functions"),
        WINDOW(4, "window"),
        INTERMEDIATE_TUPLE_ID(5, "intermediate_tuple_id"),
        OUTPUT_TUPLE_ID(6, "output_tuple_id"),
        BUFFERED_TUPLE_ID(7, "buffered_tuple_id"),
        PARTITION_BY_EQ(8, "partition_by_eq"),
        ORDER_BY_EQ(9, "order_by_eq");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PARTITION_EXPRS;
                }
                case 2: {
                    return ORDER_BY_EXPRS;
                }
                case 3: {
                    return ANALYTIC_FUNCTIONS;
                }
                case 4: {
                    return WINDOW;
                }
                case 5: {
                    return INTERMEDIATE_TUPLE_ID;
                }
                case 6: {
                    return OUTPUT_TUPLE_ID;
                }
                case 7: {
                    return BUFFERED_TUPLE_ID;
                }
                case 8: {
                    return PARTITION_BY_EQ;
                }
                case 9: {
                    return ORDER_BY_EQ;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

