/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.doris.common.io.Hll;
import org.apache.doris.load.loadv2.dpp.SparkRDDAggregator;

class HllUnionAggregator
extends SparkRDDAggregator<Hll> {
    HllUnionAggregator() {
    }

    @Override
    Hll init(Object value) {
        try {
            Hll hll = new Hll();
            if (value instanceof byte[]) {
                hll.deserialize(new DataInputStream(new ByteArrayInputStream((byte[])value)));
            } else if (value != null) {
                hll.updateWithHash(value);
            }
            return hll;
        }
        catch (Exception e) {
            throw new RuntimeException("build hll value failed", e);
        }
    }

    @Override
    Hll update(Hll v1, Hll v2) {
        Hll newHll = new Hll();
        if (v1 != null) {
            newHll.merge(v1);
        }
        if (v2 != null) {
            newHll.merge(v2);
        }
        return newHll;
    }

    byte[] finalize(Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bos);
            ((Hll)value).serialize(outputStream);
            return bos.toByteArray();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            throw new RuntimeException(ioException);
        }
    }
}

