/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.math.BigDecimal;
import org.apache.doris.load.loadv2.dpp.ColumnParser;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;

class DecimalParser
extends ColumnParser {
    public static int PRECISION = 27;
    public static int SCALE = 9;
    private BigDecimal maxValue;
    private BigDecimal minValue;

    public DecimalParser(EtlJobConfig.EtlColumn etlColumn) {
        StringBuilder precisionStr = new StringBuilder();
        for (int i = 0; i < etlColumn.precision - etlColumn.scale; ++i) {
            precisionStr.append("9");
        }
        StringBuilder scaleStr = new StringBuilder();
        for (int i = 0; i < etlColumn.scale; ++i) {
            scaleStr.append("9");
        }
        this.maxValue = new BigDecimal(precisionStr.toString() + "." + scaleStr.toString());
        this.minValue = new BigDecimal("-" + precisionStr.toString() + "." + scaleStr.toString());
    }

    @Override
    public boolean parse(String value) {
        try {
            BigDecimal bigDecimal = new BigDecimal(value);
            return bigDecimal.precision() - bigDecimal.scale() <= PRECISION - SCALE && bigDecimal.scale() <= SCALE;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("decimal parse failed ", e);
        }
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }
}

