/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.doris.common.io.BitmapValue;
import org.apache.doris.load.loadv2.dpp.SparkRDDAggregator;

class BitmapUnionAggregator
extends SparkRDDAggregator<BitmapValue> {
    BitmapUnionAggregator() {
    }

    @Override
    BitmapValue init(Object value) {
        try {
            BitmapValue bitmapValue = new BitmapValue();
            if (value instanceof byte[]) {
                bitmapValue.deserialize(new DataInputStream(new ByteArrayInputStream((byte[])value)));
            } else if (value != null) {
                bitmapValue.add(Long.valueOf(value.toString()));
            }
            return bitmapValue;
        }
        catch (Exception e) {
            throw new RuntimeException("build bitmap value failed", e);
        }
    }

    @Override
    BitmapValue update(BitmapValue v1, BitmapValue v2) {
        BitmapValue newBitmapValue = new BitmapValue();
        if (v1 != null) {
            newBitmapValue.or(v1);
        }
        if (v2 != null) {
            newBitmapValue.or(v2);
        }
        return newBitmapValue;
    }

    byte[] finalize(Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bos);
            ((BitmapValue)value).serialize(outputStream);
            return bos.toByteArray();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            throw new RuntimeException(ioException);
        }
    }
}

