/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;

public class ErrorManager {
    private static ErrorManager errorManager = new ErrorManager();
    private final List<CupLogMessage> errors = new ArrayList<CupLogMessage>();
    private final List<CupLogMessage> warnings = new ArrayList<CupLogMessage>();
    private final List<CupLogMessage> fatals = new ArrayList<CupLogMessage>();

    public int getFatalCount() {
        return this.fatals.size();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public int getWarningCount() {
        return this.warnings.size();
    }

    public List<CupLogMessage> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<CupLogMessage> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public List<CupLogMessage> getFatals() {
        return Collections.unmodifiableList(this.fatals);
    }

    public void clear() {
        this.fatals.clear();
        this.errors.clear();
        this.warnings.clear();
    }

    public static ErrorManager getManager() {
        return errorManager;
    }

    private ErrorManager() {
    }

    public void emit_fatal(String message) {
        CupLogMessage msg = new CupLogMessage(message);
        this.fatals.add(msg);
        System.err.println("Fatal : " + msg);
    }

    public void emit_fatal(String message, Symbol sym2) {
        CupLogMessage msg = CupLogMessage.fromSym(message, sym2);
        this.fatals.add(msg);
        System.err.println("Fatal: " + msg);
    }

    public void emit_warning(String message) {
        CupLogMessage msg = new CupLogMessage(message);
        this.warnings.add(msg);
        System.err.println("Warning : " + msg);
    }

    public void emit_warning(String message, Symbol sym2) {
        CupLogMessage msg = CupLogMessage.fromSym(message, sym2);
        this.warnings.add(msg);
        System.err.println("Warning: " + msg);
    }

    public void emit_error(String message) {
        CupLogMessage msg = new CupLogMessage(message);
        this.errors.add(msg);
        System.err.println("Error : " + msg);
    }

    public void emit_error(String message, Symbol sym2) {
        CupLogMessage msg = CupLogMessage.fromSym(message, sym2);
        this.errors.add(msg);
        System.err.println("Error: " + msg);
    }

    public static class CupLogMessage {
        private final String message;
        private ComplexSymbolFactory.Location leftLoc = null;
        private ComplexSymbolFactory.Location rightLoc = null;
        private int offset = -1;
        private int length = 0;

        public CupLogMessage(String message, int offset, int length) {
            this.message = message;
            this.offset = offset;
            this.length = length;
        }

        public CupLogMessage(String message) {
            this.message = message;
        }

        private CupLogMessage(String message, ComplexSymbolFactory.Location left, ComplexSymbolFactory.Location right) {
            this.message = message;
            this.leftLoc = left;
            this.rightLoc = right;
        }

        public static CupLogMessage fromSym(String message, Symbol sym2) {
            String msg = message + " @ " + sym2;
            if (sym2 instanceof ComplexSymbolFactory.ComplexSymbol) {
                ComplexSymbolFactory.ComplexSymbol csym = (ComplexSymbolFactory.ComplexSymbol)sym2;
                return new CupLogMessage(msg, csym.getLeft(), csym.getRight());
            }
            return new CupLogMessage(msg, sym2.left, sym2.right - sym2.left);
        }

        public String getMessage() {
            return this.message;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public ComplexSymbolFactory.Location getLeftLoc() {
            return this.leftLoc;
        }

        public ComplexSymbolFactory.Location getRightLoc() {
            return this.rightLoc;
        }

        public String toString() {
            return this.message;
        }
    }
}

