/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.rpc;

import co.cask.tephra.rpc.RPCServiceHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.utils.Networks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftRPCServer<T extends RPCServiceHandler, I>
extends AbstractExecutionThreadService {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftRPCServer.class);
    private final String name;
    private final int ioThreads;
    private final int workerThreads;
    private final int maxReadBufferBytes;
    private final T serviceHandler;
    private final TProcessor processor;
    private InetSocketAddress bindAddress;
    private ExecutorService executor;
    private TServer server;

    public static <I> Builder<I> builder(Class<I> serviceType) {
        return new Builder(serviceType);
    }

    private ThriftRPCServer(InetSocketAddress bindAddress, int ioThreads, int workerThreads, int maxReadBufferBytes, T serviceHandler, Class<I> serviceType, String name) {
        Preconditions.checkArgument((ioThreads > 0 ? 1 : 0) != 0, (Object)"IO threads must be > 0.");
        Preconditions.checkArgument((workerThreads > 0 ? 1 : 0) != 0, (Object)"Worker threads must be > 0.");
        this.bindAddress = bindAddress;
        this.ioThreads = ioThreads;
        this.workerThreads = workerThreads;
        this.maxReadBufferBytes = maxReadBufferBytes;
        this.serviceHandler = serviceHandler;
        this.name = name;
        this.processor = this.createProcessor(serviceHandler.getClass(), serviceType);
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    protected void startUp() throws Exception {
        InetSocketAddress listenOn = this.bindAddress;
        if (listenOn == null || listenOn.getPort() <= 0) {
            int port = Networks.getRandomPort();
            listenOn = listenOn == null ? new InetSocketAddress("localhost", port) : new InetSocketAddress(listenOn.getAddress(), port);
        }
        this.bindAddress = listenOn;
        this.executor = new ThreadPoolExecutor(0, this.workerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.createDaemonThreadFactory((String)String.format("%s-rpc-%%d", this.name)), new ThreadPoolExecutor.CallerRunsPolicy());
        this.serviceHandler.init();
        TThreadedSelectorServer.Args args = ((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)new TThreadedSelectorServer.Args((TNonblockingServerTransport)new TNonblockingServerSocket(listenOn)).selectorThreads(this.ioThreads).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).transportFactory((TTransportFactory)new TFramedTransport.Factory())).processor(this.processor)).executorService(this.executor);
        args.maxReadBufferBytes = this.maxReadBufferBytes;
        this.server = new TThreadedSelectorServer(args);
        LOG.info("Starting RPC server for {}", (Object)this.name);
    }

    protected void shutDown() throws Exception {
        this.serviceHandler.destroy();
        this.executor.shutdownNow();
        LOG.info("RPC server for {} stopped.", (Object)this.name);
    }

    protected void triggerShutdown() {
        LOG.info("Request to stop RPC server for {}", (Object)this.name);
        this.server.stop();
    }

    protected void run() throws Exception {
        this.server.serve();
    }

    private TProcessor createProcessor(Class<T> handlerType, Class<I> serviceType) {
        Class<T> processorType = null;
        Class<T> ifaceType = null;
        for (Class<T> clazz : serviceType.getDeclaredClasses()) {
            if (TProcessor.class.isAssignableFrom(clazz)) {
                processorType = clazz;
                continue;
            }
            if (!clazz.isInterface() || !"Iface".equals(clazz.getSimpleName())) continue;
            ifaceType = clazz;
        }
        Preconditions.checkArgument((processorType != null ? 1 : 0) != 0, (String)"Missing TProcessor, %s is not a valid thrift service.", (Object[])new Object[]{serviceType.getName()});
        Preconditions.checkArgument((ifaceType != null ? 1 : 0) != 0, (String)"Missing Iface, %s is not a valid thrift service.", (Object[])new Object[]{serviceType.getName()});
        if (ifaceType.isAssignableFrom(handlerType)) {
            return this.createProxyProcessor(handlerType, processorType, ifaceType);
        }
        throw new IllegalArgumentException("Unsupported handler type.");
    }

    private TProcessor createProxyProcessor(Class<T> handlerType, Class<? extends TProcessor> processorType, Class<?> ifaceType) {
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Method method : ifaceType.getMethods()) {
                Method handlerMethod = handlerType.getMethod(method.getName(), method.getParameterTypes());
                if (!handlerMethod.isAccessible()) {
                    handlerMethod.setAccessible(true);
                }
                builder.put((Object)method, (Object)handlerMethod);
            }
            ImmutableMap methods = builder.build();
            Object proxy = Proxy.newProxyInstance(ifaceType.getClassLoader(), new Class[]{ifaceType}, new InvocationHandler((Map)methods){
                final /* synthetic */ Map val$methods;
                {
                    this.val$methods = map;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        return ((Method)this.val$methods.get(method)).invoke((Object)ThriftRPCServer.this.serviceHandler, args);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() != null) {
                            throw e.getCause();
                        }
                        throw e;
                    }
                }
            });
            return processorType.getConstructor(ifaceType).newInstance(proxy);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /* synthetic */ ThriftRPCServer(InetSocketAddress x0, int x1, int x2, int x3, RPCServiceHandler x4, Class x5, String x6, 1 x7) {
        this(x0, x1, x2, x3, x4, x5, x6);
    }

    public static final class Builder<I> {
        private final Class<I> serviceType;
        private String name;
        private InetSocketAddress bindAddress = new InetSocketAddress(0);
        private int ioThreads = 2;
        private int workerThreads = Runtime.getRuntime().availableProcessors() - 2;
        private int maxReadBufferBytes = 0x1000000;

        private Builder(Class<I> serviceType) {
            this.serviceType = serviceType;
            this.name = serviceType.getSimpleName();
        }

        public Builder<I> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<I> setHost(String host) {
            this.bindAddress = new InetSocketAddress(host, this.bindAddress.getPort());
            return this;
        }

        public Builder<I> setPort(int port) {
            this.bindAddress = new InetSocketAddress(this.bindAddress.getHostName(), port);
            return this;
        }

        public Builder<I> setIOThreads(int count) {
            this.ioThreads = count;
            return this;
        }

        public Builder<I> setWorkerThreads(int count) {
            this.workerThreads = count;
            return this;
        }

        public Builder<I> setMaxReadBufferBytes(int maxReadBufferBytes) {
            this.maxReadBufferBytes = maxReadBufferBytes;
            return this;
        }

        public <T extends RPCServiceHandler> ThriftRPCServer<T, I> build(T serviceHandler) {
            return new ThriftRPCServer(this.bindAddress, this.ioThreads, this.workerThreads, this.maxReadBufferBytes, serviceHandler, this.serviceType, this.name, null);
        }
    }
}

