/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractBaseboard;
import oshi.util.ExecutingCommand;

final class FreeBsdBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    FreeBsdBaseboard() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.readDmiDecode();
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.readDmiDecode();
        }
        return super.getModel();
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.readDmiDecode();
        }
        return super.getVersion();
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.readDmiDecode();
        }
        return super.getSerialNumber();
    }

    private void readDmiDecode() {
        String manufacturerMarker = "Manufacturer:";
        String productNameMarker = "Product Name:";
        String versionMarker = "Version:";
        String serialNumMarker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t baseboard")) {
            if (checkLine.contains("Manufacturer:")) {
                String manufacturer = checkLine.split("Manufacturer:")[1].trim();
                String string = this.manufacturer = manufacturer.isEmpty() ? "unknown" : manufacturer;
            }
            if (checkLine.contains("Product Name:")) {
                String model = checkLine.split("Product Name:")[1].trim();
                String string = this.model = model.isEmpty() ? "unknown" : model;
            }
            if (checkLine.contains("Version:")) {
                String version = checkLine.split("Version:")[1].trim();
                String string = this.version = version.isEmpty() ? "unknown" : version;
            }
            if (!checkLine.contains("Serial Number:")) continue;
            String serialNumber = checkLine.split("Serial Number:")[1].trim();
            this.serialNumber = serialNumber.isEmpty() ? "unknown" : serialNumber;
        }
    }
}

