/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TSortInfo;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TSortNode
implements TBase<TSortNode, _Fields>,
Serializable,
Cloneable,
Comparable<TSortNode> {
    private static final TStruct STRUCT_DESC = new TStruct("TSortNode");
    private static final TField SORT_INFO_FIELD_DESC = new TField("sort_info", 12, 1);
    private static final TField USE_TOP_N_FIELD_DESC = new TField("use_top_n", 2, 2);
    private static final TField OFFSET_FIELD_DESC = new TField("offset", 10, 3);
    private static final TField ORDERING_EXPRS_FIELD_DESC = new TField("ordering_exprs", 15, 4);
    private static final TField IS_ASC_ORDER_FIELD_DESC = new TField("is_asc_order", 15, 5);
    private static final TField IS_DEFAULT_LIMIT_FIELD_DESC = new TField("is_default_limit", 2, 6);
    private static final TField NULLS_FIRST_FIELD_DESC = new TField("nulls_first", 15, 7);
    private static final TField SORT_TUPLE_SLOT_EXPRS_FIELD_DESC = new TField("sort_tuple_slot_exprs", 15, 8);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSortNodeStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSortNodeTupleSchemeFactory();
    @Nullable
    public TSortInfo sort_info;
    public boolean use_top_n;
    public long offset;
    @Nullable
    public List<TExpr> ordering_exprs;
    @Nullable
    public List<Boolean> is_asc_order;
    public boolean is_default_limit;
    @Nullable
    public List<Boolean> nulls_first;
    @Nullable
    public List<TExpr> sort_tuple_slot_exprs;
    private static final int __USE_TOP_N_ISSET_ID = 0;
    private static final int __OFFSET_ISSET_ID = 1;
    private static final int __IS_DEFAULT_LIMIT_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.OFFSET, _Fields.ORDERING_EXPRS, _Fields.IS_ASC_ORDER, _Fields.IS_DEFAULT_LIMIT, _Fields.NULLS_FIRST, _Fields.SORT_TUPLE_SLOT_EXPRS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSortNode() {
    }

    public TSortNode(TSortInfo sort_info, boolean use_top_n) {
        this();
        this.sort_info = sort_info;
        this.use_top_n = use_top_n;
        this.setUseTopNIsSet(true);
    }

    public TSortNode(TSortNode other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetSortInfo()) {
            this.sort_info = new TSortInfo(other.sort_info);
        }
        this.use_top_n = other.use_top_n;
        this.offset = other.offset;
        if (other.isSetOrderingExprs()) {
            ArrayList<TExpr> __this__ordering_exprs = new ArrayList<TExpr>(other.ordering_exprs.size());
            for (TExpr other_element : other.ordering_exprs) {
                __this__ordering_exprs.add(new TExpr(other_element));
            }
            this.ordering_exprs = __this__ordering_exprs;
        }
        if (other.isSetIsAscOrder()) {
            ArrayList<Boolean> __this__is_asc_order = new ArrayList<Boolean>(other.is_asc_order);
            this.is_asc_order = __this__is_asc_order;
        }
        this.is_default_limit = other.is_default_limit;
        if (other.isSetNullsFirst()) {
            ArrayList<Boolean> __this__nulls_first = new ArrayList<Boolean>(other.nulls_first);
            this.nulls_first = __this__nulls_first;
        }
        if (other.isSetSortTupleSlotExprs()) {
            ArrayList<TExpr> __this__sort_tuple_slot_exprs = new ArrayList<TExpr>(other.sort_tuple_slot_exprs.size());
            for (TExpr other_element : other.sort_tuple_slot_exprs) {
                __this__sort_tuple_slot_exprs.add(new TExpr(other_element));
            }
            this.sort_tuple_slot_exprs = __this__sort_tuple_slot_exprs;
        }
    }

    public TSortNode deepCopy() {
        return new TSortNode(this);
    }

    public void clear() {
        this.sort_info = null;
        this.setUseTopNIsSet(false);
        this.use_top_n = false;
        this.setOffsetIsSet(false);
        this.offset = 0L;
        this.ordering_exprs = null;
        this.is_asc_order = null;
        this.setIsDefaultLimitIsSet(false);
        this.is_default_limit = false;
        this.nulls_first = null;
        this.sort_tuple_slot_exprs = null;
    }

    @Nullable
    public TSortInfo getSortInfo() {
        return this.sort_info;
    }

    public TSortNode setSortInfo(@Nullable TSortInfo sort_info) {
        this.sort_info = sort_info;
        return this;
    }

    public void unsetSortInfo() {
        this.sort_info = null;
    }

    public boolean isSetSortInfo() {
        return this.sort_info != null;
    }

    public void setSortInfoIsSet(boolean value) {
        if (!value) {
            this.sort_info = null;
        }
    }

    public boolean isUseTopN() {
        return this.use_top_n;
    }

    public TSortNode setUseTopN(boolean use_top_n) {
        this.use_top_n = use_top_n;
        this.setUseTopNIsSet(true);
        return this;
    }

    public void unsetUseTopN() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetUseTopN() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setUseTopNIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getOffset() {
        return this.offset;
    }

    public TSortNode setOffset(long offset) {
        this.offset = offset;
        this.setOffsetIsSet(true);
        return this;
    }

    public void unsetOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getOrderingExprsSize() {
        return this.ordering_exprs == null ? 0 : this.ordering_exprs.size();
    }

    @Nullable
    public Iterator<TExpr> getOrderingExprsIterator() {
        return this.ordering_exprs == null ? null : this.ordering_exprs.iterator();
    }

    public void addToOrderingExprs(TExpr elem) {
        if (this.ordering_exprs == null) {
            this.ordering_exprs = new ArrayList<TExpr>();
        }
        this.ordering_exprs.add(elem);
    }

    @Nullable
    public List<TExpr> getOrderingExprs() {
        return this.ordering_exprs;
    }

    public TSortNode setOrderingExprs(@Nullable List<TExpr> ordering_exprs) {
        this.ordering_exprs = ordering_exprs;
        return this;
    }

    public void unsetOrderingExprs() {
        this.ordering_exprs = null;
    }

    public boolean isSetOrderingExprs() {
        return this.ordering_exprs != null;
    }

    public void setOrderingExprsIsSet(boolean value) {
        if (!value) {
            this.ordering_exprs = null;
        }
    }

    public int getIsAscOrderSize() {
        return this.is_asc_order == null ? 0 : this.is_asc_order.size();
    }

    @Nullable
    public Iterator<Boolean> getIsAscOrderIterator() {
        return this.is_asc_order == null ? null : this.is_asc_order.iterator();
    }

    public void addToIsAscOrder(boolean elem) {
        if (this.is_asc_order == null) {
            this.is_asc_order = new ArrayList<Boolean>();
        }
        this.is_asc_order.add(elem);
    }

    @Nullable
    public List<Boolean> getIsAscOrder() {
        return this.is_asc_order;
    }

    public TSortNode setIsAscOrder(@Nullable List<Boolean> is_asc_order) {
        this.is_asc_order = is_asc_order;
        return this;
    }

    public void unsetIsAscOrder() {
        this.is_asc_order = null;
    }

    public boolean isSetIsAscOrder() {
        return this.is_asc_order != null;
    }

    public void setIsAscOrderIsSet(boolean value) {
        if (!value) {
            this.is_asc_order = null;
        }
    }

    public boolean isIsDefaultLimit() {
        return this.is_default_limit;
    }

    public TSortNode setIsDefaultLimit(boolean is_default_limit) {
        this.is_default_limit = is_default_limit;
        this.setIsDefaultLimitIsSet(true);
        return this;
    }

    public void unsetIsDefaultLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetIsDefaultLimit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setIsDefaultLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getNullsFirstSize() {
        return this.nulls_first == null ? 0 : this.nulls_first.size();
    }

    @Nullable
    public Iterator<Boolean> getNullsFirstIterator() {
        return this.nulls_first == null ? null : this.nulls_first.iterator();
    }

    public void addToNullsFirst(boolean elem) {
        if (this.nulls_first == null) {
            this.nulls_first = new ArrayList<Boolean>();
        }
        this.nulls_first.add(elem);
    }

    @Nullable
    public List<Boolean> getNullsFirst() {
        return this.nulls_first;
    }

    public TSortNode setNullsFirst(@Nullable List<Boolean> nulls_first) {
        this.nulls_first = nulls_first;
        return this;
    }

    public void unsetNullsFirst() {
        this.nulls_first = null;
    }

    public boolean isSetNullsFirst() {
        return this.nulls_first != null;
    }

    public void setNullsFirstIsSet(boolean value) {
        if (!value) {
            this.nulls_first = null;
        }
    }

    public int getSortTupleSlotExprsSize() {
        return this.sort_tuple_slot_exprs == null ? 0 : this.sort_tuple_slot_exprs.size();
    }

    @Nullable
    public Iterator<TExpr> getSortTupleSlotExprsIterator() {
        return this.sort_tuple_slot_exprs == null ? null : this.sort_tuple_slot_exprs.iterator();
    }

    public void addToSortTupleSlotExprs(TExpr elem) {
        if (this.sort_tuple_slot_exprs == null) {
            this.sort_tuple_slot_exprs = new ArrayList<TExpr>();
        }
        this.sort_tuple_slot_exprs.add(elem);
    }

    @Nullable
    public List<TExpr> getSortTupleSlotExprs() {
        return this.sort_tuple_slot_exprs;
    }

    public TSortNode setSortTupleSlotExprs(@Nullable List<TExpr> sort_tuple_slot_exprs) {
        this.sort_tuple_slot_exprs = sort_tuple_slot_exprs;
        return this;
    }

    public void unsetSortTupleSlotExprs() {
        this.sort_tuple_slot_exprs = null;
    }

    public boolean isSetSortTupleSlotExprs() {
        return this.sort_tuple_slot_exprs != null;
    }

    public void setSortTupleSlotExprsIsSet(boolean value) {
        if (!value) {
            this.sort_tuple_slot_exprs = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case SORT_INFO: {
                if (value == null) {
                    this.unsetSortInfo();
                    break;
                }
                this.setSortInfo((TSortInfo)value);
                break;
            }
            case USE_TOP_N: {
                if (value == null) {
                    this.unsetUseTopN();
                    break;
                }
                this.setUseTopN((Boolean)value);
                break;
            }
            case OFFSET: {
                if (value == null) {
                    this.unsetOffset();
                    break;
                }
                this.setOffset((Long)value);
                break;
            }
            case ORDERING_EXPRS: {
                if (value == null) {
                    this.unsetOrderingExprs();
                    break;
                }
                this.setOrderingExprs((List)value);
                break;
            }
            case IS_ASC_ORDER: {
                if (value == null) {
                    this.unsetIsAscOrder();
                    break;
                }
                this.setIsAscOrder((List)value);
                break;
            }
            case IS_DEFAULT_LIMIT: {
                if (value == null) {
                    this.unsetIsDefaultLimit();
                    break;
                }
                this.setIsDefaultLimit((Boolean)value);
                break;
            }
            case NULLS_FIRST: {
                if (value == null) {
                    this.unsetNullsFirst();
                    break;
                }
                this.setNullsFirst((List)value);
                break;
            }
            case SORT_TUPLE_SLOT_EXPRS: {
                if (value == null) {
                    this.unsetSortTupleSlotExprs();
                    break;
                }
                this.setSortTupleSlotExprs((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SORT_INFO: {
                return this.getSortInfo();
            }
            case USE_TOP_N: {
                return this.isUseTopN();
            }
            case OFFSET: {
                return this.getOffset();
            }
            case ORDERING_EXPRS: {
                return this.getOrderingExprs();
            }
            case IS_ASC_ORDER: {
                return this.getIsAscOrder();
            }
            case IS_DEFAULT_LIMIT: {
                return this.isIsDefaultLimit();
            }
            case NULLS_FIRST: {
                return this.getNullsFirst();
            }
            case SORT_TUPLE_SLOT_EXPRS: {
                return this.getSortTupleSlotExprs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SORT_INFO: {
                return this.isSetSortInfo();
            }
            case USE_TOP_N: {
                return this.isSetUseTopN();
            }
            case OFFSET: {
                return this.isSetOffset();
            }
            case ORDERING_EXPRS: {
                return this.isSetOrderingExprs();
            }
            case IS_ASC_ORDER: {
                return this.isSetIsAscOrder();
            }
            case IS_DEFAULT_LIMIT: {
                return this.isSetIsDefaultLimit();
            }
            case NULLS_FIRST: {
                return this.isSetNullsFirst();
            }
            case SORT_TUPLE_SLOT_EXPRS: {
                return this.isSetSortTupleSlotExprs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TSortNode) {
            return this.equals((TSortNode)that);
        }
        return false;
    }

    public boolean equals(TSortNode that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_sort_info = this.isSetSortInfo();
        boolean that_present_sort_info = that.isSetSortInfo();
        if (this_present_sort_info || that_present_sort_info) {
            if (!this_present_sort_info || !that_present_sort_info) {
                return false;
            }
            if (!this.sort_info.equals(that.sort_info)) {
                return false;
            }
        }
        boolean this_present_use_top_n = true;
        boolean that_present_use_top_n = true;
        if (this_present_use_top_n || that_present_use_top_n) {
            if (!this_present_use_top_n || !that_present_use_top_n) {
                return false;
            }
            if (this.use_top_n != that.use_top_n) {
                return false;
            }
        }
        boolean this_present_offset = this.isSetOffset();
        boolean that_present_offset = that.isSetOffset();
        if (this_present_offset || that_present_offset) {
            if (!this_present_offset || !that_present_offset) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
        }
        boolean this_present_ordering_exprs = this.isSetOrderingExprs();
        boolean that_present_ordering_exprs = that.isSetOrderingExprs();
        if (this_present_ordering_exprs || that_present_ordering_exprs) {
            if (!this_present_ordering_exprs || !that_present_ordering_exprs) {
                return false;
            }
            if (!this.ordering_exprs.equals(that.ordering_exprs)) {
                return false;
            }
        }
        boolean this_present_is_asc_order = this.isSetIsAscOrder();
        boolean that_present_is_asc_order = that.isSetIsAscOrder();
        if (this_present_is_asc_order || that_present_is_asc_order) {
            if (!this_present_is_asc_order || !that_present_is_asc_order) {
                return false;
            }
            if (!this.is_asc_order.equals(that.is_asc_order)) {
                return false;
            }
        }
        boolean this_present_is_default_limit = this.isSetIsDefaultLimit();
        boolean that_present_is_default_limit = that.isSetIsDefaultLimit();
        if (this_present_is_default_limit || that_present_is_default_limit) {
            if (!this_present_is_default_limit || !that_present_is_default_limit) {
                return false;
            }
            if (this.is_default_limit != that.is_default_limit) {
                return false;
            }
        }
        boolean this_present_nulls_first = this.isSetNullsFirst();
        boolean that_present_nulls_first = that.isSetNullsFirst();
        if (this_present_nulls_first || that_present_nulls_first) {
            if (!this_present_nulls_first || !that_present_nulls_first) {
                return false;
            }
            if (!this.nulls_first.equals(that.nulls_first)) {
                return false;
            }
        }
        boolean this_present_sort_tuple_slot_exprs = this.isSetSortTupleSlotExprs();
        boolean that_present_sort_tuple_slot_exprs = that.isSetSortTupleSlotExprs();
        if (this_present_sort_tuple_slot_exprs || that_present_sort_tuple_slot_exprs) {
            if (!this_present_sort_tuple_slot_exprs || !that_present_sort_tuple_slot_exprs) {
                return false;
            }
            if (!this.sort_tuple_slot_exprs.equals(that.sort_tuple_slot_exprs)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetSortInfo() ? 131071 : 524287);
        if (this.isSetSortInfo()) {
            hashCode = hashCode * 8191 + this.sort_info.hashCode();
        }
        hashCode = hashCode * 8191 + (this.use_top_n ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetOffset() ? 131071 : 524287);
        if (this.isSetOffset()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.offset);
        }
        hashCode = hashCode * 8191 + (this.isSetOrderingExprs() ? 131071 : 524287);
        if (this.isSetOrderingExprs()) {
            hashCode = hashCode * 8191 + this.ordering_exprs.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsAscOrder() ? 131071 : 524287);
        if (this.isSetIsAscOrder()) {
            hashCode = hashCode * 8191 + this.is_asc_order.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsDefaultLimit() ? 131071 : 524287);
        if (this.isSetIsDefaultLimit()) {
            hashCode = hashCode * 8191 + (this.is_default_limit ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetNullsFirst() ? 131071 : 524287);
        if (this.isSetNullsFirst()) {
            hashCode = hashCode * 8191 + this.nulls_first.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSortTupleSlotExprs() ? 131071 : 524287);
        if (this.isSetSortTupleSlotExprs()) {
            hashCode = hashCode * 8191 + this.sort_tuple_slot_exprs.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSortNode other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSortInfo()).compareTo(other.isSetSortInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortInfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.sort_info, (Comparable)other.sort_info)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUseTopN()).compareTo(other.isSetUseTopN());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUseTopN() && (lastComparison = TBaseHelper.compareTo((boolean)this.use_top_n, (boolean)other.use_top_n)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(other.isSetOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo((long)this.offset, (long)other.offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrderingExprs()).compareTo(other.isSetOrderingExprs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrderingExprs() && (lastComparison = TBaseHelper.compareTo(this.ordering_exprs, other.ordering_exprs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsAscOrder()).compareTo(other.isSetIsAscOrder());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsAscOrder() && (lastComparison = TBaseHelper.compareTo(this.is_asc_order, other.is_asc_order)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsDefaultLimit()).compareTo(other.isSetIsDefaultLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsDefaultLimit() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_default_limit, (boolean)other.is_default_limit)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNullsFirst()).compareTo(other.isSetNullsFirst());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNullsFirst() && (lastComparison = TBaseHelper.compareTo(this.nulls_first, other.nulls_first)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSortTupleSlotExprs()).compareTo(other.isSetSortTupleSlotExprs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortTupleSlotExprs() && (lastComparison = TBaseHelper.compareTo(this.sort_tuple_slot_exprs, other.sort_tuple_slot_exprs)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TSortNode.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TSortNode.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSortNode(");
        boolean first = true;
        sb.append("sort_info:");
        if (this.sort_info == null) {
            sb.append("null");
        } else {
            sb.append(this.sort_info);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("use_top_n:");
        sb.append(this.use_top_n);
        first = false;
        if (this.isSetOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offset:");
            sb.append(this.offset);
            first = false;
        }
        if (this.isSetOrderingExprs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ordering_exprs:");
            if (this.ordering_exprs == null) {
                sb.append("null");
            } else {
                sb.append(this.ordering_exprs);
            }
            first = false;
        }
        if (this.isSetIsAscOrder()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_asc_order:");
            if (this.is_asc_order == null) {
                sb.append("null");
            } else {
                sb.append(this.is_asc_order);
            }
            first = false;
        }
        if (this.isSetIsDefaultLimit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_default_limit:");
            sb.append(this.is_default_limit);
            first = false;
        }
        if (this.isSetNullsFirst()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("nulls_first:");
            if (this.nulls_first == null) {
                sb.append("null");
            } else {
                sb.append(this.nulls_first);
            }
            first = false;
        }
        if (this.isSetSortTupleSlotExprs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sort_tuple_slot_exprs:");
            if (this.sort_tuple_slot_exprs == null) {
                sb.append("null");
            } else {
                sb.append(this.sort_tuple_slot_exprs);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sort_info == null) {
            throw new TProtocolException("Required field 'sort_info' was not present! Struct: " + this.toString());
        }
        if (this.sort_info != null) {
            this.sort_info.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SORT_INFO, new FieldMetaData("sort_info", 1, (FieldValueMetaData)new StructMetaData(12, TSortInfo.class)));
        tmpMap.put(_Fields.USE_TOP_N, new FieldMetaData("use_top_n", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.OFFSET, new FieldMetaData("offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ORDERING_EXPRS, new FieldMetaData("ordering_exprs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.IS_ASC_ORDER, new FieldMetaData("is_asc_order", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(2))));
        tmpMap.put(_Fields.IS_DEFAULT_LIMIT, new FieldMetaData("is_default_limit", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.NULLS_FIRST, new FieldMetaData("nulls_first", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(2))));
        tmpMap.put(_Fields.SORT_TUPLE_SLOT_EXPRS, new FieldMetaData("sort_tuple_slot_exprs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TExpr.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSortNode.class, metaDataMap);
    }

    private static class TSortNodeTupleScheme
    extends TupleScheme<TSortNode> {
        private TSortNodeTupleScheme() {
        }

        public void write(TProtocol prot, TSortNode struct) throws TException {
            Iterator<Comparable<TExpr>> iterator;
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.sort_info.write((TProtocol)oprot);
            oprot.writeBool(struct.use_top_n);
            BitSet optionals = new BitSet();
            if (struct.isSetOffset()) {
                optionals.set(0);
            }
            if (struct.isSetOrderingExprs()) {
                optionals.set(1);
            }
            if (struct.isSetIsAscOrder()) {
                optionals.set(2);
            }
            if (struct.isSetIsDefaultLimit()) {
                optionals.set(3);
            }
            if (struct.isSetNullsFirst()) {
                optionals.set(4);
            }
            if (struct.isSetSortTupleSlotExprs()) {
                optionals.set(5);
            }
            oprot.writeBitSet(optionals, 6);
            if (struct.isSetOffset()) {
                oprot.writeI64(struct.offset);
            }
            if (struct.isSetOrderingExprs()) {
                oprot.writeI32(struct.ordering_exprs.size());
                for (TExpr _iter440 : struct.ordering_exprs) {
                    _iter440.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIsAscOrder()) {
                oprot.writeI32(struct.is_asc_order.size());
                iterator = struct.is_asc_order.iterator();
                while (iterator.hasNext()) {
                    boolean _iter441 = (Boolean)iterator.next();
                    oprot.writeBool(_iter441);
                }
            }
            if (struct.isSetIsDefaultLimit()) {
                oprot.writeBool(struct.is_default_limit);
            }
            if (struct.isSetNullsFirst()) {
                oprot.writeI32(struct.nulls_first.size());
                iterator = struct.nulls_first.iterator();
                while (iterator.hasNext()) {
                    boolean _iter442 = (Boolean)iterator.next();
                    oprot.writeBool(_iter442);
                }
            }
            if (struct.isSetSortTupleSlotExprs()) {
                oprot.writeI32(struct.sort_tuple_slot_exprs.size());
                for (TExpr _iter443 : struct.sort_tuple_slot_exprs) {
                    _iter443.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TSortNode struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.sort_info = new TSortInfo();
            struct.sort_info.read((TProtocol)iprot);
            struct.setSortInfoIsSet(true);
            struct.use_top_n = iprot.readBool();
            struct.setUseTopNIsSet(true);
            BitSet incoming = iprot.readBitSet(6);
            if (incoming.get(0)) {
                struct.offset = iprot.readI64();
                struct.setOffsetIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list444 = new TList(12, iprot.readI32());
                struct.ordering_exprs = new ArrayList<TExpr>(_list444.size);
                for (int _i446 = 0; _i446 < _list444.size; ++_i446) {
                    TExpr _elem445 = new TExpr();
                    _elem445.read((TProtocol)iprot);
                    struct.ordering_exprs.add(_elem445);
                }
                struct.setOrderingExprsIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list447 = new TList(2, iprot.readI32());
                struct.is_asc_order = new ArrayList<Boolean>(_list447.size);
                for (int _i449 = 0; _i449 < _list447.size; ++_i449) {
                    boolean _elem448 = iprot.readBool();
                    struct.is_asc_order.add(_elem448);
                }
                struct.setIsAscOrderIsSet(true);
            }
            if (incoming.get(3)) {
                struct.is_default_limit = iprot.readBool();
                struct.setIsDefaultLimitIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list450 = new TList(2, iprot.readI32());
                struct.nulls_first = new ArrayList<Boolean>(_list450.size);
                for (int _i452 = 0; _i452 < _list450.size; ++_i452) {
                    boolean _elem451 = iprot.readBool();
                    struct.nulls_first.add(_elem451);
                }
                struct.setNullsFirstIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list453 = new TList(12, iprot.readI32());
                struct.sort_tuple_slot_exprs = new ArrayList<TExpr>(_list453.size);
                for (int _i455 = 0; _i455 < _list453.size; ++_i455) {
                    TExpr _elem454 = new TExpr();
                    _elem454.read((TProtocol)iprot);
                    struct.sort_tuple_slot_exprs.add(_elem454);
                }
                struct.setSortTupleSlotExprsIsSet(true);
            }
        }
    }

    private static class TSortNodeTupleSchemeFactory
    implements SchemeFactory {
        private TSortNodeTupleSchemeFactory() {
        }

        public TSortNodeTupleScheme getScheme() {
            return new TSortNodeTupleScheme();
        }
    }

    private static class TSortNodeStandardScheme
    extends StandardScheme<TSortNode> {
        private TSortNodeStandardScheme() {
        }

        public void read(TProtocol iprot, TSortNode struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.sort_info = new TSortInfo();
                            struct.sort_info.read(iprot);
                            struct.setSortInfoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 2) {
                            struct.use_top_n = iprot.readBool();
                            struct.setUseTopNIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.offset = iprot.readI64();
                            struct.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list424 = iprot.readListBegin();
                            struct.ordering_exprs = new ArrayList<TExpr>(_list424.size);
                            for (int _i426 = 0; _i426 < _list424.size; ++_i426) {
                                TExpr _elem425 = new TExpr();
                                _elem425.read(iprot);
                                struct.ordering_exprs.add(_elem425);
                            }
                            iprot.readListEnd();
                            struct.setOrderingExprsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list427 = iprot.readListBegin();
                            struct.is_asc_order = new ArrayList<Boolean>(_list427.size);
                            for (int _i429 = 0; _i429 < _list427.size; ++_i429) {
                                boolean _elem428 = iprot.readBool();
                                struct.is_asc_order.add(_elem428);
                            }
                            iprot.readListEnd();
                            struct.setIsAscOrderIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.is_default_limit = iprot.readBool();
                            struct.setIsDefaultLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list430 = iprot.readListBegin();
                            struct.nulls_first = new ArrayList<Boolean>(_list430.size);
                            for (int _i432 = 0; _i432 < _list430.size; ++_i432) {
                                boolean _elem431 = iprot.readBool();
                                struct.nulls_first.add(_elem431);
                            }
                            iprot.readListEnd();
                            struct.setNullsFirstIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list433 = iprot.readListBegin();
                            struct.sort_tuple_slot_exprs = new ArrayList<TExpr>(_list433.size);
                            for (int _i435 = 0; _i435 < _list433.size; ++_i435) {
                                TExpr _elem434 = new TExpr();
                                _elem434.read(iprot);
                                struct.sort_tuple_slot_exprs.add(_elem434);
                            }
                            iprot.readListEnd();
                            struct.setSortTupleSlotExprsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetUseTopN()) {
                throw new TProtocolException("Required field 'use_top_n' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TSortNode struct) throws TException {
            Iterator<Comparable<TExpr>> iterator;
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.sort_info != null) {
                oprot.writeFieldBegin(SORT_INFO_FIELD_DESC);
                struct.sort_info.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(USE_TOP_N_FIELD_DESC);
            oprot.writeBool(struct.use_top_n);
            oprot.writeFieldEnd();
            if (struct.isSetOffset()) {
                oprot.writeFieldBegin(OFFSET_FIELD_DESC);
                oprot.writeI64(struct.offset);
                oprot.writeFieldEnd();
            }
            if (struct.ordering_exprs != null && struct.isSetOrderingExprs()) {
                oprot.writeFieldBegin(ORDERING_EXPRS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.ordering_exprs.size()));
                for (TExpr _iter436 : struct.ordering_exprs) {
                    _iter436.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.is_asc_order != null && struct.isSetIsAscOrder()) {
                oprot.writeFieldBegin(IS_ASC_ORDER_FIELD_DESC);
                oprot.writeListBegin(new TList(2, struct.is_asc_order.size()));
                iterator = struct.is_asc_order.iterator();
                while (iterator.hasNext()) {
                    boolean _iter437 = (Boolean)iterator.next();
                    oprot.writeBool(_iter437);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsDefaultLimit()) {
                oprot.writeFieldBegin(IS_DEFAULT_LIMIT_FIELD_DESC);
                oprot.writeBool(struct.is_default_limit);
                oprot.writeFieldEnd();
            }
            if (struct.nulls_first != null && struct.isSetNullsFirst()) {
                oprot.writeFieldBegin(NULLS_FIRST_FIELD_DESC);
                oprot.writeListBegin(new TList(2, struct.nulls_first.size()));
                iterator = struct.nulls_first.iterator();
                while (iterator.hasNext()) {
                    boolean _iter438 = (Boolean)iterator.next();
                    oprot.writeBool(_iter438);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.sort_tuple_slot_exprs != null && struct.isSetSortTupleSlotExprs()) {
                oprot.writeFieldBegin(SORT_TUPLE_SLOT_EXPRS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.sort_tuple_slot_exprs.size()));
                for (TExpr _iter439 : struct.sort_tuple_slot_exprs) {
                    _iter439.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TSortNodeStandardSchemeFactory
    implements SchemeFactory {
        private TSortNodeStandardSchemeFactory() {
        }

        public TSortNodeStandardScheme getScheme() {
            return new TSortNodeStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SORT_INFO(1, "sort_info"),
        USE_TOP_N(2, "use_top_n"),
        OFFSET(3, "offset"),
        ORDERING_EXPRS(4, "ordering_exprs"),
        IS_ASC_ORDER(5, "is_asc_order"),
        IS_DEFAULT_LIMIT(6, "is_default_limit"),
        NULLS_FIRST(7, "nulls_first"),
        SORT_TUPLE_SLOT_EXPRS(8, "sort_tuple_slot_exprs");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SORT_INFO;
                }
                case 2: {
                    return USE_TOP_N;
                }
                case 3: {
                    return OFFSET;
                }
                case 4: {
                    return ORDERING_EXPRS;
                }
                case 5: {
                    return IS_ASC_ORDER;
                }
                case 6: {
                    return IS_DEFAULT_LIMIT;
                }
                case 7: {
                    return NULLS_FIRST;
                }
                case 8: {
                    return SORT_TUPLE_SLOT_EXPRS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

