/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.FrontendServiceVersion;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TMiniLoadRequest
implements TBase<TMiniLoadRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TMiniLoadRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TMiniLoadRequest");
    private static final TField PROTOCOL_VERSION_FIELD_DESC = new TField("protocolVersion", 8, 1);
    private static final TField DB_FIELD_DESC = new TField("db", 11, 2);
    private static final TField TBL_FIELD_DESC = new TField("tbl", 11, 3);
    private static final TField LABEL_FIELD_DESC = new TField("label", 11, 4);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 5);
    private static final TField BACKEND_FIELD_DESC = new TField("backend", 12, 6);
    private static final TField FILES_FIELD_DESC = new TField("files", 15, 7);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 8);
    private static final TField SUB_LABEL_FIELD_DESC = new TField("subLabel", 11, 9);
    private static final TField CLUSTER_FIELD_DESC = new TField("cluster", 11, 10);
    private static final TField TIMESTAMP_FIELD_DESC = new TField("timestamp", 10, 11);
    private static final TField USER_IP_FIELD_DESC = new TField("user_ip", 11, 12);
    private static final TField IS_RETRY_FIELD_DESC = new TField("is_retry", 2, 13);
    private static final TField FILE_SIZE_FIELD_DESC = new TField("file_size", 15, 14);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TMiniLoadRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TMiniLoadRequestTupleSchemeFactory();
    @Nullable
    public FrontendServiceVersion protocolVersion;
    @Nullable
    public String db;
    @Nullable
    public String tbl;
    @Nullable
    public String label;
    @Nullable
    public String user;
    @Nullable
    public TNetworkAddress backend;
    @Nullable
    public List<String> files;
    @Nullable
    public Map<String, String> properties;
    @Nullable
    public String subLabel;
    @Nullable
    public String cluster;
    public long timestamp;
    @Nullable
    public String user_ip;
    public boolean is_retry;
    @Nullable
    public List<Long> file_size;
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private static final int __IS_RETRY_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.USER, _Fields.SUB_LABEL, _Fields.CLUSTER, _Fields.TIMESTAMP, _Fields.USER_IP, _Fields.IS_RETRY, _Fields.FILE_SIZE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TMiniLoadRequest() {
    }

    public TMiniLoadRequest(FrontendServiceVersion protocolVersion, String db, String tbl, String label, TNetworkAddress backend, List<String> files, Map<String, String> properties) {
        this();
        this.protocolVersion = protocolVersion;
        this.db = db;
        this.tbl = tbl;
        this.label = label;
        this.backend = backend;
        this.files = files;
        this.properties = properties;
    }

    public TMiniLoadRequest(TMiniLoadRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetProtocolVersion()) {
            this.protocolVersion = other.protocolVersion;
        }
        if (other.isSetDb()) {
            this.db = other.db;
        }
        if (other.isSetTbl()) {
            this.tbl = other.tbl;
        }
        if (other.isSetLabel()) {
            this.label = other.label;
        }
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetBackend()) {
            this.backend = new TNetworkAddress(other.backend);
        }
        if (other.isSetFiles()) {
            ArrayList<String> __this__files = new ArrayList<String>(other.files);
            this.files = __this__files;
        }
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>(other.properties);
            this.properties = __this__properties;
        }
        if (other.isSetSubLabel()) {
            this.subLabel = other.subLabel;
        }
        if (other.isSetCluster()) {
            this.cluster = other.cluster;
        }
        this.timestamp = other.timestamp;
        if (other.isSetUserIp()) {
            this.user_ip = other.user_ip;
        }
        this.is_retry = other.is_retry;
        if (other.isSetFileSize()) {
            ArrayList<Long> __this__file_size = new ArrayList<Long>(other.file_size);
            this.file_size = __this__file_size;
        }
    }

    public TMiniLoadRequest deepCopy() {
        return new TMiniLoadRequest(this);
    }

    public void clear() {
        this.protocolVersion = null;
        this.db = null;
        this.tbl = null;
        this.label = null;
        this.user = null;
        this.backend = null;
        this.files = null;
        this.properties = null;
        this.subLabel = null;
        this.cluster = null;
        this.setTimestampIsSet(false);
        this.timestamp = 0L;
        this.user_ip = null;
        this.setIsRetryIsSet(false);
        this.is_retry = false;
        this.file_size = null;
    }

    @Nullable
    public FrontendServiceVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public TMiniLoadRequest setProtocolVersion(@Nullable FrontendServiceVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public void unsetProtocolVersion() {
        this.protocolVersion = null;
    }

    public boolean isSetProtocolVersion() {
        return this.protocolVersion != null;
    }

    public void setProtocolVersionIsSet(boolean value) {
        if (!value) {
            this.protocolVersion = null;
        }
    }

    @Nullable
    public String getDb() {
        return this.db;
    }

    public TMiniLoadRequest setDb(@Nullable String db) {
        this.db = db;
        return this;
    }

    public void unsetDb() {
        this.db = null;
    }

    public boolean isSetDb() {
        return this.db != null;
    }

    public void setDbIsSet(boolean value) {
        if (!value) {
            this.db = null;
        }
    }

    @Nullable
    public String getTbl() {
        return this.tbl;
    }

    public TMiniLoadRequest setTbl(@Nullable String tbl) {
        this.tbl = tbl;
        return this;
    }

    public void unsetTbl() {
        this.tbl = null;
    }

    public boolean isSetTbl() {
        return this.tbl != null;
    }

    public void setTblIsSet(boolean value) {
        if (!value) {
            this.tbl = null;
        }
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public TMiniLoadRequest setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public void unsetLabel() {
        this.label = null;
    }

    public boolean isSetLabel() {
        return this.label != null;
    }

    public void setLabelIsSet(boolean value) {
        if (!value) {
            this.label = null;
        }
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public TMiniLoadRequest setUser(@Nullable String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    @Nullable
    public TNetworkAddress getBackend() {
        return this.backend;
    }

    public TMiniLoadRequest setBackend(@Nullable TNetworkAddress backend) {
        this.backend = backend;
        return this;
    }

    public void unsetBackend() {
        this.backend = null;
    }

    public boolean isSetBackend() {
        return this.backend != null;
    }

    public void setBackendIsSet(boolean value) {
        if (!value) {
            this.backend = null;
        }
    }

    public int getFilesSize() {
        return this.files == null ? 0 : this.files.size();
    }

    @Nullable
    public Iterator<String> getFilesIterator() {
        return this.files == null ? null : this.files.iterator();
    }

    public void addToFiles(String elem) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.add(elem);
    }

    @Nullable
    public List<String> getFiles() {
        return this.files;
    }

    public TMiniLoadRequest setFiles(@Nullable List<String> files) {
        this.files = files;
        return this;
    }

    public void unsetFiles() {
        this.files = null;
    }

    public boolean isSetFiles() {
        return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
        if (!value) {
            this.files = null;
        }
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TMiniLoadRequest setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    @Nullable
    public String getSubLabel() {
        return this.subLabel;
    }

    public TMiniLoadRequest setSubLabel(@Nullable String subLabel) {
        this.subLabel = subLabel;
        return this;
    }

    public void unsetSubLabel() {
        this.subLabel = null;
    }

    public boolean isSetSubLabel() {
        return this.subLabel != null;
    }

    public void setSubLabelIsSet(boolean value) {
        if (!value) {
            this.subLabel = null;
        }
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    public TMiniLoadRequest setCluster(@Nullable String cluster) {
        this.cluster = cluster;
        return this;
    }

    public void unsetCluster() {
        this.cluster = null;
    }

    public boolean isSetCluster() {
        return this.cluster != null;
    }

    public void setClusterIsSet(boolean value) {
        if (!value) {
            this.cluster = null;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TMiniLoadRequest setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setTimestampIsSet(true);
        return this;
    }

    public void unsetTimestamp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTimestamp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTimestampIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getUserIp() {
        return this.user_ip;
    }

    public TMiniLoadRequest setUserIp(@Nullable String user_ip) {
        this.user_ip = user_ip;
        return this;
    }

    public void unsetUserIp() {
        this.user_ip = null;
    }

    public boolean isSetUserIp() {
        return this.user_ip != null;
    }

    public void setUserIpIsSet(boolean value) {
        if (!value) {
            this.user_ip = null;
        }
    }

    public boolean isIsRetry() {
        return this.is_retry;
    }

    public TMiniLoadRequest setIsRetry(boolean is_retry) {
        this.is_retry = is_retry;
        this.setIsRetryIsSet(true);
        return this;
    }

    public void unsetIsRetry() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetIsRetry() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIsRetryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getFileSizeSize() {
        return this.file_size == null ? 0 : this.file_size.size();
    }

    @Nullable
    public Iterator<Long> getFileSizeIterator() {
        return this.file_size == null ? null : this.file_size.iterator();
    }

    public void addToFileSize(long elem) {
        if (this.file_size == null) {
            this.file_size = new ArrayList<Long>();
        }
        this.file_size.add(elem);
    }

    @Nullable
    public List<Long> getFileSize() {
        return this.file_size;
    }

    public TMiniLoadRequest setFileSize(@Nullable List<Long> file_size) {
        this.file_size = file_size;
        return this;
    }

    public void unsetFileSize() {
        this.file_size = null;
    }

    public boolean isSetFileSize() {
        return this.file_size != null;
    }

    public void setFileSizeIsSet(boolean value) {
        if (!value) {
            this.file_size = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PROTOCOL_VERSION: {
                if (value == null) {
                    this.unsetProtocolVersion();
                    break;
                }
                this.setProtocolVersion((FrontendServiceVersion)((Object)value));
                break;
            }
            case DB: {
                if (value == null) {
                    this.unsetDb();
                    break;
                }
                this.setDb((String)value);
                break;
            }
            case TBL: {
                if (value == null) {
                    this.unsetTbl();
                    break;
                }
                this.setTbl((String)value);
                break;
            }
            case LABEL: {
                if (value == null) {
                    this.unsetLabel();
                    break;
                }
                this.setLabel((String)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case BACKEND: {
                if (value == null) {
                    this.unsetBackend();
                    break;
                }
                this.setBackend((TNetworkAddress)value);
                break;
            }
            case FILES: {
                if (value == null) {
                    this.unsetFiles();
                    break;
                }
                this.setFiles((List)value);
                break;
            }
            case PROPERTIES: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
                break;
            }
            case SUB_LABEL: {
                if (value == null) {
                    this.unsetSubLabel();
                    break;
                }
                this.setSubLabel((String)value);
                break;
            }
            case CLUSTER: {
                if (value == null) {
                    this.unsetCluster();
                    break;
                }
                this.setCluster((String)value);
                break;
            }
            case TIMESTAMP: {
                if (value == null) {
                    this.unsetTimestamp();
                    break;
                }
                this.setTimestamp((Long)value);
                break;
            }
            case USER_IP: {
                if (value == null) {
                    this.unsetUserIp();
                    break;
                }
                this.setUserIp((String)value);
                break;
            }
            case IS_RETRY: {
                if (value == null) {
                    this.unsetIsRetry();
                    break;
                }
                this.setIsRetry((Boolean)value);
                break;
            }
            case FILE_SIZE: {
                if (value == null) {
                    this.unsetFileSize();
                    break;
                }
                this.setFileSize((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PROTOCOL_VERSION: {
                return this.getProtocolVersion();
            }
            case DB: {
                return this.getDb();
            }
            case TBL: {
                return this.getTbl();
            }
            case LABEL: {
                return this.getLabel();
            }
            case USER: {
                return this.getUser();
            }
            case BACKEND: {
                return this.getBackend();
            }
            case FILES: {
                return this.getFiles();
            }
            case PROPERTIES: {
                return this.getProperties();
            }
            case SUB_LABEL: {
                return this.getSubLabel();
            }
            case CLUSTER: {
                return this.getCluster();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case USER_IP: {
                return this.getUserIp();
            }
            case IS_RETRY: {
                return this.isIsRetry();
            }
            case FILE_SIZE: {
                return this.getFileSize();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PROTOCOL_VERSION: {
                return this.isSetProtocolVersion();
            }
            case DB: {
                return this.isSetDb();
            }
            case TBL: {
                return this.isSetTbl();
            }
            case LABEL: {
                return this.isSetLabel();
            }
            case USER: {
                return this.isSetUser();
            }
            case BACKEND: {
                return this.isSetBackend();
            }
            case FILES: {
                return this.isSetFiles();
            }
            case PROPERTIES: {
                return this.isSetProperties();
            }
            case SUB_LABEL: {
                return this.isSetSubLabel();
            }
            case CLUSTER: {
                return this.isSetCluster();
            }
            case TIMESTAMP: {
                return this.isSetTimestamp();
            }
            case USER_IP: {
                return this.isSetUserIp();
            }
            case IS_RETRY: {
                return this.isSetIsRetry();
            }
            case FILE_SIZE: {
                return this.isSetFileSize();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TMiniLoadRequest) {
            return this.equals((TMiniLoadRequest)that);
        }
        return false;
    }

    public boolean equals(TMiniLoadRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_protocolVersion = this.isSetProtocolVersion();
        boolean that_present_protocolVersion = that.isSetProtocolVersion();
        if (this_present_protocolVersion || that_present_protocolVersion) {
            if (!this_present_protocolVersion || !that_present_protocolVersion) {
                return false;
            }
            if (!this.protocolVersion.equals((Object)that.protocolVersion)) {
                return false;
            }
        }
        boolean this_present_db = this.isSetDb();
        boolean that_present_db = that.isSetDb();
        if (this_present_db || that_present_db) {
            if (!this_present_db || !that_present_db) {
                return false;
            }
            if (!this.db.equals(that.db)) {
                return false;
            }
        }
        boolean this_present_tbl = this.isSetTbl();
        boolean that_present_tbl = that.isSetTbl();
        if (this_present_tbl || that_present_tbl) {
            if (!this_present_tbl || !that_present_tbl) {
                return false;
            }
            if (!this.tbl.equals(that.tbl)) {
                return false;
            }
        }
        boolean this_present_label = this.isSetLabel();
        boolean that_present_label = that.isSetLabel();
        if (this_present_label || that_present_label) {
            if (!this_present_label || !that_present_label) {
                return false;
            }
            if (!this.label.equals(that.label)) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_backend = this.isSetBackend();
        boolean that_present_backend = that.isSetBackend();
        if (this_present_backend || that_present_backend) {
            if (!this_present_backend || !that_present_backend) {
                return false;
            }
            if (!this.backend.equals(that.backend)) {
                return false;
            }
        }
        boolean this_present_files = this.isSetFiles();
        boolean that_present_files = that.isSetFiles();
        if (this_present_files || that_present_files) {
            if (!this_present_files || !that_present_files) {
                return false;
            }
            if (!this.files.equals(that.files)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        boolean this_present_subLabel = this.isSetSubLabel();
        boolean that_present_subLabel = that.isSetSubLabel();
        if (this_present_subLabel || that_present_subLabel) {
            if (!this_present_subLabel || !that_present_subLabel) {
                return false;
            }
            if (!this.subLabel.equals(that.subLabel)) {
                return false;
            }
        }
        boolean this_present_cluster = this.isSetCluster();
        boolean that_present_cluster = that.isSetCluster();
        if (this_present_cluster || that_present_cluster) {
            if (!this_present_cluster || !that_present_cluster) {
                return false;
            }
            if (!this.cluster.equals(that.cluster)) {
                return false;
            }
        }
        boolean this_present_timestamp = this.isSetTimestamp();
        boolean that_present_timestamp = that.isSetTimestamp();
        if (this_present_timestamp || that_present_timestamp) {
            if (!this_present_timestamp || !that_present_timestamp) {
                return false;
            }
            if (this.timestamp != that.timestamp) {
                return false;
            }
        }
        boolean this_present_user_ip = this.isSetUserIp();
        boolean that_present_user_ip = that.isSetUserIp();
        if (this_present_user_ip || that_present_user_ip) {
            if (!this_present_user_ip || !that_present_user_ip) {
                return false;
            }
            if (!this.user_ip.equals(that.user_ip)) {
                return false;
            }
        }
        boolean this_present_is_retry = this.isSetIsRetry();
        boolean that_present_is_retry = that.isSetIsRetry();
        if (this_present_is_retry || that_present_is_retry) {
            if (!this_present_is_retry || !that_present_is_retry) {
                return false;
            }
            if (this.is_retry != that.is_retry) {
                return false;
            }
        }
        boolean this_present_file_size = this.isSetFileSize();
        boolean that_present_file_size = that.isSetFileSize();
        if (this_present_file_size || that_present_file_size) {
            if (!this_present_file_size || !that_present_file_size) {
                return false;
            }
            if (!this.file_size.equals(that.file_size)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetProtocolVersion() ? 131071 : 524287);
        if (this.isSetProtocolVersion()) {
            hashCode = hashCode * 8191 + this.protocolVersion.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetDb() ? 131071 : 524287);
        if (this.isSetDb()) {
            hashCode = hashCode * 8191 + this.db.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTbl() ? 131071 : 524287);
        if (this.isSetTbl()) {
            hashCode = hashCode * 8191 + this.tbl.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLabel() ? 131071 : 524287);
        if (this.isSetLabel()) {
            hashCode = hashCode * 8191 + this.label.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetUser() ? 131071 : 524287);
        if (this.isSetUser()) {
            hashCode = hashCode * 8191 + this.user.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBackend() ? 131071 : 524287);
        if (this.isSetBackend()) {
            hashCode = hashCode * 8191 + this.backend.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFiles() ? 131071 : 524287);
        if (this.isSetFiles()) {
            hashCode = hashCode * 8191 + this.files.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProperties() ? 131071 : 524287);
        if (this.isSetProperties()) {
            hashCode = hashCode * 8191 + this.properties.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSubLabel() ? 131071 : 524287);
        if (this.isSetSubLabel()) {
            hashCode = hashCode * 8191 + this.subLabel.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCluster() ? 131071 : 524287);
        if (this.isSetCluster()) {
            hashCode = hashCode * 8191 + this.cluster.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTimestamp() ? 131071 : 524287);
        if (this.isSetTimestamp()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.timestamp);
        }
        hashCode = hashCode * 8191 + (this.isSetUserIp() ? 131071 : 524287);
        if (this.isSetUserIp()) {
            hashCode = hashCode * 8191 + this.user_ip.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsRetry() ? 131071 : 524287);
        if (this.isSetIsRetry()) {
            hashCode = hashCode * 8191 + (this.is_retry ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetFileSize() ? 131071 : 524287);
        if (this.isSetFileSize()) {
            hashCode = hashCode * 8191 + this.file_size.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TMiniLoadRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetProtocolVersion()).compareTo(other.isSetProtocolVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProtocolVersion() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.protocolVersion), (Comparable)((Object)other.protocolVersion))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDb()).compareTo(other.isSetDb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDb() && (lastComparison = TBaseHelper.compareTo((String)this.db, (String)other.db)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTbl()).compareTo(other.isSetTbl());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTbl() && (lastComparison = TBaseHelper.compareTo((String)this.tbl, (String)other.tbl)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLabel()).compareTo(other.isSetLabel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLabel() && (lastComparison = TBaseHelper.compareTo((String)this.label, (String)other.label)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUser()).compareTo(other.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)other.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBackend()).compareTo(other.isSetBackend());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBackend() && (lastComparison = TBaseHelper.compareTo((Comparable)this.backend, (Comparable)other.backend)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFiles()).compareTo(other.isSetFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFiles() && (lastComparison = TBaseHelper.compareTo(this.files, other.files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProperties()).compareTo(other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo(this.properties, other.properties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSubLabel()).compareTo(other.isSetSubLabel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSubLabel() && (lastComparison = TBaseHelper.compareTo((String)this.subLabel, (String)other.subLabel)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCluster()).compareTo(other.isSetCluster());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCluster() && (lastComparison = TBaseHelper.compareTo((String)this.cluster, (String)other.cluster)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTimestamp()).compareTo(other.isSetTimestamp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimestamp() && (lastComparison = TBaseHelper.compareTo((long)this.timestamp, (long)other.timestamp)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUserIp()).compareTo(other.isSetUserIp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUserIp() && (lastComparison = TBaseHelper.compareTo((String)this.user_ip, (String)other.user_ip)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsRetry()).compareTo(other.isSetIsRetry());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsRetry() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_retry, (boolean)other.is_retry)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFileSize()).compareTo(other.isSetFileSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileSize() && (lastComparison = TBaseHelper.compareTo(this.file_size, other.file_size)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TMiniLoadRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TMiniLoadRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TMiniLoadRequest(");
        boolean first = true;
        sb.append("protocolVersion:");
        if (this.protocolVersion == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.protocolVersion);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("db:");
        if (this.db == null) {
            sb.append("null");
        } else {
            sb.append(this.db);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tbl:");
        if (this.tbl == null) {
            sb.append("null");
        } else {
            sb.append(this.tbl);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("label:");
        if (this.label == null) {
            sb.append("null");
        } else {
            sb.append(this.label);
        }
        first = false;
        if (this.isSetUser()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("user:");
            if (this.user == null) {
                sb.append("null");
            } else {
                sb.append(this.user);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("backend:");
        if (this.backend == null) {
            sb.append("null");
        } else {
            sb.append(this.backend);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("files:");
        if (this.files == null) {
            sb.append("null");
        } else {
            sb.append(this.files);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("properties:");
        if (this.properties == null) {
            sb.append("null");
        } else {
            sb.append(this.properties);
        }
        first = false;
        if (this.isSetSubLabel()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("subLabel:");
            if (this.subLabel == null) {
                sb.append("null");
            } else {
                sb.append(this.subLabel);
            }
            first = false;
        }
        if (this.isSetCluster()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cluster:");
            if (this.cluster == null) {
                sb.append("null");
            } else {
                sb.append(this.cluster);
            }
            first = false;
        }
        if (this.isSetTimestamp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timestamp:");
            sb.append(this.timestamp);
            first = false;
        }
        if (this.isSetUserIp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("user_ip:");
            if (this.user_ip == null) {
                sb.append("null");
            } else {
                sb.append(this.user_ip);
            }
            first = false;
        }
        if (this.isSetIsRetry()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_retry:");
            sb.append(this.is_retry);
            first = false;
        }
        if (this.isSetFileSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("file_size:");
            if (this.file_size == null) {
                sb.append("null");
            } else {
                sb.append(this.file_size);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.protocolVersion == null) {
            throw new TProtocolException("Required field 'protocolVersion' was not present! Struct: " + this.toString());
        }
        if (this.db == null) {
            throw new TProtocolException("Required field 'db' was not present! Struct: " + this.toString());
        }
        if (this.tbl == null) {
            throw new TProtocolException("Required field 'tbl' was not present! Struct: " + this.toString());
        }
        if (this.label == null) {
            throw new TProtocolException("Required field 'label' was not present! Struct: " + this.toString());
        }
        if (this.backend == null) {
            throw new TProtocolException("Required field 'backend' was not present! Struct: " + this.toString());
        }
        if (this.files == null) {
            throw new TProtocolException("Required field 'files' was not present! Struct: " + this.toString());
        }
        if (this.properties == null) {
            throw new TProtocolException("Required field 'properties' was not present! Struct: " + this.toString());
        }
        if (this.backend != null) {
            this.backend.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PROTOCOL_VERSION, new FieldMetaData("protocolVersion", 1, (FieldValueMetaData)new EnumMetaData(16, FrontendServiceVersion.class)));
        tmpMap.put(_Fields.DB, new FieldMetaData("db", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL, new FieldMetaData("tbl", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LABEL, new FieldMetaData("label", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BACKEND, new FieldMetaData("backend", 1, (FieldValueMetaData)new StructMetaData(12, TNetworkAddress.class)));
        tmpMap.put(_Fields.FILES, new FieldMetaData("files", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.SUB_LABEL, new FieldMetaData("subLabel", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CLUSTER, new FieldMetaData("cluster", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TIMESTAMP, new FieldMetaData("timestamp", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.USER_IP, new FieldMetaData("user_ip", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.IS_RETRY, new FieldMetaData("is_retry", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.FILE_SIZE, new FieldMetaData("file_size", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(10))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TMiniLoadRequest.class, metaDataMap);
    }

    private static class TMiniLoadRequestTupleScheme
    extends TupleScheme<TMiniLoadRequest> {
        private TMiniLoadRequestTupleScheme() {
        }

        public void write(TProtocol prot, TMiniLoadRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.protocolVersion.getValue());
            oprot.writeString(struct.db);
            oprot.writeString(struct.tbl);
            oprot.writeString(struct.label);
            struct.backend.write((TProtocol)oprot);
            oprot.writeI32(struct.files.size());
            for (String string : struct.files) {
                oprot.writeString(string);
            }
            oprot.writeI32(struct.properties.size());
            for (Map.Entry entry : struct.properties.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            BitSet optionals = new BitSet();
            if (struct.isSetUser()) {
                optionals.set(0);
            }
            if (struct.isSetSubLabel()) {
                optionals.set(1);
            }
            if (struct.isSetCluster()) {
                optionals.set(2);
            }
            if (struct.isSetTimestamp()) {
                optionals.set(3);
            }
            if (struct.isSetUserIp()) {
                optionals.set(4);
            }
            if (struct.isSetIsRetry()) {
                optionals.set(5);
            }
            if (struct.isSetFileSize()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetSubLabel()) {
                oprot.writeString(struct.subLabel);
            }
            if (struct.isSetCluster()) {
                oprot.writeString(struct.cluster);
            }
            if (struct.isSetTimestamp()) {
                oprot.writeI64(struct.timestamp);
            }
            if (struct.isSetUserIp()) {
                oprot.writeString(struct.user_ip);
            }
            if (struct.isSetIsRetry()) {
                oprot.writeBool(struct.is_retry);
            }
            if (struct.isSetFileSize()) {
                oprot.writeI32(struct.file_size.size());
                for (long _iter173 : struct.file_size) {
                    oprot.writeI64(_iter173);
                }
            }
        }

        public void read(TProtocol prot, TMiniLoadRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.protocolVersion = FrontendServiceVersion.findByValue(iprot.readI32());
            struct.setProtocolVersionIsSet(true);
            struct.db = iprot.readString();
            struct.setDbIsSet(true);
            struct.tbl = iprot.readString();
            struct.setTblIsSet(true);
            struct.label = iprot.readString();
            struct.setLabelIsSet(true);
            struct.backend = new TNetworkAddress();
            struct.backend.read((TProtocol)iprot);
            struct.setBackendIsSet(true);
            TList _list174 = new TList(11, iprot.readI32());
            struct.files = new ArrayList<String>(_list174.size);
            for (int _i176 = 0; _i176 < _list174.size; ++_i176) {
                String _elem175 = iprot.readString();
                struct.files.add(_elem175);
            }
            struct.setFilesIsSet(true);
            TMap _map177 = new TMap(11, 11, iprot.readI32());
            struct.properties = new HashMap<String, String>(2 * _map177.size);
            for (int _i180 = 0; _i180 < _map177.size; ++_i180) {
                String _key178 = iprot.readString();
                String _val179 = iprot.readString();
                struct.properties.put(_key178, _val179);
            }
            struct.setPropertiesIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(1)) {
                struct.subLabel = iprot.readString();
                struct.setSubLabelIsSet(true);
            }
            if (incoming.get(2)) {
                struct.cluster = iprot.readString();
                struct.setClusterIsSet(true);
            }
            if (incoming.get(3)) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
            }
            if (incoming.get(4)) {
                struct.user_ip = iprot.readString();
                struct.setUserIpIsSet(true);
            }
            if (incoming.get(5)) {
                struct.is_retry = iprot.readBool();
                struct.setIsRetryIsSet(true);
            }
            if (incoming.get(6)) {
                TList _list181 = new TList(10, iprot.readI32());
                struct.file_size = new ArrayList<Long>(_list181.size);
                for (int _i183 = 0; _i183 < _list181.size; ++_i183) {
                    long _elem182 = iprot.readI64();
                    struct.file_size.add(_elem182);
                }
                struct.setFileSizeIsSet(true);
            }
        }
    }

    private static class TMiniLoadRequestTupleSchemeFactory
    implements SchemeFactory {
        private TMiniLoadRequestTupleSchemeFactory() {
        }

        public TMiniLoadRequestTupleScheme getScheme() {
            return new TMiniLoadRequestTupleScheme();
        }
    }

    private static class TMiniLoadRequestStandardScheme
    extends StandardScheme<TMiniLoadRequest> {
        private TMiniLoadRequestStandardScheme() {
        }

        public void read(TProtocol iprot, TMiniLoadRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.protocolVersion = FrontendServiceVersion.findByValue(iprot.readI32());
                            struct.setProtocolVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.db = iprot.readString();
                            struct.setDbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tbl = iprot.readString();
                            struct.setTblIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.label = iprot.readString();
                            struct.setLabelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.backend = new TNetworkAddress();
                            struct.backend.read(iprot);
                            struct.setBackendIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list158 = iprot.readListBegin();
                            struct.files = new ArrayList<String>(_list158.size);
                            for (int _i160 = 0; _i160 < _list158.size; ++_i160) {
                                String _elem159 = iprot.readString();
                                struct.files.add(_elem159);
                            }
                            iprot.readListEnd();
                            struct.setFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 13) {
                            TMap _map161 = iprot.readMapBegin();
                            struct.properties = new HashMap<String, String>(2 * _map161.size);
                            for (int _i164 = 0; _i164 < _map161.size; ++_i164) {
                                String _key162 = iprot.readString();
                                String _val163 = iprot.readString();
                                struct.properties.put(_key162, _val163);
                            }
                            iprot.readMapEnd();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.subLabel = iprot.readString();
                            struct.setSubLabelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.cluster = iprot.readString();
                            struct.setClusterIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.timestamp = iprot.readI64();
                            struct.setTimestampIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.user_ip = iprot.readString();
                            struct.setUserIpIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 2) {
                            struct.is_retry = iprot.readBool();
                            struct.setIsRetryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 15) {
                            TList _list165 = iprot.readListBegin();
                            struct.file_size = new ArrayList<Long>(_list165.size);
                            for (int _i167 = 0; _i167 < _list165.size; ++_i167) {
                                long _elem166 = iprot.readI64();
                                struct.file_size.add(_elem166);
                            }
                            iprot.readListEnd();
                            struct.setFileSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TMiniLoadRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.protocolVersion != null) {
                oprot.writeFieldBegin(PROTOCOL_VERSION_FIELD_DESC);
                oprot.writeI32(struct.protocolVersion.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.db != null) {
                oprot.writeFieldBegin(DB_FIELD_DESC);
                oprot.writeString(struct.db);
                oprot.writeFieldEnd();
            }
            if (struct.tbl != null) {
                oprot.writeFieldBegin(TBL_FIELD_DESC);
                oprot.writeString(struct.tbl);
                oprot.writeFieldEnd();
            }
            if (struct.label != null) {
                oprot.writeFieldBegin(LABEL_FIELD_DESC);
                oprot.writeString(struct.label);
                oprot.writeFieldEnd();
            }
            if (struct.user != null && struct.isSetUser()) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.backend != null) {
                oprot.writeFieldBegin(BACKEND_FIELD_DESC);
                struct.backend.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.files != null) {
                oprot.writeFieldBegin(FILES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.files.size()));
                for (String string : struct.files) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.properties != null) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.properties.size()));
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.subLabel != null && struct.isSetSubLabel()) {
                oprot.writeFieldBegin(SUB_LABEL_FIELD_DESC);
                oprot.writeString(struct.subLabel);
                oprot.writeFieldEnd();
            }
            if (struct.cluster != null && struct.isSetCluster()) {
                oprot.writeFieldBegin(CLUSTER_FIELD_DESC);
                oprot.writeString(struct.cluster);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimestamp()) {
                oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
                oprot.writeI64(struct.timestamp);
                oprot.writeFieldEnd();
            }
            if (struct.user_ip != null && struct.isSetUserIp()) {
                oprot.writeFieldBegin(USER_IP_FIELD_DESC);
                oprot.writeString(struct.user_ip);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsRetry()) {
                oprot.writeFieldBegin(IS_RETRY_FIELD_DESC);
                oprot.writeBool(struct.is_retry);
                oprot.writeFieldEnd();
            }
            if (struct.file_size != null && struct.isSetFileSize()) {
                oprot.writeFieldBegin(FILE_SIZE_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.file_size.size()));
                Iterator<Object> iterator = struct.file_size.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    oprot.writeI64(l);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TMiniLoadRequestStandardSchemeFactory
    implements SchemeFactory {
        private TMiniLoadRequestStandardSchemeFactory() {
        }

        public TMiniLoadRequestStandardScheme getScheme() {
            return new TMiniLoadRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PROTOCOL_VERSION(1, "protocolVersion"),
        DB(2, "db"),
        TBL(3, "tbl"),
        LABEL(4, "label"),
        USER(5, "user"),
        BACKEND(6, "backend"),
        FILES(7, "files"),
        PROPERTIES(8, "properties"),
        SUB_LABEL(9, "subLabel"),
        CLUSTER(10, "cluster"),
        TIMESTAMP(11, "timestamp"),
        USER_IP(12, "user_ip"),
        IS_RETRY(13, "is_retry"),
        FILE_SIZE(14, "file_size");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PROTOCOL_VERSION;
                }
                case 2: {
                    return DB;
                }
                case 3: {
                    return TBL;
                }
                case 4: {
                    return LABEL;
                }
                case 5: {
                    return USER;
                }
                case 6: {
                    return BACKEND;
                }
                case 7: {
                    return FILES;
                }
                case 8: {
                    return PROPERTIES;
                }
                case 9: {
                    return SUB_LABEL;
                }
                case 10: {
                    return CLUSTER;
                }
                case 11: {
                    return TIMESTAMP;
                }
                case 12: {
                    return USER_IP;
                }
                case 13: {
                    return IS_RETRY;
                }
                case 14: {
                    return FILE_SIZE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

