/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.doris.common.io.Text;
import org.slf4j.Logger;

public class IOUtils {
    public static long copyBytes(InputStream in, OutputStream out, int buffSize, long len) throws IOException {
        byte[] buf = new byte[buffSize];
        int totalRead = 0;
        int toRead = 0;
        int bytesRead = 0;
        toRead = (int)Math.min((long)buffSize, len - (long)totalRead);
        bytesRead = in.read(buf, 0, toRead);
        totalRead += bytesRead;
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            toRead = (int)Math.min((long)buffSize, len - (long)totalRead);
            if (toRead == 0) break;
            bytesRead = in.read(buf, 0, toRead);
            totalRead += bytesRead;
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyBytes(InputStream in, OutputStream out, int buffSize, int speed, boolean close2) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        long bytesReadTotal = 0L;
        long startTime = 0L;
        long sleepTime = 0L;
        long curTime = 0L;
        try {
            if (speed > 0) {
                startTime = System.currentTimeMillis();
            }
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                if (speed > 0 && (sleepTime = (bytesReadTotal += (long)bytesRead) / (long)speed * 1000L / 1024L - ((curTime = System.currentTimeMillis()) - startTime)) > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                bytesRead = in.read(buf);
            }
            long l = bytesReadTotal;
            return l;
        }
        finally {
            if (close2) {
                out.close();
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyBytes(InputStream in, OutputStream out, int buffSize, boolean close2) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        long totalBytes = 0L;
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                totalBytes += (long)bytesRead;
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
            long l = totalBytes;
            return l;
        }
        finally {
            if (close2) {
                out.close();
                in.close();
            }
        }
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        int tmpOff = off;
        while (toRead > 0) {
            int ret = in.read(buf, tmpOff, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            tmpOff += ret;
        }
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        long ret;
        for (long tmpLen = len; tmpLen > 0L; tmpLen -= ret) {
            ret = in.skip(tmpLen);
            if (ret >= 0L) continue;
            throw new IOException("Premature EOF from inputStream");
        }
    }

    public static void cleanup(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing {} {}", (Object)c, (Object)e);
            }
        }
    }

    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeOptionString(DataOutput output, String value) throws IOException {
        boolean hasValue = !Strings.isNullOrEmpty((String)value);
        output.writeBoolean(hasValue);
        if (hasValue) {
            Text.writeString(output, value);
        }
    }

    public static String readOptionStringOrNull(DataInput input) throws IOException {
        if (input.readBoolean()) {
            return Text.readString(input);
        }
        return null;
    }
}

