/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;

final class FSDirTruncateOp {
    private FSDirTruncateOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TruncateResult truncate(FSNamesystem fsn, String srcArg, long newLength, String clientName, String clientMachine, long mtime, INode.BlocksMapUpdateInfo toRemoveBlocks, FSPermissionChecker pc) throws IOException, UnresolvedLinkException {
        boolean onBlockBoundary;
        String src;
        INodesInPath iip;
        assert (fsn.hasWriteLock());
        FSDirectory fsd = fsn.getFSDirectory();
        Block truncateBlock = null;
        fsd.writeLock();
        try {
            long truncateLength;
            Block truncatedBlock;
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            INodeFile file = INodeFile.valueOf(iip.getLastINode(), src);
            BlockStoragePolicy lpPolicy = fsd.getBlockManager().getStoragePolicy("LAZY_PERSIST");
            if (lpPolicy != null && lpPolicy.getId() == file.getStoragePolicyID()) {
                throw new UnsupportedOperationException("Cannot truncate lazy persist file " + src);
            }
            BlockInfo last = file.getLastBlock();
            if (last != null && last.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY && (truncatedBlock = last.getUnderConstructionFeature().getTruncateBlock()) != null && newLength == (truncateLength = file.computeFileSize(false, false) + truncatedBlock.getNumBytes())) {
                TruncateResult truncateResult = new TruncateResult(false, fsd.getAuditFileInfo(iip));
                return truncateResult;
            }
            fsn.recoverLeaseInternal(FSNamesystem.RecoverLeaseOp.TRUNCATE_FILE, iip, src, clientName, clientMachine, false);
            long oldLength = file.computeFileSize();
            if (oldLength == newLength) {
                TruncateResult truncateResult = new TruncateResult(true, fsd.getAuditFileInfo(iip));
                return truncateResult;
            }
            if (oldLength < newLength) {
                throw new HadoopIllegalArgumentException("Cannot truncate to a larger file size. Current size: " + oldLength + ", truncate size: " + newLength + ".");
            }
            QuotaCounts delta = new QuotaCounts.Builder().build();
            onBlockBoundary = FSDirTruncateOp.unprotectedTruncate(fsn, iip, newLength, toRemoveBlocks, mtime, delta);
            if (!onBlockBoundary) {
                long lastBlockDelta = file.computeFileSize() - newLength;
                assert (lastBlockDelta > 0L) : "delta is 0 only if on block bounday";
                truncateBlock = FSDirTruncateOp.prepareFileForTruncate(fsn, iip, clientName, clientMachine, lastBlockDelta, null);
            }
            fsd.updateCountNoQuotaCheck(iip, iip.length() - 1, delta);
        }
        finally {
            fsd.writeUnlock();
        }
        fsn.getEditLog().logTruncate(src, clientName, clientMachine, newLength, mtime, truncateBlock);
        return new TruncateResult(onBlockBoundary, fsd.getAuditFileInfo(iip));
    }

    static void unprotectedTruncate(FSNamesystem fsn, INodesInPath iip, String clientName, String clientMachine, long newLength, long mtime, Block truncateBlock) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, IOException {
        assert (fsn.hasWriteLock());
        FSDirectory fsd = fsn.getFSDirectory();
        INodeFile file = iip.getLastINode().asFile();
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        boolean onBlockBoundary = FSDirTruncateOp.unprotectedTruncate(fsn, iip, newLength, collectedBlocks, mtime, null);
        if (!onBlockBoundary) {
            BlockInfo oldBlock = file.getLastBlock();
            Block tBlk = FSDirTruncateOp.prepareFileForTruncate(fsn, iip, clientName, clientMachine, file.computeFileSize() - newLength, truncateBlock);
            assert (Block.matchingIdAndGenStamp((Block)tBlk, (Block)truncateBlock) && tBlk.getNumBytes() == truncateBlock.getNumBytes()) : "Should be the same block.";
            if (oldBlock.getBlockId() != tBlk.getBlockId() && !file.isBlockInLatestSnapshot(oldBlock)) {
                fsd.getBlockManager().removeBlockFromMap(oldBlock);
            }
        }
        assert (onBlockBoundary == (truncateBlock == null)) : "truncateBlock is null iff on block boundary: " + truncateBlock;
        fsn.removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
    }

    @VisibleForTesting
    static Block prepareFileForTruncate(FSNamesystem fsn, INodesInPath iip, String leaseHolder, String clientMachine, long lastBlockDelta, Block newBlock) throws IOException {
        BlockInfo truncatedBlockUC;
        assert (fsn.hasWriteLock());
        INodeFile file = iip.getLastINode().asFile();
        file.recordModification(iip.getLatestSnapshotId());
        file.toUnderConstruction(leaseHolder, clientMachine);
        assert (file.isUnderConstruction()) : "inode should be under construction.";
        fsn.getLeaseManager().addLease(file.getFileUnderConstructionFeature().getClientName(), file.getId());
        boolean shouldRecoverNow = newBlock == null;
        BlockInfo oldBlock = file.getLastBlock();
        boolean shouldCopyOnTruncate = FSDirTruncateOp.shouldCopyOnTruncate(fsn, file, oldBlock);
        if (newBlock == null) {
            newBlock = shouldCopyOnTruncate ? fsn.createNewBlock() : new Block(oldBlock.getBlockId(), oldBlock.getNumBytes(), fsn.nextGenerationStamp(fsn.getBlockIdManager().isLegacyBlock(oldBlock)));
        }
        BlockManager blockManager = fsn.getFSDirectory().getBlockManager();
        if (shouldCopyOnTruncate) {
            truncatedBlockUC = new BlockInfoContiguous(newBlock, file.getPreferredBlockReplication());
            truncatedBlockUC.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, blockManager.getStorages(oldBlock));
            truncatedBlockUC.setNumBytes(oldBlock.getNumBytes() - lastBlockDelta);
            truncatedBlockUC.getUnderConstructionFeature().setTruncateBlock(oldBlock);
            file.setLastBlock(truncatedBlockUC);
            blockManager.addBlockCollection(truncatedBlockUC, file);
            NameNode.stateChangeLog.debug("BLOCK* prepareFileForTruncate: Scheduling copy-on-truncate to new size {}  new block {} old block {}", new Object[]{truncatedBlockUC.getNumBytes(), newBlock, oldBlock});
        } else {
            blockManager.convertLastBlockToUnderConstruction(file, lastBlockDelta);
            oldBlock = file.getLastBlock();
            assert (!oldBlock.isComplete()) : "oldBlock should be under construction";
            BlockUnderConstructionFeature uc = oldBlock.getUnderConstructionFeature();
            uc.setTruncateBlock(new Block((Block)oldBlock));
            uc.getTruncateBlock().setNumBytes(oldBlock.getNumBytes() - lastBlockDelta);
            uc.getTruncateBlock().setGenerationStamp(newBlock.getGenerationStamp());
            truncatedBlockUC = oldBlock;
            NameNode.stateChangeLog.debug("BLOCK* prepareFileForTruncate: {} Scheduling in-place block truncate to new size {}", (Object)uc, (Object)uc.getTruncateBlock().getNumBytes());
        }
        if (shouldRecoverNow) {
            truncatedBlockUC.getUnderConstructionFeature().initializeBlockRecovery(truncatedBlockUC, newBlock.getGenerationStamp());
        }
        return newBlock;
    }

    private static boolean unprotectedTruncate(FSNamesystem fsn, INodesInPath iip, long newLength, INode.BlocksMapUpdateInfo collectedBlocks, long mtime, QuotaCounts delta) throws IOException {
        assert (fsn.hasWriteLock());
        INodeFile file = iip.getLastINode().asFile();
        int latestSnapshot = iip.getLatestSnapshotId();
        file.recordModification(latestSnapshot, true);
        FSDirTruncateOp.verifyQuotaForTruncate(fsn, iip, file, newLength, delta);
        long remainingLength = file.collectBlocksBeyondMax(newLength, collectedBlocks);
        file.excludeSnapshotBlocks(latestSnapshot, collectedBlocks);
        file.setModificationTime(mtime);
        return remainingLength - newLength == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyQuotaForTruncate(FSNamesystem fsn, INodesInPath iip, INodeFile file, long newLength, QuotaCounts delta) throws QuotaExceededException {
        FSDirectory fsd = fsn.getFSDirectory();
        if (!fsn.isImageLoaded() || fsd.shouldSkipQuotaChecks()) {
            return;
        }
        BlockStoragePolicy policy = fsd.getBlockStoragePolicySuite().getPolicy(file.getStoragePolicyID());
        file.computeQuotaDeltaForTruncate(newLength, policy, delta);
        fsd.readLock();
        try {
            FSDirectory.verifyQuota(iip, iip.length() - 1, delta, null);
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static boolean shouldCopyOnTruncate(FSNamesystem fsn, INodeFile file, BlockInfo blk) {
        if (!fsn.isUpgradeFinalized()) {
            return true;
        }
        if (fsn.isRollingUpgrade()) {
            return true;
        }
        return file.isBlockInLatestSnapshot(blk);
    }

    static class TruncateResult {
        private final boolean result;
        private final HdfsFileStatus stat;

        public TruncateResult(boolean result, HdfsFileStatus stat) {
            this.result = result;
            this.stat = stat;
        }

        boolean getResult() {
            return this.result;
        }

        HdfsFileStatus getFileStatus() {
            return this.stat;
        }
    }
}

