/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Time;

class FSDirSymlinkOp {
    FSDirSymlinkOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus createSymlinkInt(FSNamesystem fsn, String target, String linkArg, PermissionStatus dirPerms, boolean createParent, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        FSDirectory fsd = fsn.getFSDirectory();
        String link = linkArg;
        if (!DFSUtil.isValidName(link)) {
            throw new InvalidPathException("Invalid link name: " + link);
        }
        if (FSDirectory.isReservedName(target) || target.isEmpty() || FSDirectory.isExactReservedName(target)) {
            throw new InvalidPathException("Invalid target name: " + target);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.createSymlink: target=" + target + " link=" + link);
        }
        FSPermissionChecker pc = fsn.getPermissionChecker();
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, link, FSDirectory.DirOp.WRITE_LINK);
            link = iip.getPath();
            if (!createParent) {
                fsd.verifyParentDir(iip);
            }
            if (!fsd.isValidToCreate(link, iip)) {
                throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
            }
            if (fsd.isPermissionEnabled()) {
                fsd.checkAncestorAccess(pc, iip, FsAction.WRITE);
            }
            fsn.checkFsObjectLimit();
            FSDirSymlinkOp.addSymlink(fsd, link, iip, target, dirPerms, createParent, logRetryCache);
        }
        finally {
            fsd.writeUnlock();
        }
        NameNode.getNameNodeMetrics().incrCreateSymlinkOps();
        return fsd.getAuditFileInfo(iip);
    }

    static INodeSymlink unprotectedAddSymlink(FSDirectory fsd, INodesInPath iip, byte[] localName, long id, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException {
        assert (fsd.hasWriteLock());
        INodeSymlink symlink = new INodeSymlink(id, null, perm, mtime, atime, target);
        symlink.setLocalName(localName);
        return fsd.addINode(iip, symlink) != null ? symlink : null;
    }

    private static INodeSymlink addSymlink(FSDirectory fsd, String path, INodesInPath iip, String target, PermissionStatus dirPerms, boolean createParent, boolean logRetryCache) throws IOException {
        INodesInPath parent;
        long mtime = Time.now();
        if (createParent) {
            parent = FSDirMkdirOp.createAncestorDirectories(fsd, iip, dirPerms);
            if (parent == null) {
                return null;
            }
        } else {
            parent = iip.getParentINodesInPath();
        }
        String userName = dirPerms.getUserName();
        long id = fsd.allocateNewInodeId();
        PermissionStatus perm = new PermissionStatus(userName, null, FsPermission.getDefault());
        INodeSymlink newNode = FSDirSymlinkOp.unprotectedAddSymlink(fsd, parent, iip.getLastLocalName(), id, target, mtime, mtime, perm);
        if (newNode == null) {
            NameNode.stateChangeLog.info("addSymlink: failed to add " + path);
            return null;
        }
        fsd.getEditLog().logSymlink(path, target, mtime, mtime, newNode, logRetryCache);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("addSymlink: " + path + " is added");
        }
        return newNode;
    }
}

