/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.BiMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableBiMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Tasks;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableOperations.class);
    private static final String HIVE_ACQUIRE_LOCK_TIMEOUT_MS = "iceberg.hive.lock-timeout-ms";
    private static final String HIVE_LOCK_CHECK_MIN_WAIT_MS = "iceberg.hive.lock-check-min-wait-ms";
    private static final String HIVE_LOCK_CHECK_MAX_WAIT_MS = "iceberg.hive.lock-check-max-wait-ms";
    private static final String HIVE_TABLE_LEVEL_LOCK_EVICT_MS = "iceberg.hive.table-level-lock-evict-ms";
    private static final long HIVE_ACQUIRE_LOCK_TIMEOUT_MS_DEFAULT = 180000L;
    private static final long HIVE_LOCK_CHECK_MIN_WAIT_MS_DEFAULT = 50L;
    private static final long HIVE_LOCK_CHECK_MAX_WAIT_MS_DEFAULT = 5000L;
    private static final long HIVE_TABLE_LEVEL_LOCK_EVICT_MS_DEFAULT = TimeUnit.MINUTES.toMillis(10L);
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder((String)"alter_table").impl(HiveMetaStoreClient.class, "alter_table_with_environmentContext", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).impl(HiveMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).build();
    private static final BiMap<String, String> ICEBERG_TO_HMS_TRANSLATION = ImmutableBiMap.of((Object)"gc.enabled", (Object)"external.table.purge");
    private static Cache<String, ReentrantLock> commitLockCache;
    private final String fullName;
    private final String database;
    private final String tableName;
    private final Configuration conf;
    private final long lockAcquireTimeout;
    private final long lockCheckMinWaitTime;
    private final long lockCheckMaxWaitTime;
    private final FileIO fileIO;
    private final ClientPool<HiveMetaStoreClient, TException> metaClients;

    private static synchronized void initTableLevelLockCache(long evictionTimeout) {
        if (commitLockCache == null) {
            commitLockCache = Caffeine.newBuilder().expireAfterAccess(evictionTimeout, TimeUnit.MILLISECONDS).build();
        }
    }

    public static String translateToIcebergProp(String hmsProp) {
        return (String)ICEBERG_TO_HMS_TRANSLATION.inverse().getOrDefault((Object)hmsProp, (Object)hmsProp);
    }

    protected HiveTableOperations(Configuration conf, ClientPool metaClients, FileIO fileIO, String catalogName, String database, String table) {
        this.conf = conf;
        this.metaClients = metaClients;
        this.fileIO = fileIO;
        this.fullName = catalogName + "." + database + "." + table;
        this.database = database;
        this.tableName = table;
        this.lockAcquireTimeout = conf.getLong(HIVE_ACQUIRE_LOCK_TIMEOUT_MS, 180000L);
        this.lockCheckMinWaitTime = conf.getLong(HIVE_LOCK_CHECK_MIN_WAIT_MS, 50L);
        this.lockCheckMaxWaitTime = conf.getLong(HIVE_LOCK_CHECK_MAX_WAIT_MS, 5000L);
        long tableLevelLockCacheEvictionTimeout = conf.getLong(HIVE_TABLE_LEVEL_LOCK_EVICT_MS, HIVE_TABLE_LEVEL_LOCK_EVICT_MS_DEFAULT);
        HiveTableOperations.initTableLevelLockCache(tableLevelLockCacheEvictionTimeout);
    }

    protected String tableName() {
        return this.fullName;
    }

    public FileIO io() {
        return this.fileIO;
    }

    protected void doRefresh() {
        String metadataLocation = null;
        try {
            Table table = (Table)this.metaClients.run(client -> client.getTable(this.database, this.tableName));
            HiveTableOperations.validateTableIsIceberg(table, this.fullName);
            metadataLocation = (String)table.getParameters().get("metadata_location");
        }
        catch (NoSuchObjectException e) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("No such table: %s.%s", new Object[]{this.database, this.tableName});
            }
        }
        catch (TException e) {
            String errMsg = String.format("Failed to get table info from metastore %s.%s", this.database, this.tableName);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during refresh", e);
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean hiveEngineEnabled = HiveTableOperations.hiveEngineEnabled(metadata, this.conf);
        BaseMetastoreTableOperations.CommitStatus commitStatus = BaseMetastoreTableOperations.CommitStatus.FAILURE;
        boolean updateHiveTable = false;
        Optional<Long> lockId = Optional.empty();
        ReentrantLock tableLevelMutex = (ReentrantLock)commitLockCache.get((Object)this.fullName, t -> new ReentrantLock(true));
        tableLevelMutex.lock();
        try {
            String baseMetadataLocation;
            lockId = Optional.of(this.acquireLock());
            Table tbl = this.loadHmsTable();
            if (tbl != null) {
                if (base == null && tbl.getParameters().get("metadata_location") != null) {
                    throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s.%s", new Object[]{this.database, this.tableName});
                }
                updateHiveTable = true;
                LOG.debug("Committing existing table: {}", (Object)this.fullName);
            } else {
                tbl = this.newHmsTable();
                LOG.debug("Committing new table: {}", (Object)this.fullName);
            }
            tbl.setSd(this.storageDescriptor(metadata, hiveEngineEnabled));
            String metadataLocation = (String)tbl.getParameters().get("metadata_location");
            String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
            if (!Objects.equals(baseMetadataLocation, metadataLocation)) {
                throw new CommitFailedException("Base metadata location '%s' is not same as the current table metadata location '%s' for %s.%s", new Object[]{baseMetadataLocation, metadataLocation, this.database, this.tableName});
            }
            Set<String> removedProps = Collections.emptySet();
            if (base != null) {
                removedProps = base.properties().keySet().stream().filter(key -> !metadata.properties().containsKey(key)).collect(Collectors.toSet());
            }
            Map summary = Optional.ofNullable(metadata.currentSnapshot()).map(Snapshot::summary).orElseGet(ImmutableMap::of);
            this.setHmsTableParameters(newMetadataLocation, tbl, metadata.properties(), removedProps, hiveEngineEnabled, summary);
            try {
                this.persistTable(tbl, updateHiveTable);
                commitStatus = BaseMetastoreTableOperations.CommitStatus.SUCCESS;
                return;
            }
            catch (Throwable persistFailure) {
                LOG.error("Cannot tell if commit to {}.{} succeeded, attempting to reconnect and check.", new Object[]{this.database, this.tableName, persistFailure});
                commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
                switch (commitStatus) {
                    case SUCCESS: {
                        return;
                    }
                    case FAILURE: {
                        throw persistFailure;
                    }
                    case UNKNOWN: {
                        throw new CommitStateUnknownException(persistFailure);
                    }
                }
            }
            return;
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s.%s", new Object[]{this.database, this.tableName});
        }
        catch (UnknownHostException | TException e) {
            if (e.getMessage() == null || !e.getMessage().contains("Table/View 'HIVE_LOCKS' does not exist")) throw new RuntimeException(String.format("Metastore operation failed for %s.%s", this.database, this.tableName), e);
            throw new RuntimeException("Failed to acquire locks from metastore because 'HIVE_LOCKS' doesn't exist, this probably happened when using embedded metastore or doesn't create a transactional meta table. To fix this, use an alternative metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        finally {
            this.cleanupMetadataAndUnlock(commitStatus, newMetadataLocation, lockId);
            tableLevelMutex.unlock();
        }
    }

    @VisibleForTesting
    void persistTable(Table hmsTable, boolean updateHiveTable) throws TException, InterruptedException {
        if (updateHiveTable) {
            this.metaClients.run(client -> {
                EnvironmentContext envContext = new EnvironmentContext((Map)ImmutableMap.of((Object)"DO_NOT_UPDATE_STATS", (Object)"true"));
                ALTER_TABLE.invoke(client, new Object[]{this.database, this.tableName, hmsTable, envContext});
                return null;
            });
        } else {
            this.metaClients.run(client -> {
                client.createTable(hmsTable);
                return null;
            });
        }
    }

    private Table loadHmsTable() throws TException, InterruptedException {
        try {
            return (Table)this.metaClients.run(client -> client.getTable(this.database, this.tableName));
        }
        catch (NoSuchObjectException nte) {
            LOG.trace("Table not found {}", (Object)this.fullName, (Object)nte);
            return null;
        }
    }

    private Table newHmsTable() {
        long currentTimeMillis = System.currentTimeMillis();
        Table newTable = new Table(this.tableName, this.database, System.getProperty("user.name"), (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, null, Collections.emptyList(), new HashMap(), null, null, TableType.EXTERNAL_TABLE.toString());
        newTable.getParameters().put("EXTERNAL", "TRUE");
        return newTable;
    }

    private void setHmsTableParameters(String newMetadataLocation, Table tbl, Map<String, String> icebergTableProps, Set<String> obsoleteProps, boolean hiveEngineEnabled, Map<String, String> summary) {
        Map parameters = Optional.ofNullable(tbl.getParameters()).orElseGet(HashMap::new);
        icebergTableProps.forEach((key, value) -> {
            String hmsKey = (String)ICEBERG_TO_HMS_TRANSLATION.getOrDefault(key, key);
            parameters.put(hmsKey, value);
        });
        obsoleteProps.forEach(parameters::remove);
        parameters.put("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        parameters.put("metadata_location", newMetadataLocation);
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            parameters.put("previous_metadata_location", this.currentMetadataLocation());
        }
        if (hiveEngineEnabled) {
            parameters.put("storage_handler", "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler");
        } else {
            parameters.remove("storage_handler");
        }
        if (summary.get("total-data-files") != null) {
            parameters.put("numFiles", summary.get("total-data-files"));
        }
        if (summary.get("total-records") != null) {
            parameters.put("numRows", summary.get("total-records"));
        }
        if (summary.get("total-files-size") != null) {
            parameters.put("totalSize", summary.get("total-files-size"));
        }
        tbl.setParameters(parameters);
    }

    private StorageDescriptor storageDescriptor(TableMetadata metadata, boolean hiveEngineEnabled) {
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setCols(HiveSchemaUtil.convert(metadata.schema()));
        storageDescriptor.setLocation(metadata.location());
        SerDeInfo serDeInfo = new SerDeInfo();
        if (hiveEngineEnabled) {
            storageDescriptor.setInputFormat("org.apache.iceberg.mr.hive.HiveIcebergInputFormat");
            storageDescriptor.setOutputFormat("org.apache.iceberg.mr.hive.HiveIcebergOutputFormat");
            serDeInfo.setSerializationLib("org.apache.iceberg.mr.hive.HiveIcebergSerDe");
        } else {
            storageDescriptor.setOutputFormat("org.apache.hadoop.mapred.FileOutputFormat");
            storageDescriptor.setInputFormat("org.apache.hadoop.mapred.FileInputFormat");
            serDeInfo.setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        }
        storageDescriptor.setSerdeInfo(serDeInfo);
        return storageDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long acquireLock() throws UnknownHostException, TException, InterruptedException {
        LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, this.database);
        lockComponent.setTablename(this.tableName);
        LockRequest lockRequest = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{lockComponent}), System.getProperty("user.name"), InetAddress.getLocalHost().getHostName());
        LockResponse lockResponse = (LockResponse)this.metaClients.run(client -> client.lock(lockRequest));
        AtomicReference<LockState> state = new AtomicReference<LockState>(lockResponse.getState());
        long lockId = lockResponse.getLockid();
        long start = System.currentTimeMillis();
        long duration = 0L;
        boolean timeout = false;
        try {
            if (state.get().equals((Object)LockState.WAITING)) {
                Tasks.foreach((Object[])new Long[]{lockId}).retry(2147483547).exponentialBackoff(this.lockCheckMinWaitTime, this.lockCheckMaxWaitTime, this.lockAcquireTimeout, 1.5).throwFailureWhenFinished().onlyRetryOn(WaitingForLockException.class).run(id -> {
                    try {
                        LockResponse response = (LockResponse)this.metaClients.run(client -> client.checkLock(id.longValue()));
                        LockState newState = response.getState();
                        state.set(newState);
                        if (newState.equals((Object)LockState.WAITING)) {
                            throw new WaitingForLockException("Waiting for lock.");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        LOG.warn("Interrupted while waiting for lock.", (Throwable)e);
                    }
                }, TException.class);
            }
        }
        catch (WaitingForLockException waitingForLockException) {
            timeout = true;
            duration = System.currentTimeMillis() - start;
        }
        finally {
            if (!state.get().equals((Object)LockState.ACQUIRED)) {
                this.unlock(Optional.of(lockId));
            }
        }
        if (timeout && !state.get().equals((Object)LockState.ACQUIRED)) {
            throw new CommitFailedException("Timed out after %s ms waiting for lock on %s.%s", new Object[]{duration, this.database, this.tableName});
        }
        if (!state.get().equals((Object)LockState.ACQUIRED)) {
            throw new CommitFailedException("Could not acquire the lock on %s.%s, lock request ended in state %s", new Object[]{this.database, this.tableName, state});
        }
        return lockId;
    }

    private void cleanupMetadataAndUnlock(BaseMetastoreTableOperations.CommitStatus commitStatus, String metadataLocation, Optional<Long> lockId) {
        try {
            if (commitStatus == BaseMetastoreTableOperations.CommitStatus.FAILURE) {
                this.io().deleteFile(metadataLocation);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Fail to cleanup metadata file at {}", (Object)metadataLocation, (Object)e);
            throw e;
        }
        finally {
            this.unlock(lockId);
        }
    }

    private void unlock(Optional<Long> lockId) {
        if (lockId.isPresent()) {
            try {
                this.doUnlock(lockId.get());
            }
            catch (Exception e) {
                LOG.warn("Failed to unlock {}.{}", new Object[]{this.database, this.tableName, e});
            }
        }
    }

    @VisibleForTesting
    void doUnlock(long lockId) throws TException, InterruptedException {
        this.metaClients.run(client -> {
            client.unlock(lockId);
            return null;
        });
    }

    static void validateTableIsIceberg(Table table, String fullName) {
        String tableType = (String)table.getParameters().get("table_type");
        NoSuchIcebergTableException.check((tableType != null && tableType.equalsIgnoreCase("iceberg") ? 1 : 0) != 0, (String)"Not an iceberg table: %s (type=%s)", (Object[])new Object[]{fullName, tableType});
    }

    private static boolean hiveEngineEnabled(TableMetadata metadata, Configuration conf) {
        if (metadata.properties().get("engine.hive.enabled") != null) {
            return metadata.propertyAsBoolean("engine.hive.enabled", false);
        }
        return conf.getBoolean("iceberg.engine.hive.enabled", false);
    }

    private static class WaitingForLockException
    extends RuntimeException {
        WaitingForLockException(String message) {
            super(message);
        }
    }
}

