/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.CharSequenceSet;

class BaseRowDelta
extends MergingSnapshotProducer<RowDelta>
implements RowDelta {
    private Long startingSnapshotId = null;
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private boolean validateDeletes = false;
    private Expression conflictDetectionFilter = null;
    private boolean caseSensitive = true;

    BaseRowDelta(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected BaseRowDelta self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    public RowDelta addRows(DataFile inserts) {
        this.add(inserts);
        return this;
    }

    public RowDelta addDeletes(DeleteFile deletes) {
        this.add(deletes);
        return this;
    }

    public RowDelta validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    public RowDelta caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    public RowDelta validateDeletedFiles() {
        this.validateDeletes = true;
        return this;
    }

    public RowDelta validateDataFilesExist(Iterable<? extends CharSequence> referencedFiles) {
        referencedFiles.forEach(arg_0 -> ((CharSequenceSet)this.referencedDataFiles).add(arg_0));
        return this;
    }

    public RowDelta validateNoConflictingAppends(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument((newConflictDetectionFilter != null ? 1 : 0) != 0, (Object)"Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    @Override
    protected void validate(TableMetadata base) {
        if (base.currentSnapshot() != null) {
            if (!this.referencedDataFiles.isEmpty()) {
                this.validateDataFilesExist(base, this.startingSnapshotId, this.referencedDataFiles, !this.validateDeletes);
            }
            if (this.conflictDetectionFilter != null) {
                this.validateAddedDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, this.caseSensitive);
            }
        }
    }
}

