/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node.cbvlsn;

import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.cbvlsn.GlobalCBVLSN;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class LocalCBVLSNTracker {
    private VLSN lastSyncableVLSN;
    private VLSN currentLocalCBVLSN;
    private long currentFile;
    private boolean allowUpdate = true;
    private final boolean defunct;

    public LocalCBVLSNTracker(RepNode repNode, GlobalCBVLSN globalCBVLSN) {
        this.defunct = globalCBVLSN.isDefunct();
        if (!this.defunct) {
            VLSNIndex vlsnIndex = repNode.getRepImpl().getVLSNIndex();
            this.lastSyncableVLSN = this.currentLocalCBVLSN = vlsnIndex.getRange().getLastSync();
            this.currentFile = DbLsn.getFileNumber(-1L);
        }
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(VLSN newVLSN, long lsn) {
        if (this.defunct || !this.allowUpdate) {
            return;
        }
        LocalCBVLSNTracker localCBVLSNTracker = this;
        synchronized (localCBVLSNTracker) {
            if (newVLSN.compareTo(this.lastSyncableVLSN) > 0) {
                VLSN old = this.lastSyncableVLSN;
                this.lastSyncableVLSN = newVLSN;
                if (DbLsn.getFileNumber(lsn) != this.currentFile) {
                    this.currentFile = DbLsn.getFileNumber(lsn);
                    this.currentLocalCBVLSN = old;
                }
            }
        }
    }

    public void registerMatchpoint(VLSN matchpoint) {
        if (this.defunct) {
            return;
        }
        this.currentLocalCBVLSN = matchpoint;
        this.lastSyncableVLSN = matchpoint;
    }

    public VLSN getBroadcastCBVLSN() {
        return this.defunct ? VLSN.NULL_VLSN : this.currentLocalCBVLSN;
    }

    public VLSN getLastSyncableVLSN() {
        return this.defunct ? VLSN.NULL_VLSN : this.lastSyncableVLSN;
    }
}

