/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.ExpirationTracker;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.ErasedException;
import com.sleepycat.je.log.FSyncManager;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileHandleSource;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileSource;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogBufferPool;
import com.sleepycat.je.log.LogBufferSegment;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogParams;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.util.verify.VerifierUtils;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LSNStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LogManager {
    private final LogBufferPool logBufferPool;
    private final Object logWriteMutex;
    private final boolean doChecksumOnRead;
    private final FileManager fileManager;
    private final FSyncManager grpManager;
    private final EnvironmentImpl envImpl;
    private final boolean readOnly;
    private final int readBufferSize;
    private long lastLsnAtRecovery = -1L;
    private final StatGroup stats;
    private final LongStat nRepeatFaultReads;
    private final LongStat nRepeatIteratorReads;
    private final LongStat nTempBufferWrites;
    private final LSNStat endOfLog;
    private LogBuffer prevLogBuffer = null;
    private TestHook readHook;
    private TestHook<Object> delayVLSNRegisterHook;
    private TestHook<Object> flushHook;
    private final Queue<LazyQueueEntry> lazyLogQueue = new ConcurrentLinkedQueue<LazyQueueEntry>();
    private ExpirationTracker expirationTracker = null;

    public LogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        this.envImpl = envImpl;
        this.fileManager = envImpl.getFileManager();
        this.grpManager = new FSyncManager(this.envImpl);
        DbConfigManager configManager = envImpl.getConfigManager();
        this.readOnly = readOnly;
        this.logBufferPool = new LogBufferPool(this.fileManager, envImpl);
        this.doChecksumOnRead = configManager.getBoolean(EnvironmentParams.LOG_CHECKSUM_READ);
        this.logWriteMutex = new Object();
        this.readBufferSize = configManager.getInt(EnvironmentParams.LOG_FAULT_READ_SIZE);
        this.stats = new StatGroup("I/O", "The file I/O component of the append-only storage system includes data file access, buffering and group commit.");
        this.nRepeatFaultReads = new LongStat(this.stats, LogStatDefinition.LOGMGR_REPEAT_FAULT_READS);
        this.nRepeatIteratorReads = new LongStat(this.stats, LogStatDefinition.LOGMGR_REPEAT_ITERATOR_READS);
        this.nTempBufferWrites = new LongStat(this.stats, LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES);
        this.endOfLog = new LSNStat(this.stats, LogStatDefinition.LOGMGR_END_OF_LOG);
    }

    boolean getChecksumOnRead() {
        return this.doChecksumOnRead;
    }

    public long getLastLsnAtRecovery() {
        return this.lastLsnAtRecovery;
    }

    public void setLastLsnAtRecovery(long lastLsnAtRecovery) {
        this.lastLsnAtRecovery = lastLsnAtRecovery;
    }

    public void initExpirationTracker(ExpirationTracker tracker) {
        this.expirationTracker = tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPool(DbConfigManager configManager) throws DatabaseException {
        Object object = this.logWriteMutex;
        synchronized (object) {
            this.logBufferPool.reset(configManager);
        }
    }

    public long logForceFlush(LogEntry entry, boolean fsyncRequired, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, fsyncRequired, false, repContext);
    }

    public long logForceFlip(LogEntry entry) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, false, true, ReplicationContext.NO_REPLICATE);
    }

    public long log(LogEntry entry, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, false, false, false, repContext);
    }

    void logLazily(LogEntry entry, ReplicationContext repContext) {
        this.lazyLogQueue.add(new LazyQueueEntry(entry, repContext));
    }

    private long log(LogEntry entry, Provisional provisional, boolean flushRequired, boolean fsyncRequired, boolean forceNewLogFile, ReplicationContext repContext) throws DatabaseException {
        LogParams params = new LogParams();
        params.entry = entry;
        params.provisional = provisional;
        params.repContext = repContext;
        params.flushRequired = flushRequired;
        params.fsyncRequired = fsyncRequired;
        params.forceNewLogFile = forceNewLogFile;
        LogItem item = this.log(params);
        return item.lsn;
    }

    public LogItem log(LogParams params) throws DatabaseException {
        LogItem item = new LogItem();
        if (this.readOnly) {
            return item;
        }
        try {
            LazyQueueEntry lqe = this.lazyLogQueue.poll();
            while (lqe != null) {
                LogParams lqeParams = new LogParams();
                lqeParams.entry = lqe.entry;
                lqeParams.provisional = Provisional.NO;
                lqeParams.repContext = lqe.repContext;
                this.logItem(new LogItem(), lqeParams);
                lqe = this.lazyLogQueue.poll();
            }
            LogEntry logEntry = params.entry;
            if (logEntry.getLogType().marshallOutsideLatch()) {
                item.header = new LogEntryHeader(logEntry, params.provisional, params.repContext);
                item.buffer = this.marshallIntoBuffer(item.header, logEntry);
            }
            this.logItem(item, params);
            if (params.fsyncRequired || params.flushRequired) {
                this.grpManager.flushAndSync(params.fsyncRequired);
            } else if (params.switchedLogBuffer) {
                this.logBufferPool.writeDirty(false);
            }
            TestHookExecute.doHookIfSet(this.flushHook);
            if (params.repContext.inReplicationStream()) {
                assert (item.header.getVLSN() != null) : "Unexpected null vlsn: " + item.header + " " + params.repContext;
                TestHookExecute.doHookIfSet(this.delayVLSNRegisterHook);
                this.envImpl.registerVLSN(item);
            }
        }
        catch (EnvironmentFailureException e) {
            if (!this.envImpl.isValid()) {
                throw e;
            }
            throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException(this.envImpl, e);
        }
        catch (Error e) {
            this.envImpl.invalidate(e);
            throw e;
        }
        this.envImpl.getCheckpointer().wakeupAfterWrite();
        this.envImpl.getCleaner().wakeupAfterWrite(item.size);
        if (params.backgroundIO) {
            this.envImpl.updateBackgroundWrites(item.size, this.logBufferPool.getLogBufferSize());
        }
        return item;
    }

    private void logItem(LogItem item, LogParams params) throws IOException, DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        LogWriteInfo lwi = this.serialLog(item, params, tracker);
        if (lwi != null) {
            item.buffer = item.header.addPostMarshallingInfo(item.buffer, lwi.fileOffset, lwi.vlsn);
            lwi.lbs.put(item.buffer);
        }
        this.updateObsolete(params, tracker);
        if (params.expirationTrackerToUse != null) {
            params.expirationTrackerToUse.track(params.entry, item.size);
        }
        if (params.expirationTrackerCompleted != null) {
            this.envImpl.getExpirationProfile().addCompletedTracker(params.expirationTrackerCompleted);
        }
    }

    private LogWriteInfo serialLog(LogItem item, LogParams params, UtilizationTracker tracker) throws IOException {
        Object object = this.logWriteMutex;
        synchronized (object) {
            this.envImpl.checkIfInvalid();
            try {
                return this.serialLogWork(item, params, tracker);
            }
            catch (EnvironmentFailureException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
            }
            catch (Exception e) {
                throw EnvironmentFailureException.unexpectedException(this.envImpl, e);
            }
            catch (Error e) {
                this.envImpl.invalidate(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogWriteInfo serialLogWork(LogItem item, LogParams params, UtilizationTracker tracker) throws IOException {
        LogBufferSegment useBuffer;
        int entrySize;
        boolean marshallOutsideLatch;
        LogEntryType entryType = params.entry.getLogType();
        if (!DbLsn.isTransientOrNull(params.oldLsn)) {
            if (params.obsoleteDupsAllowed) {
                tracker.countObsoleteNodeDupsAllowed(params.oldLsn, entryType, params.oldSize);
            } else {
                tracker.countObsoleteNode(params.oldLsn, entryType, params.oldSize);
            }
        }
        if (!DbLsn.isTransientOrNull(params.auxOldLsn)) {
            if (params.obsoleteDupsAllowed) {
                tracker.countObsoleteNodeDupsAllowed(params.auxOldLsn, entryType, 0);
            } else {
                tracker.countObsoleteNode(params.auxOldLsn, entryType, 0);
            }
        }
        VLSN vlsn = params.repContext.getClientVLSN() != null || params.repContext.mustGenerateVLSN() ? (params.repContext.mustGenerateVLSN() ? this.envImpl.assignVLSNs(params.entry) : params.repContext.getClientVLSN()) : null;
        boolean bl = marshallOutsideLatch = item.buffer != null;
        if (marshallOutsideLatch) {
            entrySize = item.buffer.limit();
            assert (item.header != null);
        } else {
            assert (item.header == null);
            item.header = new LogEntryHeader(params.entry, params.provisional, params.repContext);
            entrySize = item.header.getEntrySize();
        }
        if (params.forceNewLogFile) {
            this.fileManager.forceNewLogFile();
        }
        boolean flippedFile = this.fileManager.shouldFlipFile(entrySize);
        long currentLsn = this.fileManager.calculateNextLsn(flippedFile);
        tracker.countNewLogEntry(currentLsn, entryType, entrySize);
        if (params.entry.isImmediatelyObsolete(params.nodeDb)) {
            tracker.countObsoleteNodeInexact(currentLsn, entryType, entrySize);
        }
        if (!marshallOutsideLatch) {
            assert (item.buffer == null);
            item.buffer = this.marshallIntoBuffer(item.header, params.entry);
        }
        if (entrySize != item.buffer.limit()) {
            throw EnvironmentFailureException.unexpectedState("Logged entry entrySize= " + entrySize + " but marshalledSize=" + item.buffer.limit() + " type=" + entryType + " currentLsn=" + DbLsn.getNoFormatString(currentLsn));
        }
        LogBuffer lastLogBuffer = this.logBufferPool.getWriteBuffer(entrySize, flippedFile);
        long prevOffset = this.fileManager.advanceLsn(currentLsn, entrySize, flippedFile);
        if (lastLogBuffer != this.prevLogBuffer) {
            params.switchedLogBuffer = true;
        }
        this.prevLogBuffer = lastLogBuffer;
        lastLogBuffer.latchForWrite();
        try {
            useBuffer = lastLogBuffer.allocate(entrySize);
            if (useBuffer != null) {
                lastLogBuffer.registerLsn(currentLsn);
            } else {
                item.buffer = item.header.addPostMarshallingInfo(item.buffer, prevOffset, vlsn);
                boolean flushWriteQueue = params.flushRequired && !params.fsyncRequired;
                this.fileManager.writeLogBuffer(new LogBuffer(item.buffer, currentLsn), flushWriteQueue);
                assert (lastLogBuffer.getDataBuffer().position() == 0);
                this.nTempBufferWrites.increment();
            }
        }
        finally {
            lastLogBuffer.release();
        }
        params.entry.postLogWork(item.header, currentLsn, vlsn);
        item.lsn = currentLsn;
        item.size = entrySize;
        if (this.expirationTracker != null) {
            long newFile = DbLsn.getFileNumber(item.lsn);
            if (flippedFile && newFile != this.expirationTracker.getFileNum()) {
                params.expirationTrackerCompleted = this.expirationTracker;
                this.expirationTracker = new ExpirationTracker(newFile);
            }
            this.expirationTracker.incrementPendingTrackCalls();
            params.expirationTrackerToUse = this.expirationTracker;
        }
        return useBuffer == null ? null : new LogWriteInfo(useBuffer, vlsn, prevOffset);
    }

    private ByteBuffer marshallIntoBuffer(LogEntryHeader header, LogEntry entry) {
        int entrySize = header.getSize() + header.getItemSize();
        ByteBuffer destBuffer = ByteBuffer.allocate(entrySize);
        header.writeToLog(destBuffer);
        entry.writeEntry(destBuffer);
        destBuffer.flip();
        return destBuffer;
    }

    ByteBuffer putIntoBuffer(LogEntry entry, long prevLogEntryOffset) {
        LogEntryHeader header = new LogEntryHeader(entry, Provisional.NO, ReplicationContext.NO_REPLICATE);
        assert (!entry.getLogType().isTransactional());
        ByteBuffer destBuffer = this.marshallIntoBuffer(header, entry);
        return header.addPostMarshallingInfo(destBuffer, prevLogEntryOffset, null);
    }

    public LogEntry getLogEntry(long lsn) throws FileNotFoundException, ErasedException {
        return this.getLogEntry(lsn, 0, false).getEntry();
    }

    public WholeEntry getWholeLogEntry(long lsn) throws FileNotFoundException, ErasedException {
        return this.getLogEntry(lsn, 0, false);
    }

    public WholeEntry getLogEntryAllowInvisibleAtRecovery(long lsn, int size) throws FileNotFoundException, ErasedException {
        return this.getLogEntry(lsn, size, this.envImpl.isInInit());
    }

    public WholeEntry getLogEntryAllowInvisible(long lsn) throws FileNotFoundException, ErasedException {
        return this.getLogEntry(lsn, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private WholeEntry getLogEntry(long lsn, int lastLoggedSize, boolean invisibleReadAllowed) throws FileNotFoundException, ErasedException {
        this.envImpl.checkIfInvalid();
        LogSource logSource = null;
        try {
            logSource = this.getLogSource(lsn);
            try {
                WholeEntry wholeEntry = this.getLogEntryFromLogSource(lsn, lastLoggedSize, logSource, invisibleReadAllowed);
                return wholeEntry;
            }
            catch (ChecksumException ce) {
                WholeEntry wholeEntry;
                FileHandleSource fileSource;
                block18: {
                    if (!(logSource instanceof LogBuffer)) {
                        assert (logSource instanceof FileSource);
                        throw ce;
                    }
                    LogBuffer logBuffer = (LogBuffer)logSource;
                    FileHandle fileHandle = null;
                    long fileLength = -1L;
                    try {
                        fileHandle = this.fileManager.getFileHandle(DbLsn.getFileNumber(lsn));
                        fileLength = fileHandle.getFile().length();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (fileHandle == null || fileLength <= DbLsn.getFileOffset(logBuffer.getFirstLsn())) {
                        throw EnvironmentFailureException.unexpectedException(this.envImpl, "Corruption detected in log buffer, but was not written to disk.", ce);
                    }
                    fileSource = new FileHandleSource(fileHandle, this.readBufferSize, this.fileManager);
                    wholeEntry = this.getLogEntryFromLogSource(lsn, lastLoggedSize, fileSource, invisibleReadAllowed);
                    ((FileSource)fileSource).release();
                    if (logSource == null) break block18;
                    logSource.release();
                }
                return wholeEntry;
                {
                    catch (Throwable throwable) {
                        try {
                            ((FileSource)fileSource).release();
                            throw throwable;
                        }
                        catch (ChecksumException e) {
                            throw VerifierUtils.createMarkerFileFromException(RestoreRequired.FailureType.LOG_CHECKSUM, e, this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM);
                        }
                        catch (Error e) {
                            this.envImpl.invalidate(e);
                            throw e;
                        }
                    }
                }
            }
        }
        finally {
            if (logSource != null) {
                logSource.release();
            }
        }
    }

    public LogEntry getLogEntryHandleNotFound(long lsn) throws DatabaseException {
        try {
            return this.getLogEntry(lsn);
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ErasedException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Entry is erased unexpectedly, implied corruption", e);
        }
    }

    public WholeEntry getWholeLogEntryHandleNotFound(long lsn) throws DatabaseException {
        try {
            return this.getWholeLogEntry(lsn);
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ErasedException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Entry is erased unexpectedly, implied corruption", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogEntry getLogEntryAllowChecksumException(long lsn) throws ChecksumException, FileNotFoundException, ErasedException, DatabaseException {
        LogSource logSource = this.getLogSource(lsn);
        try {
            LogEntry logEntry = this.getLogEntryFromLogSource(lsn, 0, logSource, false).getEntry();
            return logEntry;
        }
        finally {
            logSource.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogEntry getLogEntryAllowChecksumException(long lsn, RandomAccessFile file, int logVersion) throws ChecksumException, ErasedException, DatabaseException {
        FileSource logSource = new FileSource(file, this.readBufferSize, this.fileManager, DbLsn.getFileNumber(lsn), logVersion);
        try {
            LogEntry logEntry = this.getLogEntryFromLogSource(lsn, 0, logSource, false).getEntry();
            return logEntry;
        }
        finally {
            logSource.release();
        }
    }

    WholeEntry getLogEntryFromLogSource(long lsn, int lastLoggedSize, LogSource logSource, boolean invisibleReadAllowed) throws ChecksumException, ErasedException, DatabaseException {
        ByteBuffer entryBuffer;
        long fileOffset = DbLsn.getFileOffset(lsn);
        ByteBuffer byteBuffer = entryBuffer = lastLoggedSize > 0 ? logSource.getBytes(fileOffset, lastLoggedSize) : logSource.getBytes(fileOffset);
        if (entryBuffer.remaining() < 14) {
            throw new ChecksumException("Incomplete log entry header in " + logSource + " needed=" + 14 + " remaining=" + entryBuffer.remaining() + " lsn=" + DbLsn.getNoFormatString(lsn));
        }
        LogEntryHeader header = new LogEntryHeader(entryBuffer, logSource.getLogVersion(), lsn);
        if (header.isVariableLength()) {
            if (entryBuffer.remaining() < header.getVariablePortionSize()) {
                throw new ChecksumException("Incomplete log entry header in " + logSource + " needed=" + header.getVariablePortionSize() + " remaining=" + entryBuffer.remaining() + " lsn=" + DbLsn.getNoFormatString(lsn));
            }
            header.readVariablePortion(entryBuffer);
        }
        ChecksumValidator validator = null;
        if (header.hasChecksum() && this.doChecksumOnRead) {
            int itemStart = entryBuffer.position();
            if (header.isInvisible()) {
                LogEntryHeader.turnOffInvisible(entryBuffer, itemStart - header.getSize());
            }
            validator = new ChecksumValidator(this.envImpl);
            int headerSizeMinusChecksum = header.getSizeMinusChecksum();
            entryBuffer.position(itemStart - headerSizeMinusChecksum);
            validator.update(entryBuffer, headerSizeMinusChecksum);
            entryBuffer.position(itemStart);
        }
        int itemSize = header.getItemSize();
        if (entryBuffer.remaining() < itemSize) {
            entryBuffer = logSource.getBytes(fileOffset + (long)header.getSize(), itemSize);
            if (entryBuffer.remaining() < itemSize) {
                throw new ChecksumException("Incomplete log entry item in " + logSource + " needed=" + itemSize + " remaining=" + entryBuffer.remaining() + " lsn=" + DbLsn.getNoFormatString(lsn));
            }
            this.nRepeatFaultReads.increment();
        }
        if (validator != null) {
            validator.update(entryBuffer, itemSize);
            validator.validate(header.getChecksum(), lsn);
        }
        if (header.isInvisible() && !invisibleReadAllowed) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Read invisible log entry at " + DbLsn.getNoFormatString(lsn) + " " + header);
        }
        assert (LogEntryType.isValidType(header.getType())) : "Read non-valid log entry type: " + header.getType();
        LogEntry logEntry = LogEntryType.findType(header.getType()).getNewLogEntry();
        logEntry.readEntry(this.envImpl, header, entryBuffer);
        if (this.readHook != null) {
            try {
                this.readHook.doIOHook();
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
            }
        }
        if (header.isErased()) {
            throw new ErasedException(lsn, header);
        }
        return new WholeEntry(header, logEntry);
    }

    public Object getEntry(long lsn) throws FileNotFoundException, ErasedException, DatabaseException {
        LogEntry entry = this.getLogEntry(lsn);
        return entry.getMainItem();
    }

    public Object getEntryHandleNotFound(long lsn) {
        LogEntry entry = this.getLogEntryHandleNotFound(lsn);
        return entry.getMainItem();
    }

    public LogSource getLogSource(long lsn) throws FileNotFoundException, ChecksumException, DatabaseException {
        LogBuffer logBuffer = this.logBufferPool.getReadBufferByLsn(lsn);
        if (logBuffer == null) {
            try {
                long fileNum = DbLsn.getFileNumber(lsn);
                return new FileHandleSource(this.fileManager.getFileHandle(fileNum), this.readBufferSize, this.fileManager);
            }
            catch (DatabaseException e) {
                e.addErrorMessage("lsn= " + DbLsn.getNoFormatString(lsn));
                throw e;
            }
        }
        return logBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WholeEntry getLogEntryDirectFromFile(long lsn) throws ChecksumException {
        FileSource fileSource;
        Object fileHandle;
        LogSource logSource;
        try {
            logSource = this.getLogSource(lsn);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        if (logSource instanceof LogBuffer) {
            try {
                long fileLength;
                LogBuffer logBuffer = (LogBuffer)logSource;
                try {
                    fileHandle = this.fileManager.getFileHandle(DbLsn.getFileNumber(lsn));
                    fileLength = ((FileHandle)fileHandle).getFile().length();
                }
                catch (IOException ioe) {
                    WholeEntry wholeEntry = null;
                    logSource.release();
                    return wholeEntry;
                }
                if (fileLength <= DbLsn.getFileOffset(logBuffer.getFirstLsn())) {
                    WholeEntry wholeEntry = null;
                    return wholeEntry;
                }
            }
            finally {
                logSource.release();
            }
            fileSource = new FileHandleSource((FileHandle)fileHandle, this.readBufferSize, this.fileManager);
        } else {
            fileSource = (FileSource)logSource;
        }
        try {
            fileHandle = this.getLogEntryFromLogSource(lsn, 0, fileSource, false);
            return fileHandle;
        }
        catch (ErasedException e) {
            WholeEntry wholeEntry = null;
            return wholeEntry;
        }
        finally {
            fileSource.release();
        }
    }

    public LogBuffer getReadBufferByLsn(long lsn) {
        assert (DbLsn.getFileOffset(lsn) != 0L) : "Read of lsn " + DbLsn.getNoFormatString(lsn) + " is illegal because file header entry is not in the log buffer";
        return this.logBufferPool.getReadBufferByLsn(lsn);
    }

    public void flushSync() throws DatabaseException {
        if (this.readOnly) {
            return;
        }
        this.flushInternal(false);
        this.fileManager.syncLogEnd();
    }

    public void flushNoSync() throws DatabaseException {
        if (this.readOnly) {
            return;
        }
        this.flushInternal(true);
    }

    void flushBeforeSync() throws DatabaseException {
        if (this.readOnly) {
            return;
        }
        this.flushInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(boolean flushWriteQueue) throws DatabaseException {
        assert (!this.readOnly);
        Object object = this.logWriteMutex;
        synchronized (object) {
            if (!this.logBufferPool.bumpCurrent(0)) {
                this.logBufferPool.bumpAndWriteDirty(0, flushWriteQueue);
                return;
            }
        }
        this.logBufferPool.writeDirty(flushWriteQueue);
    }

    public StatGroup loadStats(StatsConfig config) throws DatabaseException {
        this.endOfLog.set(this.fileManager.getLastUsedLsn());
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.logBufferPool.loadStats(config));
        copyStats.addAll(this.fileManager.loadStats(config));
        copyStats.addAll(this.grpManager.loadStats(config));
        return copyStats;
    }

    public long getNCacheMiss() {
        return this.logBufferPool.getNCacheMiss();
    }

    StatGroup getBufferPoolLatchStats() {
        return this.logBufferPool.getBufferPoolLatchStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedFileSummary getUnflushableTrackedSummary(long file) {
        Object object = this.logWriteMutex;
        synchronized (object) {
            return this.envImpl.getUtilizationTracker().getUnflushableTrackedSummary(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackedFile(TrackedFileSummary tfs) {
        Object object = this.logWriteMutex;
        synchronized (object) {
            tfs.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObsolete(LogParams params, UtilizationTracker tracker) {
        if (params.packedObsoleteInfo == null && params.obsoleteWriteLockInfo == null) {
            return;
        }
        Object object = this.logWriteMutex;
        synchronized (object) {
            if (params.packedObsoleteInfo != null) {
                params.packedObsoleteInfo.countObsoleteInfo(tracker);
            }
            if (params.obsoleteWriteLockInfo != null) {
                for (WriteLockInfo info : params.obsoleteWriteLockInfo) {
                    tracker.countObsoleteNode(info.getAbortLsn(), null, info.getAbortLogSize());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNode(long lsn, LogEntryType type, int size, boolean countExact) {
        Object object = this.logWriteMutex;
        synchronized (object) {
            UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
            if (countExact) {
                tracker.countObsoleteNode(lsn, type, size);
            } else {
                tracker.countObsoleteNodeInexact(lsn, type, size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNodeDupsAllowed(long lsn, LogEntryType type, int size) {
        Object object = this.logWriteMutex;
        synchronized (object) {
            UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
            tracker.countObsoleteNodeDupsAllowed(lsn, type, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        Object object = this.logWriteMutex;
        synchronized (object) {
            UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
            localTracker.transferToUtilizationTracker(tracker);
        }
    }

    public void incRepeatIteratorReads() {
        this.nRepeatIteratorReads.increment();
    }

    public void setReadHook(TestHook hook) {
        this.readHook = hook;
    }

    public void setDelayVLSNRegisterHook(TestHook<Object> hook) {
        this.delayVLSNRegisterHook = hook;
    }

    public void setFlushLogHook(TestHook<Object> hook) {
        this.flushHook = hook;
        this.grpManager.setFlushLogHook(hook);
    }

    private class LogWriteInfo {
        final LogBufferSegment lbs;
        final VLSN vlsn;
        final long fileOffset;

        LogWriteInfo(LogBufferSegment bs, VLSN vlsn, long fileOffset) {
            this.lbs = bs;
            this.vlsn = vlsn;
            this.fileOffset = fileOffset;
        }
    }

    private static class LazyQueueEntry {
        private final LogEntry entry;
        private final ReplicationContext repContext;

        private LazyQueueEntry(LogEntry entry, ReplicationContext repContext) {
            this.entry = entry;
            this.repContext = repContext;
        }
    }
}

