/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.TTL;
import java.util.concurrent.TimeUnit;

public class WriteOptions
implements Cloneable {
    public static final int TTL_MAX_HOURS = 0x3FFFFFFF;
    public static final int TTL_MAX_DAYS = 0x2AAAAAA;
    private CacheMode cacheMode = null;
    private int ttl = 0;
    private TimeUnit ttlUnit = TimeUnit.DAYS;
    private boolean updateTtl = false;

    public WriteOptions clone() {
        try {
            return (WriteOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public WriteOptions setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public WriteOptions setTTL(int ttl) {
        this.ttl = ttl;
        this.ttlUnit = TimeUnit.DAYS;
        return this;
    }

    public WriteOptions setTTL(int ttl, TimeUnit timeUnit) {
        this.ttl = ttl;
        this.ttlUnit = timeUnit;
        return this;
    }

    public int getTTL() {
        return this.ttl;
    }

    public TimeUnit getTTLUnit() {
        return this.ttlUnit;
    }

    public WriteOptions setUpdateTTL(boolean updateTtl) {
        this.updateTtl = updateTtl;
        return this;
    }

    public boolean getUpdateTTL() {
        return this.updateTtl;
    }

    public WriteOptions setExpirationTime(long expirationTime, TimeUnit timeUnit) {
        boolean hours;
        if (expirationTime == 0L) {
            return this.setTTL(0, timeUnit);
        }
        if (timeUnit == TimeUnit.DAYS) {
            hours = false;
        } else if (timeUnit == TimeUnit.HOURS) {
            hours = true;
        } else if (timeUnit == null) {
            hours = TTL.isSystemTimeInHours(expirationTime);
            timeUnit = hours ? TimeUnit.HOURS : TimeUnit.DAYS;
        } else {
            throw new IllegalArgumentException("ttlUnits not allowed: " + (Object)((Object)timeUnit));
        }
        this.setTTL(TTL.systemTimeToExpiration(expirationTime - TTL.currentSystemTime(), hours), timeUnit);
        return this;
    }
}

