/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.PhasedExecutionState;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.CaptureMatcher;
import mockit.internal.expectations.argumentMatching.ClassMatcher;

public abstract class TestOnlyPhase
extends Phase {
    boolean matchInstance;
    @Nullable
    List<ArgumentMatcher<?>> argMatchers;
    @Nullable
    Expectation currentExpectation;

    TestOnlyPhase(@Nonnull PhasedExecutionState executionState) {
        super(executionState);
    }

    public final void addArgMatcher(@Nonnull ArgumentMatcher<?> matcher) {
        this.getArgumentMatchers().add(matcher);
    }

    @Nonnull
    private List<ArgumentMatcher<?>> getArgumentMatchers() {
        if (this.argMatchers == null) {
            this.argMatchers = new ArrayList();
        }
        return this.argMatchers;
    }

    final void moveArgMatcher(@Nonnegative int originalMatcherIndex, @Nonnegative int toIndex) {
        List<ArgumentMatcher<?>> matchers = this.getArgumentMatchers();
        int i = TestOnlyPhase.getMatcherPositionIgnoringNulls(originalMatcherIndex, matchers);
        --i;
        while (i < toIndex) {
            matchers.add(i, null);
            ++i;
        }
    }

    @Nonnegative
    private static int getMatcherPositionIgnoringNulls(@Nonnegative int originalMatcherIndex, @Nonnull List<ArgumentMatcher<?>> matchers) {
        int i = 0;
        int matchersFound = 0;
        while (matchersFound <= originalMatcherIndex) {
            if (matchers.get(i) != null) {
                ++matchersFound;
            }
            ++i;
        }
        return i;
    }

    final void setExpectedSingleArgumentType(@Nonnegative int parameterIndex, @Nonnull Class<?> argumentType) {
        ClassMatcher newMatcher = ClassMatcher.create(argumentType);
        this.getArgumentMatchers().set(parameterIndex, newMatcher);
    }

    final void setExpectedMultiArgumentType(@Nonnegative int parameterIndex, @Nonnull Class<?> argumentType) {
        CaptureMatcher matcher = (CaptureMatcher)this.getArgumentMatchers().get(parameterIndex);
        matcher.setExpectedType(argumentType);
    }

    void setMaxInvocationCount(int maxInvocations) {
        if (this.currentExpectation != null) {
            int currentMinimum = this.currentExpectation.constraints.minInvocations;
            int minInvocations = maxInvocations < 0 ? currentMinimum : Math.min(currentMinimum, maxInvocations);
            this.handleInvocationCountConstraint(minInvocations, maxInvocations);
        }
    }

    abstract void handleInvocationCountConstraint(int var1, int var2);

    static boolean isEnumElement(@Nonnull Object mock) {
        ?[] enumElements = mock.getClass().getEnumConstants();
        if (enumElements != null) {
            for (Object enumElement : enumElements) {
                if (enumElement != mock) continue;
                return true;
            }
        }
        return false;
    }
}

