/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchInputPartition;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\u0011\"\u0001AB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")A\f\u0001C\u0001;\"A!\r\u0001b\u0001\n\u0003\t3\r\u0003\u0004k\u0001\u0001\u0006I\u0001\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\t\b\u0001)A\u0005[\"9!\u000f\u0001b\u0001\n\u0013a\u0007BB:\u0001A\u0003%Q\u000eC\u0004u\u0001\t\u0007I\u0011\u00027\t\rU\u0004\u0001\u0015!\u0003n\u0011!1\bA1A\u0005\u0002\u0005b\u0007BB<\u0001A\u0003%Q\u000eC\u0004y\u0001\u0001\u0007I\u0011\u00027\t\u000fe\u0004\u0001\u0019!C\u0005u\"9\u0011\u0011\u0001\u0001!B\u0013i\u0007bCA\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bA1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a!Y\u0011Q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\b\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\u0004\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111\u0005\u0005\f\u0003O\u0001\u0001\u0019!A!B\u0013\ty\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA+\u0001\u0011\u0005\u00131\u000b\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\ty\u0006\u0001C!\u0003CBq!! \u0001\t\u0003\ny\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\nQ\"+\u0019;f'R\u0014X-Y7NS\u000e\u0014xNQ1uG\"\u0014V-\u00193fe*\u0011!eI\u0001\bg>,(oY3t\u0015\t!S%A\u0005tiJ,\u0017-\\5oO*\u0011aeJ\u0001\nKb,7-\u001e;j_:T!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0019:\u0007B\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0005Y\u0006twMC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u001a$AB(cU\u0016\u001cG\u000f\u0005\u0002;\u00036\t1H\u0003\u0002%y)\u0011QHP\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005}\u0002\u0015A\u0001<3\u0015\t\u0011s%\u0003\u0002Cw\t\u0001R*[2s_\n\u000bGo\u00195SK\u0006$WM\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r&\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw-A\u0004paRLwN\\:\u0011\u0005-cU\"\u0001 \n\u00055s$!\u0005#bi\u0006\u001cv.\u001e:dK>\u0003H/[8og\u0006\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o!\t\u0001\u0016L\u0004\u0002R/B\u0011!+V\u0007\u0002'*\u0011AkL\u0001\u0007yI|w\u000e\u001e \u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031V\u000ba\u0001P5oSRtDc\u00010aCB\u0011q\fA\u0007\u0002C!)\u0011j\u0001a\u0001\u0015\")aj\u0001a\u0001\u001f\u0006)1\r\\8dWV\tA\r\u0005\u0002fQ6\taM\u0003\u0002hS\u0005!Q\u000f^5m\u0013\tIgMA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u000ee><8\u000fU3s'\u0016\u001cwN\u001c3\u0016\u00035\u0004\"A\\8\u000e\u0003UK!\u0001]+\u0003\t1{gnZ\u0001\u000fe><8\u000fU3s'\u0016\u001cwN\u001c3!\u0003E\u0011\u0018-\u001c9VaRKW.Z*fG>tGm]\u0001\u0013e\u0006l\u0007/\u00169US6,7+Z2p]\u0012\u001c\b%\u0001\u0006nCb\u001cVmY8oIN\f1\"\\1y'\u0016\u001cwN\u001c3tA\u0005q1M]3bi&|g\u000eV5nK6\u001b\u0018aD2sK\u0006$\u0018n\u001c8US6,Wj\u001d\u0011\u0002\u00151\f7\u000f\u001e+j[\u0016l5/\u0001\bmCN$H+[7f\u001bN|F%Z9\u0015\u0005mt\bC\u00018}\u0013\tiXK\u0001\u0003V]&$\bbB@\u0010\u0003\u0003\u0005\r!\\\u0001\u0004q\u0012\n\u0014a\u00037bgR$\u0016.\\3Ng\u0002B3\u0001EA\u0003!\rq\u0017qA\u0005\u0004\u0003\u0013)&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000bM$\u0018M\u001d;\u0016\u0005\u0005=\u0001\u0003BA\t\u0003'i\u0011aI\u0005\u0004\u0003+\u0019#A\u0003'p]\u001e|eMZ:fi\u0006I1\u000f^1si~#S-\u001d\u000b\u0004w\u0006m\u0001\u0002C@\u0013\u0003\u0003\u0005\r!a\u0004\u0002\rM$\u0018M\u001d;!\u0003\r)g\u000eZ\u0001\bK:$w\fJ3r)\rY\u0018Q\u0005\u0005\t\u007fV\t\t\u00111\u0001\u0002\u0010\u0005!QM\u001c3!\u0003)\u0011X-\u00193TG\",W.\u0019\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u001c\u0003c\u0011!b\u0015;sk\u000e$H+\u001f9f\u00039\u0019X\r^(gMN,GOU1oO\u0016$Ra_A\u001f\u0003\u001fBq!a\u0003\u0019\u0001\u0004\ty\u0004\u0005\u0004\u0002B\u0005\u0015\u0013\u0011J\u0007\u0003\u0003\u0007R!aZ\u001b\n\t\u0005\u001d\u00131\t\u0002\t\u001fB$\u0018n\u001c8bYB\u0019!(a\u0013\n\u0007\u000553H\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\b\u0003?A\u0002\u0019AA \u000399W\r^*uCJ$xJ\u001a4tKR$\"!!\u0013\u0002\u0019\u001d,G/\u00128e\u001f\u001a47/\u001a;\u0002#\u0011,7/\u001a:jC2L'0Z(gMN,G\u000f\u0006\u0003\u0002J\u0005m\u0003BBA/7\u0001\u0007q*\u0001\u0003kg>t\u0017a\u00059mC:Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cHCAA2!\u0019\t\t%!\u001a\u0002j%!\u0011qMA\"\u0005\u0011a\u0015n\u001d;\u0011\r\u0005-\u0014QNA9\u001b\u0005a\u0014bAA8y\tq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0007\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]t%\u0001\u0005dCR\fG._:u\u0013\u0011\tY(!\u001e\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0007G>lW.\u001b;\u0015\u0007m\f\t\tC\u0004\u0002 u\u0001\r!!\u0013\u0002\tM$x\u000e\u001d\u000b\u0002w\u0006AAo\\*ue&tw\rF\u0001P\u0001")
public class RateStreamMicroBatchReader
implements MicroBatchReader,
Logging {
    private final DataSourceOptions options;
    public final String org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation;
    private final Clock clock;
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final long maxSeconds;
    private final long creationTimeMs;
    private volatile long lastTimeMs;
    private LongOffset start;
    private LongOffset end;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock clock() {
        return this.clock;
    }

    private long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    private long rampUpTimeSeconds() {
        return this.rampUpTimeSeconds;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    private LongOffset start() {
        return this.start;
    }

    private void start_$eq(LongOffset x$1) {
        this.start = x$1;
    }

    private LongOffset end() {
        return this.end;
    }

    private void end_$eq(LongOffset x$1) {
        this.end = x$1;
    }

    @Override
    public StructType readSchema() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public void setOffsetRange(Optional<Offset> start, Optional<Offset> end) {
        this.start_$eq((LongOffset)start.orElse(new LongOffset(0L)));
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        this.end_$eq((LongOffset)end.orElse(new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.creationTimeMs()))));
    }

    @Override
    public Offset getStartOffset() {
        if (this.start() == null) {
            throw new IllegalStateException("start offset not set");
        }
        return this.start();
    }

    @Override
    public Offset getEndOffset() {
        if (this.end() == null) {
            throw new IllegalStateException("end offset not set");
        }
        return this.end();
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public List<InputPartition<InternalRow>> planInputPartitions() {
        long endSeconds;
        long startSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.start()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.end()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("startSeconds(").append(startSeconds).append(") > endSeconds(").append(endSeconds).append(")").toString());
        if (endSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder(68).append("Integer overflow. Max offset with ").append(this.rowsPerSecond()).append(" rowsPerSecond is ").append(this.maxSeconds()).append(", but it's ").append(endSeconds).append(" now.").toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs());
        }
        long rangeStart = RateStreamProvider$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        long rangeEnd = RateStreamProvider$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("startSeconds: ").append(startSeconds).append(", endSeconds: ").append(endSeconds).append(", ").append("rangeStart: ").append(rangeStart).append(", rangeEnd: ").append(rangeEnd).toString());
        if (rangeStart == rangeEnd) {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        }
        long localStartTimeMs = this.creationTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        Option<SparkSession> activeSession = SparkSession$.MODULE$.getActiveSession();
        Predef$.MODULE$.require(activeSession.isDefined());
        int numPartitions = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse(null)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)RateStreamMicroBatchReader.$anonfun$planInputPartitions$7(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((SparkSession)activeSession.get()).sparkContext().defaultParallelism()));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)p -> RateStreamMicroBatchReader.$anonfun$planInputPartitions$9(numPartitions, rangeStart, rangeEnd, localStartTimeMs, relativeMsPerValue, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return new StringBuilder(63).append("RateStreamV2[rowsPerSecond=").append(this.rowsPerSecond()).append(", ").append("rampUpTimeSeconds=").append(this.rampUpTimeSeconds()).append(", ").append("numPartitions=").append((Object)this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse("default")).toString();
    }

    public static final /* synthetic */ long $anonfun$rampUpTimeSeconds$1(String x$1) {
        return JavaUtils.timeStringAsSec((String)x$1);
    }

    public static final /* synthetic */ int $anonfun$planInputPartitions$7(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ InputPartition $anonfun$planInputPartitions$9(int numPartitions$1, long rangeStart$1, long rangeEnd$1, long localStartTimeMs$1, double relativeMsPerValue$1, int p) {
        return new RateStreamMicroBatchInputPartition(p, numPartitions$1, rangeStart$1, rangeEnd$1, localStartTimeMs$1, relativeMsPerValue$1);
    }

    public RateStreamMicroBatchReader(DataSourceOptions options, String checkpointLocation) {
        this.options = options;
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation = checkpointLocation;
        Logging.$init$((Logging)this);
        this.clock = options.getBoolean("useManualClock", false) ? new ManualClock() : new SystemClock();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).orElse("1"))).toLong();
        this.rampUpTimeSeconds = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).orElse(null)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)RateStreamMicroBatchReader.$anonfun$rampUpTimeSeconds$1(x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.maxSeconds = Long.MAX_VALUE / this.rowsPerSecond();
        if (this.rampUpTimeSeconds() > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder(82).append("Integer overflow. Max offset with ").append(this.rowsPerSecond()).append(" rowsPerSecond").append(" is ").append(this.maxSeconds()).append(", but 'rampUpTimeSeconds' is ").append(this.rampUpTimeSeconds()).append(".").toString());
        }
        Option session = SparkSession$.MODULE$.getActiveSession().orElse((Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.getDefaultSession());
        Predef$.MODULE$.require(session.isDefined());
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this, session){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder(2).append("v").append(RateStreamProvider$.MODULE$.VERSION()).append("\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                int indexOfNewLine;
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine <= 0) {
                        throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                    }
                } else {
                    throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                }
                this.parseVersion(content.substring(0, indexOfNewLine), RateStreamProvider$.MODULE$.VERSION());
                return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            }
        };
        this.creationTimeMs = ((LongOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            LongOffset offset = new LongOffset(this.clock().getTimeMillis());
            metadataLog.add(0L, offset);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Start time: ").append(offset).toString());
            return var2_2;
        })).offset();
        this.lastTimeMs = this.creationTimeMs();
    }
}

