/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.transaction.TxnStateChangeCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TxnStateCallbackFactory {
    private static final Logger LOG = LogManager.getLogger(TxnStateCallbackFactory.class);
    private Map<Long, TxnStateChangeCallback> callbacks = Maps.newHashMap();

    public synchronized boolean addCallback(TxnStateChangeCallback callback) {
        if (this.callbacks.containsKey(callback.getId())) {
            return false;
        }
        this.callbacks.put(callback.getId(), callback);
        LOG.info("add callback of txn state : {}. current callback size: {}", (Object)callback.getId(), (Object)this.callbacks.size());
        return true;
    }

    public synchronized void removeCallback(long id) {
        if (this.callbacks.remove(id) != null) {
            LOG.info("remove callback of txn state : {}. current callback size: {}", (Object)id, (Object)this.callbacks.size());
        }
    }

    public synchronized TxnStateChangeCallback getCallback(long id) {
        return this.callbacks.get(id);
    }
}

