/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.MiniLoadTxnCommitAttachment;
import org.apache.doris.load.routineload.RLTaskTxnCommitAttachment;
import org.apache.doris.thrift.TTxnCommitAttachment;
import org.apache.doris.transaction.TransactionState;

public abstract class TxnCommitAttachment
implements Writable {
    protected TransactionState.LoadJobSourceType sourceType;
    protected boolean isTypeRead = false;

    public TxnCommitAttachment(TransactionState.LoadJobSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public static TxnCommitAttachment fromThrift(TTxnCommitAttachment txnCommitAttachment) {
        if (txnCommitAttachment != null) {
            switch (txnCommitAttachment.getLoadType()) {
                case ROUTINE_LOAD: {
                    return new RLTaskTxnCommitAttachment(txnCommitAttachment.getRlTaskTxnCommitAttachment());
                }
                case MINI_LOAD: {
                    return new MiniLoadTxnCommitAttachment(txnCommitAttachment.getMlTxnCommitAttachment());
                }
            }
            return null;
        }
        return null;
    }

    public static TxnCommitAttachment read(DataInput in) throws IOException {
        TxnCommitAttachment attachment = null;
        TransactionState.LoadJobSourceType type = TransactionState.LoadJobSourceType.valueOf(Text.readString((DataInput)in));
        if (type == TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK) {
            attachment = new RLTaskTxnCommitAttachment();
        } else if (type == TransactionState.LoadJobSourceType.BATCH_LOAD_JOB) {
            attachment = new LoadJobFinalOperation();
        } else if (type == TransactionState.LoadJobSourceType.BACKEND_STREAMING) {
            attachment = new MiniLoadTxnCommitAttachment();
        } else if (type == TransactionState.LoadJobSourceType.FRONTEND) {
            attachment = new LoadJobFinalOperation();
        } else {
            throw new IOException("Unknown load job source type: " + type.name());
        }
        attachment.setTypeRead(true);
        ((TxnCommitAttachment)attachment).readFields(in);
        return attachment;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.sourceType.name());
    }

    public void readFields(DataInput in) throws IOException {
        if (!this.isTypeRead) {
            this.sourceType = TransactionState.LoadJobSourceType.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
    }
}

