/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

public enum TransactionStatus {
    UNKNOWN(0),
    PREPARE(1),
    COMMITTED(2),
    VISIBLE(3),
    ABORTED(4),
    PRECOMMITTED(5);

    private final int flag;

    private TransactionStatus(int flag) {
        this.flag = flag;
    }

    public int value() {
        return this.flag;
    }

    public static TransactionStatus valueOf(int flag) {
        switch (flag) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return PREPARE;
            }
            case 2: {
                return COMMITTED;
            }
            case 3: {
                return VISIBLE;
            }
            case 4: {
                return ABORTED;
            }
            case 5: {
                return PRECOMMITTED;
            }
        }
        return null;
    }

    public boolean isFinalStatus() {
        return this == VISIBLE || this == ABORTED;
    }

    public String toString() {
        switch (this) {
            case UNKNOWN: {
                return "UNKNOWN";
            }
            case PREPARE: {
                return "PREPARE";
            }
            case COMMITTED: {
                return "COMMITTED";
            }
            case VISIBLE: {
                return "VISIBLE";
            }
            case ABORTED: {
                return "ABORTED";
            }
            case PRECOMMITTED: {
                return "PRECOMMITTED";
            }
        }
        return "UNKNOWN";
    }
}

