/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.task.PublishVersionTask;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.TableCommitInfo;
import org.apache.doris.transaction.TransactionException;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.doris.transaction.TxnCommitAttachment;
import org.apache.doris.transaction.TxnStateChangeCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionState
implements Writable {
    private static final Logger LOG = LogManager.getLogger(TransactionState.class);
    public static final TxnStateComparator TXN_ID_COMPARATOR = new TxnStateComparator();
    private long dbId;
    private List<Long> tableIdList;
    private long transactionId;
    private String label;
    private TUniqueId requestId;
    private Map<Long, TableCommitInfo> idToTableCommitInfos;
    private TxnCoordinator txnCoordinator;
    private TransactionStatus transactionStatus;
    private LoadJobSourceType sourceType;
    private long prepareTime;
    private long preCommitTime;
    private long commitTime;
    private long finishTime;
    private String reason = "";
    private Set<Long> errorReplicas;
    private CountDownLatch latch;
    private Map<Long, PublishVersionTask> publishVersionTasks;
    private boolean hasSendTask;
    private long publishVersionTime = -1L;
    private TransactionStatus preStatus = null;
    private long callbackId = -1L;
    private TxnStateChangeCallback callback = null;
    private long timeoutMs = Config.stream_load_default_timeout_second;
    private long preCommittedTimeoutMs = Config.stream_load_default_precommit_timeout_second * 1000;
    private String authCode = "";
    private boolean prolongPublishTimeout = false;
    private TxnCommitAttachment txnCommitAttachment;
    private Map<Long, Set<Long>> loadedTblIndexes = Maps.newHashMap();
    private String errorLogUrl = null;
    private String errMsg = "";

    public TransactionState() {
        this.dbId = -1L;
        this.tableIdList = Lists.newArrayList();
        this.transactionId = -1L;
        this.label = "";
        this.idToTableCommitInfos = Maps.newHashMap();
        this.txnCoordinator = new TxnCoordinator(TxnSourceType.FE, "127.0.0.1");
        this.transactionStatus = TransactionStatus.PREPARE;
        this.sourceType = LoadJobSourceType.FRONTEND;
        this.prepareTime = -1L;
        this.preCommitTime = -1L;
        this.commitTime = -1L;
        this.finishTime = -1L;
        this.reason = "";
        this.errorReplicas = Sets.newHashSet();
        this.publishVersionTasks = Maps.newHashMap();
        this.hasSendTask = false;
        this.latch = new CountDownLatch(1);
        this.authCode = UUID.randomUUID().toString();
    }

    public TransactionState(long dbId, List<Long> tableIdList, long transactionId, String label, TUniqueId requestId, LoadJobSourceType sourceType, TxnCoordinator txnCoordinator, long callbackId, long timeoutMs) {
        this.dbId = dbId;
        this.tableIdList = tableIdList == null ? Lists.newArrayList() : tableIdList;
        this.transactionId = transactionId;
        this.label = label;
        this.requestId = requestId;
        this.idToTableCommitInfos = Maps.newHashMap();
        this.txnCoordinator = txnCoordinator;
        this.transactionStatus = TransactionStatus.PREPARE;
        this.sourceType = sourceType;
        this.prepareTime = -1L;
        this.preCommitTime = -1L;
        this.commitTime = -1L;
        this.finishTime = -1L;
        this.reason = "";
        this.errorReplicas = Sets.newHashSet();
        this.publishVersionTasks = Maps.newHashMap();
        this.hasSendTask = false;
        this.latch = new CountDownLatch(1);
        this.callbackId = callbackId;
        this.timeoutMs = timeoutMs;
        this.authCode = UUID.randomUUID().toString();
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setErrorReplicas(Set<Long> newErrorReplicas) {
        this.errorReplicas = newErrorReplicas;
    }

    public boolean isRunning() {
        return this.transactionStatus == TransactionStatus.PREPARE || this.transactionStatus == TransactionStatus.COMMITTED;
    }

    public void addPublishVersionTask(Long backendId, PublishVersionTask task) {
        this.publishVersionTasks.put(backendId, task);
    }

    public void setHasSendTask(boolean hasSendTask) {
        this.hasSendTask = hasSendTask;
        this.publishVersionTime = System.currentTimeMillis();
    }

    public void updateSendTaskTime() {
        this.publishVersionTime = System.currentTimeMillis();
    }

    public long getPublishVersionTime() {
        return this.publishVersionTime;
    }

    public boolean hasSendTask() {
        return this.hasSendTask;
    }

    public TUniqueId getRequestId() {
        return this.requestId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public String getLabel() {
        return this.label;
    }

    public TxnCoordinator getCoordinator() {
        return this.txnCoordinator;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public long getPrepareTime() {
        return this.prepareTime;
    }

    public long getPreCommitTime() {
        return this.preCommitTime;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getReason() {
        return this.reason;
    }

    public TransactionStatus getPreStatus() {
        return this.preStatus;
    }

    public TxnCommitAttachment getTxnCommitAttachment() {
        return this.txnCommitAttachment;
    }

    public long getCallbackId() {
        return this.callbackId;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setErrorLogUrl(String errorLogUrl) {
        this.errorLogUrl = errorLogUrl;
    }

    public String getErrorLogUrl() {
        return this.errorLogUrl;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.preStatus = this.transactionStatus;
        this.transactionStatus = transactionStatus;
        if (transactionStatus == TransactionStatus.VISIBLE) {
            this.latch.countDown();
            if (MetricRepo.isInit) {
                MetricRepo.COUNTER_TXN_SUCCESS.increase(1L);
            }
        } else if (transactionStatus == TransactionStatus.ABORTED && MetricRepo.isInit) {
            MetricRepo.COUNTER_TXN_FAILED.increase(1L);
        }
    }

    public void beforeStateTransform(TransactionStatus transactionStatus) throws TransactionException {
        this.callback = Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().getCallback(this.callbackId);
        if (this.callback != null) {
            switch (transactionStatus) {
                case ABORTED: {
                    this.callback.beforeAborted(this);
                    break;
                }
                case COMMITTED: {
                    this.callback.beforeCommitted(this);
                    break;
                }
            }
        } else if (this.callback == null && this.callbackId > 0L) {
            switch (transactionStatus) {
                case COMMITTED: {
                    throw new TransactionException("Failed to commit txn when callback " + this.callbackId + "could not be found");
                }
            }
        }
    }

    public void afterStateTransform(TransactionStatus transactionStatus, boolean txnOperated) throws UserException {
        this.afterStateTransform(transactionStatus, txnOperated, null);
    }

    public void afterStateTransform(TransactionStatus transactionStatus, boolean txnOperated, String txnStatusChangeReason) throws UserException {
        if (this.callback == null) {
            this.callback = Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().getCallback(this.callbackId);
        }
        if (this.callback != null) {
            switch (transactionStatus) {
                case ABORTED: {
                    this.callback.afterAborted(this, txnOperated, txnStatusChangeReason);
                    break;
                }
                case COMMITTED: {
                    this.callback.afterCommitted(this, txnOperated);
                    break;
                }
                case VISIBLE: {
                    this.callback.afterVisible(this, txnOperated);
                    break;
                }
            }
        }
    }

    public void replaySetTransactionStatus() {
        TxnStateChangeCallback callback = Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().getCallback(this.callbackId);
        if (callback != null) {
            if (this.transactionStatus == TransactionStatus.ABORTED) {
                callback.replayOnAborted(this);
            } else if (this.transactionStatus == TransactionStatus.COMMITTED) {
                callback.replayOnCommitted(this);
            } else if (this.transactionStatus == TransactionStatus.VISIBLE) {
                callback.replayOnVisible(this);
            }
        }
    }

    public void waitTransactionVisible(long timeoutMillis) throws InterruptedException {
        this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setPrepareTime(long prepareTime) {
        this.prepareTime = prepareTime;
    }

    public void setPreCommitTime(long preCommitTime) {
        this.preCommitTime = preCommitTime;
    }

    public void setCommitTime(long commitTime) {
        this.commitTime = commitTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public void setReason(String reason) {
        this.reason = Strings.nullToEmpty((String)reason);
    }

    public Set<Long> getErrorReplicas() {
        return this.errorReplicas;
    }

    public long getDbId() {
        return this.dbId;
    }

    public List<Long> getTableIdList() {
        return this.tableIdList;
    }

    public Map<Long, TableCommitInfo> getIdToTableCommitInfos() {
        return this.idToTableCommitInfos;
    }

    public void putIdToTableCommitInfo(long tableId, TableCommitInfo tableCommitInfo) {
        this.idToTableCommitInfos.put(tableId, tableCommitInfo);
    }

    public TableCommitInfo getTableCommitInfo(long tableId) {
        return this.idToTableCommitInfos.get(tableId);
    }

    public void removeTable(long tableId) {
        this.idToTableCommitInfos.remove(tableId);
    }

    public void setTxnCommitAttachment(TxnCommitAttachment txnCommitAttachment) {
        this.txnCommitAttachment = txnCommitAttachment;
    }

    public boolean isExpired(long currentMillis) {
        if (!this.transactionStatus.isFinalStatus()) {
            return false;
        }
        long expireTime = Config.label_keep_max_second;
        if (this.isShortTxn()) {
            expireTime = Config.streaming_label_keep_max_second;
        }
        return (currentMillis - this.finishTime) / 1000L > expireTime;
    }

    public boolean isShortTxn() {
        return this.sourceType == LoadJobSourceType.BACKEND_STREAMING || this.sourceType == LoadJobSourceType.INSERT_STREAMING || this.sourceType == LoadJobSourceType.ROUTINE_LOAD_TASK;
    }

    public boolean isTimeout(long currentMillis) {
        return this.transactionStatus == TransactionStatus.PREPARE && currentMillis - this.prepareTime > this.timeoutMs || this.transactionStatus == TransactionStatus.PRECOMMITTED && currentMillis - this.preCommitTime > this.preCommittedTimeoutMs;
    }

    public synchronized void addTableIndexes(OlapTable table) {
        HashSet indexIds = this.loadedTblIndexes.get(table.getId());
        if (indexIds == null) {
            indexIds = Sets.newHashSet();
            this.loadedTblIndexes.put(table.getId(), indexIds);
        }
        indexIds.clear();
        for (Long indexId : table.getIndexIdToMeta().keySet()) {
            indexIds.add(indexId);
        }
    }

    public Map<Long, Set<Long>> getLoadedTblIndexes() {
        return this.loadedTblIndexes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionState. ");
        sb.append("transaction id: ").append(this.transactionId);
        sb.append(", label: ").append(this.label);
        sb.append(", db id: ").append(this.dbId);
        sb.append(", table id list: ").append(StringUtils.join(this.tableIdList, (String)","));
        sb.append(", callback id: ").append(this.callbackId);
        sb.append(", coordinator: ").append(this.txnCoordinator.toString());
        sb.append(", transaction status: ").append((Object)this.transactionStatus);
        sb.append(", error replicas num: ").append(this.errorReplicas.size());
        sb.append(", replica ids: ").append(Joiner.on((String)",").join(this.errorReplicas.stream().limit(5L).toArray()));
        sb.append(", prepare time: ").append(this.prepareTime);
        sb.append(", commit time: ").append(this.commitTime);
        sb.append(", finish time: ").append(this.finishTime);
        sb.append(", reason: ").append(this.reason);
        if (this.txnCommitAttachment != null) {
            sb.append(" attactment: ").append(this.txnCommitAttachment);
        }
        return sb.toString();
    }

    public LoadJobSourceType getSourceType() {
        return this.sourceType;
    }

    public Map<Long, PublishVersionTask> getPublishVersionTasks() {
        return this.publishVersionTasks;
    }

    public boolean isPublishTimeout() {
        long timeoutMillis = Config.publish_version_timeout_second * 1000;
        if (this.prolongPublishTimeout) {
            timeoutMillis *= 2L;
        }
        return System.currentTimeMillis() - this.publishVersionTime > timeoutMillis;
    }

    public void prolongPublishTimeout() {
        this.prolongPublishTimeout = true;
        LOG.info("prolong the timeout of publish version task for transaction: {}", (Object)this.transactionId);
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.transactionId);
        Text.writeString((DataOutput)out, (String)this.label);
        out.writeLong(this.dbId);
        out.writeInt(this.idToTableCommitInfos.size());
        for (TableCommitInfo info : this.idToTableCommitInfos.values()) {
            info.write(out);
        }
        out.writeInt(this.txnCoordinator.sourceType.value());
        Text.writeString((DataOutput)out, (String)this.txnCoordinator.ip);
        out.writeInt(this.transactionStatus.value());
        out.writeInt(this.sourceType.value());
        out.writeLong(this.prepareTime);
        out.writeLong(this.preCommitTime);
        out.writeLong(this.commitTime);
        out.writeLong(this.finishTime);
        Text.writeString((DataOutput)out, (String)this.reason);
        out.writeInt(this.errorReplicas.size());
        Iterator<Object> iterator = this.errorReplicas.iterator();
        while (iterator.hasNext()) {
            long errorReplciaId = (Long)iterator.next();
            out.writeLong(errorReplciaId);
        }
        if (this.txnCommitAttachment == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.txnCommitAttachment.write(out);
        }
        out.writeLong(this.callbackId);
        out.writeLong(this.timeoutMs);
        out.writeInt(this.tableIdList.size());
        for (int i = 0; i < this.tableIdList.size(); ++i) {
            out.writeLong(this.tableIdList.get(i));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.transactionId = in.readLong();
        this.label = Text.readString((DataInput)in);
        this.dbId = in.readLong();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            TableCommitInfo info = new TableCommitInfo();
            info.readFields(in);
            this.idToTableCommitInfos.put(info.getTableId(), info);
        }
        this.txnCoordinator = new TxnCoordinator(TxnSourceType.valueOf(in.readInt()), Text.readString((DataInput)in));
        this.transactionStatus = TransactionStatus.valueOf(in.readInt());
        this.sourceType = LoadJobSourceType.valueOf(in.readInt());
        this.prepareTime = in.readLong();
        if (Catalog.getCurrentCatalogJournalVersion() >= 107) {
            this.preCommitTime = in.readLong();
        }
        this.commitTime = in.readLong();
        this.finishTime = in.readLong();
        this.reason = Text.readString((DataInput)in);
        int errorReplicaNum = in.readInt();
        for (int i = 0; i < errorReplicaNum; ++i) {
            this.errorReplicas.add(in.readLong());
        }
        if (in.readBoolean()) {
            this.txnCommitAttachment = TxnCommitAttachment.read(in);
        }
        this.callbackId = in.readLong();
        this.timeoutMs = in.readLong();
        this.tableIdList = Lists.newArrayList();
        int tableListSize = in.readInt();
        for (int i = 0; i < tableListSize; ++i) {
            this.tableIdList.add(in.readLong());
        }
    }

    public void setErrorMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void clearErrorMsg() {
        this.errMsg = "";
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static class TxnCoordinator {
        public TxnSourceType sourceType;
        public String ip;

        public TxnCoordinator() {
        }

        public TxnCoordinator(TxnSourceType sourceType, String ip) {
            this.sourceType = sourceType;
            this.ip = ip;
        }

        public String toString() {
            return this.sourceType.toString() + ": " + this.ip;
        }
    }

    public static enum TxnSourceType {
        FE(1),
        BE(2);

        private int flag;

        public int value() {
            return this.flag;
        }

        private TxnSourceType(int flag) {
            this.flag = flag;
        }

        public static TxnSourceType valueOf(int flag) {
            switch (flag) {
                case 1: {
                    return FE;
                }
                case 2: {
                    return BE;
                }
            }
            return null;
        }
    }

    public static enum TxnStatusChangeReason {
        DB_DROPPED,
        TIMEOUT,
        OFFSET_OUT_OF_RANGE,
        PAUSE,
        NO_PARTITIONS;


        public static TxnStatusChangeReason fromString(String reasonString) {
            for (TxnStatusChangeReason txnStatusChangeReason : TxnStatusChangeReason.values()) {
                if (!reasonString.contains(txnStatusChangeReason.toString())) continue;
                return txnStatusChangeReason;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case OFFSET_OUT_OF_RANGE: {
                    return "Offset out of range";
                }
                case NO_PARTITIONS: {
                    return "all partitions have no load data";
                }
            }
            return this.name();
        }
    }

    public static enum LoadJobSourceType {
        FRONTEND(1),
        BACKEND_STREAMING(2),
        INSERT_STREAMING(3),
        ROUTINE_LOAD_TASK(4),
        BATCH_LOAD_JOB(5);

        private final int flag;

        private LoadJobSourceType(int flag) {
            this.flag = flag;
        }

        public int value() {
            return this.flag;
        }

        public static LoadJobSourceType valueOf(int flag) {
            switch (flag) {
                case 1: {
                    return FRONTEND;
                }
                case 2: {
                    return BACKEND_STREAMING;
                }
                case 3: {
                    return INSERT_STREAMING;
                }
                case 4: {
                    return ROUTINE_LOAD_TASK;
                }
                case 5: {
                    return BATCH_LOAD_JOB;
                }
            }
            return null;
        }
    }

    public static class TxnStateComparator
    implements Comparator<TransactionState> {
        @Override
        public int compare(TransactionState t1, TransactionState t2) {
            return Long.compare(t2.getTransactionId(), t1.getTransactionId());
        }
    }
}

