/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.persist.EditLog;

public class TransactionIdGenerator {
    public static final long NEXT_ID_INIT_VALUE = 1L;
    private static final int BATCH_ID_INTERVAL = 1000;
    private long nextId = 1L;
    private long batchEndId = 0L;
    private EditLog editLog;

    public void setEditLog(EditLog editLog) {
        this.editLog = editLog;
    }

    public synchronized long getNextTransactionId() {
        if (this.nextId < this.batchEndId) {
            ++this.nextId;
            return this.nextId;
        }
        this.batchEndId += 1000L;
        this.editLog.logSaveTransactionId(this.batchEndId);
        ++this.nextId;
        return this.nextId;
    }

    public synchronized void initTransactionId(long id) {
        if (id > this.batchEndId) {
            this.batchEndId = id;
            this.nextId = id;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.batchEndId);
    }

    public void readFields(DataInput in) throws IOException {
        this.nextId = this.batchEndId = in.readLong();
    }
}

