/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.proto.InternalService;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TTxnParams;

public class TransactionEntry {
    private String label = "";
    private Database db;
    private Table table;
    private Backend backend;
    private TTxnParams txnConf;
    private List<InternalService.PDataRow> dataToSend = new ArrayList<InternalService.PDataRow>();
    private long rowsInTransaction = 0L;

    public TransactionEntry() {
    }

    public TransactionEntry(TTxnParams txnConf, Database db, Table table) {
        this.txnConf = txnConf;
        this.db = db;
        this.table = table;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Database getDb() {
        return this.db;
    }

    public void setDb(Database db) {
        this.db = db;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void setBackend(Backend backend) {
        this.backend = backend;
    }

    public TTxnParams getTxnConf() {
        return this.txnConf;
    }

    public void setTxnConf(TTxnParams txnConf) {
        this.txnConf = txnConf;
    }

    public boolean isTxnModel() {
        return this.txnConf != null && this.txnConf.isNeedTxn();
    }

    public boolean isTxnIniting() {
        return this.isTxnModel() && this.txnConf.getTxnId() == -1L;
    }

    public boolean isTxnBegin() {
        return this.isTxnModel() && this.txnConf.getTxnId() != -1L;
    }

    public List<InternalService.PDataRow> getDataToSend() {
        return this.dataToSend;
    }

    public void setDataToSend(List<InternalService.PDataRow> dataToSend) {
        this.dataToSend = dataToSend;
    }

    public void clearDataToSend() {
        this.dataToSend.clear();
    }

    public long getRowsInTransaction() {
        return this.rowsInTransaction;
    }

    public void setRowsInTransaction(long rowsInTransaction) {
        this.rowsInTransaction = rowsInTransaction;
    }
}

