/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.doris.transaction.TransactionException;

public class TabletQuorumFailedException
extends TransactionException {
    private static final String TABLET_QUORUM_FAILED_MSG = "Failed to commit txn %s. Tablet [%s] success replica num %s is less than quorum replica num %s while error backends %s";
    private long tabletId;
    private Set<Long> errorBackendIdsForTablet = Sets.newHashSet();

    public TabletQuorumFailedException(long transactionId, long tabletId, int successReplicaNum, int quorumReplicaNum, Set<Long> errorBackendIdsForTablet) {
        super(String.format(TABLET_QUORUM_FAILED_MSG, transactionId, tabletId, successReplicaNum, quorumReplicaNum, Joiner.on((String)",").join(errorBackendIdsForTablet)), transactionId);
        this.tabletId = tabletId;
        this.errorBackendIdsForTablet = errorBackendIdsForTablet;
    }
}

