/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TTabletCommitInfo;

public class TabletCommitInfo
implements Writable {
    private long tabletId;
    private long backendId;

    public TabletCommitInfo(long tabletId, long backendId) {
        this.tabletId = tabletId;
        this.backendId = backendId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public static List<TabletCommitInfo> fromThrift(List<TTabletCommitInfo> tTabletCommitInfos) {
        ArrayList commitInfos = Lists.newArrayList();
        for (TTabletCommitInfo tTabletCommitInfo : tTabletCommitInfos) {
            commitInfos.add(new TabletCommitInfo(tTabletCommitInfo.getTabletId(), tTabletCommitInfo.getBackendId()));
        }
        return commitInfos;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.tabletId);
        out.writeLong(this.backendId);
    }

    public void readFields(DataInput in) throws IOException {
        this.tabletId = in.readLong();
        this.backendId = in.readLong();
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

