/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.common.io.Writable;
import org.apache.doris.transaction.PartitionCommitInfo;

public class TableCommitInfo
implements Writable {
    private long tableId;
    private Map<Long, PartitionCommitInfo> idToPartitionCommitInfo;

    public TableCommitInfo() {
    }

    public TableCommitInfo(long tableId) {
        this.tableId = tableId;
        this.idToPartitionCommitInfo = Maps.newHashMap();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.tableId);
        if (this.idToPartitionCommitInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.idToPartitionCommitInfo.size());
            for (PartitionCommitInfo partitionCommitInfo : this.idToPartitionCommitInfo.values()) {
                partitionCommitInfo.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.tableId = in.readLong();
        boolean hasPartitionInfo = in.readBoolean();
        this.idToPartitionCommitInfo = Maps.newHashMap();
        if (hasPartitionInfo) {
            int elementNum = in.readInt();
            for (int i = 0; i < elementNum; ++i) {
                PartitionCommitInfo partitionCommitInfo = PartitionCommitInfo.read(in);
                this.idToPartitionCommitInfo.put(partitionCommitInfo.getPartitionId(), partitionCommitInfo);
            }
        }
    }

    public long getTableId() {
        return this.tableId;
    }

    public Map<Long, PartitionCommitInfo> getIdToPartitionCommitInfo() {
        return this.idToPartitionCommitInfo;
    }

    public void addPartitionCommitInfo(PartitionCommitInfo info) {
        this.idToPartitionCommitInfo.put(info.getPartitionId(), info);
    }

    public void removePartition(long partitionId) {
        this.idToPartitionCommitInfo.remove(partitionId);
    }

    public PartitionCommitInfo getPartitionCommitInfo(long partitionId) {
        return this.idToPartitionCommitInfo.get(partitionId);
    }
}

