/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.PublishVersionTask;
import org.apache.doris.thrift.TPartitionVersionInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.PartitionCommitInfo;
import org.apache.doris.transaction.TableCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublishVersionDaemon
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(PublishVersionDaemon.class);

    public PublishVersionDaemon() {
        super("PUBLISH_VERSION", Config.publish_version_interval_ms);
    }

    @Override
    protected void runAfterCatalogReady() {
        try {
            this.publishVersion();
        }
        catch (Throwable t) {
            LOG.error("errors while publish version to all backends", t);
        }
    }

    private boolean isAllBackendsOfUnfinishedTasksDead(List<PublishVersionTask> unfinishedTasks) {
        for (PublishVersionTask unfinishedTask : unfinishedTasks) {
            if (!Catalog.getCurrentSystemInfo().checkBackendAlive(unfinishedTask.getBackendId())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void publishVersion() {
        GlobalTransactionMgr globalTransactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        List<TransactionState> readyTransactionStates = globalTransactionMgr.getReadyToPublishTransactions();
        if (readyTransactionStates.isEmpty()) {
            return;
        }
        List<Long> allBackends = Catalog.getCurrentSystemInfo().getBackendIds(false);
        if (allBackends.isEmpty()) {
            LOG.warn("some transaction state need to publish, but no backend exists");
            return;
        }
        long createPublishVersionTaskTime = System.currentTimeMillis();
        AgentBatchTask batchTask = new AgentBatchTask();
        for (TransactionState transactionState : readyTransactionStates) {
            void var11_10;
            Object commitInfo2;
            if (transactionState.hasSendTask()) continue;
            ArrayList<PartitionCommitInfo> partitionCommitInfos = new ArrayList<PartitionCommitInfo>();
            for (TableCommitInfo tableCommitInfo : transactionState.getIdToTableCommitInfos().values()) {
                partitionCommitInfos.addAll(tableCommitInfo.getIdToPartitionCommitInfo().values());
            }
            ArrayList<TPartitionVersionInfo> partitionVersionInfos = new ArrayList<TPartitionVersionInfo>(partitionCommitInfos.size());
            for (Object commitInfo2 : partitionCommitInfos) {
                TPartitionVersionInfo versionInfo = new TPartitionVersionInfo(((PartitionCommitInfo)commitInfo2).getPartitionId(), ((PartitionCommitInfo)commitInfo2).getVersion(), 0L);
                partitionVersionInfos.add(versionInfo);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("try to publish version info partitionid [{}], version [{}]", (Object)((PartitionCommitInfo)commitInfo2).getPartitionId(), (Object)((PartitionCommitInfo)commitInfo2).getVersion());
            }
            Set<Long> set = transactionState.getPublishVersionTasks().keySet();
            if (set.isEmpty()) {
                HashSet hashSet = Sets.newHashSet();
                hashSet.addAll(allBackends);
            }
            commitInfo2 = var11_10.iterator();
            while (commitInfo2.hasNext()) {
                long backendId = (Long)commitInfo2.next();
                PublishVersionTask task = new PublishVersionTask(backendId, transactionState.getTransactionId(), transactionState.getDbId(), partitionVersionInfos, createPublishVersionTaskTime);
                AgentTaskQueue.addTask(task);
                batchTask.addTask(task);
                transactionState.addPublishVersionTask(backendId, task);
            }
            transactionState.setHasSendTask(true);
            LOG.info("send publish tasks for transaction: {}", (Object)transactionState.getTransactionId());
        }
        if (!batchTask.getAllTasks().isEmpty()) {
            AgentTaskExecutor.submit(batchTask);
        }
        TabletInvertedIndex tabletInvertedIndex = Catalog.getCurrentInvertedIndex();
        for (TransactionState transactionState : readyTransactionStates) {
            Map<Long, PublishVersionTask> transTasks = transactionState.getPublishVersionTasks();
            HashSet hashSet = Sets.newHashSet();
            ArrayList unfinishedTasks = Lists.newArrayList();
            for (PublishVersionTask publishVersionTask : transTasks.values()) {
                if (publishVersionTask.isFinished()) {
                    List<Long> errorTablets = publishVersionTask.getErrorTablets();
                    if (errorTablets == null || errorTablets.isEmpty()) continue;
                    for (long tabletId : errorTablets) {
                        if (tabletInvertedIndex.getTabletMeta(tabletId) == null) continue;
                        Replica replica = tabletInvertedIndex.getReplica(tabletId, publishVersionTask.getBackendId());
                        if (replica != null) {
                            hashSet.add(replica.getId());
                            continue;
                        }
                        LOG.info("could not find related replica with tabletid={}, backendid={}", (Object)tabletId, (Object)publishVersionTask.getBackendId());
                    }
                    continue;
                }
                unfinishedTasks.add(publishVersionTask);
            }
            boolean shouldFinishTxn = false;
            if (!unfinishedTasks.isEmpty()) {
                shouldFinishTxn = this.isAllBackendsOfUnfinishedTasksDead(unfinishedTasks);
                if (transactionState.isPublishTimeout() || shouldFinishTxn) {
                    for (PublishVersionTask unfinishedTask : unfinishedTasks) {
                        List<TPartitionVersionInfo> versionInfos = unfinishedTask.getPartitionVersionInfos();
                        HashSet errorPartitionIds = Sets.newHashSet();
                        for (TPartitionVersionInfo versionInfo : versionInfos) {
                            errorPartitionIds.add(versionInfo.getPartitionId());
                        }
                        if (errorPartitionIds.isEmpty()) continue;
                        Database db = Catalog.getCurrentCatalog().getDbNullable(transactionState.getDbId());
                        if (db == null) {
                            LOG.warn("Database [{}] has been dropped.", (Object)transactionState.getDbId());
                            continue;
                        }
                        for (long tableId : transactionState.getTableIdList()) {
                            Table table = db.getTableNullable(tableId);
                            if (table == null || table.getType() != Table.TableType.OLAP) {
                                LOG.warn("Table [{}] in database [{}] has been dropped.", (Object)tableId, (Object)db.getFullName());
                                continue;
                            }
                            OlapTable olapTable = (OlapTable)table;
                            olapTable.readLock();
                            try {
                                for (Long errorPartitionId : errorPartitionIds) {
                                    Partition partition = olapTable.getPartition(errorPartitionId);
                                    if (partition == null) continue;
                                    List<MaterializedIndex> materializedIndexList = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                                    for (MaterializedIndex materializedIndex : materializedIndexList) {
                                        for (Tablet tablet : materializedIndex.getTablets()) {
                                            Replica replica = tablet.getReplicaByBackendId(unfinishedTask.getBackendId());
                                            if (replica == null) continue;
                                            hashSet.add(replica.getId());
                                        }
                                    }
                                }
                            }
                            finally {
                                olapTable.readUnlock();
                            }
                        }
                    }
                    shouldFinishTxn = true;
                }
            } else {
                shouldFinishTxn = true;
            }
            if (shouldFinishTxn) {
                try {
                    globalTransactionMgr.finishTransaction(transactionState.getDbId(), transactionState.getTransactionId(), hashSet);
                }
                catch (Exception exception) {
                    LOG.warn("error happens when finish transaction {}", (Object)transactionState.getTransactionId(), (Object)exception);
                }
                if (transactionState.getTransactionStatus() != TransactionStatus.VISIBLE) {
                    transactionState.updateSendTaskTime();
                    LOG.debug("publish version for transaction {} failed, has {} error replicas during publish", (Object)transactionState, (Object)hashSet.size());
                }
            }
            if (transactionState.getTransactionStatus() != TransactionStatus.VISIBLE) continue;
            for (PublishVersionTask task : transactionState.getPublishVersionTasks().values()) {
                AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.PUBLISH_VERSION, task.getSignature());
            }
        }
    }
}

