/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.persist.BatchRemoveTransactionsOperation;
import org.apache.doris.persist.EditLog;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.thrift.TWaitingTxnStatusRequest;
import org.apache.doris.thrift.TWaitingTxnStatusResult;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.DatabaseTransactionMgr;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionCommitFailedException;
import org.apache.doris.transaction.TransactionIdGenerator;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.doris.transaction.TxnCommitAttachment;
import org.apache.doris.transaction.TxnStateCallbackFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalTransactionMgr
implements Writable {
    private static final Logger LOG = LogManager.getLogger(GlobalTransactionMgr.class);
    private Map<Long, DatabaseTransactionMgr> dbIdToDatabaseTransactionMgrs = Maps.newConcurrentMap();
    private TransactionIdGenerator idGenerator = new TransactionIdGenerator();
    private TxnStateCallbackFactory callbackFactory = new TxnStateCallbackFactory();
    private Catalog catalog;

    public GlobalTransactionMgr(Catalog catalog) {
        this.catalog = catalog;
    }

    public TxnStateCallbackFactory getCallbackFactory() {
        return this.callbackFactory;
    }

    public DatabaseTransactionMgr getDatabaseTransactionMgr(long dbId) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.dbIdToDatabaseTransactionMgrs.get(dbId);
        if (dbTransactionMgr == null) {
            throw new AnalysisException("databaseTransactionMgr[" + dbId + "] does not exist");
        }
        return dbTransactionMgr;
    }

    public void addDatabaseTransactionMgr(Long dbId) {
        if (this.dbIdToDatabaseTransactionMgrs.putIfAbsent(dbId, new DatabaseTransactionMgr(dbId, this.catalog, this.idGenerator)) == null) {
            LOG.debug("add database transaction manager for db {}", (Object)dbId);
        }
    }

    public void removeDatabaseTransactionMgr(Long dbId) {
        if (this.dbIdToDatabaseTransactionMgrs.remove(dbId) != null) {
            LOG.debug("remove database transaction manager for db {}", (Object)dbId);
        }
    }

    public long beginTransaction(long dbId, List<Long> tableIdList, String label, TransactionState.TxnCoordinator coordinator, TransactionState.LoadJobSourceType sourceType, long timeoutSecond) throws AnalysisException, LabelAlreadyUsedException, BeginTransactionException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        return this.beginTransaction(dbId, tableIdList, label, null, coordinator, sourceType, -1L, timeoutSecond);
    }

    public long beginTransaction(long dbId, List<Long> tableIdList, String label, TUniqueId requestId, TransactionState.TxnCoordinator coordinator, TransactionState.LoadJobSourceType sourceType, long listenerId, long timeoutSecond) throws AnalysisException, LabelAlreadyUsedException, BeginTransactionException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        if (Config.disable_load_job) {
            throw new AnalysisException("disable_load_job is set to true, all load jobs are prevented");
        }
        switch (sourceType) {
            case BACKEND_STREAMING: {
                this.checkValidTimeoutSecond(timeoutSecond, Config.max_stream_load_timeout_second, Config.min_load_timeout_second);
                break;
            }
            default: {
                this.checkValidTimeoutSecond(timeoutSecond, Config.max_load_timeout_second, Config.min_load_timeout_second);
            }
        }
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.beginTransaction(tableIdList, label, requestId, coordinator, sourceType, listenerId, timeoutSecond);
    }

    private void checkValidTimeoutSecond(long timeoutSecond, int maxLoadTimeoutSecond, int minLoadTimeOutSecond) throws AnalysisException {
        if (timeoutSecond > (long)maxLoadTimeoutSecond || timeoutSecond < (long)minLoadTimeOutSecond) {
            throw new AnalysisException("Invalid timeout: " + timeoutSecond + ". Timeout should between " + minLoadTimeOutSecond + " and " + maxLoadTimeoutSecond + " seconds");
        }
    }

    public TransactionStatus getLabelState(long dbId, String label) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getLabelState(label);
        }
        catch (AnalysisException e) {
            LOG.warn("Get transaction status by label " + label + " failed", (Throwable)e);
            return TransactionStatus.UNKNOWN;
        }
    }

    public Long getTransactionId(long dbId, String label) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getTransactionId(label);
        }
        catch (AnalysisException e) {
            LOG.warn("Get transaction id by label " + label + " failed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommitTransaction2PC(Database db, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, long timeoutMillis, TxnCommitAttachment txnCommitAttachment) throws UserException {
        if (!MetaLockUtils.tryWriteLockTablesOrMetaException(tableList, timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new UserException("get tableList write lock timeout, tableList=(" + StringUtils.join(tableList, (String)",") + ")");
        }
        try {
            this.preCommitTransaction2PC(db.getId(), tableList, transactionId, tabletCommitInfos, txnCommitAttachment);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
    }

    public void preCommitTransaction2PC(long dbId, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, TxnCommitAttachment txnCommitAttachment) throws UserException {
        if (Config.disable_load_job) {
            throw new TransactionCommitFailedException("disable_load_job is set to true, all load jobs are prevented");
        }
        LOG.debug("try to pre-commit transaction: {}", (Object)transactionId);
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.preCommitTransaction2PC(tableList, transactionId, tabletCommitInfos, txnCommitAttachment);
    }

    public void commitTransaction(long dbId, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos) throws UserException {
        this.commitTransaction(dbId, tableList, transactionId, tabletCommitInfos, null);
    }

    public void commitTransaction(long dbId, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, TxnCommitAttachment txnCommitAttachment) throws UserException {
        if (Config.disable_load_job) {
            throw new TransactionCommitFailedException("disable_load_job is set to true, all load jobs are prevented");
        }
        LOG.debug("try to commit transaction: {}", (Object)transactionId);
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.commitTransaction(tableList, transactionId, tabletCommitInfos, txnCommitAttachment, false);
    }

    private void commitTransaction2PC(long dbId, long transactionId) throws UserException {
        if (Config.disable_load_job) {
            throw new TransactionCommitFailedException("disable_load_job is set to true, all load jobs are prevented");
        }
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.commitTransaction(null, transactionId, null, null, true);
    }

    public boolean commitAndPublishTransaction(Database db, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, long timeoutMillis) throws UserException {
        return this.commitAndPublishTransaction(db, tableList, transactionId, tabletCommitInfos, timeoutMillis, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitAndPublishTransaction(Database db, List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, long timeoutMillis, TxnCommitAttachment txnCommitAttachment) throws UserException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (!MetaLockUtils.tryWriteLockTablesOrMetaException(tableList, timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new UserException("get tableList write lock timeout, tableList=(" + StringUtils.join(tableList, (String)",") + ")");
        }
        try {
            this.commitTransaction(db.getId(), tableList, transactionId, tabletCommitInfos, txnCommitAttachment);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
        stopWatch.stop();
        long publishTimeoutMillis = timeoutMillis - stopWatch.getTime();
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(db.getId());
        if (publishTimeoutMillis < 0L) {
            return false;
        }
        return dbTransactionMgr.waitForTransactionFinished(db, transactionId, publishTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction2PC(Database db, List<Table> tableList, long transactionId, long timeoutMillis) throws UserException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (!MetaLockUtils.tryWriteLockTablesOrMetaException(tableList, timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new UserException("get tableList write lock timeout, tableList=(" + StringUtils.join(tableList, (String)",") + ")");
        }
        try {
            this.commitTransaction2PC(db.getId(), transactionId);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
        stopWatch.stop();
        LOG.info("stream load tasks are committed successfully. txns: {}. time cost: {} ms. data will be visable later.", (Object)transactionId, (Object)stopWatch.getTime());
    }

    public void abortTransaction(long dbId, long transactionId, String reason) throws UserException {
        this.abortTransaction(dbId, transactionId, reason, null);
    }

    public void abortTransaction(Long dbId, Long txnId, String reason, TxnCommitAttachment txnCommitAttachment) throws UserException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.abortTransaction(txnId, reason, txnCommitAttachment);
    }

    public void abortTransaction(Long dbId, String label, String reason) throws UserException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.abortTransaction(label, reason);
    }

    public void abortTransaction2PC(Long dbId, long transactionId) throws UserException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.abortTransaction2PC(transactionId);
    }

    public List<TransactionState> getReadyToPublishTransactions() {
        ArrayList transactionStateList = Lists.newArrayList();
        for (DatabaseTransactionMgr dbTransactionMgr : this.dbIdToDatabaseTransactionMgrs.values()) {
            transactionStateList.addAll(dbTransactionMgr.getCommittedTxnList());
        }
        return transactionStateList;
    }

    public boolean existCommittedTxns(Long dbId, Long tableId, Long partitionId) {
        DatabaseTransactionMgr dbTransactionMgr = this.dbIdToDatabaseTransactionMgrs.get(dbId);
        if (tableId == null && partitionId == null) {
            return !dbTransactionMgr.getCommittedTxnList().isEmpty();
        }
        for (TransactionState transactionState : dbTransactionMgr.getCommittedTxnList()) {
            if (!transactionState.getTableIdList().contains(tableId)) continue;
            if (partitionId == null) {
                return true;
            }
            if (transactionState.getTableCommitInfo(tableId).getPartitionCommitInfo(partitionId) == null) continue;
            return true;
        }
        return false;
    }

    public void finishTransaction(long dbId, long transactionId, Set<Long> errorReplicaIds) throws UserException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.finishTransaction(transactionId, errorReplicaIds);
    }

    public boolean isPreviousTransactionsFinished(long endTransactionId, long dbId, List<Long> tableIdList) throws AnalysisException {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.isPreviousTransactionsFinished(endTransactionId, tableIdList);
        }
        catch (AnalysisException e) {
            LOG.warn("Check whether all previous transactions in db [" + dbId + "] finished failed", (Throwable)e);
            throw e;
        }
    }

    public void removeExpiredAndTimeoutTxns() {
        long currentMillis = System.currentTimeMillis();
        for (DatabaseTransactionMgr dbTransactionMgr : this.dbIdToDatabaseTransactionMgrs.values()) {
            dbTransactionMgr.removeExpiredAndTimeoutTxns(currentMillis);
        }
    }

    public TransactionState getTransactionState(long dbId, long transactionId) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getTransactionState(transactionId);
        }
        catch (AnalysisException e) {
            LOG.warn("Get transaction {} in db {} failed. msg: {}", (Object)transactionId, (Object)dbId, (Object)e.getMessage());
            return null;
        }
    }

    public void setEditLog(EditLog editLog) {
        this.idGenerator.setEditLog(editLog);
    }

    public void replayUpsertTransactionState(TransactionState transactionState) throws MetaNotFoundException {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(transactionState.getDbId());
            dbTransactionMgr.replayUpsertTransactionState(transactionState);
        }
        catch (AnalysisException e) {
            throw new MetaNotFoundException(e);
        }
    }

    @Deprecated
    public void replayDeleteTransactionState(TransactionState transactionState) throws MetaNotFoundException {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(transactionState.getDbId());
            dbTransactionMgr.replayDeleteTransaction(transactionState);
        }
        catch (AnalysisException e) {
            throw new MetaNotFoundException(e);
        }
    }

    public void replayBatchRemoveTransactions(BatchRemoveTransactionsOperation operation) {
        Map<Long, List<Long>> dbTxnIds = operation.getDbTxnIds();
        for (Long dbId : dbTxnIds.keySet()) {
            try {
                DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
                dbTransactionMgr.replayBatchRemoveTransaction(dbTxnIds.get(dbId));
            }
            catch (AnalysisException e) {
                LOG.warn("replay batch remove transactions failed. db " + dbId, (Throwable)e);
            }
        }
    }

    public List<List<Comparable>> getDbInfo() {
        ArrayList<List<Comparable>> infos = new ArrayList<List<Comparable>>();
        ArrayList dbIds = Lists.newArrayList(this.dbIdToDatabaseTransactionMgrs.keySet());
        Iterator iterator = dbIds.iterator();
        while (iterator.hasNext()) {
            long dbId = (Long)iterator.next();
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(dbId);
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            info.add(db.getFullName());
            long runningNum = 0L;
            try {
                DatabaseTransactionMgr dbMgr = this.getDatabaseTransactionMgr(dbId);
                runningNum = dbMgr.getRunningTxnNums() + dbMgr.getRunningRoutineLoadTxnNums();
            }
            catch (AnalysisException e) {
                LOG.warn("get database running transaction num failed", (Throwable)e);
            }
            info.add(runningNum);
            infos.add(info);
        }
        return infos;
    }

    public List<List<String>> getDbTransStateInfo(long dbId) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getDbTransStateInfo();
        }
        catch (AnalysisException e) {
            LOG.warn("Get db [" + dbId + "] transactions info failed", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<List<String>> getDbTransInfo(long dbId, boolean running, int limit) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.getTxnStateInfoList(running, limit);
    }

    public List<List<String>> getDbTransInfoByStatus(long dbId, TransactionStatus status) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.getTxnStateInfoList(status);
    }

    public List<List<String>> getSingleTranInfo(long dbId, long txnId) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.getSingleTranInfo(dbId, txnId);
    }

    public List<List<Comparable>> getTableTransInfo(long dbId, long txnId) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.getTableTransInfo(txnId);
    }

    public List<List<Comparable>> getPartitionTransInfo(long dbId, long tid, long tableId) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        return dbTransactionMgr.getPartitionTransInfo(tid, tableId);
    }

    public int getTransactionNum() {
        int txnNum = 0;
        for (DatabaseTransactionMgr dbTransactionMgr : this.dbIdToDatabaseTransactionMgrs.values()) {
            txnNum += dbTransactionMgr.getTransactionNum();
        }
        return txnNum;
    }

    public TransactionIdGenerator getTransactionIDGenerator() {
        return this.idGenerator;
    }

    public void write(DataOutput out) throws IOException {
        int numTransactions = this.getTransactionNum();
        out.writeInt(numTransactions);
        for (DatabaseTransactionMgr dbTransactionMgr : this.dbIdToDatabaseTransactionMgrs.values()) {
            dbTransactionMgr.unprotectWriteAllTransactionStates(out);
        }
        this.idGenerator.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        int numTransactions = in.readInt();
        for (int i = 0; i < numTransactions; ++i) {
            TransactionState transactionState = new TransactionState();
            transactionState.readFields(in);
            try {
                DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(transactionState.getDbId());
                dbTransactionMgr.unprotectUpsertTransactionState(transactionState, true);
                continue;
            }
            catch (AnalysisException e) {
                LOG.warn("failed to get db transaction manager for txn: {}", (Object)transactionState);
                throw new IOException("Read transaction states failed", e);
            }
        }
        this.idGenerator.readFields(in);
    }

    public TransactionState getTransactionStateByCallbackIdAndStatus(long dbId, long callbackId, Set<TransactionStatus> status) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getTransactionStateByCallbackIdAndStatus(callbackId, status);
        }
        catch (AnalysisException e) {
            LOG.warn("Get transaction by callbackId and status failed", (Throwable)e);
            return null;
        }
    }

    public TransactionState getTransactionStateByCallbackId(long dbId, long callbackId) {
        try {
            DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
            return dbTransactionMgr.getTransactionStateByCallbackId(callbackId);
        }
        catch (AnalysisException e) {
            LOG.warn("Get transaction by callbackId failed", (Throwable)e);
            return null;
        }
    }

    public List<Pair<Long, Long>> getTransactionIdByCoordinateBe(String coordinateHost, int limit) {
        ArrayList<Pair<Long, Long>> txnInfos = new ArrayList<Pair<Long, Long>>();
        for (DatabaseTransactionMgr databaseTransactionMgr : this.dbIdToDatabaseTransactionMgrs.values()) {
            txnInfos.addAll(databaseTransactionMgr.getTransactionIdByCoordinateBe(coordinateHost, limit));
            if (txnInfos.size() <= limit) continue;
            break;
        }
        return txnInfos.size() > limit ? new ArrayList<Pair<Long, Long>>(txnInfos.subList(0, limit)) : txnInfos;
    }

    public void abortTxnWhenCoordinateBeDown(String coordinateHost, int limit) {
        List<Pair<Long, Long>> transactionIdByCoordinateBe = this.getTransactionIdByCoordinateBe(coordinateHost, limit);
        for (Pair<Long, Long> txnInfo : transactionIdByCoordinateBe) {
            try {
                DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr((Long)txnInfo.first);
                TransactionState transactionState = dbTransactionMgr.getTransactionState((Long)txnInfo.second);
                if (transactionState.getTransactionStatus() == TransactionStatus.PRECOMMITTED) continue;
                dbTransactionMgr.abortTransaction((Long)txnInfo.second, "coordinate BE is down", null);
            }
            catch (UserException e) {
                LOG.warn("Abort txn on coordinate BE {} failed, msg={}", (Object)coordinateHost, (Object)e.getMessage());
            }
        }
    }

    public void updateDatabaseUsedQuotaData(long dbId, long usedQuotaDataBytes) throws AnalysisException {
        DatabaseTransactionMgr dbTransactionMgr = this.getDatabaseTransactionMgr(dbId);
        dbTransactionMgr.updateDatabaseUsedQuotaData(usedQuotaDataBytes);
    }

    public TWaitingTxnStatusResult getWaitingTxnStatus(TWaitingTxnStatusRequest request) throws AnalysisException, TimeoutException {
        long dbId = request.getDbId();
        int commitTimeoutSec = Config.commit_timeout_second;
        for (int i = 0; i < commitTimeoutSec; ++i) {
            Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbId);
            TWaitingTxnStatusResult statusResult = new TWaitingTxnStatusResult();
            statusResult.status = new TStatus();
            TransactionStatus txnStatus = null;
            if (request.isSetTxnId()) {
                long txnId = request.getTxnId();
                TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(dbId, txnId);
                if (txnState == null) {
                    throw new AnalysisException("txn does not exist: " + txnId);
                }
                txnStatus = txnState.getTransactionStatus();
                if (!txnState.getReason().trim().isEmpty()) {
                    statusResult.status.setErrorMsgsIsSet(true);
                    statusResult.status.addToErrorMsgs(txnState.getReason());
                }
            } else {
                txnStatus = this.getLabelState(dbId, request.getLabel());
            }
            if (txnStatus == TransactionStatus.UNKNOWN || txnStatus.isFinalStatus()) {
                statusResult.setTxnStatusId(txnStatus.value());
                return statusResult;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.info("commit sleep exception.", (Throwable)e);
            }
        }
        throw new TimeoutException("Operation is timeout");
    }
}

