/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbUsedDataQuotaInfoCollector
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(DbUsedDataQuotaInfoCollector.class);

    public DbUsedDataQuotaInfoCollector() {
        super("DbUsedDataQuotaInfoCollector", Config.db_used_data_quota_update_interval_secs * 1000);
    }

    @Override
    protected void runAfterCatalogReady() {
        this.updateAllDatabaseUsedDataQuota();
    }

    private void updateAllDatabaseUsedDataQuota() {
        Catalog catalog = Catalog.getCurrentCatalog();
        List<Long> dbIdList = catalog.getDbIds();
        GlobalTransactionMgr globalTransactionMgr = catalog.getGlobalTransactionMgr();
        for (Long dbId : dbIdList) {
            Database db = catalog.getDbNullable(dbId);
            if (db == null) {
                LOG.warn("Database [" + dbId + "] does not exist, skip to update database used data quota");
                continue;
            }
            if (db.isInfoSchemaDb()) continue;
            try {
                long usedDataQuotaBytes = db.getUsedDataQuotaWithLock();
                globalTransactionMgr.updateDatabaseUsedQuotaData(dbId, usedDataQuotaBytes);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Update database[{}] used data quota bytes : {}.", (Object)db.getFullName(), (Object)usedDataQuotaBytes);
            }
            catch (AnalysisException e) {
                LOG.warn("Update database[" + db.getFullName() + "] used data quota failed", (Throwable)e);
            }
        }
    }
}

