/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.transaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.BatchRemoveTransactionsOperation;
import org.apache.doris.persist.EditLog;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.ClearTransactionTask;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.PartitionCommitInfo;
import org.apache.doris.transaction.TableCommitInfo;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TabletQuorumFailedException;
import org.apache.doris.transaction.TransactionCommitFailedException;
import org.apache.doris.transaction.TransactionIdGenerator;
import org.apache.doris.transaction.TransactionNotFoundException;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.doris.transaction.TxnCommitAttachment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseTransactionMgr {
    private static final Logger LOG = LogManager.getLogger(DatabaseTransactionMgr.class);
    private static final int MAX_REMOVE_TXN_PER_ROUND = 10000;
    private long dbId;
    private ReentrantReadWriteLock transactionLock = new ReentrantReadWriteLock(true);
    private Map<Long, TransactionState> idToRunningTransactionState = Maps.newHashMap();
    private Map<Long, TransactionState> idToFinalStatusTransactionState = Maps.newHashMap();
    private ArrayDeque<TransactionState> finalStatusTransactionStateDequeShort = new ArrayDeque();
    private ArrayDeque<TransactionState> finalStatusTransactionStateDequeLong = new ArrayDeque();
    private Map<String, Set<Long>> labelToTxnIds = Maps.newHashMap();
    private volatile int runningTxnNums = 0;
    private volatile int runningRoutineLoadTxnNums = 0;
    private Catalog catalog;
    private EditLog editLog;
    private TransactionIdGenerator idGenerator;
    private List<ClearTransactionTask> clearTransactionTasks = Lists.newArrayList();
    private volatile long usedQuotaDataBytes = -1L;

    protected void readLock() {
        this.transactionLock.readLock().lock();
    }

    protected void readUnlock() {
        this.transactionLock.readLock().unlock();
    }

    protected void writeLock() {
        this.transactionLock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.transactionLock.writeLock().unlock();
    }

    public DatabaseTransactionMgr(long dbId, Catalog catalog, TransactionIdGenerator idGenerator) {
        this.dbId = dbId;
        this.catalog = catalog;
        this.idGenerator = idGenerator;
        this.editLog = catalog.getEditLog();
    }

    public long getDbId() {
        return this.dbId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getTransactionState(Long transactionId) {
        this.readLock();
        try {
            TransactionState transactionState = this.idToRunningTransactionState.get(transactionId);
            if (transactionState != null) {
                TransactionState transactionState2 = transactionState;
                return transactionState2;
            }
            TransactionState transactionState3 = this.idToFinalStatusTransactionState.get(transactionId);
            return transactionState3;
        }
        finally {
            this.readUnlock();
        }
    }

    private TransactionState unprotectedGetTransactionState(Long transactionId) {
        TransactionState transactionState = this.idToRunningTransactionState.get(transactionId);
        if (transactionState != null) {
            return transactionState;
        }
        return this.idToFinalStatusTransactionState.get(transactionId);
    }

    @VisibleForTesting
    protected Set<Long> unprotectedGetTxnIdsByLabel(String label) {
        return this.labelToTxnIds.get(label);
    }

    public int getRunningTxnNums() {
        return this.runningTxnNums;
    }

    protected int getRunningRoutineLoadTxnNums() {
        return this.runningRoutineLoadTxnNums;
    }

    @VisibleForTesting
    protected int getFinishedTxnNums() {
        return this.idToFinalStatusTransactionState.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getTxnStateInfoList(boolean running, int limit) {
        ArrayList infos = Lists.newArrayList();
        Collection<TransactionState> transactionStateCollection = null;
        this.readLock();
        try {
            transactionStateCollection = running ? this.idToRunningTransactionState.values() : this.idToFinalStatusTransactionState.values();
            transactionStateCollection.stream().sorted(TransactionState.TXN_ID_COMPARATOR).limit(limit).forEach(t -> {
                ArrayList info = Lists.newArrayList();
                this.getTxnStateInfo((TransactionState)t, info);
                infos.add(info);
            });
        }
        finally {
            this.readUnlock();
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getTxnStateInfoList(TransactionStatus status) {
        ArrayList infos = Lists.newArrayList();
        Collection<TransactionState> transactionStateCollection = null;
        this.readLock();
        try {
            transactionStateCollection = status == TransactionStatus.VISIBLE || status == TransactionStatus.ABORTED ? this.idToFinalStatusTransactionState.values() : this.idToRunningTransactionState.values();
            transactionStateCollection.stream().filter(transactionState -> transactionState.getTransactionStatus() == status).sorted(TransactionState.TXN_ID_COMPARATOR).forEach(t -> {
                ArrayList info = Lists.newArrayList();
                this.getTxnStateInfo((TransactionState)t, info);
                infos.add(info);
            });
        }
        finally {
            this.readUnlock();
        }
        return infos;
    }

    private void getTxnStateInfo(TransactionState txnState, List<String> info) {
        info.add(String.valueOf(txnState.getTransactionId()));
        info.add(txnState.getLabel());
        info.add(txnState.getCoordinator().toString());
        info.add(txnState.getTransactionStatus().name());
        info.add(txnState.getSourceType().name());
        info.add(TimeUtils.longToTimeString(txnState.getPrepareTime()));
        info.add(TimeUtils.longToTimeString(txnState.getPreCommitTime()));
        info.add(TimeUtils.longToTimeString(txnState.getCommitTime()));
        info.add(TimeUtils.longToTimeString(txnState.getPublishVersionTime()));
        info.add(TimeUtils.longToTimeString(txnState.getFinishTime()));
        info.add(txnState.getReason());
        info.add(String.valueOf(txnState.getErrorReplicas().size()));
        info.add(String.valueOf(txnState.getCallbackId()));
        info.add(String.valueOf(txnState.getTimeoutMs()));
        info.add(txnState.getErrMsg());
    }

    public long beginTransaction(List<Long> tableIdList, String label, TUniqueId requestId, TransactionState.TxnCoordinator coordinator, TransactionState.LoadJobSourceType sourceType, long listenerId, long timeoutSecond) throws DuplicatedRequestException, LabelAlreadyUsedException, BeginTransactionException, AnalysisException, QuotaExceedException, MetaNotFoundException {
        this.checkDatabaseDataQuota();
        this.writeLock();
        try {
            Preconditions.checkNotNull((Object)coordinator);
            Preconditions.checkNotNull((Object)label);
            FeNameFormat.checkLabel(label);
            Set<Long> existingTxnIds = this.unprotectedGetTxnIdsByLabel(label);
            if (existingTxnIds != null && !existingTxnIds.isEmpty()) {
                ArrayList notAbortedTxns = Lists.newArrayList();
                for (long txnId : existingTxnIds) {
                    TransactionState txn = this.unprotectedGetTransactionState(txnId);
                    Preconditions.checkNotNull((Object)txn);
                    if (txn.getTransactionStatus() == TransactionStatus.ABORTED) continue;
                    notAbortedTxns.add(txn);
                }
                Preconditions.checkState((notAbortedTxns.size() <= 1 ? 1 : 0) != 0, (Object)notAbortedTxns);
                if (!notAbortedTxns.isEmpty()) {
                    TransactionState notAbortedTxn = (TransactionState)notAbortedTxns.get(0);
                    if (requestId != null && (notAbortedTxn.getTransactionStatus() == TransactionStatus.PREPARE || notAbortedTxn.getTransactionStatus() == TransactionStatus.PRECOMMITTED) && notAbortedTxn.getRequestId() != null && notAbortedTxn.getRequestId().equals(requestId)) {
                        throw new DuplicatedRequestException(DebugUtil.printId(requestId), notAbortedTxn.getTransactionId(), "");
                    }
                    throw new LabelAlreadyUsedException(notAbortedTxn);
                }
            }
            this.checkRunningTxnExceedLimit(sourceType);
            long tid = this.idGenerator.getNextTransactionId();
            LOG.info("begin transaction: txn id {} with label {} from coordinator {}, listner id: {}", (Object)tid, (Object)label, (Object)coordinator, (Object)listenerId);
            TransactionState transactionState = new TransactionState(this.dbId, tableIdList, tid, label, requestId, sourceType, coordinator, listenerId, timeoutSecond * 1000L);
            transactionState.setPrepareTime(System.currentTimeMillis());
            this.unprotectUpsertTransactionState(transactionState, false);
            if (MetricRepo.isInit) {
                MetricRepo.COUNTER_TXN_BEGIN.increase(1L);
            }
            long l = tid;
            return l;
        }
        catch (DuplicatedRequestException e) {
            throw e;
        }
        catch (Exception e) {
            if (MetricRepo.isInit) {
                MetricRepo.COUNTER_TXN_REJECT.increase(1L);
            }
            throw e;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void checkDatabaseDataQuota() throws MetaNotFoundException, QuotaExceedException {
        long dataQuotaBytes;
        Database db = this.catalog.getDbOrMetaException(this.dbId);
        if (this.usedQuotaDataBytes == -1L) {
            this.usedQuotaDataBytes = db.getUsedDataQuotaWithLock();
        }
        if (this.usedQuotaDataBytes >= (dataQuotaBytes = db.getDataQuota())) {
            throw new QuotaExceedException(db.getFullName(), dataQuotaBytes);
        }
    }

    public void updateDatabaseUsedQuotaData(long usedQuotaDataBytes) {
        this.usedQuotaDataBytes = usedQuotaDataBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommitTransaction2PC(List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, TxnCommitAttachment txnCommitAttachment) throws UserException {
        TransactionState transactionState;
        Database db = this.catalog.getDbOrMetaException(this.dbId);
        this.readLock();
        try {
            transactionState = this.unprotectedGetTransactionState(transactionId);
        }
        finally {
            this.readUnlock();
        }
        if (transactionState == null || transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
            throw new TransactionCommitFailedException(transactionState == null ? "transaction not found" : transactionState.getReason());
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.VISIBLE) {
            LOG.debug("transaction is already visible: {}", (Object)transactionId);
            throw new TransactionCommitFailedException("transaction is already visible");
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.COMMITTED) {
            LOG.debug("transaction is already committed: {}", (Object)transactionId);
            throw new TransactionCommitFailedException("transaction is already committed");
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.PRECOMMITTED) {
            LOG.debug("transaction is already pre-committed: {}", (Object)transactionId);
            return;
        }
        HashSet errorReplicaIds = Sets.newHashSet();
        HashSet totalInvolvedBackends = Sets.newHashSet();
        HashMap<Long, Set<Long>> tableToPartition = new HashMap<Long, Set<Long>>();
        this.checkCommitStatus(tableList, transactionState, tabletCommitInfos, txnCommitAttachment, errorReplicaIds, tableToPartition, totalInvolvedBackends);
        this.unprotectedPreCommitTransaction2PC(transactionState, errorReplicaIds, tableToPartition, totalInvolvedBackends, db);
        LOG.info("transaction:[{}] successfully pre-committed", (Object)transactionState);
    }

    private void checkCommitStatus(List<Table> tableList, TransactionState transactionState, List<TabletCommitInfo> tabletCommitInfos, TxnCommitAttachment txnCommitAttachment, Set<Long> errorReplicaIds, Map<Long, Set<Long>> tableToPartition, Set<Long> totalInvolvedBackends) throws UserException {
        Database db = this.catalog.getDbOrMetaException(this.dbId);
        if (txnCommitAttachment != null) {
            transactionState.setTxnCommitAttachment(txnCommitAttachment);
        }
        TabletInvertedIndex tabletInvertedIndex = this.catalog.getTabletInvertedIndex();
        HashMap tabletToBackends = new HashMap();
        HashMap<Long, Table> idToTable = new HashMap<Long, Table>();
        for (int i = 0; i < tableList.size(); ++i) {
            idToTable.put(tableList.get(i).getId(), tableList.get(i));
        }
        List<Long> tabletIds = tabletCommitInfos.stream().map(tabletCommitInfo -> tabletCommitInfo.getTabletId()).collect(Collectors.toList());
        List<TabletMeta> tabletMetaList = tabletInvertedIndex.getTabletMetaList(tabletIds);
        for (int i = 0; i < tabletMetaList.size(); ++i) {
            TabletMeta tabletMeta = tabletMetaList.get(i);
            if (tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) continue;
            long tabletId = tabletIds.get(i);
            long tableId = tabletMeta.getTableId();
            OlapTable tbl = (OlapTable)idToTable.get(tableId);
            if (tbl == null) continue;
            if (tbl.getState() == OlapTable.OlapTableState.RESTORE) {
                throw new LoadException("Table " + tbl.getName() + " is in restore process. Can not load into it");
            }
            long partitionId = tabletMeta.getPartitionId();
            if (tbl.getPartition(partitionId) == null) continue;
            if (!tableToPartition.containsKey(tableId)) {
                tableToPartition.put(tableId, new HashSet());
            }
            tableToPartition.get(tableId).add(partitionId);
            if (!tabletToBackends.containsKey(tabletId)) {
                tabletToBackends.put(tabletId, new HashSet());
            }
            ((Set)tabletToBackends.get(tabletId)).add(tabletCommitInfos.get(i).getBackendId());
        }
        for (long tableId : tableToPartition.keySet()) {
            OlapTable table = (OlapTable)db.getTableOrMetaException(tableId);
            for (Partition partition : table.getAllPartitions()) {
                List<Object> allIndices;
                if (!tableToPartition.get(tableId).contains(partition.getId())) continue;
                if (transactionState.getLoadedTblIndexes().isEmpty()) {
                    allIndices = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                } else {
                    allIndices = Lists.newArrayList();
                    for (long indexId : transactionState.getLoadedTblIndexes().get(tableId)) {
                        MaterializedIndex index = partition.getIndex(indexId);
                        if (index == null) continue;
                        allIndices.add(index);
                    }
                }
                if (table.getState() == OlapTable.OlapTableState.ROLLUP || table.getState() == OlapTable.OlapTableState.SCHEMA_CHANGE) {
                    transactionState.prolongPublishTimeout();
                }
                int quorumReplicaNum = table.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum() / 2 + 1;
                for (MaterializedIndex materializedIndex : allIndices) {
                    for (Tablet tablet : materializedIndex.getTablets()) {
                        int successReplicaNum = 0;
                        long tabletId = tablet.getId();
                        Set<Long> tabletBackends = tablet.getBackendIds();
                        totalInvolvedBackends.addAll(tabletBackends);
                        Set commitBackends = (Set)tabletToBackends.get(tabletId);
                        HashSet errorBackendIdsForTablet = Sets.newHashSet();
                        for (long tabletBackend : tabletBackends) {
                            Replica replica = tabletInvertedIndex.getReplica(tabletId, tabletBackend);
                            if (replica == null) {
                                throw new TransactionCommitFailedException("could not find replica for tablet [" + tabletId + "], backend [" + tabletBackend + "]");
                            }
                            if (commitBackends != null && commitBackends.contains(tabletBackend)) {
                                if (replica.getLastFailedVersion() >= 0L) continue;
                                ++successReplicaNum;
                                continue;
                            }
                            errorBackendIdsForTablet.add(tabletBackend);
                            errorReplicaIds.add(replica.getId());
                        }
                        if (successReplicaNum >= quorumReplicaNum) continue;
                        LOG.warn("Failed to commit txn [{}]. Tablet [{}] success replica num is {} < quorum replica num {} while error backends {}", (Object)transactionState.getTransactionId(), (Object)tablet.getId(), (Object)successReplicaNum, (Object)quorumReplicaNum, (Object)Joiner.on((String)",").join((Iterable)errorBackendIdsForTablet));
                        throw new TabletQuorumFailedException(transactionState.getTransactionId(), tablet.getId(), successReplicaNum, quorumReplicaNum, errorBackendIdsForTablet);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(List<Table> tableList, long transactionId, List<TabletCommitInfo> tabletCommitInfos, TxnCommitAttachment txnCommitAttachment, Boolean is2PC) throws UserException {
        TransactionState transactionState;
        Database db = this.catalog.getDbOrMetaException(this.dbId);
        this.readLock();
        try {
            transactionState = this.unprotectedGetTransactionState(transactionId);
        }
        finally {
            this.readUnlock();
        }
        if (transactionState == null) {
            LOG.debug("transaction not found: {}", (Object)transactionId);
            throw new TransactionCommitFailedException("transaction [" + transactionId + "] not found.");
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
            LOG.debug("transaction is already aborted: {}", (Object)transactionId);
            throw new TransactionCommitFailedException("transaction [" + transactionId + "] is already aborted. abort reason: " + transactionState.getReason());
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.VISIBLE) {
            LOG.debug("transaction is already visible: {}", (Object)transactionId);
            if (is2PC.booleanValue()) {
                throw new TransactionCommitFailedException("transaction [" + transactionId + "] is already visible, not pre-committed.");
            }
            return;
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.COMMITTED) {
            LOG.debug("transaction is already committed: {}", (Object)transactionId);
            if (is2PC.booleanValue()) {
                throw new TransactionCommitFailedException("transaction [" + transactionId + "] is already committed, not pre-committed.");
            }
            return;
        }
        if (is2PC.booleanValue() && transactionState.getTransactionStatus() == TransactionStatus.PREPARE) {
            LOG.debug("transaction is prepare, not pre-committed: {}", (Object)transactionId);
            throw new TransactionCommitFailedException("transaction [" + transactionId + "] is prepare, not pre-committed.");
        }
        HashSet errorReplicaIds = Sets.newHashSet();
        HashSet totalInvolvedBackends = Sets.newHashSet();
        HashMap<Long, Set<Long>> tableToPartition = new HashMap<Long, Set<Long>>();
        if (!is2PC.booleanValue()) {
            this.checkCommitStatus(tableList, transactionState, tabletCommitInfos, txnCommitAttachment, errorReplicaIds, tableToPartition, totalInvolvedBackends);
        }
        transactionState.beforeStateTransform(TransactionStatus.COMMITTED);
        boolean txnOperated = false;
        this.writeLock();
        try {
            if (is2PC.booleanValue()) {
                this.unprotectedCommitTransaction2PC(transactionState, db);
            } else {
                this.unprotectedCommitTransaction(transactionState, errorReplicaIds, tableToPartition, totalInvolvedBackends, db);
            }
            txnOperated = true;
        }
        finally {
            this.writeUnlock();
            transactionState.afterStateTransform(TransactionStatus.COMMITTED, txnOperated);
        }
        this.updateCatalogAfterCommitted(transactionState, db);
        LOG.info("transaction:[{}] successfully committed", (Object)transactionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTransactionFinished(Database db, long transactionId, long timeoutMillis) throws TransactionCommitFailedException {
        TransactionState transactionState = null;
        this.readLock();
        try {
            transactionState = this.unprotectedGetTransactionState(transactionId);
        }
        finally {
            this.readUnlock();
        }
        switch (transactionState.getTransactionStatus()) {
            case COMMITTED: 
            case VISIBLE: {
                break;
            }
            default: {
                LOG.warn("transaction commit failed, db={}, txn={}", (Object)db.getFullName(), (Object)transactionId);
                throw new TransactionCommitFailedException("transaction commit failed");
            }
        }
        long currentTimeMillis = System.currentTimeMillis();
        long timeoutTimeMillis = currentTimeMillis + timeoutMillis;
        while (currentTimeMillis < timeoutTimeMillis && transactionState.getTransactionStatus() == TransactionStatus.COMMITTED) {
            try {
                transactionState.waitTransactionVisible(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentTimeMillis = System.currentTimeMillis();
        }
        return transactionState.getTransactionStatus() == TransactionStatus.VISIBLE;
    }

    @Deprecated
    public void replayDeleteTransaction(TransactionState transactionState) {
        this.writeLock();
        try {
            if (!this.finalStatusTransactionStateDequeShort.isEmpty() && transactionState.getTransactionId() == this.finalStatusTransactionStateDequeShort.getFirst().getTransactionId()) {
                this.finalStatusTransactionStateDequeShort.pop();
                this.clearTransactionState(transactionState.getTransactionId());
            } else if (!this.finalStatusTransactionStateDequeLong.isEmpty() && transactionState.getTransactionId() == this.finalStatusTransactionStateDequeLong.getFirst().getTransactionId()) {
                this.finalStatusTransactionStateDequeLong.pop();
                this.clearTransactionState(transactionState.getTransactionId());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayBatchRemoveTransaction(List<Long> txnIds) {
        this.writeLock();
        try {
            for (Long txnId : txnIds) {
                if (!this.finalStatusTransactionStateDequeShort.isEmpty() && txnId.longValue() == this.finalStatusTransactionStateDequeShort.getFirst().getTransactionId()) {
                    this.finalStatusTransactionStateDequeShort.pop();
                    this.clearTransactionState(txnId);
                    continue;
                }
                if (this.finalStatusTransactionStateDequeLong.isEmpty() || txnId.longValue() != this.finalStatusTransactionStateDequeLong.getFirst().getTransactionId()) continue;
                this.finalStatusTransactionStateDequeLong.pop();
                this.clearTransactionState(txnId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStatus getLabelState(String label) {
        this.readLock();
        try {
            Set<Long> existingTxnIds = this.unprotectedGetTxnIdsByLabel(label);
            if (existingTxnIds == null || existingTxnIds.isEmpty()) {
                TransactionStatus transactionStatus = TransactionStatus.UNKNOWN;
                return transactionStatus;
            }
            long maxTxnId = existingTxnIds.stream().max(Comparator.comparingLong(Long::valueOf)).get();
            TransactionStatus transactionStatus = this.unprotectedGetTransactionState(maxTxnId).getTransactionStatus();
            return transactionStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTransactionId(String label) {
        this.readLock();
        try {
            Set<Long> existingTxnIds = this.unprotectedGetTxnIdsByLabel(label);
            if (existingTxnIds == null || existingTxnIds.isEmpty()) {
                Long l = null;
                return l;
            }
            Long l = existingTxnIds.stream().max(Comparator.comparingLong(Long::valueOf)).get();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<TransactionState> getPreCommittedTxnList() {
        this.readLock();
        try {
            List<TransactionState> list = this.idToRunningTransactionState.values().stream().filter(transactionState -> transactionState.getTransactionStatus() == TransactionStatus.PRECOMMITTED).sorted(Comparator.comparing(TransactionState::getPreCommitTime)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<TransactionState> getCommittedTxnList() {
        this.readLock();
        try {
            List<TransactionState> list = this.idToRunningTransactionState.values().stream().filter(transactionState -> transactionState.getTransactionStatus() == TransactionStatus.COMMITTED).sorted(Comparator.comparing(TransactionState::getCommitTime)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishTransaction(long transactionId, Set<Long> errorReplicaIds) throws UserException {
        Set<Long> originalErrorReplicas;
        TransactionState transactionState = null;
        this.readLock();
        try {
            transactionState = this.unprotectedGetTransactionState(transactionId);
        }
        finally {
            this.readUnlock();
        }
        if (errorReplicaIds == null) {
            errorReplicaIds = Sets.newHashSet();
        }
        if ((originalErrorReplicas = transactionState.getErrorReplicas()) != null) {
            errorReplicaIds.addAll(originalErrorReplicas);
        }
        Database db = this.catalog.getDbOrMetaException(transactionState.getDbId());
        List<Long> tableIdList = transactionState.getTableIdList();
        List<Table> tableList = db.getTablesOnIdOrderIfExist(tableIdList);
        tableList = MetaLockUtils.writeLockTablesIfExist(tableList);
        try {
            boolean hasError = false;
            Iterator<TableCommitInfo> tableCommitInfoIterator = transactionState.getIdToTableCommitInfos().values().iterator();
            while (tableCommitInfoIterator.hasNext()) {
                TableCommitInfo tableCommitInfo = tableCommitInfoIterator.next();
                long tableId = tableCommitInfo.getTableId();
                OlapTable table = (OlapTable)db.getTableNullable(tableId);
                if (table == null) {
                    tableCommitInfoIterator.remove();
                    LOG.warn("table {} is dropped, skip version check and remove it from transaction state {}", (Object)tableId, (Object)transactionState);
                    continue;
                }
                PartitionInfo partitionInfo = table.getPartitionInfo();
                Iterator<PartitionCommitInfo> partitionCommitInfoIterator = tableCommitInfo.getIdToPartitionCommitInfo().values().iterator();
                while (partitionCommitInfoIterator.hasNext()) {
                    List<Object> allIndices;
                    PartitionCommitInfo partitionCommitInfo = partitionCommitInfoIterator.next();
                    long partitionId = partitionCommitInfo.getPartitionId();
                    Partition partition = table.getPartition(partitionId);
                    if (partition == null) {
                        partitionCommitInfoIterator.remove();
                        LOG.warn("partition {} is dropped, skip version check and remove it from transaction state {}", (Object)partitionId, (Object)transactionState);
                        continue;
                    }
                    if (partition.getVisibleVersion() != partitionCommitInfo.getVersion() - 1L) {
                        LOG.debug("transactionId {} partition commitInfo version {} is not equal with partition visible version {} plus one, need wait", (Object)transactionId, (Object)partitionCommitInfo.getVersion(), (Object)partition.getVisibleVersion());
                        String errMsg = String.format("wait for publishing partition %d version %d. self version: %d. table %d", partitionId, partition.getVisibleVersion() + 1L, partitionCommitInfo.getVersion(), tableId);
                        transactionState.setErrorMsg(errMsg);
                        return;
                    }
                    int quorumReplicaNum = partitionInfo.getReplicaAllocation(partitionId).getTotalReplicaNum() / 2 + 1;
                    if (transactionState.getLoadedTblIndexes().isEmpty()) {
                        allIndices = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                    } else {
                        allIndices = Lists.newArrayList();
                        Iterator<Object> iterator = transactionState.getLoadedTblIndexes().get(tableId).iterator();
                        while (iterator.hasNext()) {
                            long l = (Long)iterator.next();
                            MaterializedIndex index = partition.getIndex(l);
                            if (index == null) continue;
                            allIndices.add(index);
                        }
                    }
                    for (MaterializedIndex materializedIndex : allIndices) {
                        for (Tablet tablet : materializedIndex.getTablets()) {
                            int healthReplicaNum = 0;
                            for (Replica replica : tablet.getReplicas()) {
                                if (!errorReplicaIds.contains(replica.getId()) && replica.getLastFailedVersion() < 0L) {
                                    if (!replica.checkVersionCatchUp(partition.getVisibleVersion(), true)) continue;
                                    ++healthReplicaNum;
                                    continue;
                                }
                                if (replica.getVersion() < partitionCommitInfo.getVersion()) continue;
                                errorReplicaIds.remove(replica.getId());
                                ++healthReplicaNum;
                            }
                            if (healthReplicaNum >= quorumReplicaNum) continue;
                            LOG.info("publish version failed for transaction {} on tablet {}, with only {} replicas less than quorum {}", (Object)transactionState, (Object)tablet, (Object)healthReplicaNum, (Object)quorumReplicaNum);
                            String errMsg = String.format("publish on tablet %d failed. succeed replica num %d less than quorum %d. table: %d, partition: %d, publish version: %d", tablet.getId(), healthReplicaNum, quorumReplicaNum, tableId, partitionId, partition.getVisibleVersion() + 1L);
                            transactionState.setErrorMsg(errMsg);
                            hasError = true;
                        }
                    }
                }
            }
            if (hasError) {
                return;
            }
            boolean txnOperated = false;
            this.writeLock();
            try {
                transactionState.setErrorReplicas(errorReplicaIds);
                transactionState.setFinishTime(System.currentTimeMillis());
                transactionState.clearErrorMsg();
                transactionState.setTransactionStatus(TransactionStatus.VISIBLE);
                this.unprotectUpsertTransactionState(transactionState, false);
                txnOperated = true;
                LOG.debug("after set transaction {} to visible", (Object)transactionState);
            }
            finally {
                this.writeUnlock();
                transactionState.afterStateTransform(TransactionStatus.VISIBLE, txnOperated);
            }
            this.updateCatalogAfterVisible(transactionState, db);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
        LOG.info("finish transaction {} successfully", (Object)transactionState);
    }

    protected void unprotectedPreCommitTransaction2PC(TransactionState transactionState, Set<Long> errorReplicaIds, Map<Long, Set<Long>> tableToPartition, Set<Long> totalInvolvedBackends, Database db) {
        if (transactionState.getTransactionStatus() != TransactionStatus.PREPARE) {
            return;
        }
        transactionState.setPreCommitTime(System.currentTimeMillis());
        transactionState.setTransactionStatus(TransactionStatus.PRECOMMITTED);
        transactionState.setErrorReplicas(errorReplicaIds);
        for (long tableId : tableToPartition.keySet()) {
            TableCommitInfo tableCommitInfo = new TableCommitInfo(tableId);
            for (long partitionId : tableToPartition.get(tableId)) {
                PartitionCommitInfo partitionCommitInfo = new PartitionCommitInfo(partitionId, -1L, -1L);
                tableCommitInfo.addPartitionCommitInfo(partitionCommitInfo);
            }
            transactionState.putIdToTableCommitInfo(tableId, tableCommitInfo);
        }
        this.unprotectUpsertTransactionState(transactionState, false);
        for (long backendId : totalInvolvedBackends) {
            transactionState.addPublishVersionTask(backendId, null);
        }
    }

    protected void unprotectedCommitTransaction(TransactionState transactionState, Set<Long> errorReplicaIds, Map<Long, Set<Long>> tableToPartition, Set<Long> totalInvolvedBackends, Database db) {
        if (transactionState.getTransactionStatus() != TransactionStatus.PREPARE) {
            return;
        }
        transactionState.setCommitTime(System.currentTimeMillis());
        transactionState.setTransactionStatus(TransactionStatus.COMMITTED);
        transactionState.setErrorReplicas(errorReplicaIds);
        for (long tableId : tableToPartition.keySet()) {
            TableCommitInfo tableCommitInfo = new TableCommitInfo(tableId);
            for (long partitionId : tableToPartition.get(tableId)) {
                OlapTable table = (OlapTable)db.getTableNullable(tableId);
                Partition partition = table.getPartition(partitionId);
                PartitionCommitInfo partitionCommitInfo = new PartitionCommitInfo(partitionId, partition.getNextVersion(), System.currentTimeMillis());
                tableCommitInfo.addPartitionCommitInfo(partitionCommitInfo);
            }
            transactionState.putIdToTableCommitInfo(tableId, tableCommitInfo);
        }
        this.unprotectUpsertTransactionState(transactionState, false);
        for (long backendId : totalInvolvedBackends) {
            transactionState.addPublishVersionTask(backendId, null);
        }
    }

    protected void unprotectedCommitTransaction2PC(TransactionState transactionState, Database db) {
        if (transactionState.getTransactionStatus() != TransactionStatus.PRECOMMITTED) {
            LOG.warn("Unknow exception. state of transaction [{}] changed, failed to commit transaction", (Object)transactionState.getTransactionId());
            return;
        }
        transactionState.setCommitTime(System.currentTimeMillis());
        transactionState.setTransactionStatus(TransactionStatus.COMMITTED);
        Iterator<TableCommitInfo> tableCommitInfoIterator = transactionState.getIdToTableCommitInfos().values().iterator();
        while (tableCommitInfoIterator.hasNext()) {
            TableCommitInfo tableCommitInfo = tableCommitInfoIterator.next();
            long tableId = tableCommitInfo.getTableId();
            OlapTable table = (OlapTable)db.getTableNullable(tableId);
            if (table == null) {
                tableCommitInfoIterator.remove();
                LOG.warn("table {} is dropped, skip and remove it from transaction state {}", (Object)tableId, (Object)transactionState);
                continue;
            }
            Iterator<PartitionCommitInfo> partitionCommitInfoIterator = tableCommitInfo.getIdToPartitionCommitInfo().values().iterator();
            while (partitionCommitInfoIterator.hasNext()) {
                PartitionCommitInfo partitionCommitInfo = partitionCommitInfoIterator.next();
                long partitionId = partitionCommitInfo.getPartitionId();
                Partition partition = table.getPartition(partitionId);
                if (partition == null) {
                    partitionCommitInfoIterator.remove();
                    LOG.warn("partition {} is dropped, skip and remove it from transaction state {}", (Object)partitionId, (Object)transactionState);
                    continue;
                }
                partitionCommitInfo.setVersion(partition.getNextVersion());
                partitionCommitInfo.setVersionTime(System.currentTimeMillis());
            }
        }
        this.editLog.logInsertTransactionState(transactionState);
    }

    protected void unprotectUpsertTransactionState(TransactionState transactionState, boolean isReplay) {
        if (!(isReplay || transactionState.getTransactionStatus() == TransactionStatus.PREPARE && transactionState.getSourceType() != TransactionState.LoadJobSourceType.FRONTEND)) {
            this.editLog.logInsertTransactionState(transactionState);
        }
        if (!transactionState.getTransactionStatus().isFinalStatus()) {
            if (this.idToRunningTransactionState.put(transactionState.getTransactionId(), transactionState) == null) {
                if (transactionState.getSourceType() == TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK) {
                    ++this.runningRoutineLoadTxnNums;
                } else {
                    ++this.runningTxnNums;
                }
            }
        } else {
            if (this.idToRunningTransactionState.remove(transactionState.getTransactionId()) != null) {
                if (transactionState.getSourceType() == TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK) {
                    --this.runningRoutineLoadTxnNums;
                } else {
                    --this.runningTxnNums;
                }
            }
            this.idToFinalStatusTransactionState.put(transactionState.getTransactionId(), transactionState);
            if (transactionState.isShortTxn()) {
                this.finalStatusTransactionStateDequeShort.add(transactionState);
            } else {
                this.finalStatusTransactionStateDequeLong.add(transactionState);
            }
        }
        this.updateTxnLabels(transactionState);
    }

    private void updateTxnLabels(TransactionState transactionState) {
        HashSet txnIds = this.labelToTxnIds.get(transactionState.getLabel());
        if (txnIds == null) {
            txnIds = Sets.newHashSet();
            this.labelToTxnIds.put(transactionState.getLabel(), txnIds);
        }
        txnIds.add(transactionState.getTransactionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransaction(String label, String reason) throws UserException {
        Preconditions.checkNotNull((Object)label);
        long transactionId = -1L;
        this.readLock();
        try {
            Set<Long> existingTxns = this.unprotectedGetTxnIdsByLabel(label);
            if (existingTxns == null || existingTxns.isEmpty()) {
                throw new TransactionNotFoundException("transaction not found, label=" + label);
            }
            TransactionState prepareTxn = null;
            for (Long txnId : existingTxns) {
                TransactionState txn = this.unprotectedGetTransactionState(txnId);
                if (txn.getTransactionStatus() != TransactionStatus.PREPARE) continue;
                prepareTxn = txn;
                break;
            }
            if (prepareTxn == null) {
                throw new TransactionNotFoundException("running transaction not found, label=" + label);
            }
            transactionId = prepareTxn.getTransactionId();
        }
        finally {
            this.readUnlock();
        }
        this.abortTransaction(transactionId, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransaction(long transactionId, String reason, TxnCommitAttachment txnCommitAttachment) throws UserException {
        if (transactionId < 0L) {
            LOG.info("transaction id is {}, less than 0, maybe this is an old type load job, ignore abort operation", (Object)transactionId);
            return;
        }
        TransactionState transactionState = null;
        this.readLock();
        try {
            transactionState = this.idToRunningTransactionState.get(transactionId);
        }
        finally {
            this.readUnlock();
        }
        if (transactionState == null) {
            throw new TransactionNotFoundException("transaction not found", transactionId);
        }
        if (txnCommitAttachment != null) {
            transactionState.setTxnCommitAttachment(txnCommitAttachment);
        }
        transactionState.beforeStateTransform(TransactionStatus.ABORTED);
        boolean txnOperated = false;
        this.writeLock();
        try {
            txnOperated = this.unprotectAbortTransaction(transactionId, reason);
        }
        finally {
            this.writeUnlock();
            transactionState.afterStateTransform(TransactionStatus.ABORTED, txnOperated, reason);
        }
        if (txnOperated && transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
            this.clearBackendTransactions(transactionState);
        }
        LOG.info("abort transaction: {} successfully", (Object)transactionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransaction2PC(long transactionId) throws UserException {
        TransactionState transactionState;
        LOG.info("begin to abort txn {}", (Object)transactionId);
        if (transactionId < 0L) {
            LOG.info("transaction id is {}, less than 0, maybe this is an old type load job, ignore abort operation", (Object)transactionId);
            return;
        }
        this.readLock();
        try {
            transactionState = this.unprotectedGetTransactionState(transactionId);
        }
        finally {
            this.readUnlock();
        }
        if (transactionState == null) {
            throw new TransactionNotFoundException("transaction [" + transactionId + "] not found");
        }
        transactionState.beforeStateTransform(TransactionStatus.ABORTED);
        boolean txnOperated = false;
        this.writeLock();
        try {
            txnOperated = this.unprotectAbortTransaction(transactionId, "User Abort");
        }
        finally {
            this.writeUnlock();
            transactionState.afterStateTransform(TransactionStatus.ABORTED, txnOperated, "User Abort");
        }
        if (txnOperated && transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
            this.clearBackendTransactions(transactionState);
        }
        LOG.info("abort transaction: {} successfully", (Object)transactionState);
    }

    private boolean unprotectAbortTransaction(long transactionId, String reason) throws UserException {
        TransactionState transactionState = this.unprotectedGetTransactionState(transactionId);
        if (transactionState == null) {
            throw new TransactionNotFoundException("transaction [" + transactionId + "] not found.");
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
            throw new TransactionNotFoundException("transaction [" + transactionId + "] is already aborted, abort reason: " + transactionState.getReason());
        }
        if (transactionState.getTransactionStatus() == TransactionStatus.COMMITTED || transactionState.getTransactionStatus() == TransactionStatus.VISIBLE) {
            throw new UserException("transaction [" + transactionId + "] is already " + (Object)((Object)transactionState.getTransactionStatus()) + ", could not abort.");
        }
        transactionState.setFinishTime(System.currentTimeMillis());
        transactionState.setReason(reason);
        transactionState.setTransactionStatus(TransactionStatus.ABORTED);
        this.unprotectUpsertTransactionState(transactionState, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBackendTransactions(TransactionState transactionState) {
        Preconditions.checkState((transactionState.getTransactionStatus() == TransactionStatus.ABORTED ? 1 : 0) != 0);
        List<Long> allBeIds = Catalog.getCurrentSystemInfo().getBackendIds(false);
        AgentBatchTask batchTask = null;
        List<ClearTransactionTask> list = this.clearTransactionTasks;
        synchronized (list) {
            for (Long beId : allBeIds) {
                ClearTransactionTask task = new ClearTransactionTask(beId, transactionState.getTransactionId(), Lists.newArrayList());
                this.clearTransactionTasks.add(task);
            }
            if (this.clearTransactionTasks.size() > allBeIds.size() * 2) {
                batchTask = new AgentBatchTask();
                for (ClearTransactionTask clearTransactionTask : this.clearTransactionTasks) {
                    batchTask.addTask(clearTransactionTask);
                }
                this.clearTransactionTasks.clear();
            }
        }
        if (batchTask != null) {
            AgentTaskExecutor.submit(batchTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Comparable>> getTableTransInfo(long txnId) throws AnalysisException {
        ArrayList<List<Comparable>> tableInfos = new ArrayList<List<Comparable>>();
        this.readLock();
        try {
            TransactionState transactionState = this.unprotectedGetTransactionState(txnId);
            if (null == transactionState) {
                throw new AnalysisException("Transaction[" + txnId + "] does not exist.");
            }
            for (Map.Entry<Long, TableCommitInfo> entry : transactionState.getIdToTableCommitInfos().entrySet()) {
                ArrayList<Object> tableInfo = new ArrayList<Object>();
                tableInfo.add(entry.getKey());
                tableInfo.add(Joiner.on((String)", ").join((Iterable)entry.getValue().getIdToPartitionCommitInfo().values().stream().map(PartitionCommitInfo::getPartitionId).collect(Collectors.toList())));
                tableInfos.add(tableInfo);
            }
        }
        finally {
            this.readUnlock();
        }
        return tableInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Comparable>> getPartitionTransInfo(long txnId, long tableId) throws AnalysisException {
        ArrayList<List<Comparable>> partitionInfos = new ArrayList<List<Comparable>>();
        this.readLock();
        try {
            TransactionState transactionState = this.unprotectedGetTransactionState(txnId);
            if (null == transactionState) {
                throw new AnalysisException("Transaction[" + txnId + "] does not exist.");
            }
            TableCommitInfo tableCommitInfo = transactionState.getIdToTableCommitInfos().get(tableId);
            Map<Long, PartitionCommitInfo> idToPartitionCommitInfo = tableCommitInfo.getIdToPartitionCommitInfo();
            for (Map.Entry<Long, PartitionCommitInfo> entry : idToPartitionCommitInfo.entrySet()) {
                ArrayList<Comparable> partitionInfo = new ArrayList<Comparable>();
                partitionInfo.add(entry.getKey());
                partitionInfo.add(Long.valueOf(entry.getValue().getVersion()));
                partitionInfos.add(partitionInfo);
            }
        }
        finally {
            this.readUnlock();
        }
        return partitionInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredTxns(long currentMillis) {
        ArrayList expiredTxnIds = Lists.newArrayList();
        int leftNum = 10000;
        this.writeLock();
        try {
            leftNum = this.unprotectedRemoveExpiredTxns(currentMillis, expiredTxnIds, this.finalStatusTransactionStateDequeShort, leftNum);
            leftNum = this.unprotectedRemoveExpiredTxns(currentMillis, expiredTxnIds, this.finalStatusTransactionStateDequeLong, leftNum);
            if (!expiredTxnIds.isEmpty()) {
                HashMap dbExpiredTxnIds = Maps.newHashMap();
                dbExpiredTxnIds.put(this.dbId, expiredTxnIds);
                BatchRemoveTransactionsOperation op = new BatchRemoveTransactionsOperation(dbExpiredTxnIds);
                this.editLog.logBatchRemoveTransactions(op);
                LOG.info("Remove {} expired transactions", (Object)(10000 - leftNum));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private int unprotectedRemoveExpiredTxns(long currentMillis, List<Long> expiredTxnIds, ArrayDeque<TransactionState> finalStatusTransactionStateDequeShort, int maxNumber) {
        TransactionState transactionState;
        int left;
        for (left = maxNumber; !finalStatusTransactionStateDequeShort.isEmpty() && left > 0 && (transactionState = finalStatusTransactionStateDequeShort.getFirst()).isExpired(currentMillis); --left) {
            finalStatusTransactionStateDequeShort.pop();
            this.clearTransactionState(transactionState.getTransactionId());
            expiredTxnIds.add(transactionState.getTransactionId());
        }
        return left;
    }

    private void clearTransactionState(long txnId) {
        TransactionState transactionState = this.idToFinalStatusTransactionState.remove(txnId);
        if (transactionState != null) {
            Set<Long> txnIds = this.unprotectedGetTxnIdsByLabel(transactionState.getLabel());
            txnIds.remove(transactionState.getTransactionId());
            if (txnIds.isEmpty()) {
                this.labelToTxnIds.remove(transactionState.getLabel());
            }
            LOG.info("transaction [" + txnId + "] is expired, remove it from transaction manager");
        } else {
            LOG.warn("transaction state is not found when clear transaction: " + txnId);
        }
    }

    public int getTransactionNum() {
        return this.idToRunningTransactionState.size() + this.finalStatusTransactionStateDequeShort.size() + this.finalStatusTransactionStateDequeLong.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getTransactionStateByCallbackIdAndStatus(long callbackId, Set<TransactionStatus> status) {
        this.readLock();
        try {
            for (TransactionState txn : this.idToRunningTransactionState.values()) {
                if (txn.getCallbackId() != callbackId || !status.contains((Object)txn.getTransactionStatus())) continue;
                TransactionState transactionState = txn;
                return transactionState;
            }
            for (TransactionState txn : this.idToFinalStatusTransactionState.values()) {
                if (txn.getCallbackId() != callbackId || !status.contains((Object)txn.getTransactionStatus())) continue;
                TransactionState transactionState = txn;
                return transactionState;
            }
        }
        finally {
            this.readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getTransactionStateByCallbackId(long callbackId) {
        this.readLock();
        try {
            for (TransactionState txn : this.idToRunningTransactionState.values()) {
                if (txn.getCallbackId() != callbackId) continue;
                TransactionState transactionState = txn;
                return transactionState;
            }
            for (TransactionState txn : this.idToFinalStatusTransactionState.values()) {
                if (txn.getCallbackId() != callbackId) continue;
                TransactionState transactionState = txn;
                return transactionState;
            }
        }
        finally {
            this.readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<Long, Long>> getTransactionIdByCoordinateBe(String coordinateHost, int limit) {
        ArrayList<Pair<Long, Long>> txnInfos = new ArrayList<Pair<Long, Long>>();
        this.readLock();
        try {
            this.idToRunningTransactionState.values().stream().filter(t -> t.getCoordinator().sourceType == TransactionState.TxnSourceType.BE && t.getCoordinator().ip.equals(coordinateHost)).limit(limit).forEach(t -> txnInfos.add(new Pair<Long, Long>(t.getDbId(), t.getTransactionId())));
        }
        finally {
            this.readUnlock();
        }
        return txnInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getSingleTranInfo(long dbId, long txnId) throws AnalysisException {
        ArrayList<List<String>> infos = new ArrayList<List<String>>();
        this.readLock();
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbId);
            TransactionState txnState = this.unprotectedGetTransactionState(txnId);
            if (txnState == null) {
                throw new AnalysisException("transaction with id " + txnId + " does not exist");
            }
            if (ConnectContext.get() != null) {
                Set<Long> tblIds = txnState.getIdToTableCommitInfos().keySet();
                for (Long tblId : tblIds) {
                    Table tbl = db.getTableNullable(tblId);
                    if (tbl == null || Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), tbl.getName(), PrivPredicate.SHOW)) continue;
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW TRANSACTION", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), db.getFullName() + ": " + tbl.getName());
                }
            }
            ArrayList info = Lists.newArrayList();
            this.getTxnStateInfo(txnState, info);
            infos.add(info);
        }
        finally {
            this.readUnlock();
        }
        return infos;
    }

    protected void checkRunningTxnExceedLimit(TransactionState.LoadJobSourceType sourceType) throws BeginTransactionException {
        switch (sourceType) {
            case ROUTINE_LOAD_TASK: {
                break;
            }
            default: {
                if (this.runningTxnNums < Config.max_running_txn_num_per_db) break;
                throw new BeginTransactionException("current running txns on db " + this.dbId + " is " + this.runningTxnNums + ", larger than limit " + Config.max_running_txn_num_per_db);
            }
        }
    }

    private void updateCatalogAfterCommitted(TransactionState transactionState, Database db) {
        Set<Long> errorReplicaIds = transactionState.getErrorReplicas();
        for (TableCommitInfo tableCommitInfo : transactionState.getIdToTableCommitInfos().values()) {
            long tableId = tableCommitInfo.getTableId();
            OlapTable table = (OlapTable)db.getTableNullable(tableId);
            if (table == null) {
                LOG.warn("table {} does not exist when update catalog after committed. transaction: {}, db: {}", (Object)tableId, (Object)transactionState.getTransactionId(), (Object)db.getId());
                continue;
            }
            for (PartitionCommitInfo partitionCommitInfo : tableCommitInfo.getIdToPartitionCommitInfo().values()) {
                long partitionId = partitionCommitInfo.getPartitionId();
                Partition partition = table.getPartition(partitionId);
                if (partition == null) {
                    LOG.warn("partition {} of table {} does not exist when update catalog after committed. transaction: {}, db: {}", (Object)partitionId, (Object)tableId, (Object)transactionState.getTransactionId(), (Object)db.getId());
                    continue;
                }
                List<MaterializedIndex> allIndices = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                for (MaterializedIndex index : allIndices) {
                    List<Tablet> tablets = index.getTablets();
                    for (Tablet tablet : tablets) {
                        for (Replica replica : tablet.getReplicas()) {
                            if (!errorReplicaIds.contains(replica.getId())) continue;
                            replica.updateLastFailedVersion(partitionCommitInfo.getVersion());
                        }
                    }
                }
                partition.setNextVersion(partition.getNextVersion() + 1L);
            }
        }
    }

    private boolean updateCatalogAfterVisible(TransactionState transactionState, Database db) {
        Set<Long> errorReplicaIds = transactionState.getErrorReplicas();
        for (TableCommitInfo tableCommitInfo : transactionState.getIdToTableCommitInfos().values()) {
            long tableId = tableCommitInfo.getTableId();
            OlapTable table = (OlapTable)db.getTableNullable(tableId);
            if (table == null) {
                LOG.warn("table {} does not exist when update catalog after visible. transaction: {}, db: {}", (Object)tableId, (Object)transactionState.getTransactionId(), (Object)db.getId());
                continue;
            }
            for (PartitionCommitInfo partitionCommitInfo : tableCommitInfo.getIdToPartitionCommitInfo().values()) {
                long partitionId = partitionCommitInfo.getPartitionId();
                long newCommitVersion = partitionCommitInfo.getVersion();
                Partition partition = table.getPartition(partitionId);
                if (partition == null) {
                    LOG.warn("partition {} in table {} does not exist when update catalog after visible. transaction: {}, db: {}", (Object)partitionId, (Object)tableId, (Object)transactionState.getTransactionId(), (Object)db.getId());
                    continue;
                }
                List<MaterializedIndex> allIndices = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                for (MaterializedIndex index : allIndices) {
                    for (Tablet tablet : index.getTablets()) {
                        for (Replica replica : tablet.getReplicas()) {
                            long lastFailedVersion = replica.getLastFailedVersion();
                            long newVersion = newCommitVersion;
                            long lastSuccessVersion = replica.getLastSuccessVersion();
                            if (!errorReplicaIds.contains(replica.getId())) {
                                if (replica.getLastFailedVersion() > 0L) {
                                    newVersion = replica.getVersion();
                                } else if (!replica.checkVersionCatchUp(partition.getVisibleVersion(), true)) {
                                    lastFailedVersion = partition.getVisibleVersion();
                                    newVersion = replica.getVersion();
                                }
                                lastSuccessVersion = newCommitVersion;
                            } else {
                                newVersion = replica.getVersion();
                                if (newCommitVersion > lastFailedVersion) {
                                    lastFailedVersion = newCommitVersion;
                                }
                            }
                            replica.updateVersionWithFailedInfo(newVersion, lastFailedVersion, lastSuccessVersion);
                        }
                    }
                }
                long version = partitionCommitInfo.getVersion();
                long versionTime = partitionCommitInfo.getVersionTime();
                partition.updateVisibleVersionAndTime(version, versionTime);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("transaction state {} set partition {}'s version to [{}]", (Object)transactionState, (Object)partition.getId(), (Object)version);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPreviousTransactionsFinished(long endTransactionId, List<Long> tableIdList) {
        this.readLock();
        try {
            for (Map.Entry<Long, TransactionState> entry : this.idToRunningTransactionState.entrySet()) {
                if (entry.getValue().getDbId() != this.dbId || !this.isIntersectionNotEmpty(entry.getValue().getTableIdList(), tableIdList) || !entry.getValue().isRunning()) continue;
                if (entry.getKey() > endTransactionId) continue;
                LOG.debug("find a running txn with txn_id={} on db: {}, less than watermark txn_id {}", (Object)entry.getKey(), (Object)this.dbId, (Object)endTransactionId);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.readUnlock();
        }
        return true;
    }

    public boolean isIntersectionNotEmpty(List<Long> sourceTableIdList, List<Long> targetTableIdList) {
        if (CollectionUtils.isEmpty(sourceTableIdList) || CollectionUtils.isEmpty(targetTableIdList)) {
            return true;
        }
        for (Long srcValue : sourceTableIdList) {
            for (Long targetValue : targetTableIdList) {
                if (!srcValue.equals(targetValue)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTimeoutTxns(long currentMillis) {
        ArrayList timeoutTxns = Lists.newArrayList();
        this.readLock();
        try {
            for (TransactionState transactionState : this.idToRunningTransactionState.values()) {
                if (!transactionState.isTimeout(currentMillis)) continue;
                timeoutTxns.add(transactionState.getTransactionId());
            }
        }
        finally {
            this.readUnlock();
        }
        return timeoutTxns;
    }

    public void removeExpiredAndTimeoutTxns(long currentMillis) {
        this.removeExpiredTxns(currentMillis);
        List<Long> timeoutTxns = this.getTimeoutTxns(currentMillis);
        for (Long txnId : timeoutTxns) {
            try {
                this.abortTransaction(txnId, "timeout by txn manager", null);
                LOG.info("transaction [" + txnId + "] is timeout, abort it by transaction manager");
            }
            catch (UserException e) {
                LOG.warn("abort timeout txn {} failed. msg: {}", (Object)txnId, (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayUpsertTransactionState(TransactionState transactionState) throws MetaNotFoundException {
        boolean shouldAddTableListLock = transactionState.getTransactionStatus() == TransactionStatus.COMMITTED || transactionState.getTransactionStatus() == TransactionStatus.VISIBLE;
        Database db = null;
        List<Table> tableList = null;
        if (shouldAddTableListLock) {
            db = this.catalog.getDbOrMetaException(transactionState.getDbId());
            tableList = db.getTablesOnIdOrderIfExist(transactionState.getTableIdList());
            tableList = MetaLockUtils.writeLockTablesIfExist(tableList);
        }
        this.writeLock();
        try {
            transactionState.replaySetTransactionStatus();
            if (transactionState.getTransactionStatus() == TransactionStatus.COMMITTED) {
                LOG.info("replay a committed transaction {}", (Object)transactionState);
                this.updateCatalogAfterCommitted(transactionState, db);
            } else if (transactionState.getTransactionStatus() == TransactionStatus.VISIBLE) {
                LOG.info("replay a visible transaction {}", (Object)transactionState);
                this.updateCatalogAfterVisible(transactionState, db);
            }
            this.unprotectUpsertTransactionState(transactionState, true);
        }
        finally {
            this.writeUnlock();
            if (shouldAddTableListLock) {
                MetaLockUtils.writeUnlockTables(tableList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getDbTransStateInfo() {
        ArrayList infos = Lists.newArrayList();
        this.readLock();
        try {
            infos.add(Lists.newArrayList((Object[])new String[]{"running", String.valueOf(this.runningTxnNums + this.runningRoutineLoadTxnNums)}));
            long finishedNum = this.getFinishedTxnNums();
            infos.add(Lists.newArrayList((Object[])new String[]{"finished", String.valueOf(finishedNum)}));
        }
        finally {
            this.readUnlock();
        }
        return infos;
    }

    public void unprotectWriteAllTransactionStates(DataOutput out) throws IOException {
        for (Map.Entry<Long, TransactionState> entry : this.idToRunningTransactionState.entrySet()) {
            entry.getValue().write(out);
        }
        for (TransactionState transactionState : this.finalStatusTransactionStateDequeShort) {
            transactionState.write(out);
        }
        for (TransactionState transactionState : this.finalStatusTransactionStateDequeLong) {
            transactionState.write(out);
        }
    }
}

