/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.Map;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.doris.thrift.TUploadReq;

public class UploadTask
extends AgentTask {
    private long jobId;
    private Map<String, String> srcToDestPath;
    private FsBroker broker;
    private Map<String, String> brokerProperties;
    private StorageBackend.StorageType storageType;

    public UploadTask(TResourceInfo resourceInfo, long backendId, long signature, long jobId, Long dbId, Map<String, String> srcToDestPath, FsBroker broker, Map<String, String> brokerProperties, StorageBackend.StorageType storageType) {
        super(resourceInfo, backendId, TTaskType.UPLOAD, dbId, -1L, -1L, -1L, -1L, signature);
        this.jobId = jobId;
        this.srcToDestPath = srcToDestPath;
        this.broker = broker;
        this.brokerProperties = brokerProperties;
        this.storageType = storageType;
    }

    public long getJobId() {
        return this.jobId;
    }

    public Map<String, String> getSrcToDestPath() {
        return this.srcToDestPath;
    }

    public FsBroker getBrokerAddress() {
        return this.broker;
    }

    public Map<String, String> getBrokerProperties() {
        return this.brokerProperties;
    }

    public TUploadReq toThrift() {
        TNetworkAddress address = new TNetworkAddress(this.broker.ip, this.broker.port);
        TUploadReq request = new TUploadReq(this.jobId, this.srcToDestPath, address);
        request.setBrokerProp(this.brokerProperties);
        request.setStorageBackend(this.storageType.toThrift());
        return request;
    }
}

