/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Status;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TTabletMetaInfo;
import org.apache.doris.thrift.TTabletMetaType;
import org.apache.doris.thrift.TTaskType;
import org.apache.doris.thrift.TUpdateTabletMetaInfoReq;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateTabletMetaInfoTask
extends AgentTask {
    private static final Logger LOG = LogManager.getLogger(UpdateTabletMetaInfoTask.class);
    private MarkedCountDownLatch<Long, Set<Pair<Long, Integer>>> latch;
    private Set<Pair<Long, Integer>> tableIdWithSchemaHash;
    private boolean isInMemory;
    private TTabletMetaType metaType;
    private List<Triple<Long, Integer, Boolean>> tabletToInMemory;

    public UpdateTabletMetaInfoTask(long backendId, Set<Pair<Long, Integer>> tableIdWithSchemaHash, TTabletMetaType metaType) {
        super(null, backendId, TTaskType.UPDATE_TABLET_META_INFO, -1L, -1L, -1L, -1L, -1L, tableIdWithSchemaHash.hashCode());
        this.tableIdWithSchemaHash = tableIdWithSchemaHash;
        this.metaType = metaType;
    }

    public UpdateTabletMetaInfoTask(long backendId, Set<Pair<Long, Integer>> tableIdWithSchemaHash, boolean isInMemory, MarkedCountDownLatch<Long, Set<Pair<Long, Integer>>> latch) {
        this(backendId, tableIdWithSchemaHash, TTabletMetaType.INMEMORY);
        this.isInMemory = isInMemory;
        this.latch = latch;
    }

    public UpdateTabletMetaInfoTask(long backendId, List<Triple<Long, Integer, Boolean>> tabletToInMemory) {
        super(null, backendId, TTaskType.UPDATE_TABLET_META_INFO, -1L, -1L, -1L, -1L, -1L, tabletToInMemory.hashCode());
        this.metaType = TTabletMetaType.INMEMORY;
        this.tabletToInMemory = tabletToInMemory;
    }

    public void countDownLatch(long backendId, Set<Pair<Long, Integer>> tablets) {
        if (this.latch != null && this.latch.markedCountDown(backendId, tablets)) {
            LOG.debug("UpdateTabletMetaInfoTask current latch count: {}, backend: {}, tablets:{}", (Object)this.latch.getCount(), (Object)backendId, tablets);
        }
    }

    public void countDownToZero(String errMsg) {
        if (this.latch != null) {
            this.latch.countDownToZero(new Status(TStatusCode.CANCELLED, errMsg));
            LOG.debug("UpdateTabletMetaInfoTask count down to zero. error msg: {}", (Object)errMsg);
        }
    }

    public Set<Pair<Long, Integer>> getTablets() {
        return this.tableIdWithSchemaHash;
    }

    public TUpdateTabletMetaInfoReq toThrift() {
        TUpdateTabletMetaInfoReq updateTabletMetaInfoReq = new TUpdateTabletMetaInfoReq();
        ArrayList metaInfos = Lists.newArrayList();
        block0 : switch (this.metaType) {
            case PARTITIONID: {
                int tabletEntryNum = 0;
                for (Pair<Long, Integer> pair : this.tableIdWithSchemaHash) {
                    if (tabletEntryNum > 10000) break block0;
                    TTabletMetaInfo metaInfo = new TTabletMetaInfo();
                    metaInfo.setTabletId(((Long)pair.first).longValue());
                    metaInfo.setSchemaHash(((Integer)pair.second).intValue());
                    TabletMeta tabletMeta = Catalog.getCurrentCatalog().getTabletInvertedIndex().getTabletMeta((Long)pair.first);
                    if (tabletMeta == null) {
                        LOG.warn("could not find tablet [{}] in meta ignore it", pair.second);
                        continue;
                    }
                    metaInfo.setPartitionId(tabletMeta.getPartitionId());
                    metaInfo.setMetaType(this.metaType);
                    metaInfos.add(metaInfo);
                    ++tabletEntryNum;
                }
                break;
            }
            case INMEMORY: {
                if (this.latch != null) {
                    for (Pair<Long, Integer> pair : this.tableIdWithSchemaHash) {
                        TTabletMetaInfo metaInfo = new TTabletMetaInfo();
                        metaInfo.setTabletId(((Long)pair.first).longValue());
                        metaInfo.setSchemaHash(((Integer)pair.second).intValue());
                        metaInfo.setIsInMemory(this.isInMemory);
                        metaInfo.setMetaType(this.metaType);
                        metaInfos.add(metaInfo);
                    }
                } else {
                    for (Triple<Long, Integer, Boolean> triple : this.tabletToInMemory) {
                        TTabletMetaInfo metaInfo = new TTabletMetaInfo();
                        metaInfo.setTabletId(((Long)triple.getLeft()).longValue());
                        metaInfo.setSchemaHash(((Integer)triple.getMiddle()).intValue());
                        metaInfo.setIsInMemory(((Boolean)triple.getRight()).booleanValue());
                        metaInfo.setMetaType(this.metaType);
                        metaInfos.add(metaInfo);
                    }
                }
                break;
            }
        }
        updateTabletMetaInfoReq.setTabletMetaInfos((List)metaInfos);
        return updateTabletMetaInfoReq;
    }
}

