/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.load.sync.SyncChannelCallback;
import org.apache.doris.task.SerialExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SyncTask
implements SerialExecutorService.SerialRunnable {
    private static final Logger LOG = LogManager.getLogger(SyncTask.class);
    protected long signature;
    protected int index;
    protected SyncChannelCallback callback;

    public SyncTask(long signature, int index, SyncChannelCallback callback) {
        this.signature = signature;
        this.index = index;
        this.callback = callback;
    }

    @Override
    public void run() {
        try {
            this.exec();
        }
        catch (Exception e) {
            String errMsg = "channel " + this.signature + ", msg: " + e.getMessage();
            LOG.error("sync task exec error: {}", (Object)errMsg);
            this.callback.onFailed(errMsg);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected abstract void exec() throws Exception;
}

